/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SpellCheckerSession;
import android.view.textservice.SpellCheckerSubtype;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesManager;
import java.util.Locale;

public class _Original_TextServicesManager {
    private static final String TAG = _Original_TextServicesManager.class.getSimpleName();
    private static final boolean DBG = false;
    @Deprecated
    private static _Original_TextServicesManager sInstance;
    private final ITextServicesManager mService = ITextServicesManager.Stub.asInterface(ServiceManager.getServiceOrThrow("textservices"));
    private final int mUserId;

    private _Original_TextServicesManager(int userId) throws ServiceManager.ServiceNotFoundException {
        this.mUserId = userId;
    }

    public static _Original_TextServicesManager createInstance(Context context) throws ServiceManager.ServiceNotFoundException {
        return new _Original_TextServicesManager(context.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static _Original_TextServicesManager getInstance() {
        Class<_Original_TextServicesManager> clazz = _Original_TextServicesManager.class;
        synchronized (_Original_TextServicesManager.class) {
            if (sInstance == null) {
                try {
                    sInstance = new _Original_TextServicesManager(UserHandle.myUserId());
                }
                catch (ServiceManager.ServiceNotFoundException e) {
                    throw new IllegalStateException(e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private static String parseLanguageFromLocaleString(String locale) {
        int idx = locale.indexOf(95);
        if (idx < 0) {
            return locale;
        }
        return locale.substring(0, idx);
    }

    public SpellCheckerSession newSpellCheckerSession(Bundle bundle, Locale locale, SpellCheckerSession.SpellCheckerSessionListener listener, boolean referToSpellCheckerLanguageSettings) {
        SpellCheckerInfo sci;
        if (listener == null) {
            throw new NullPointerException();
        }
        if (!referToSpellCheckerLanguageSettings && locale == null) {
            throw new IllegalArgumentException("Locale should not be null if you don't refer settings.");
        }
        if (referToSpellCheckerLanguageSettings && !this.isSpellCheckerEnabled()) {
            return null;
        }
        try {
            sci = this.mService.getCurrentSpellChecker(this.mUserId, null);
        }
        catch (RemoteException e) {
            return null;
        }
        if (sci == null) {
            return null;
        }
        SpellCheckerSubtype subtypeInUse = null;
        if (referToSpellCheckerLanguageSettings) {
            String subtypeLocale;
            String subtypeLanguage;
            subtypeInUse = this.getCurrentSpellCheckerSubtype(true);
            if (subtypeInUse == null) {
                return null;
            }
            if (!(locale == null || (subtypeLanguage = _Original_TextServicesManager.parseLanguageFromLocaleString(subtypeLocale = subtypeInUse.getLocale())).length() >= 2 && locale.getLanguage().equals(subtypeLanguage))) {
                return null;
            }
        } else {
            String localeStr = locale.toString();
            for (int i = 0; i < sci.getSubtypeCount(); ++i) {
                SpellCheckerSubtype subtype = sci.getSubtypeAt(i);
                String tempSubtypeLocale = subtype.getLocale();
                String tempSubtypeLanguage = _Original_TextServicesManager.parseLanguageFromLocaleString(tempSubtypeLocale);
                if (tempSubtypeLocale.equals(localeStr)) {
                    subtypeInUse = subtype;
                    break;
                }
                if (tempSubtypeLanguage.length() < 2 || !locale.getLanguage().equals(tempSubtypeLanguage)) continue;
                subtypeInUse = subtype;
            }
        }
        if (subtypeInUse == null) {
            return null;
        }
        SpellCheckerSession session = new SpellCheckerSession(sci, this, listener);
        try {
            this.mService.getSpellCheckerService(this.mUserId, sci.getId(), subtypeInUse.getLocale(), session.getTextServicesSessionListener(), session.getSpellCheckerSessionListener(), bundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        return session;
    }

    @UnsupportedAppUsage
    public SpellCheckerInfo[] getEnabledSpellCheckers() {
        try {
            SpellCheckerInfo[] retval = this.mService.getEnabledSpellCheckers(this.mUserId);
            return retval;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public SpellCheckerInfo getCurrentSpellChecker() {
        try {
            return this.mService.getCurrentSpellChecker(this.mUserId, null);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public SpellCheckerSubtype getCurrentSpellCheckerSubtype(boolean allowImplicitlySelectedSubtype) {
        try {
            return this.mService.getCurrentSpellCheckerSubtype(this.mUserId, allowImplicitlySelectedSubtype);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @UnsupportedAppUsage
    public boolean isSpellCheckerEnabled() {
        try {
            return this.mService.isSpellCheckerEnabled(this.mUserId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    void finishSpellCheckerService(ISpellCheckerSessionListener listener) {
        try {
            this.mService.finishSpellCheckerService(this.mUserId, listener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

