/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.app.Person;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannedString;
import android.view.textclassifier.ConversationAction;
import android.view.textclassifier.SystemTextClassifierMetadata;
import android.view.textclassifier.TextClassifier;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ConversationActions
implements Parcelable {
    public static final Parcelable.Creator<ConversationActions> CREATOR = new Parcelable.Creator<ConversationActions>(){

        @Override
        public ConversationActions createFromParcel(Parcel in) {
            return new ConversationActions(in);
        }

        public ConversationActions[] newArray(int size) {
            return new ConversationActions[size];
        }
    };
    private final List<ConversationAction> mConversationActions;
    private final String mId;

    public ConversationActions(List<ConversationAction> conversationActions, String id2) {
        this.mConversationActions = Collections.unmodifiableList(Objects.requireNonNull(conversationActions));
        this.mId = id2;
    }

    private ConversationActions(Parcel in) {
        this.mConversationActions = Collections.unmodifiableList(in.createTypedArrayList(ConversationAction.CREATOR));
        this.mId = in.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeTypedList(this.mConversationActions);
        parcel.writeString(this.mId);
    }

    public List<ConversationAction> getConversationActions() {
        return this.mConversationActions;
    }

    public String getId() {
        return this.mId;
    }

    public static class Request
    implements Parcelable {
        public static final String HINT_FOR_IN_APP = "in_app";
        public static final String HINT_FOR_NOTIFICATION = "notification";
        private final List<Message> mConversation;
        private final TextClassifier.EntityConfig mTypeConfig;
        private final int mMaxSuggestions;
        private final List<String> mHints;
        private Bundle mExtras;
        private SystemTextClassifierMetadata mSystemTcMetadata;
        public static final Parcelable.Creator<Request> CREATOR = new Parcelable.Creator<Request>(){

            @Override
            public Request createFromParcel(Parcel in) {
                return Request.readFromParcel(in);
            }

            public Request[] newArray(int size) {
                return new Request[size];
            }
        };

        private Request(List<Message> conversation, TextClassifier.EntityConfig typeConfig, int maxSuggestions, List<String> hints, Bundle extras) {
            this.mConversation = Objects.requireNonNull(conversation);
            this.mTypeConfig = Objects.requireNonNull(typeConfig);
            this.mMaxSuggestions = maxSuggestions;
            this.mHints = hints;
            this.mExtras = extras;
        }

        private static Request readFromParcel(Parcel in) {
            ArrayList<Message> conversation = new ArrayList<Message>();
            in.readParcelableList(conversation, null);
            TextClassifier.EntityConfig typeConfig = (TextClassifier.EntityConfig)in.readParcelable(null);
            int maxSuggestions = in.readInt();
            ArrayList<String> hints = new ArrayList<String>();
            in.readStringList(hints);
            Bundle extras = in.readBundle();
            SystemTextClassifierMetadata systemTcMetadata = (SystemTextClassifierMetadata)in.readParcelable(null);
            Request request = new Request(conversation, typeConfig, maxSuggestions, hints, extras);
            request.setSystemTextClassifierMetadata(systemTcMetadata);
            return request;
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeParcelableList(this.mConversation, flags);
            parcel.writeParcelable(this.mTypeConfig, flags);
            parcel.writeInt(this.mMaxSuggestions);
            parcel.writeStringList(this.mHints);
            parcel.writeBundle(this.mExtras);
            parcel.writeParcelable(this.mSystemTcMetadata, flags);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public TextClassifier.EntityConfig getTypeConfig() {
            return this.mTypeConfig;
        }

        public List<Message> getConversation() {
            return this.mConversation;
        }

        public int getMaxSuggestions() {
            return this.mMaxSuggestions;
        }

        public List<String> getHints() {
            return this.mHints;
        }

        public String getCallingPackageName() {
            return this.mSystemTcMetadata != null ? this.mSystemTcMetadata.getCallingPackageName() : null;
        }

        void setSystemTextClassifierMetadata(SystemTextClassifierMetadata systemTcData) {
            this.mSystemTcMetadata = systemTcData;
        }

        public SystemTextClassifierMetadata getSystemTextClassifierMetadata() {
            return this.mSystemTcMetadata;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public static class Builder {
            private List<Message> mConversation;
            private TextClassifier.EntityConfig mTypeConfig;
            private int mMaxSuggestions = -1;
            private List<String> mHints;
            private Bundle mExtras;

            public Builder(List<Message> conversation) {
                this.mConversation = Objects.requireNonNull(conversation);
            }

            public Builder setHints(List<String> hints) {
                this.mHints = hints;
                return this;
            }

            public Builder setTypeConfig(TextClassifier.EntityConfig typeConfig) {
                this.mTypeConfig = typeConfig;
                return this;
            }

            public Builder setMaxSuggestions(int maxSuggestions) {
                if (maxSuggestions < -1) {
                    throw new IllegalArgumentException("maxSuggestions has to be greater than or equal to -1.");
                }
                this.mMaxSuggestions = maxSuggestions;
                return this;
            }

            public Builder setExtras(Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            public Request build() {
                return new Request(Collections.unmodifiableList(this.mConversation), this.mTypeConfig == null ? new TextClassifier.EntityConfig.Builder().build() : this.mTypeConfig, this.mMaxSuggestions, this.mHints == null ? Collections.emptyList() : Collections.unmodifiableList(this.mHints), this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Hint {
        }
    }

    public static class Message
    implements Parcelable {
        public static final Person PERSON_USER_SELF = new Person.Builder().setKey("text-classifier-conversation-actions-user-self").build();
        public static final Person PERSON_USER_OTHERS = new Person.Builder().setKey("text-classifier-conversation-actions-user-others").build();
        private final Person mAuthor;
        private final ZonedDateTime mReferenceTime;
        private final CharSequence mText;
        private final Bundle mExtras;
        public static final Parcelable.Creator<Message> CREATOR = new Parcelable.Creator<Message>(){

            @Override
            public Message createFromParcel(Parcel in) {
                return new Message(in);
            }

            public Message[] newArray(int size) {
                return new Message[size];
            }
        };

        private Message(Person author, ZonedDateTime referenceTime, CharSequence text, Bundle bundle) {
            this.mAuthor = author;
            this.mReferenceTime = referenceTime;
            this.mText = text;
            this.mExtras = Objects.requireNonNull(bundle);
        }

        private Message(Parcel in) {
            this.mAuthor = (Person)in.readParcelable(null);
            this.mReferenceTime = in.readInt() == 0 ? null : ZonedDateTime.parse(in.readString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
            this.mText = in.readCharSequence();
            this.mExtras = in.readBundle();
        }

        @Override
        public void writeToParcel(Parcel parcel, int flags) {
            parcel.writeParcelable(this.mAuthor, flags);
            parcel.writeInt(this.mReferenceTime != null ? 1 : 0);
            if (this.mReferenceTime != null) {
                parcel.writeString(this.mReferenceTime.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
            parcel.writeCharSequence(this.mText);
            parcel.writeBundle(this.mExtras);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Person getAuthor() {
            return this.mAuthor;
        }

        public ZonedDateTime getReferenceTime() {
            return this.mReferenceTime;
        }

        public CharSequence getText() {
            return this.mText;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public static class Builder {
            private Person mAuthor;
            private ZonedDateTime mReferenceTime;
            private CharSequence mText;
            private Bundle mExtras;

            public Builder(Person author) {
                this.mAuthor = Objects.requireNonNull(author);
            }

            public Builder setText(CharSequence text) {
                this.mText = text;
                return this;
            }

            public Builder setReferenceTime(ZonedDateTime referenceTime) {
                this.mReferenceTime = referenceTime;
                return this;
            }

            public Builder setExtras(Bundle bundle) {
                this.mExtras = bundle;
                return this;
            }

            public Message build() {
                return new Message(this.mAuthor, this.mReferenceTime, this.mText == null ? null : new SpannedString(this.mText), this.mExtras == null ? Bundle.EMPTY : this.mExtras);
            }
        }
    }
}

