/*
 * Decompiled with CFR 0.152.
 */
package android.view.math;

public class Math3DHelper {
    private Math3DHelper() {
    }

    public static final int min(int x1, int x2, int x3) {
        return x1 > x2 ? (x2 > x3 ? x3 : x2) : (x1 > x3 ? x3 : x1);
    }

    public static final int max(int x1, int x2, int x3) {
        return x1 < x2 ? (x2 < x3 ? x3 : x2) : (x1 < x3 ? x3 : x1);
    }

    public static float[] flatBound(float[] poly, int dimension) {
        int polySize = poly.length / dimension;
        float left = poly[0];
        float right = poly[0];
        float top = poly[1];
        float bottom = poly[1];
        for (int i = 0; i < polySize; ++i) {
            float x = poly[i * dimension + 0];
            float y = poly[i * dimension + 1];
            if (left > x) {
                left = x;
            } else if (right < x) {
                right = x;
            }
            if (top > y) {
                top = y;
                continue;
            }
            if (!(bottom < y)) continue;
            bottom = y;
        }
        return new float[]{left, top, right, bottom};
    }

    public static void translate(float[] poly, float translateX, float translateY, int dimension) {
        int polySize = poly.length / dimension;
        for (int i = 0; i < polySize; ++i) {
            int n = i * dimension + 0;
            poly[n] = poly[n] + translateX;
            int n2 = i * dimension + 1;
            poly[n2] = poly[n2] + translateY;
        }
    }
}

