/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.os.Bundle;
import android.os.LocaleList;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.Editable;
import android.text.InputType;
import android.text.TextUtils;
import android.util.Printer;
import android.view.autofill.AutofillId;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

public class EditorInfo
implements InputType,
Parcelable {
    public int inputType = 0;
    public static final int IME_MASK_ACTION = 255;
    public static final int IME_ACTION_UNSPECIFIED = 0;
    public static final int IME_ACTION_NONE = 1;
    public static final int IME_ACTION_GO = 2;
    public static final int IME_ACTION_SEARCH = 3;
    public static final int IME_ACTION_SEND = 4;
    public static final int IME_ACTION_NEXT = 5;
    public static final int IME_ACTION_DONE = 6;
    public static final int IME_ACTION_PREVIOUS = 7;
    public static final int IME_FLAG_NO_PERSONALIZED_LEARNING = 0x1000000;
    public static final int IME_FLAG_NO_FULLSCREEN = 0x2000000;
    public static final int IME_FLAG_NAVIGATE_PREVIOUS = 0x4000000;
    public static final int IME_FLAG_NAVIGATE_NEXT = 0x8000000;
    public static final int IME_FLAG_NO_EXTRACT_UI = 0x10000000;
    public static final int IME_FLAG_NO_ACCESSORY_ACTION = 0x20000000;
    public static final int IME_FLAG_NO_ENTER_ACTION = 0x40000000;
    public static final int IME_FLAG_FORCE_ASCII = Integer.MIN_VALUE;
    public static final int IME_NULL = 0;
    public int imeOptions = 0;
    public String privateImeOptions = null;
    public CharSequence actionLabel = null;
    public int actionId = 0;
    public int initialSelStart = -1;
    public int initialSelEnd = -1;
    public int initialCapsMode = 0;
    public CharSequence hintText;
    public CharSequence label;
    public String packageName;
    public AutofillId autofillId;
    public int fieldId;
    public String fieldName;
    public Bundle extras;
    public LocaleList hintLocales = null;
    public String[] contentMimeTypes = null;
    public UserHandle targetInputMethodUser = null;
    @VisibleForTesting
    static final int MEMORY_EFFICIENT_TEXT_LENGTH = 2048;
    @VisibleForTesting
    static final int MAX_INITIAL_SELECTION_LENGTH = 1024;
    private InitialSurroundingText mInitialSurroundingText = new InitialSurroundingText();
    public static final Parcelable.Creator<EditorInfo> CREATOR = new Parcelable.Creator<EditorInfo>(){

        @Override
        public EditorInfo createFromParcel(Parcel source) {
            EditorInfo res = new EditorInfo();
            res.inputType = source.readInt();
            res.imeOptions = source.readInt();
            res.privateImeOptions = source.readString();
            res.actionLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            res.actionId = source.readInt();
            res.initialSelStart = source.readInt();
            res.initialSelEnd = source.readInt();
            res.initialCapsMode = source.readInt();
            res.hintText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            res.label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            res.packageName = source.readString();
            res.autofillId = (AutofillId)source.readParcelable(AutofillId.class.getClassLoader());
            res.fieldId = source.readInt();
            res.fieldName = source.readString();
            res.extras = source.readBundle();
            InitialSurroundingText initialSurroundingText = InitialSurroundingText.CREATOR.createFromParcel(source);
            res.mInitialSurroundingText = initialSurroundingText;
            LocaleList hintLocales = LocaleList.CREATOR.createFromParcel(source);
            res.hintLocales = hintLocales.isEmpty() ? null : hintLocales;
            res.contentMimeTypes = source.readStringArray();
            res.targetInputMethodUser = UserHandle.readFromParcel(source);
            return res;
        }

        public EditorInfo[] newArray(int size) {
            return new EditorInfo[size];
        }
    };

    public void setInitialSurroundingText(CharSequence sourceText) {
        this.setInitialSurroundingSubText(sourceText, 0);
    }

    public void setInitialSurroundingSubText(CharSequence subText, int subTextStart) {
        Editable newSubText = Editable.Factory.getInstance().newEditable(subText);
        Objects.requireNonNull(newSubText);
        int subTextSelStart = this.initialSelStart > this.initialSelEnd ? this.initialSelEnd - subTextStart : this.initialSelStart - subTextStart;
        int subTextSelEnd = this.initialSelStart > this.initialSelEnd ? this.initialSelStart - subTextStart : this.initialSelEnd - subTextStart;
        int subTextLength = newSubText.length();
        if (subTextStart < 0 || subTextSelStart < 0 || subTextSelEnd > subTextLength) {
            this.mInitialSurroundingText = new InitialSurroundingText();
            return;
        }
        if (EditorInfo.isPasswordInputType(this.inputType)) {
            this.mInitialSurroundingText = new InitialSurroundingText();
            return;
        }
        if (subTextLength <= 2048) {
            this.mInitialSurroundingText = new InitialSurroundingText(newSubText, subTextSelStart, subTextSelEnd);
            return;
        }
        this.trimLongSurroundingText(newSubText, subTextSelStart, subTextSelEnd);
    }

    private void trimLongSurroundingText(CharSequence subText, int selStart, int selEnd) {
        CharSequence newInitialSurroundingText;
        int sourceSelLength = selEnd - selStart;
        int newSelLength = sourceSelLength > 1024 ? 0 : sourceSelLength;
        int subTextBeforeCursorLength = selStart;
        int subTextAfterCursorLength = subText.length() - selEnd;
        int maxLengthMinusSelection = 2048 - newSelLength;
        int possibleMaxBeforeCursorLength = Math.min(subTextBeforeCursorLength, (int)(0.8 * (double)maxLengthMinusSelection));
        int newAfterCursorLength = Math.min(subTextAfterCursorLength, maxLengthMinusSelection - possibleMaxBeforeCursorLength);
        int newBeforeCursorLength = Math.min(subTextBeforeCursorLength, maxLengthMinusSelection - newAfterCursorLength);
        int newBeforeCursorHead = subTextBeforeCursorLength - newBeforeCursorLength;
        if (EditorInfo.isCutOnSurrogate(subText, selStart - newBeforeCursorLength, 0)) {
            ++newBeforeCursorHead;
            --newBeforeCursorLength;
        }
        if (EditorInfo.isCutOnSurrogate(subText, selEnd + newAfterCursorLength - 1, 1)) {
            --newAfterCursorLength;
        }
        int newTextLength = newBeforeCursorLength + newSelLength + newAfterCursorLength;
        if (newSelLength != sourceSelLength) {
            CharSequence beforeCursor = subText.subSequence(newBeforeCursorHead, newBeforeCursorHead + newBeforeCursorLength);
            CharSequence afterCursor = subText.subSequence(selEnd, selEnd + newAfterCursorLength);
            newInitialSurroundingText = TextUtils.concat(beforeCursor, afterCursor);
        } else {
            newInitialSurroundingText = subText.subSequence(newBeforeCursorHead, newBeforeCursorHead + newTextLength);
        }
        newBeforeCursorHead = 0;
        int newSelHead = newBeforeCursorHead + newBeforeCursorLength;
        this.mInitialSurroundingText = new InitialSurroundingText(newInitialSurroundingText, newSelHead, newSelHead + newSelLength);
    }

    public CharSequence getInitialTextBeforeCursor(int length, int flags) {
        return this.mInitialSurroundingText.getInitialTextBeforeCursor(length, flags);
    }

    public CharSequence getInitialSelectedText(int flags) {
        int correctedTextSelStart = this.initialSelStart > this.initialSelEnd ? this.initialSelEnd : this.initialSelStart;
        int correctedTextSelEnd = this.initialSelStart > this.initialSelEnd ? this.initialSelStart : this.initialSelEnd;
        int sourceSelLength = correctedTextSelEnd - correctedTextSelStart;
        if (this.initialSelStart < 0 || this.initialSelEnd < 0 || this.mInitialSurroundingText.getSelectionLength() != sourceSelLength) {
            return null;
        }
        return this.mInitialSurroundingText.getInitialSelectedText(flags);
    }

    public CharSequence getInitialTextAfterCursor(int length, int flags) {
        return this.mInitialSurroundingText.getInitialTextAfterCursor(length, flags);
    }

    private static boolean isCutOnSurrogate(CharSequence sourceText, int cutPosition, int policy) {
        switch (policy) {
            case 0: {
                return Character.isLowSurrogate(sourceText.charAt(cutPosition));
            }
            case 1: {
                return Character.isHighSurrogate(sourceText.charAt(cutPosition));
            }
        }
        return false;
    }

    private static boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129 || variation == 225 || variation == 18;
    }

    public void makeCompatible(int targetSdkVersion) {
        if (targetSdkVersion < 11) {
            switch (this.inputType & 0xFFF) {
                case 209: {
                    this.inputType = 0x21 | this.inputType & 0xFFF000;
                    break;
                }
                case 225: {
                    this.inputType = 0x81 | this.inputType & 0xFFF000;
                    break;
                }
                case 2: 
                case 18: {
                    this.inputType = 2 | this.inputType & 0xFFF000;
                }
            }
        }
    }

    public void dump(Printer pw, String prefix) {
        pw.println(prefix + "inputType=0x" + Integer.toHexString(this.inputType) + " imeOptions=0x" + Integer.toHexString(this.imeOptions) + " privateImeOptions=" + this.privateImeOptions);
        pw.println(prefix + "actionLabel=" + this.actionLabel + " actionId=" + this.actionId);
        pw.println(prefix + "initialSelStart=" + this.initialSelStart + " initialSelEnd=" + this.initialSelEnd + " initialCapsMode=0x" + Integer.toHexString(this.initialCapsMode));
        pw.println(prefix + "hintText=" + this.hintText + " label=" + this.label);
        pw.println(prefix + "packageName=" + this.packageName + " autofillId=" + this.autofillId + " fieldId=" + this.fieldId + " fieldName=" + this.fieldName);
        pw.println(prefix + "extras=" + this.extras);
        pw.println(prefix + "hintLocales=" + this.hintLocales);
        pw.println(prefix + "contentMimeTypes=" + Arrays.toString(this.contentMimeTypes));
        if (this.targetInputMethodUser != null) {
            pw.println(prefix + "targetInputMethodUserId=" + this.targetInputMethodUser.getIdentifier());
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.inputType);
        dest.writeInt(this.imeOptions);
        dest.writeString(this.privateImeOptions);
        TextUtils.writeToParcel(this.actionLabel, dest, flags);
        dest.writeInt(this.actionId);
        dest.writeInt(this.initialSelStart);
        dest.writeInt(this.initialSelEnd);
        dest.writeInt(this.initialCapsMode);
        TextUtils.writeToParcel(this.hintText, dest, flags);
        TextUtils.writeToParcel(this.label, dest, flags);
        dest.writeString(this.packageName);
        dest.writeParcelable(this.autofillId, flags);
        dest.writeInt(this.fieldId);
        dest.writeString(this.fieldName);
        dest.writeBundle(this.extras);
        this.mInitialSurroundingText.writeToParcel(dest, flags);
        if (this.hintLocales != null) {
            this.hintLocales.writeToParcel(dest, flags);
        } else {
            LocaleList.getEmptyLocaleList().writeToParcel(dest, flags);
        }
        dest.writeStringArray(this.contentMimeTypes);
        UserHandle.writeToParcel(this.targetInputMethodUser, dest);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    static class InitialSurroundingText
    implements Parcelable {
        final CharSequence mSurroundingText;
        final int mSelectionHead;
        final int mSelectionEnd;
        public static final Parcelable.Creator<InitialSurroundingText> CREATOR = new Parcelable.Creator<InitialSurroundingText>(){

            @Override
            public InitialSurroundingText createFromParcel(Parcel source) {
                CharSequence initialText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
                int selectionHead = source.readInt();
                int selectionEnd = source.readInt();
                return new InitialSurroundingText(initialText, selectionHead, selectionEnd);
            }

            public InitialSurroundingText[] newArray(int size) {
                return new InitialSurroundingText[size];
            }
        };

        InitialSurroundingText() {
            this.mSurroundingText = null;
            this.mSelectionHead = 0;
            this.mSelectionEnd = 0;
        }

        InitialSurroundingText(CharSequence surroundingText, int selectionHead, int selectionEnd) {
            this.mSurroundingText = surroundingText;
            this.mSelectionHead = selectionHead;
            this.mSelectionEnd = selectionEnd;
        }

        private CharSequence getInitialTextBeforeCursor(int n, int flags) {
            if (this.mSurroundingText == null) {
                return null;
            }
            int length = Math.min(n, this.mSelectionHead);
            return (flags & 1) != 0 ? this.mSurroundingText.subSequence(this.mSelectionHead - length, this.mSelectionHead) : TextUtils.substring(this.mSurroundingText, this.mSelectionHead - length, this.mSelectionHead);
        }

        private CharSequence getInitialSelectedText(int flags) {
            if (this.mSurroundingText == null) {
                return null;
            }
            return (flags & 1) != 0 ? this.mSurroundingText.subSequence(this.mSelectionHead, this.mSelectionEnd) : TextUtils.substring(this.mSurroundingText, this.mSelectionHead, this.mSelectionEnd);
        }

        private CharSequence getInitialTextAfterCursor(int n, int flags) {
            if (this.mSurroundingText == null) {
                return null;
            }
            int length = Math.min(n, this.mSurroundingText.length() - this.mSelectionEnd);
            return (flags & 1) != 0 ? this.mSurroundingText.subSequence(this.mSelectionEnd, this.mSelectionEnd + length) : TextUtils.substring(this.mSurroundingText, this.mSelectionEnd, this.mSelectionEnd + length);
        }

        private int getSelectionLength() {
            return this.mSelectionEnd - this.mSelectionHead;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            TextUtils.writeToParcel(this.mSurroundingText, dest, flags);
            dest.writeInt(this.mSelectionHead);
            dest.writeInt(this.mSelectionEnd);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface TrimPolicy {
        public static final int HEAD = 0;
        public static final int TAIL = 1;
    }
}

