/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.ResourcesManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Insets;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.InsetsState;
import android.view.KeyboardShortcutGroup;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import android.view.WindowMetrics;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;

public class _Original_WindowManagerImpl
implements WindowManager {
    @UnsupportedAppUsage
    private final WindowManagerGlobal mGlobal = WindowManagerGlobal.getInstance();
    @VisibleForTesting
    public final Context mContext;
    private final Window mParentWindow;
    private IBinder mDefaultToken;

    public _Original_WindowManagerImpl(Context context) {
        this(context, null);
    }

    private _Original_WindowManagerImpl(Context context, Window parentWindow) {
        this.mContext = context;
        this.mParentWindow = parentWindow;
    }

    public _Original_WindowManagerImpl createLocalWindowManager(Window parentWindow) {
        return new _Original_WindowManagerImpl(this.mContext, parentWindow);
    }

    public _Original_WindowManagerImpl createPresentationWindowManager(Context displayContext) {
        return new _Original_WindowManagerImpl(displayContext, this.mParentWindow);
    }

    public void setDefaultToken(IBinder token) {
        this.mDefaultToken = token;
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams params) {
        this.applyDefaultToken(params);
        this.mGlobal.addView(view, params, this.mContext.getDisplayNoVerify(), this.mParentWindow, this.mContext.getUserId());
    }

    @Override
    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        this.applyDefaultToken(params);
        this.mGlobal.updateViewLayout(view, params);
    }

    private void applyDefaultToken(ViewGroup.LayoutParams params) {
        if (this.mDefaultToken != null && this.mParentWindow == null) {
            if (!(params instanceof WindowManager.LayoutParams)) {
                throw new IllegalArgumentException("Params must be WindowManager.LayoutParams");
            }
            WindowManager.LayoutParams wparams = (WindowManager.LayoutParams)params;
            if (wparams.token == null) {
                wparams.token = this.mDefaultToken;
            }
        }
    }

    @Override
    public void removeView(View view) {
        this.mGlobal.removeView(view, false);
    }

    @Override
    public void removeViewImmediate(View view) {
        this.mGlobal.removeView(view, true);
    }

    @Override
    public void requestAppKeyboardShortcuts(final WindowManager.KeyboardShortcutsReceiver receiver, int deviceId) {
        IResultReceiver.Stub resultReceiver = new IResultReceiver.Stub(){

            @Override
            public void send(int resultCode, Bundle resultData) throws RemoteException {
                ArrayList<KeyboardShortcutGroup> result = resultData.getParcelableArrayList("shortcuts_array");
                receiver.onKeyboardShortcutsReceived(result);
            }
        };
        try {
            WindowManagerGlobal.getWindowManagerService().requestAppKeyboardShortcuts(resultReceiver, deviceId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public Display getDefaultDisplay() {
        return this.mContext.getDisplayNoVerify();
    }

    @Override
    public Region getCurrentImeTouchRegion() {
        try {
            return WindowManagerGlobal.getWindowManagerService().getCurrentImeTouchRegion();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowWithInsecureKeyguard(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public void setShouldShowSystemDecors(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowSystemDecors(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean shouldShowSystemDecors(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().shouldShowSystemDecors(displayId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public void setShouldShowIme(int displayId, boolean shouldShow) {
        try {
            WindowManagerGlobal.getWindowManagerService().setShouldShowIme(displayId, shouldShow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public boolean shouldShowIme(int displayId) {
        try {
            return WindowManagerGlobal.getWindowManagerService().shouldShowIme(displayId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public WindowMetrics getCurrentWindowMetrics() {
        Context context = this.mParentWindow != null ? this.mParentWindow.getContext() : this.mContext;
        Rect bounds = _Original_WindowManagerImpl.getCurrentBounds(context);
        return new WindowMetrics(bounds, this.computeWindowInsets(bounds));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rect getCurrentBounds(Context context) {
        ResourcesManager resourcesManager = ResourcesManager.getInstance();
        synchronized (resourcesManager) {
            return context.getResources().getConfiguration().windowConfiguration.getBounds();
        }
    }

    @Override
    public WindowMetrics getMaximumWindowMetrics() {
        Rect maxBounds = this.getMaximumBounds();
        return new WindowMetrics(maxBounds, this.computeWindowInsets(maxBounds));
    }

    private Rect getMaximumBounds() {
        Display display = this.mContext.getDisplayNoVerify();
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        return new Rect(0, 0, displaySize.x, displaySize.y);
    }

    private WindowInsets computeWindowInsets(Rect bounds) {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams();
        params.flags = 65792;
        params.token = this.mParentWindow != null ? this.mParentWindow.getContext().getActivityToken() : this.mContext.getActivityToken();
        params.systemUiVisibility = 1536;
        params.setFitInsetsTypes(0);
        params.setFitInsetsSides(0);
        return this.getWindowInsetsFromServer(params, bounds);
    }

    private WindowInsets getWindowInsetsFromServer(WindowManager.LayoutParams attrs, Rect bounds) {
        try {
            Rect systemWindowInsets = new Rect();
            Rect stableInsets = new Rect();
            DisplayCutout.ParcelableWrapper displayCutout = new DisplayCutout.ParcelableWrapper();
            InsetsState insetsState = new InsetsState();
            boolean alwaysConsumeSystemBars = WindowManagerGlobal.getWindowManagerService().getWindowInsets(attrs, this.mContext.getDisplayId(), systemWindowInsets, stableInsets, displayCutout, insetsState);
            boolean isScreenRound = this.mContext.getResources().getConfiguration().isScreenRound();
            if (ViewRootImpl.sNewInsetsMode == 2) {
                return insetsState.calculateInsets(bounds, null, isScreenRound, alwaysConsumeSystemBars, displayCutout.get(), 48, attrs.flags, 0, null);
            }
            return new WindowInsets.Builder().setAlwaysConsumeSystemBars(alwaysConsumeSystemBars).setRound(isScreenRound).setSystemWindowInsets(Insets.of(systemWindowInsets)).setStableInsets(Insets.of(stableInsets)).setDisplayCutout(displayCutout.get()).build();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

