/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.HardwareRenderer;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.RenderNode;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceControlViewHost;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.SurfaceView;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.IAccessibilityEmbeddedConnection;
import com.android.internal.view.SurfaceCallbackHelper;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;

public class _Original_SurfaceView
extends View
implements ViewRootImpl.SurfaceChangedCallback {
    private static final String TAG = "SurfaceView";
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_POSITION = false;
    @UnsupportedAppUsage
    final ArrayList<SurfaceHolder.Callback> mCallbacks = new ArrayList();
    final int[] mLocation = new int[2];
    @UnsupportedAppUsage
    final ReentrantLock mSurfaceLock = new ReentrantLock();
    @UnsupportedAppUsage
    final Surface mSurface = new Surface();
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mDrawingStopped = true;
    boolean mDrawFinished = false;
    final Rect mScreenRect = new Rect();
    private final SurfaceSession mSurfaceSession = new SurfaceSession();
    SurfaceControl mSurfaceControl;
    SurfaceControl mDeferredDestroySurfaceControl;
    SurfaceControl mBackgroundControl;
    private boolean mDisableBackgroundLayer = false;
    final Object mSurfaceControlLock = new Object();
    final Rect mTmpRect = new Rect();
    Paint mRoundedViewportPaint;
    int mSubLayer = -2;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    boolean mIsCreating = false;
    private volatile boolean mRtHandlingPositionUpdates = false;
    private volatile boolean mRtReleaseSurfaces = false;
    private final ViewTreeObserver.OnScrollChangedListener mScrollChangedListener = (ViewTreeObserver.OnScrollChangedListener)LambdaMetafactory.metafactory(null, null, null, ()V, updateSurface(), ()V)((SurfaceView)((Object)this));
    @UnsupportedAppUsage
    private final ViewTreeObserver.OnPreDrawListener mDrawListener = (ViewTreeObserver.OnPreDrawListener)LambdaMetafactory.metafactory(null, null, null, ()Z, lambda$new$0(), ()Z)((SurfaceView)((Object)this));
    boolean mRequestedVisible = false;
    boolean mWindowVisibility = false;
    boolean mLastWindowVisibility = false;
    boolean mViewVisibility = false;
    boolean mWindowStopped = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mRequestedWidth = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    int mRequestedHeight = -1;
    @UnsupportedAppUsage
    int mRequestedFormat = 4;
    boolean mUseAlpha = false;
    float mSurfaceAlpha = 1.0f;
    boolean mClipSurfaceToBounds;
    int mBackgroundColor = -16777216;
    @UnsupportedAppUsage
    boolean mHaveFrame = false;
    boolean mSurfaceCreated = false;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    long mLastLockTime = 0L;
    boolean mVisible = false;
    int mWindowSpaceLeft = -1;
    int mWindowSpaceTop = -1;
    int mSurfaceWidth = -1;
    int mSurfaceHeight = -1;
    float mCornerRadius;
    @UnsupportedAppUsage
    int mFormat = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    final Rect mSurfaceFrame = new Rect();
    int mLastSurfaceWidth = -1;
    int mLastSurfaceHeight = -1;
    private boolean mGlobalListenersAdded;
    private boolean mAttachedToWindow;
    private int mSurfaceFlags = 4;
    private int mPendingReportDraws;
    private SurfaceControl.Transaction mRtTransaction = new SurfaceControl.Transaction();
    private SurfaceControl.Transaction mTmpTransaction = new SurfaceControl.Transaction();
    private int mParentSurfaceGenerationId;
    private RemoteAccessibilityEmbeddedConnection mRemoteAccessibilityEmbeddedConnection;
    private final Matrix mScreenMatrixForEmbeddedHierarchy = new Matrix();
    private final Matrix mTmpMatrix = new Matrix();
    private final float[] mMatrixValues = new float[9];
    SurfaceControlViewHost.SurfacePackage mSurfacePackage;
    private Rect mRTLastReportedPosition = new Rect();
    private RenderNode.PositionUpdateListener mPositionListener = new RenderNode.PositionUpdateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionChanged(long frameNumber, int left, int top, int right, int bottom) {
            if (_Original_SurfaceView.this.mSurfaceControl == null) {
                return;
            }
            Object object = _Original_SurfaceView.this.mSurfaceControlLock;
            synchronized (object) {
                _Original_SurfaceView.this.mRtHandlingPositionUpdates = true;
            }
            if (((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.left == left && ((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.top == top && ((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.right == right && ((_Original_SurfaceView)_Original_SurfaceView.this).mRTLastReportedPosition.bottom == bottom) {
                return;
            }
            try {
                _Original_SurfaceView.this.mRTLastReportedPosition.set(left, top, right, bottom);
                _Original_SurfaceView.this.setParentSpaceRectangle(_Original_SurfaceView.this.mRTLastReportedPosition, frameNumber);
            }
            catch (Exception ex) {
                Log.e(_Original_SurfaceView.TAG, "Exception from repositionChild", ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void positionLost(long frameNumber) {
            ViewRootImpl viewRoot = _Original_SurfaceView.this.getViewRootImpl();
            boolean useBLAST = viewRoot != null && viewRoot.isDrawingToBLASTTransaction();
            _Original_SurfaceView.this.mRTLastReportedPosition.setEmpty();
            if (_Original_SurfaceView.this.mSurfaceControl == null) {
                return;
            }
            SurfaceControl.Transaction t = useBLAST ? (viewRoot != null ? viewRoot.getBLASTSyncTransaction() : _Original_SurfaceView.this.mRtTransaction) : _Original_SurfaceView.this.mRtTransaction;
            Object object = _Original_SurfaceView.this.mSurfaceControlLock;
            synchronized (object) {
                if (frameNumber > 0L && viewRoot != null && !useBLAST && viewRoot.mSurface.isValid()) {
                    _Original_SurfaceView.this.mRtTransaction.deferTransactionUntil(_Original_SurfaceView.this.mSurfaceControl, viewRoot.getRenderSurfaceControl(), frameNumber);
                }
                t.hide(_Original_SurfaceView.this.mSurfaceControl);
                if (_Original_SurfaceView.this.mRtReleaseSurfaces) {
                    _Original_SurfaceView.this.mRtReleaseSurfaces = false;
                    _Original_SurfaceView.this.mRtTransaction.remove(_Original_SurfaceView.this.mSurfaceControl);
                    _Original_SurfaceView.this.mRtTransaction.remove(_Original_SurfaceView.this.mBackgroundControl);
                    _Original_SurfaceView.this.mSurfaceControl = null;
                    _Original_SurfaceView.this.mBackgroundControl = null;
                }
                _Original_SurfaceView.this.mRtHandlingPositionUpdates = false;
            }
            if (!useBLAST || viewRoot == null) {
                _Original_SurfaceView.this.mRtTransaction.apply();
            }
        }
    };
    @UnsupportedAppUsage
    private final SurfaceHolder mSurfaceHolder = new SurfaceHolder(){
        private static final String LOG_TAG = "SurfaceHolder";

        @Override
        public boolean isCreating() {
            return _Original_SurfaceView.this.mIsCreating;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                if (!_Original_SurfaceView.this.mCallbacks.contains(callback)) {
                    _Original_SurfaceView.this.mCallbacks.add(callback);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallback(SurfaceHolder.Callback callback) {
            ArrayList<SurfaceHolder.Callback> arrayList = _Original_SurfaceView.this.mCallbacks;
            synchronized (arrayList) {
                _Original_SurfaceView.this.mCallbacks.remove(callback);
            }
        }

        @Override
        public void setFixedSize(int width, int height) {
            if (_Original_SurfaceView.this.mRequestedWidth != width || _Original_SurfaceView.this.mRequestedHeight != height) {
                _Original_SurfaceView.this.mRequestedWidth = width;
                _Original_SurfaceView.this.mRequestedHeight = height;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setSizeFromLayout() {
            if (_Original_SurfaceView.this.mRequestedWidth != -1 || _Original_SurfaceView.this.mRequestedHeight != -1) {
                _Original_SurfaceView.this.mRequestedHeight = -1;
                _Original_SurfaceView.this.mRequestedWidth = -1;
                _Original_SurfaceView.this.requestLayout();
            }
        }

        @Override
        public void setFormat(int format) {
            if (format == -1) {
                format = 4;
            }
            _Original_SurfaceView.this.mRequestedFormat = format;
            if (_Original_SurfaceView.this.mSurfaceControl != null) {
                _Original_SurfaceView.this.updateSurface();
            }
        }

        @Override
        @Deprecated
        public void setType(int type) {
        }

        @Override
        public void setKeepScreenOn(boolean screenOn) {
            _Original_SurfaceView.this.runOnUiThread(() -> ((SurfaceView.2)this).lambda$setKeepScreenOn$0((boolean)screenOn));
        }

        @Override
        public Canvas lockCanvas() {
            return this.internalLockCanvas(null, false);
        }

        @Override
        public Canvas lockCanvas(Rect inOutDirty) {
            return this.internalLockCanvas(inOutDirty, false);
        }

        @Override
        public Canvas lockHardwareCanvas() {
            return this.internalLockCanvas(null, true);
        }

        private Canvas internalLockCanvas(Rect dirty, boolean hardware) {
            _Original_SurfaceView.this.mSurfaceLock.lock();
            Canvas c = null;
            if (!_Original_SurfaceView.this.mDrawingStopped && _Original_SurfaceView.this.mSurfaceControl != null) {
                try {
                    c = hardware ? _Original_SurfaceView.this.mSurface.lockHardwareCanvas() : _Original_SurfaceView.this.mSurface.lockCanvas(dirty);
                }
                catch (Exception e) {
                    Log.e(LOG_TAG, "Exception locking surface", e);
                }
            }
            if (c != null) {
                _Original_SurfaceView.this.mLastLockTime = SystemClock.uptimeMillis();
                return c;
            }
            long nextTime = _Original_SurfaceView.this.mLastLockTime + 100L;
            long now = SystemClock.uptimeMillis();
            if (nextTime > now) {
                try {
                    Thread.sleep(nextTime - now);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                now = SystemClock.uptimeMillis();
            }
            _Original_SurfaceView.this.mLastLockTime = now;
            _Original_SurfaceView.this.mSurfaceLock.unlock();
            return null;
        }

        @Override
        public void unlockCanvasAndPost(Canvas canvas) {
            _Original_SurfaceView.this.mSurface.unlockCanvasAndPost(canvas);
            _Original_SurfaceView.this.mSurfaceLock.unlock();
        }

        @Override
        public Surface getSurface() {
            return _Original_SurfaceView.this.mSurface;
        }

        @Override
        public Rect getSurfaceFrame() {
            return _Original_SurfaceView.this.mSurfaceFrame;
        }

        private /* synthetic */ void lambda$setKeepScreenOn$0(boolean screenOn) {
            _Original_SurfaceView.this.setKeepScreenOn(screenOn);
        }
    };

    public _Original_SurfaceView(Context context) {
        this(context, null);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this(context, attrs, defStyleAttr, defStyleRes, false);
    }

    public _Original_SurfaceView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, boolean disableBackgroundLayer) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mRenderNode.addPositionUpdateListener(this.mPositionListener);
        this.setWillNotDraw(true);
        this.mDisableBackgroundLayer = disableBackgroundLayer;
    }

    public SurfaceHolder getHolder() {
        return this.mSurfaceHolder;
    }

    private void updateRequestedVisibility() {
        this.mRequestedVisible = this.mViewVisibility && this.mWindowVisibility && !this.mWindowStopped;
    }

    private void setWindowStopped(boolean stopped) {
        this.mWindowStopped = stopped;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewRootImpl().addSurfaceChangedCallback(this);
        this.mWindowStopped = false;
        this.mViewVisibility = this.getVisibility() == 0;
        this.updateRequestedVisibility();
        this.mAttachedToWindow = true;
        this.mParent.requestTransparentRegion(this);
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    @Override
    public void setVisibility(int visibility) {
        boolean newRequestedVisible;
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        boolean bl = newRequestedVisible = this.mWindowVisibility && this.mViewVisibility && !this.mWindowStopped;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateSurface();
    }

    public void setUseAlpha() {
        if (!this.mUseAlpha) {
            this.mUseAlpha = true;
            this.updateSurfaceAlpha();
        }
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.updateSurfaceAlpha();
    }

    private float getFixedAlpha() {
        float alpha = this.getAlpha();
        return this.mUseAlpha && (this.mSubLayer > 0 || alpha == 0.0f) ? alpha : 1.0f;
    }

    private void updateSurfaceAlpha() {
        if (!this.mUseAlpha) {
            return;
        }
        float viewAlpha = this.getAlpha();
        if (this.mSubLayer < 0 && 0.0f < viewAlpha && viewAlpha < 1.0f) {
            Log.w(TAG, System.identityHashCode(this) + " updateSurfaceAlpha: translucent color is not supported for a surface placed z-below.");
        }
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        if (this.mSurfaceControl == null) {
            return;
        }
        Surface parent = viewRoot.mSurface;
        if (parent == null || !parent.isValid()) {
            return;
        }
        float alpha = this.getFixedAlpha();
        if (alpha != this.mSurfaceAlpha) {
            if (this.isHardwareAccelerated()) {
                boolean useBLAST = viewRoot.useBLAST();
                viewRoot.registerRtFrameCallback((HardwareRenderer.FrameDrawingCallback)LambdaMetafactory.metafactory(null, null, null, (J)V, lambda$updateSurfaceAlpha$1(boolean android.view.ViewRootImpl android.view.Surface float long ), (J)V)((SurfaceView)((Object)this), (boolean)useBLAST, (ViewRootImpl)viewRoot, (Surface)parent, (float)alpha));
                this.damageInParent();
            } else {
                this.mTmpTransaction.setAlpha(this.mSurfaceControl, alpha).apply();
            }
            this.mSurfaceAlpha = alpha;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performDrawFinished() {
        if (this.mDeferredDestroySurfaceControl != null) {
            Object object = this.mSurfaceControlLock;
            synchronized (object) {
                this.mTmpTransaction.remove(this.mDeferredDestroySurfaceControl).apply();
                this.mDeferredDestroySurfaceControl = null;
            }
        }
        if (this.mPendingReportDraws > 0) {
            this.mDrawFinished = true;
            if (this.mAttachedToWindow) {
                this.mParent.requestTransparentRegion(this);
                this.notifyDrawFinished();
                this.invalidate();
            }
        } else {
            Log.e(TAG, System.identityHashCode(this) + "finished drawing but no pending report draw (extra call to draw completion runnable?)");
        }
    }

    void notifyDrawFinished() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.pendingDrawFinished();
        }
        --this.mPendingReportDraws;
    }

    @Override
    protected void onDetachedFromWindow() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.removeSurfaceChangedCallback(this);
        }
        this.mAttachedToWindow = false;
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        while (this.mPendingReportDraws > 0) {
            this.notifyDrawFinished();
        }
        this.mRequestedVisible = false;
        this.updateSurface();
        this.releaseSurfaces();
        if (this.mSurfacePackage != null) {
            this.mSurfacePackage.release();
            this.mSurfacePackage = null;
        }
        this.mHaveFrame = false;
        super.onDetachedFromWindow();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mRequestedWidth >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedWidth, widthMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, widthMeasureSpec);
        int height = this.mRequestedHeight >= 0 ? _Original_SurfaceView.resolveSizeAndState(this.mRequestedHeight, heightMeasureSpec, 0) : _Original_SurfaceView.getDefaultSize(0, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    @Override
    @UnsupportedAppUsage
    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateSurface();
        return result;
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        if (this.isAboveParent() || !this.mDrawFinished) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    @Override
    public void draw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 0) {
            this.clearSurfaceViewPort(canvas);
        }
        super.draw(canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 128) {
            this.clearSurfaceViewPort(canvas);
        }
        super.dispatchDraw(canvas);
    }

    public void setEnableSurfaceClipping(boolean enabled) {
        this.mClipSurfaceToBounds = enabled;
        this.invalidate();
    }

    @Override
    public void setClipBounds(Rect clipBounds) {
        super.setClipBounds(clipBounds);
        if (!this.mClipSurfaceToBounds) {
            return;
        }
        if (this.mCornerRadius > 0.0f && !this.isAboveParent()) {
            this.invalidate();
        }
        if (this.mSurfaceControl != null) {
            if (this.mClipBounds != null) {
                this.mTmpRect.set(this.mClipBounds);
            } else {
                this.mTmpRect.set(0, 0, this.mSurfaceWidth, this.mSurfaceHeight);
            }
            SyncRtSurfaceTransactionApplier applier = new SyncRtSurfaceTransactionApplier(this);
            applier.scheduleApply(new SyncRtSurfaceTransactionApplier.SurfaceParams.Builder(this.mSurfaceControl).withWindowCrop(this.mTmpRect).build());
        }
    }

    private void clearSurfaceViewPort(Canvas canvas) {
        if (this.mCornerRadius > 0.0f) {
            canvas.getClipBounds(this.mTmpRect);
            if (this.mClipSurfaceToBounds && this.mClipBounds != null) {
                this.mTmpRect.intersect(this.mClipBounds);
            }
            canvas.drawRoundRect(this.mTmpRect.left, this.mTmpRect.top, this.mTmpRect.right, this.mTmpRect.bottom, this.mCornerRadius, this.mCornerRadius, this.mRoundedViewportPaint);
        } else {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
    }

    public void setCornerRadius(float cornerRadius) {
        this.mCornerRadius = cornerRadius;
        if (this.mCornerRadius > 0.0f && this.mRoundedViewportPaint == null) {
            this.mRoundedViewportPaint = new Paint(1);
            this.mRoundedViewportPaint.setBlendMode(BlendMode.CLEAR);
            this.mRoundedViewportPaint.setColor(0);
        }
        this.invalidate();
    }

    public float getCornerRadius() {
        return this.mCornerRadius;
    }

    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mSubLayer = isMediaOverlay ? -1 : -2;
    }

    public void setZOrderOnTop(boolean onTop) {
        boolean allowDynamicChange = this.getContext().getApplicationInfo().targetSdkVersion > 29;
        this.setZOrderedOnTop(onTop, allowDynamicChange);
    }

    public boolean isZOrderedOnTop() {
        return this.mSubLayer > 0;
    }

    public boolean setZOrderedOnTop(boolean onTop, boolean allowDynamicChange) {
        int subLayer = onTop ? 1 : -2;
        if (this.mSubLayer == subLayer) {
            return false;
        }
        this.mSubLayer = subLayer;
        if (!allowDynamicChange) {
            return false;
        }
        if (this.mSurfaceControl == null) {
            return true;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return true;
        }
        Surface parent = viewRoot.mSurface;
        if (parent == null || !parent.isValid()) {
            return true;
        }
        boolean useBLAST = viewRoot.useBLAST();
        viewRoot.registerRtFrameCallback((HardwareRenderer.FrameDrawingCallback)LambdaMetafactory.metafactory(null, null, null, (J)V, lambda$setZOrderedOnTop$2(boolean android.view.ViewRootImpl android.view.Surface long ), (J)V)((SurfaceView)((Object)this), (boolean)useBLAST, (ViewRootImpl)viewRoot, (Surface)parent));
        this.invalidate();
        return true;
    }

    public void setSecure(boolean isSecure) {
        this.mSurfaceFlags = isSecure ? (this.mSurfaceFlags |= 0x80) : (this.mSurfaceFlags &= 0xFFFFFF7F);
    }

    private void updateOpaqueFlag() {
        this.mSurfaceFlags = !PixelFormat.formatHasAlpha(this.mRequestedFormat) ? (this.mSurfaceFlags |= 0x400) : (this.mSurfaceFlags &= 0xFFFFFBFF);
    }

    private void updateBackgroundVisibility(SurfaceControl.Transaction t) {
        if (this.mBackgroundControl == null) {
            return;
        }
        if (this.mSubLayer < 0 && (this.mSurfaceFlags & 0x400) != 0 && !this.mDisableBackgroundLayer) {
            t.show(this.mBackgroundControl);
        } else {
            t.hide(this.mBackgroundControl);
        }
    }

    private SurfaceControl.Transaction updateBackgroundColor(SurfaceControl.Transaction t) {
        float[] colorComponents = new float[]{(float)Color.red(this.mBackgroundColor) / 255.0f, (float)Color.green(this.mBackgroundColor) / 255.0f, (float)Color.blue(this.mBackgroundColor) / 255.0f};
        t.setColor(this.mBackgroundControl, colorComponents);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSurfaces() {
        this.mSurfaceAlpha = 1.0f;
        Object object = this.mSurfaceControlLock;
        synchronized (object) {
            this.mSurface.release();
            if (this.mRtHandlingPositionUpdates) {
                this.mRtReleaseSurfaces = true;
                return;
            }
            if (this.mSurfaceControl != null) {
                this.mTmpTransaction.remove(this.mSurfaceControl);
                this.mSurfaceControl = null;
            }
            if (this.mBackgroundControl != null) {
                this.mTmpTransaction.remove(this.mBackgroundControl);
                this.mBackgroundControl = null;
            }
            this.mTmpTransaction.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSurface() {
        boolean layoutSizeChanged;
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        if (viewRoot.mSurface == null || !viewRoot.mSurface.isValid()) {
            this.notifySurfaceDestroyed();
            this.releaseSurfaces();
            return;
        }
        CompatibilityInfo.Translator translator = viewRoot.mTranslator;
        if (translator != null) {
            this.mSurface.setCompatibilityTranslator(translator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        float alpha = this.getFixedAlpha();
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean alphaChanged = this.mSurfaceAlpha != alpha;
        boolean creating = (this.mSurfaceControl == null || formatChanged || visibleChanged) && this.mRequestedVisible;
        boolean sizeChanged = this.mSurfaceWidth != myWidth || this.mSurfaceHeight != myHeight;
        boolean windowVisibleChanged = this.mWindowVisibility != this.mLastWindowVisibility;
        boolean redrawNeeded = false;
        this.getLocationInSurface(this.mLocation);
        boolean positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
        boolean bl = layoutSizeChanged = this.getWidth() != this.mScreenRect.width() || this.getHeight() != this.mScreenRect.height();
        if (creating || formatChanged || sizeChanged || visibleChanged || this.mUseAlpha && alphaChanged || windowVisibleChanged || positionChanged || layoutSizeChanged) {
            this.getLocationInWindow(this.mLocation);
            try {
                boolean visible = this.mVisible = this.mRequestedVisible;
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mSurfaceWidth = myWidth;
                this.mSurfaceHeight = myHeight;
                this.mFormat = this.mRequestedFormat;
                this.mLastWindowVisibility = this.mWindowVisibility;
                this.mScreenRect.left = this.mWindowSpaceLeft;
                this.mScreenRect.top = this.mWindowSpaceTop;
                this.mScreenRect.right = this.mWindowSpaceLeft + this.getWidth();
                this.mScreenRect.bottom = this.mWindowSpaceTop + this.getHeight();
                if (translator != null) {
                    translator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                Rect surfaceInsets = viewRoot.mWindowAttributes.surfaceInsets;
                this.mScreenRect.offset(surfaceInsets.left, surfaceInsets.top);
                if (creating) {
                    this.mDeferredDestroySurfaceControl = this.mSurfaceControl;
                    this.updateOpaqueFlag();
                    String name = "SurfaceView - " + viewRoot.getTitle().toString();
                    this.mSurfaceControl = new SurfaceControl.Builder(this.mSurfaceSession).setName(name).setLocalOwnerView(this).setOpaque((this.mSurfaceFlags & 0x400) != 0).setBufferSize(this.mSurfaceWidth, this.mSurfaceHeight).setFormat(this.mFormat).setParent(viewRoot.getBoundsLayer()).setFlags(this.mSurfaceFlags).setCallsite("SurfaceView.updateSurface").build();
                    this.mBackgroundControl = new SurfaceControl.Builder(this.mSurfaceSession).setName("Background for -" + name).setLocalOwnerView(this).setOpaque(true).setColorLayer().setParent(this.mSurfaceControl).setCallsite("SurfaceView.updateSurface").build();
                } else if (this.mSurfaceControl == null) {
                    return;
                }
                boolean realSizeChanged = false;
                this.mSurfaceLock.lock();
                try {
                    boolean bl2 = this.mDrawingStopped = !visible;
                    if (creating || this.mParentSurfaceGenerationId == viewRoot.mSurface.getGenerationId()) {
                        this.updateRelativeZ(this.mTmpTransaction);
                    }
                    this.mParentSurfaceGenerationId = viewRoot.mSurface.getGenerationId();
                    if (this.mViewVisibility) {
                        this.mTmpTransaction.show(this.mSurfaceControl);
                    } else {
                        this.mTmpTransaction.hide(this.mSurfaceControl);
                    }
                    if (this.mSurfacePackage != null) {
                        this.reparentSurfacePackage(this.mTmpTransaction, this.mSurfacePackage);
                    }
                    this.updateBackgroundVisibility(this.mTmpTransaction);
                    this.updateBackgroundColor(this.mTmpTransaction);
                    if (this.mUseAlpha) {
                        this.mTmpTransaction.setAlpha(this.mSurfaceControl, alpha);
                        this.mSurfaceAlpha = alpha;
                    }
                    if (sizeChanged || creating || !this.mRtHandlingPositionUpdates) {
                        this.onSetSurfacePositionAndScaleRT(this.mTmpTransaction, this.mSurfaceControl, this.mScreenRect.left, this.mScreenRect.top, (float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
                        if (this.mClipSurfaceToBounds && this.mClipBounds != null) {
                            this.mTmpTransaction.setWindowCrop(this.mSurfaceControl, this.mClipBounds);
                        } else {
                            this.mTmpTransaction.setWindowCrop(this.mSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight);
                        }
                    } else if ((layoutSizeChanged || positionChanged || visibleChanged) && viewRoot.useBLAST()) {
                        viewRoot.setUseBLASTSyncTransaction();
                    }
                    this.mTmpTransaction.setCornerRadius(this.mSurfaceControl, this.mCornerRadius);
                    if (sizeChanged && !creating) {
                        this.mTmpTransaction.setBufferSize(this.mSurfaceControl, this.mSurfaceWidth, this.mSurfaceHeight);
                    }
                    this.mTmpTransaction.apply();
                    this.updateScreenMatrixForEmbeddedHierarchy();
                    if (sizeChanged || creating) {
                        redrawNeeded = true;
                    }
                    this.mSurfaceFrame.left = 0;
                    this.mSurfaceFrame.top = 0;
                    if (translator == null) {
                        this.mSurfaceFrame.right = this.mSurfaceWidth;
                        this.mSurfaceFrame.bottom = this.mSurfaceHeight;
                    } else {
                        float appInvertedScale = translator.applicationInvertedScale;
                        this.mSurfaceFrame.right = (int)((float)this.mSurfaceWidth * appInvertedScale + 0.5f);
                        this.mSurfaceFrame.bottom = (int)((float)this.mSurfaceHeight * appInvertedScale + 0.5f);
                    }
                    int surfaceWidth = this.mSurfaceFrame.right;
                    int surfaceHeight = this.mSurfaceFrame.bottom;
                    realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
                    this.mLastSurfaceWidth = surfaceWidth;
                    this.mLastSurfaceHeight = surfaceHeight;
                }
                finally {
                    this.mSurfaceLock.unlock();
                }
                try {
                    redrawNeeded |= visible && !this.mDrawFinished;
                    SurfaceHolder.Callback[] callbacks = null;
                    boolean surfaceChanged = creating;
                    if (this.mSurfaceCreated && (surfaceChanged || !visible && visibleChanged)) {
                        this.mSurfaceCreated = false;
                        this.notifySurfaceDestroyed();
                    }
                    if (creating) {
                        this.mSurface.copyFrom(this.mSurfaceControl);
                    }
                    if (sizeChanged && this.getContext().getApplicationInfo().targetSdkVersion < 26) {
                        this.mSurface.createFrom(this.mSurfaceControl);
                    }
                    if (visible && this.mSurface.isValid()) {
                        if (!this.mSurfaceCreated && (surfaceChanged || visibleChanged)) {
                            this.mSurfaceCreated = true;
                            this.mIsCreating = true;
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        if (creating || formatChanged || sizeChanged || visibleChanged || realSizeChanged) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                            }
                        }
                        if (redrawNeeded) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            ++this.mPendingReportDraws;
                            viewRoot.drawPending();
                            SurfaceCallbackHelper sch = new SurfaceCallbackHelper((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, onDrawFinished(), ()V)((SurfaceView)((Object)this)));
                            sch.dispatchSurfaceRedrawNeededAsync(this.mSurfaceHolder, callbacks);
                        }
                    }
                }
                finally {
                    this.mIsCreating = false;
                    if (this.mSurfaceControl != null && !this.mSurfaceCreated) {
                        this.releaseSurfaces();
                    }
                }
            }
            catch (Exception ex) {
                Log.e(TAG, "Exception configuring surface", ex);
            }
        }
    }

    private void onDrawFinished() {
        this.runOnUiThread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, performDrawFinished(), ()V)((SurfaceView)((Object)this)));
    }

    protected void applyChildSurfaceTransaction_renderWorker(SurfaceControl.Transaction t, Surface viewRootSurface, long nextViewRootFrameNumber) {
    }

    protected void onSetSurfacePositionAndScaleRT(SurfaceControl.Transaction transaction, SurfaceControl surface, int positionLeft, int positionTop, float postScaleX, float postScaleY) {
        transaction.setPosition(surface, positionLeft, positionTop);
        transaction.setMatrix(surface, postScaleX, 0.0f, 0.0f, postScaleY);
    }

    public void requestUpdateSurfacePositionAndScale() {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.onSetSurfacePositionAndScaleRT(this.mTmpTransaction, this.mSurfaceControl, this.mScreenRect.left, this.mScreenRect.top, (float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
        this.mTmpTransaction.apply();
    }

    private void applySurfaceTransforms(SurfaceControl surface, SurfaceControl.Transaction t, Rect position, long frameNumber) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (frameNumber > 0L && viewRoot != null && !viewRoot.isDrawingToBLASTTransaction()) {
            t.deferTransactionUntil(surface, viewRoot.getRenderSurfaceControl(), frameNumber);
        }
        this.onSetSurfacePositionAndScaleRT(t, surface, position.left, position.top, (float)position.width() / (float)this.mSurfaceWidth, (float)position.height() / (float)this.mSurfaceHeight);
        if (this.mViewVisibility) {
            t.show(surface);
        }
    }

    public Rect getSurfaceRenderPosition() {
        return this.mRTLastReportedPosition;
    }

    private void setParentSpaceRectangle(Rect position, long frameNumber) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        boolean useBLAST = viewRoot.isDrawingToBLASTTransaction();
        SurfaceControl.Transaction t = useBLAST ? viewRoot.getBLASTSyncTransaction() : this.mRtTransaction;
        this.applySurfaceTransforms(this.mSurfaceControl, t, position, frameNumber);
        this.applyChildSurfaceTransaction_renderWorker(t, viewRoot.mSurface, frameNumber);
        if (!useBLAST) {
            t.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        SurfaceHolder.Callback[] callbacks;
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbacks);
        }
        return callbacks;
    }

    private void runOnUiThread(Runnable runnable) {
        Handler handler = this.getHandler();
        if (handler != null && handler.getLooper() != Looper.myLooper()) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    @UnsupportedAppUsage
    public boolean isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    private boolean isAboveParent() {
        return this.mSubLayer >= 0;
    }

    public void setResizeBackgroundColor(int bgColor) {
        if (this.mBackgroundControl == null) {
            return;
        }
        this.mBackgroundColor = bgColor;
        this.updateBackgroundColor(this.mTmpTransaction).apply();
    }

    public SurfaceControl getSurfaceControl() {
        return this.mSurfaceControl;
    }

    public IBinder getHostToken() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return null;
        }
        return viewRoot.getInputToken();
    }

    @Override
    public void surfaceCreated(SurfaceControl.Transaction t) {
        this.setWindowStopped(false);
    }

    @Override
    public void surfaceDestroyed() {
        this.setWindowStopped(true);
        this.setRemoteAccessibilityEmbeddedConnection(null, null);
    }

    @Override
    public void surfaceReplaced(SurfaceControl.Transaction t) {
        if (this.mSurfaceControl != null && this.mBackgroundControl != null) {
            this.updateRelativeZ(t);
        }
    }

    private void updateRelativeZ(SurfaceControl.Transaction t) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null) {
            return;
        }
        SurfaceControl viewRootControl = viewRoot.getSurfaceControl();
        t.setRelativeLayer(this.mBackgroundControl, viewRootControl, Integer.MIN_VALUE);
        t.setRelativeLayer(this.mSurfaceControl, viewRootControl, this.mSubLayer);
    }

    public void setChildSurfacePackage(SurfaceControlViewHost.SurfacePackage p) {
        SurfaceControl lastSc;
        SurfaceControl sc = p != null ? p.getSurfaceControl() : null;
        SurfaceControl surfaceControl = lastSc = this.mSurfacePackage != null ? this.mSurfacePackage.getSurfaceControl() : null;
        if (this.mSurfaceControl != null && lastSc != null) {
            this.mTmpTransaction.reparent(lastSc, null).apply();
            this.mSurfacePackage.release();
        } else if (this.mSurfaceControl != null) {
            this.reparentSurfacePackage(this.mTmpTransaction, p);
            this.mTmpTransaction.apply();
        }
        this.mSurfacePackage = p;
    }

    private void reparentSurfacePackage(SurfaceControl.Transaction t, SurfaceControlViewHost.SurfacePackage p) {
        this.initEmbeddedHierarchyForAccessibility(p);
        SurfaceControl sc = p.getSurfaceControl();
        t.reparent(sc, this.mSurfaceControl).show(sc);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        RemoteAccessibilityEmbeddedConnection wrapper = this.getRemoteAccessibilityEmbeddedConnection();
        if (wrapper == null) {
            return;
        }
        info.addChild(wrapper.getLeashToken());
    }

    @Override
    public int getImportantForAccessibility() {
        int mode = super.getImportantForAccessibility();
        if (this.mRemoteAccessibilityEmbeddedConnection == null || mode != 0) {
            return mode;
        }
        return 1;
    }

    private void initEmbeddedHierarchyForAccessibility(SurfaceControlViewHost.SurfacePackage p) {
        IAccessibilityEmbeddedConnection connection = p.getAccessibilityEmbeddedConnection();
        RemoteAccessibilityEmbeddedConnection wrapper = this.getRemoteAccessibilityEmbeddedConnection();
        if (wrapper != null && wrapper.getConnection().equals(connection)) {
            return;
        }
        this.setRemoteAccessibilityEmbeddedConnection(null, null);
        try {
            IBinder leashToken = connection.associateEmbeddedHierarchy(this.getViewRootImpl().mLeashToken, this.getAccessibilityViewId());
            this.setRemoteAccessibilityEmbeddedConnection(connection, leashToken);
        }
        catch (RemoteException e) {
            Log.d(TAG, "Error while associateEmbeddedHierarchy " + e);
        }
        this.updateScreenMatrixForEmbeddedHierarchy();
    }

    private void setRemoteAccessibilityEmbeddedConnection(IAccessibilityEmbeddedConnection connection, IBinder leashToken) {
        try {
            if (this.mRemoteAccessibilityEmbeddedConnection != null) {
                this.mRemoteAccessibilityEmbeddedConnection.getConnection().disassociateEmbeddedHierarchy();
                this.mRemoteAccessibilityEmbeddedConnection.unlinkToDeath();
                this.mRemoteAccessibilityEmbeddedConnection = null;
            }
            if (connection != null && leashToken != null) {
                this.mRemoteAccessibilityEmbeddedConnection = new RemoteAccessibilityEmbeddedConnection(connection, leashToken);
                this.mRemoteAccessibilityEmbeddedConnection.linkToDeath();
            }
        }
        catch (RemoteException e) {
            Log.d(TAG, "Error while setRemoteEmbeddedConnection " + e);
        }
    }

    private RemoteAccessibilityEmbeddedConnection getRemoteAccessibilityEmbeddedConnection() {
        return this.mRemoteAccessibilityEmbeddedConnection;
    }

    private void updateScreenMatrixForEmbeddedHierarchy() {
        this.getBoundsOnScreen(this.mTmpRect);
        this.mTmpMatrix.reset();
        this.mTmpMatrix.setTranslate(this.mTmpRect.left, this.mTmpRect.top);
        this.mTmpMatrix.postScale((float)this.mScreenRect.width() / (float)this.mSurfaceWidth, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
        if (this.mTmpMatrix.isIdentity() || this.mTmpMatrix.equals(this.mScreenMatrixForEmbeddedHierarchy)) {
            return;
        }
        try {
            RemoteAccessibilityEmbeddedConnection wrapper = this.getRemoteAccessibilityEmbeddedConnection();
            if (wrapper == null) {
                return;
            }
            this.mTmpMatrix.getValues(this.mMatrixValues);
            wrapper.getConnection().setScreenMatrix(this.mMatrixValues);
            this.mScreenMatrixForEmbeddedHierarchy.set(this.mTmpMatrix);
        }
        catch (RemoteException e) {
            Log.d(TAG, "Error while setScreenMatrix " + e);
        }
    }

    private void notifySurfaceDestroyed() {
        if (this.mSurface.isValid()) {
            SurfaceHolder.Callback[] callbacks;
            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                c.surfaceDestroyed(this.mSurfaceHolder);
            }
            if (this.mSurface.isValid()) {
                this.mSurface.forceScopedDisconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$setZOrderedOnTop$2(boolean useBLAST, ViewRootImpl viewRoot, Surface parent, long frame) {
        try {
            SurfaceControl.Transaction t = useBLAST ? viewRoot.getBLASTSyncTransaction() : new SurfaceControl.Transaction();
            Object object = this.mSurfaceControlLock;
            synchronized (object) {
                if (!parent.isValid() || this.mSurfaceControl == null) {
                    return;
                }
                this.updateRelativeZ(t);
                if (!useBLAST) {
                    t.deferTransactionUntil(this.mSurfaceControl, viewRoot.getRenderSurfaceControl(), frame);
                }
            }
            t.apply();
        }
        catch (Exception e) {
            Log.e(TAG, System.identityHashCode(this) + "setZOrderOnTop RT: Exception during surface transaction", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$updateSurfaceAlpha$1(boolean useBLAST, ViewRootImpl viewRoot, Surface parent, float alpha, long frame) {
        try {
            SurfaceControl.Transaction t = useBLAST ? viewRoot.getBLASTSyncTransaction() : new SurfaceControl.Transaction();
            Object object = this.mSurfaceControlLock;
            synchronized (object) {
                if (!parent.isValid()) {
                    return;
                }
                if (this.mSurfaceControl == null) {
                    return;
                }
                t.setAlpha(this.mSurfaceControl, alpha);
                if (!useBLAST) {
                    t.deferTransactionUntil(this.mSurfaceControl, viewRoot.getRenderSurfaceControl(), frame);
                }
            }
            t.apply();
        }
        catch (Exception e) {
            Log.e(TAG, System.identityHashCode(this) + "updateSurfaceAlpha RT: Exception during surface transaction", e);
        }
    }

    private /* synthetic */ boolean lambda$new$0() {
        this.mHaveFrame = this.getWidth() > 0 && this.getHeight() > 0;
        this.updateSurface();
        return true;
    }

    private class RemoteAccessibilityEmbeddedConnection
    implements IBinder.DeathRecipient {
        private final IAccessibilityEmbeddedConnection mConnection;
        private final IBinder mLeashToken;

        RemoteAccessibilityEmbeddedConnection(IAccessibilityEmbeddedConnection connection, IBinder leashToken) {
            this.mConnection = connection;
            this.mLeashToken = leashToken;
        }

        IAccessibilityEmbeddedConnection getConnection() {
            return this.mConnection;
        }

        IBinder getLeashToken() {
            return this.mLeashToken;
        }

        void linkToDeath() throws RemoteException {
            this.mConnection.asBinder().linkToDeath(this, 0);
        }

        void unlinkToDeath() {
            this.mConnection.asBinder().unlinkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            this.unlinkToDeath();
            _Original_SurfaceView.this.runOnUiThread(() -> ((SurfaceView.RemoteAccessibilityEmbeddedConnection)this).lambda$binderDied$0());
        }

        private /* synthetic */ void lambda$binderDied$0() {
            if (_Original_SurfaceView.this.mRemoteAccessibilityEmbeddedConnection == this) {
                _Original_SurfaceView.this.mRemoteAccessibilityEmbeddedConnection = null;
            }
        }
    }
}

