/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.ScrollCaptureCallback;
import android.view.ScrollCaptureTarget;
import android.view.View;
import android.view.ViewParent;
import com.android.internal.annotations.VisibleForTesting;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class ScrollCaptureTargetResolver {
    private static final String TAG = "ScrollCaptureTargetRes";
    private static final boolean DEBUG = true;
    private final Object mLock = new Object();
    private final Queue<ScrollCaptureTarget> mTargets;
    private Handler mHandler;
    private long mTimeLimitMillis;
    private Consumer<ScrollCaptureTarget> mWhenComplete;
    private int mPendingBoundsRequests;
    private long mDeadlineMillis;
    private ScrollCaptureTarget mResult;
    private boolean mFinished;
    private boolean mStarted;
    private final Runnable mTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            ScrollCaptureTargetResolver.this.checkThread();
            ScrollCaptureTargetResolver.this.supplyResult(null);
        }
    };

    private static int area(Rect r) {
        return r.width() * r.height();
    }

    private static boolean nullOrEmpty(Rect r) {
        return r == null || r.isEmpty();
    }

    private static ScrollCaptureTarget chooseTarget(ScrollCaptureTarget a, ScrollCaptureTarget b) {
        int scrollAreaB;
        boolean hintIncludeB;
        Log.d(TAG, "chooseTarget: " + a + " or " + b);
        if (a == null && b == null) {
            Log.d(TAG, "chooseTarget: (both null) return " + null);
            return null;
        }
        if (a == null || b == null) {
            ScrollCaptureTarget c = a == null ? b : a;
            Log.d(TAG, "chooseTarget: (other is null) return " + c);
            return c;
        }
        boolean emptyScrollBoundsA = ScrollCaptureTargetResolver.nullOrEmpty(a.getScrollBounds());
        boolean emptyScrollBoundsB = ScrollCaptureTargetResolver.nullOrEmpty(b.getScrollBounds());
        if (emptyScrollBoundsA || emptyScrollBoundsB) {
            if (emptyScrollBoundsA && emptyScrollBoundsB) {
                Log.d(TAG, "chooseTarget: (both have empty or null bounds) return " + null);
                return null;
            }
            if (emptyScrollBoundsA) {
                Log.d(TAG, "chooseTarget: (a has empty or null bounds) return " + b);
                return b;
            }
            Log.d(TAG, "chooseTarget: (b has empty or null bounds) return " + a);
            return a;
        }
        View viewA = a.getContainingView();
        View viewB = b.getContainingView();
        boolean hintIncludeA = ScrollCaptureTargetResolver.hasIncludeHint(viewA);
        if (hintIncludeA != (hintIncludeB = ScrollCaptureTargetResolver.hasIncludeHint(viewB))) {
            ScrollCaptureTarget c = hintIncludeA ? a : b;
            Log.d(TAG, "chooseTarget: (has hint=INCLUDE) return " + c);
            return c;
        }
        if (ScrollCaptureTargetResolver.isDescendant(viewA, viewB)) {
            Log.d(TAG, "chooseTarget: (b is descendant of a) return " + b);
            return b;
        }
        if (ScrollCaptureTargetResolver.isDescendant(viewB, viewA)) {
            Log.d(TAG, "chooseTarget: (a is descendant of b) return " + a);
            return a;
        }
        int scrollAreaA = ScrollCaptureTargetResolver.area(a.getScrollBounds());
        ScrollCaptureTarget c = scrollAreaA >= (scrollAreaB = ScrollCaptureTargetResolver.area(b.getScrollBounds())) ? a : b;
        Log.d(TAG, "chooseTarget: return " + c);
        return c;
    }

    public ScrollCaptureTargetResolver(Queue<ScrollCaptureTarget> targets) {
        this.mTargets = targets;
    }

    void checkThread() {
        if (this.mHandler.getLooper() != Looper.myLooper()) {
            throw new IllegalStateException("Called from wrong thread! (" + Thread.currentThread().getName() + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public ScrollCaptureTarget waitForResult() throws InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            while (!this.mFinished) {
                this.mLock.wait();
            }
        }
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void supplyResult(ScrollCaptureTarget target) {
        boolean finish;
        this.checkThread();
        if (this.mFinished) {
            return;
        }
        this.mResult = ScrollCaptureTargetResolver.chooseTarget(this.mResult, target);
        boolean bl = finish = this.mPendingBoundsRequests == 0 || SystemClock.elapsedRealtime() >= this.mDeadlineMillis;
        if (finish) {
            System.err.println("We think we're done, or timed out");
            this.mPendingBoundsRequests = 0;
            this.mWhenComplete.accept(this.mResult);
            Object object = this.mLock;
            synchronized (object) {
                this.mFinished = true;
                this.mLock.notify();
            }
            this.mWhenComplete = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Handler uiHandler, long timeLimitMillis, Consumer<ScrollCaptureTarget> resultConsumer) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                throw new IllegalStateException("already started!");
            }
            if (timeLimitMillis < 0L) {
                throw new IllegalArgumentException("Time limit must be positive");
            }
            this.mHandler = uiHandler;
            this.mTimeLimitMillis = timeLimitMillis;
            this.mWhenComplete = resultConsumer;
            if (this.mTargets.isEmpty()) {
                this.mHandler.post(() -> this.supplyResult(null));
                return;
            }
            this.mStarted = true;
            uiHandler.post(() -> this.run(timeLimitMillis, resultConsumer));
        }
    }

    private void run(long timeLimitMillis, Consumer<ScrollCaptureTarget> resultConsumer) {
        this.checkThread();
        this.mPendingBoundsRequests = this.mTargets.size();
        for (ScrollCaptureTarget target : this.mTargets) {
            this.queryTarget(target);
        }
        this.mDeadlineMillis = SystemClock.elapsedRealtime() + this.mTimeLimitMillis;
        this.mHandler.postAtTime(this.mTimeoutRunnable, this.mDeadlineMillis);
    }

    private void queryTarget(ScrollCaptureTarget target) {
        this.checkThread();
        ScrollCaptureCallback callback = target.getCallback();
        callback.onScrollCaptureSearch(new SingletonConsumer<Rect>(scrollBounds -> this.mHandler.post(() -> this.onScrollBoundsProvided(target, (Rect)scrollBounds))));
    }

    private void onScrollBoundsProvided(ScrollCaptureTarget target, Rect scrollBounds) {
        this.checkThread();
        if (this.mFinished) {
            return;
        }
        --this.mPendingBoundsRequests;
        this.mHandler.removeCallbacks(this.mTimeoutRunnable);
        boolean doneOrTimedOut = this.mPendingBoundsRequests == 0 || SystemClock.elapsedRealtime() >= this.mDeadlineMillis;
        View containingView = target.getContainingView();
        if (!ScrollCaptureTargetResolver.nullOrEmpty(scrollBounds) && containingView.isAggregatedVisible()) {
            target.updatePositionInWindow();
            target.setScrollBounds(scrollBounds);
            this.supplyResult(target);
        }
        System.err.println("mPendingBoundsRequests: " + this.mPendingBoundsRequests);
        System.err.println("mDeadlineMillis: " + this.mDeadlineMillis);
        System.err.println("SystemClock.elapsedRealtime(): " + SystemClock.elapsedRealtime());
        if (!this.mFinished) {
            System.err.println("We think we're NOT done yet and will check back at " + this.mDeadlineMillis);
            this.mHandler.postAtTime(this.mTimeoutRunnable, this.mDeadlineMillis);
        }
    }

    private static boolean hasIncludeHint(View view) {
        return (view.getScrollCaptureHint() & 2) != 0;
    }

    private static boolean isDescendant(View view, View otherView) {
        ViewParent otherParent;
        if (view == otherView) {
            return false;
        }
        for (otherParent = otherView.getParent(); otherParent != view && otherParent != null; otherParent = otherParent.getParent()) {
        }
        return otherParent == view;
    }

    private static int findRelation(View a, View b) {
        if (a == b) {
            return 0;
        }
        ViewParent parentA = a.getParent();
        ViewParent parentB = b.getParent();
        while (parentA != null || parentB != null) {
            if (parentA == parentB) {
                return 0;
            }
            if (parentA == b) {
                return 1;
            }
            if (parentB == a) {
                return -1;
            }
            if (parentA != null) {
                parentA = parentA.getParent();
            }
            if (parentB == null) continue;
            parentB = parentB.getParent();
        }
        return 0;
    }

    static class SingletonConsumer<T>
    implements Consumer<T> {
        final AtomicReference<Consumer<T>> mAtomicRef;

        SingletonConsumer(Consumer<T> target) {
            this.mAtomicRef = new AtomicReference<Consumer<T>>(target);
        }

        @Override
        public void accept(T t) {
            Consumer consumer = this.mAtomicRef.getAndSet(null);
            if (consumer != null) {
                consumer.accept(t);
            }
        }
    }
}

