/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.hardware.display.DeviceProductInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.proto.ProtoOutputStream;
import android.view.Display;
import android.view.DisplayAddress;
import android.view.DisplayAdjustments;
import android.view.DisplayCutout;
import java.util.Arrays;
import java.util.Objects;

public class DisplayInfo
implements Parcelable {
    public int layerStack;
    public int flags;
    public int type;
    public int displayId;
    public DisplayAddress address;
    public DeviceProductInfo deviceProductInfo;
    public String name;
    public String uniqueId;
    public int appWidth;
    public int appHeight;
    public int smallestNominalAppWidth;
    public int smallestNominalAppHeight;
    public int largestNominalAppWidth;
    public int largestNominalAppHeight;
    @UnsupportedAppUsage
    public int logicalWidth;
    @UnsupportedAppUsage
    public int logicalHeight;
    @UnsupportedAppUsage(maxTargetSdk=28)
    public DisplayCutout displayCutout;
    @UnsupportedAppUsage
    public int rotation;
    public int modeId;
    public int defaultModeId;
    public Display.Mode[] supportedModes = Display.Mode.EMPTY_ARRAY;
    public int colorMode;
    public int[] supportedColorModes = new int[]{0};
    public Display.HdrCapabilities hdrCapabilities;
    public boolean minimalPostProcessingSupported;
    public int logicalDensityDpi;
    public float physicalXDpi;
    public float physicalYDpi;
    public long appVsyncOffsetNanos;
    public long presentationDeadlineNanos;
    public int state;
    public int ownerUid;
    public String ownerPackageName;
    public int removeMode = 0;
    public static final Parcelable.Creator<DisplayInfo> CREATOR = new Parcelable.Creator<DisplayInfo>(){

        @Override
        public DisplayInfo createFromParcel(Parcel source) {
            return new DisplayInfo(source);
        }

        public DisplayInfo[] newArray(int size) {
            return new DisplayInfo[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=123769467L)
    public DisplayInfo() {
    }

    public DisplayInfo(DisplayInfo other) {
        this.copyFrom(other);
    }

    private DisplayInfo(Parcel source) {
        this.readFromParcel(source);
    }

    public boolean equals(Object o) {
        return o instanceof DisplayInfo && this.equals((DisplayInfo)o);
    }

    public boolean equals(DisplayInfo other) {
        return other != null && this.layerStack == other.layerStack && this.flags == other.flags && this.type == other.type && this.displayId == other.displayId && Objects.equals(this.address, other.address) && Objects.equals(this.deviceProductInfo, other.deviceProductInfo) && Objects.equals(this.uniqueId, other.uniqueId) && this.appWidth == other.appWidth && this.appHeight == other.appHeight && this.smallestNominalAppWidth == other.smallestNominalAppWidth && this.smallestNominalAppHeight == other.smallestNominalAppHeight && this.largestNominalAppWidth == other.largestNominalAppWidth && this.largestNominalAppHeight == other.largestNominalAppHeight && this.logicalWidth == other.logicalWidth && this.logicalHeight == other.logicalHeight && Objects.equals(this.displayCutout, other.displayCutout) && this.rotation == other.rotation && this.modeId == other.modeId && this.defaultModeId == other.defaultModeId && this.colorMode == other.colorMode && Arrays.equals(this.supportedColorModes, other.supportedColorModes) && Objects.equals(this.hdrCapabilities, other.hdrCapabilities) && this.minimalPostProcessingSupported == other.minimalPostProcessingSupported && this.logicalDensityDpi == other.logicalDensityDpi && this.physicalXDpi == other.physicalXDpi && this.physicalYDpi == other.physicalYDpi && this.appVsyncOffsetNanos == other.appVsyncOffsetNanos && this.presentationDeadlineNanos == other.presentationDeadlineNanos && this.state == other.state && this.ownerUid == other.ownerUid && Objects.equals(this.ownerPackageName, other.ownerPackageName) && this.removeMode == other.removeMode;
    }

    public int hashCode() {
        return 0;
    }

    public void copyFrom(DisplayInfo other) {
        this.layerStack = other.layerStack;
        this.flags = other.flags;
        this.type = other.type;
        this.displayId = other.displayId;
        this.address = other.address;
        this.deviceProductInfo = other.deviceProductInfo;
        this.name = other.name;
        this.uniqueId = other.uniqueId;
        this.appWidth = other.appWidth;
        this.appHeight = other.appHeight;
        this.smallestNominalAppWidth = other.smallestNominalAppWidth;
        this.smallestNominalAppHeight = other.smallestNominalAppHeight;
        this.largestNominalAppWidth = other.largestNominalAppWidth;
        this.largestNominalAppHeight = other.largestNominalAppHeight;
        this.logicalWidth = other.logicalWidth;
        this.logicalHeight = other.logicalHeight;
        this.displayCutout = other.displayCutout;
        this.rotation = other.rotation;
        this.modeId = other.modeId;
        this.defaultModeId = other.defaultModeId;
        this.supportedModes = Arrays.copyOf(other.supportedModes, other.supportedModes.length);
        this.colorMode = other.colorMode;
        this.supportedColorModes = Arrays.copyOf(other.supportedColorModes, other.supportedColorModes.length);
        this.hdrCapabilities = other.hdrCapabilities;
        this.minimalPostProcessingSupported = other.minimalPostProcessingSupported;
        this.logicalDensityDpi = other.logicalDensityDpi;
        this.physicalXDpi = other.physicalXDpi;
        this.physicalYDpi = other.physicalYDpi;
        this.appVsyncOffsetNanos = other.appVsyncOffsetNanos;
        this.presentationDeadlineNanos = other.presentationDeadlineNanos;
        this.state = other.state;
        this.ownerUid = other.ownerUid;
        this.ownerPackageName = other.ownerPackageName;
        this.removeMode = other.removeMode;
    }

    public void readFromParcel(Parcel source) {
        this.layerStack = source.readInt();
        this.flags = source.readInt();
        this.type = source.readInt();
        this.displayId = source.readInt();
        this.address = (DisplayAddress)source.readParcelable(null);
        this.deviceProductInfo = (DeviceProductInfo)source.readParcelable(null);
        this.name = source.readString8();
        this.appWidth = source.readInt();
        this.appHeight = source.readInt();
        this.smallestNominalAppWidth = source.readInt();
        this.smallestNominalAppHeight = source.readInt();
        this.largestNominalAppWidth = source.readInt();
        this.largestNominalAppHeight = source.readInt();
        this.logicalWidth = source.readInt();
        this.logicalHeight = source.readInt();
        this.displayCutout = DisplayCutout.ParcelableWrapper.readCutoutFromParcel(source);
        this.rotation = source.readInt();
        this.modeId = source.readInt();
        this.defaultModeId = source.readInt();
        int nModes = source.readInt();
        this.supportedModes = new Display.Mode[nModes];
        for (int i = 0; i < nModes; ++i) {
            this.supportedModes[i] = Display.Mode.CREATOR.createFromParcel(source);
        }
        this.colorMode = source.readInt();
        int nColorModes = source.readInt();
        this.supportedColorModes = new int[nColorModes];
        for (int i = 0; i < nColorModes; ++i) {
            this.supportedColorModes[i] = source.readInt();
        }
        this.hdrCapabilities = (Display.HdrCapabilities)source.readParcelable(null);
        this.minimalPostProcessingSupported = source.readBoolean();
        this.logicalDensityDpi = source.readInt();
        this.physicalXDpi = source.readFloat();
        this.physicalYDpi = source.readFloat();
        this.appVsyncOffsetNanos = source.readLong();
        this.presentationDeadlineNanos = source.readLong();
        this.state = source.readInt();
        this.ownerUid = source.readInt();
        this.ownerPackageName = source.readString8();
        this.uniqueId = source.readString8();
        this.removeMode = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int i;
        dest.writeInt(this.layerStack);
        dest.writeInt(this.flags);
        dest.writeInt(this.type);
        dest.writeInt(this.displayId);
        dest.writeParcelable(this.address, flags);
        dest.writeParcelable(this.deviceProductInfo, flags);
        dest.writeString8(this.name);
        dest.writeInt(this.appWidth);
        dest.writeInt(this.appHeight);
        dest.writeInt(this.smallestNominalAppWidth);
        dest.writeInt(this.smallestNominalAppHeight);
        dest.writeInt(this.largestNominalAppWidth);
        dest.writeInt(this.largestNominalAppHeight);
        dest.writeInt(this.logicalWidth);
        dest.writeInt(this.logicalHeight);
        DisplayCutout.ParcelableWrapper.writeCutoutToParcel(this.displayCutout, dest, flags);
        dest.writeInt(this.rotation);
        dest.writeInt(this.modeId);
        dest.writeInt(this.defaultModeId);
        dest.writeInt(this.supportedModes.length);
        for (i = 0; i < this.supportedModes.length; ++i) {
            this.supportedModes[i].writeToParcel(dest, flags);
        }
        dest.writeInt(this.colorMode);
        dest.writeInt(this.supportedColorModes.length);
        for (i = 0; i < this.supportedColorModes.length; ++i) {
            dest.writeInt(this.supportedColorModes[i]);
        }
        dest.writeParcelable(this.hdrCapabilities, flags);
        dest.writeBoolean(this.minimalPostProcessingSupported);
        dest.writeInt(this.logicalDensityDpi);
        dest.writeFloat(this.physicalXDpi);
        dest.writeFloat(this.physicalYDpi);
        dest.writeLong(this.appVsyncOffsetNanos);
        dest.writeLong(this.presentationDeadlineNanos);
        dest.writeInt(this.state);
        dest.writeInt(this.ownerUid);
        dest.writeString8(this.ownerPackageName);
        dest.writeString8(this.uniqueId);
        dest.writeInt(this.removeMode);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Display.Mode getMode() {
        return this.findMode(this.modeId);
    }

    public Display.Mode getDefaultMode() {
        return this.findMode(this.defaultModeId);
    }

    private Display.Mode findMode(int id2) {
        for (int i = 0; i < this.supportedModes.length; ++i) {
            if (this.supportedModes[i].getModeId() != id2) continue;
            return this.supportedModes[i];
        }
        throw new IllegalStateException("Unable to locate mode " + id2);
    }

    public int findDefaultModeByRefreshRate(float refreshRate) {
        Display.Mode[] modes = this.supportedModes;
        Display.Mode defaultMode = this.getDefaultMode();
        for (int i = 0; i < modes.length; ++i) {
            if (!modes[i].matches(defaultMode.getPhysicalWidth(), defaultMode.getPhysicalHeight(), refreshRate)) continue;
            return modes[i].getModeId();
        }
        return 0;
    }

    public float[] getDefaultRefreshRates() {
        Display.Mode[] modes = this.supportedModes;
        ArraySet<Float> rates = new ArraySet<Float>();
        Display.Mode defaultMode = this.getDefaultMode();
        for (int i = 0; i < modes.length; ++i) {
            Display.Mode mode = modes[i];
            if (mode.getPhysicalWidth() != defaultMode.getPhysicalWidth() || mode.getPhysicalHeight() != defaultMode.getPhysicalHeight()) continue;
            rates.add(Float.valueOf(mode.getRefreshRate()));
        }
        float[] result = new float[rates.size()];
        int i = 0;
        for (Float rate : rates) {
            result[i++] = rate.floatValue();
        }
        return result;
    }

    public void getAppMetrics(DisplayMetrics outMetrics) {
        this.getAppMetrics(outMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
    }

    public void getAppMetrics(DisplayMetrics outMetrics, DisplayAdjustments displayAdjustments) {
        this.getMetricsWithSize(outMetrics, displayAdjustments.getCompatibilityInfo(), displayAdjustments.getConfiguration(), this.appWidth, this.appHeight);
    }

    public void getAppMetrics(DisplayMetrics outMetrics, CompatibilityInfo ci, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, ci, configuration, this.appWidth, this.appHeight);
    }

    public void getLogicalMetrics(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration) {
        this.getMetricsWithSize(outMetrics, compatInfo, configuration, this.logicalWidth, this.logicalHeight);
    }

    public int getNaturalWidth() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalWidth : this.logicalHeight;
    }

    public int getNaturalHeight() {
        return this.rotation == 0 || this.rotation == 2 ? this.logicalHeight : this.logicalWidth;
    }

    public boolean isHdr() {
        int[] types = this.hdrCapabilities != null ? this.hdrCapabilities.getSupportedHdrTypes() : null;
        return types != null && types.length > 0;
    }

    public boolean isWideColorGamut() {
        for (int colorMode : this.supportedColorModes) {
            if (colorMode != 6 && colorMode <= 7) continue;
            return true;
        }
        return false;
    }

    public boolean hasAccess(int uid) {
        return Display.hasAccess(uid, this.flags, this.ownerUid, this.displayId);
    }

    private void getMetricsWithSize(DisplayMetrics outMetrics, CompatibilityInfo compatInfo, Configuration configuration, int width, int height) {
        outMetrics.densityDpi = outMetrics.noncompatDensityDpi = this.logicalDensityDpi;
        outMetrics.scaledDensity = outMetrics.noncompatScaledDensity = (outMetrics.density = (outMetrics.noncompatDensity = (float)this.logicalDensityDpi * 0.00625f));
        outMetrics.xdpi = outMetrics.noncompatXdpi = this.physicalXDpi;
        outMetrics.ydpi = outMetrics.noncompatYdpi = this.physicalYDpi;
        Rect appBounds = configuration != null ? configuration.windowConfiguration.getAppBounds() : null;
        width = appBounds != null ? appBounds.width() : width;
        height = appBounds != null ? appBounds.height() : height;
        outMetrics.noncompatWidthPixels = outMetrics.widthPixels = width;
        outMetrics.noncompatHeightPixels = outMetrics.heightPixels = height;
        if (!compatInfo.equals(CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO)) {
            compatInfo.applyToDisplayMetrics(outMetrics);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DisplayInfo{\"");
        sb.append(this.name);
        sb.append("\", displayId ");
        sb.append(this.displayId);
        sb.append(DisplayInfo.flagsToString(this.flags));
        sb.append(", real ");
        sb.append(this.logicalWidth);
        sb.append(" x ");
        sb.append(this.logicalHeight);
        sb.append(", largest app ");
        sb.append(this.largestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.largestNominalAppHeight);
        sb.append(", smallest app ");
        sb.append(this.smallestNominalAppWidth);
        sb.append(" x ");
        sb.append(this.smallestNominalAppHeight);
        sb.append(", appVsyncOff ");
        sb.append(this.appVsyncOffsetNanos);
        sb.append(", presDeadline ");
        sb.append(this.presentationDeadlineNanos);
        sb.append(", mode ");
        sb.append(this.modeId);
        sb.append(", defaultMode ");
        sb.append(this.defaultModeId);
        sb.append(", modes ");
        sb.append(Arrays.toString(this.supportedModes));
        sb.append(", hdrCapabilities ");
        sb.append(this.hdrCapabilities);
        sb.append(", minimalPostProcessingSupported ");
        sb.append(this.minimalPostProcessingSupported);
        sb.append(", rotation ");
        sb.append(this.rotation);
        sb.append(", state ");
        sb.append(Display.stateToString(this.state));
        if (Process.myUid() != 1000) {
            sb.append("}");
            return sb.toString();
        }
        sb.append(", type ");
        sb.append(Display.typeToString(this.type));
        sb.append(", uniqueId \"");
        sb.append(this.uniqueId);
        sb.append("\", app ");
        sb.append(this.appWidth);
        sb.append(" x ");
        sb.append(this.appHeight);
        sb.append(", density ");
        sb.append(this.logicalDensityDpi);
        sb.append(" (");
        sb.append(this.physicalXDpi);
        sb.append(" x ");
        sb.append(this.physicalYDpi);
        sb.append(") dpi, layerStack ");
        sb.append(this.layerStack);
        sb.append(", colorMode ");
        sb.append(this.colorMode);
        sb.append(", supportedColorModes ");
        sb.append(Arrays.toString(this.supportedColorModes));
        if (this.address != null) {
            sb.append(", address ").append(this.address);
        }
        sb.append(", deviceProductInfo ");
        sb.append(this.deviceProductInfo);
        if (this.ownerUid != 0 || this.ownerPackageName != null) {
            sb.append(", owner ").append(this.ownerPackageName);
            sb.append(" (uid ").append(this.ownerUid).append(")");
        }
        sb.append(", removeMode ");
        sb.append(this.removeMode);
        sb.append("}");
        return sb.toString();
    }

    public void dumpDebug(ProtoOutputStream protoOutputStream, long fieldId) {
        long token = protoOutputStream.start(fieldId);
        protoOutputStream.write(0x10500000001L, this.logicalWidth);
        protoOutputStream.write(1120986464258L, this.logicalHeight);
        protoOutputStream.write(1120986464259L, this.appWidth);
        protoOutputStream.write(1120986464260L, this.appHeight);
        protoOutputStream.write(1138166333445L, this.name);
        protoOutputStream.write(1120986464262L, this.flags);
        protoOutputStream.end(token);
    }

    private static String flagsToString(int flags) {
        StringBuilder result = new StringBuilder();
        if ((flags & 2) != 0) {
            result.append(", FLAG_SECURE");
        }
        if ((flags & 1) != 0) {
            result.append(", FLAG_SUPPORTS_PROTECTED_BUFFERS");
        }
        if ((flags & 4) != 0) {
            result.append(", FLAG_PRIVATE");
        }
        if ((flags & 8) != 0) {
            result.append(", FLAG_PRESENTATION");
        }
        if ((flags & 0x40000000) != 0) {
            result.append(", FLAG_SCALING_DISABLED");
        }
        if ((flags & 0x10) != 0) {
            result.append(", FLAG_ROUND");
        }
        if ((flags & 0x20) != 0) {
            result.append(", FLAG_CAN_SHOW_WITH_INSECURE_KEYGUARD");
        }
        if ((flags & 0x40) != 0) {
            result.append(", FLAG_SHOULD_SHOW_SYSTEM_DECORATIONS");
        }
        if ((flags & 0x80) != 0) {
            result.append(", FLAG_TRUSTED");
        }
        return result.toString();
    }
}

