/*
 * Decompiled with CFR 0.152.
 */
package android.util.imagepool;

import android.util.imagepool.ImagePoolStats;
import android.util.imagepool.ImagePoolStatsProdImpl;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;

public class ImagePoolStatsDebugImpl
extends ImagePoolStatsProdImpl {
    private static String PACKAGE_NAME = ImagePoolStats.class.getPackage().getName();
    private final Map<Integer, String> mCallStack = new HashMap<Integer, String>();
    private long mRequestedTotalBytes = 0L;
    private long mAllocatedOutsidePoolBytes = 0L;
    private long mPreviousGcCollection = 0L;
    private long mPreviousGcTime = 0L;

    @Override
    public void recordBucketCreation(int widthBucket, int heightBucket) {
        super.recordBucketCreation(widthBucket, heightBucket);
    }

    @Override
    public boolean fitsMaxCacheSize(int width, int height, long maxCacheSize) {
        return super.fitsMaxCacheSize(width, height, maxCacheSize);
    }

    @Override
    public void clear() {
        super.clear();
        this.mRequestedTotalBytes = 0L;
        this.mAllocatedOutsidePoolBytes = 0L;
        this.mTooBigForPoolCount = 0;
        this.mCallStack.clear();
    }

    @Override
    public void tooBigForCache() {
        super.tooBigForCache();
    }

    @Override
    public void recordBucketRequest(int w, int h) {
        this.mRequestedTotalBytes += (long)(w * h * ESTIMATED_PIXEL_BYTES);
    }

    @Override
    public void recordAllocOutsidePool(int width, int height) {
        this.mAllocatedOutsidePoolBytes += (long)(width * height * ESTIMATED_PIXEL_BYTES);
    }

    @Override
    public void acquiredImage(Integer imageHash) {
        for (int i = 1; i < Thread.currentThread().getStackTrace().length; ++i) {
            StackTraceElement element = Thread.currentThread().getStackTrace()[i];
            String str = element.toString();
            if (str.contains(PACKAGE_NAME)) continue;
            this.mCallStack.put(imageHash, str);
            break;
        }
    }

    @Override
    public void disposeImage(Integer imageHash) {
        this.mCallStack.remove(imageHash);
    }

    @Override
    public void start() {
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count >= 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) < 0L) continue;
            garbageCollectionTime += time;
        }
        this.mPreviousGcCollection = totalGarbageCollections;
        this.mPreviousGcTime = garbageCollectionTime;
    }

    private String calculateGcStatAndReturn() {
        long totalGarbageCollections = 0L;
        long garbageCollectionTime = 0L;
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            long time;
            long count = gc.getCollectionCount();
            if (count > 0L) {
                totalGarbageCollections += count;
            }
            if ((time = gc.getCollectionTime()) <= 0L) continue;
            garbageCollectionTime += time;
        }
        garbageCollectionTime -= this.mPreviousGcTime;
        StringBuilder builder = new StringBuilder();
        builder.append("Total Garbage Collections: ");
        builder.append(totalGarbageCollections -= this.mPreviousGcCollection);
        builder.append("\n");
        builder.append("Total Garbage Collection Time (ms): ");
        builder.append(garbageCollectionTime);
        builder.append("\n");
        return builder.toString();
    }

    @Override
    public String getStatistic() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.calculateGcStatAndReturn());
        builder.append("Memory\n");
        builder.append(" requested total         : ");
        builder.append(this.mRequestedTotalBytes / 1000000L);
        builder.append(" MB\n");
        builder.append(" allocated (in pool)     : ");
        builder.append(this.mAllocateTotalBytes / 1000000L);
        builder.append(" MB\n");
        builder.append(" allocated (out of pool) : ");
        builder.append(this.mAllocatedOutsidePoolBytes / 1000000L);
        builder.append(" MB\n");
        double percent = 1.0 - (double)this.mRequestedTotalBytes / (double)(this.mAllocateTotalBytes + this.mAllocatedOutsidePoolBytes);
        if (percent < 0.0) {
            builder.append(" saved : ");
            builder.append(-1.0 * percent);
            builder.append("%\n");
        } else {
            builder.append(" wasting : ");
            builder.append(percent);
            builder.append("%\n");
        }
        builder.append("Undispose images\n");
        HashMultiset countSet = HashMultiset.create();
        for (String callsite : this.mCallStack.values()) {
            countSet.add((Object)callsite);
        }
        for (Multiset.Entry entry : countSet.entrySet()) {
            builder.append(" - ");
            builder.append((String)entry.getElement());
            builder.append(" - missed dispose : ");
            builder.append(entry.getCount());
            builder.append(" times\n");
        }
        builder.append("Number of times requested image didn't fit the pool : ");
        builder.append(this.mTooBigForPoolCount);
        builder.append("\n");
        return builder.toString();
    }
}

