/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.LeakyTypefaceStorage;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Parcel;
import android.text.ParcelableSpan;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;

public class TypefaceSpan
extends MetricAffectingSpan
implements ParcelableSpan {
    private final String mFamily;
    private final Typeface mTypeface;

    public TypefaceSpan(String family) {
        this(family, null);
    }

    public TypefaceSpan(Typeface typeface) {
        this(null, typeface);
    }

    public TypefaceSpan(Parcel src) {
        this.mFamily = src.readString();
        this.mTypeface = LeakyTypefaceStorage.readTypefaceFromParcel(src);
    }

    private TypefaceSpan(String family, Typeface typeface) {
        this.mFamily = family;
        this.mTypeface = typeface;
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 13;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeString(this.mFamily);
        LeakyTypefaceStorage.writeTypefaceToParcel(this.mTypeface, dest);
    }

    public String getFamily() {
        return this.mFamily;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    @Override
    public void updateDrawState(TextPaint ds) {
        this.updateTypeface(ds);
    }

    @Override
    public void updateMeasureState(TextPaint paint) {
        this.updateTypeface(paint);
    }

    private void updateTypeface(Paint paint) {
        if (this.mTypeface != null) {
            paint.setTypeface(this.mTypeface);
        } else if (this.mFamily != null) {
            this.applyFontFamily(paint, this.mFamily);
        }
    }

    private void applyFontFamily(Paint paint, String family) {
        Typeface styledTypeface;
        Typeface old = paint.getTypeface();
        int style2 = old == null ? 0 : old.getStyle();
        int fake = style2 & ~(styledTypeface = Typeface.create(family, style2)).getStyle();
        if ((fake & 1) != 0) {
            paint.setFakeBoldText(true);
        }
        if ((fake & 2) != 0) {
            paint.setTextSkewX(-0.25f);
        }
        paint.setTypeface(styledTypeface);
    }
}

