/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.telephony.CellInfo;
import android.telephony.NetworkScan;
import android.telephony.NetworkScanRequest;
import android.telephony.TelephonyFrameworkInitializer;
import android.util.SparseArray;
import com.android.internal.telephony.ITelephony;
import com.android.internal.util.Preconditions;
import com.android.telephony.Rlog;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;

public class TelephonyScanManager {
    private static final String TAG = "TelephonyScanManager";
    public static final String SCAN_RESULT_KEY = "scanResult";
    public static final int CALLBACK_SCAN_RESULTS = 1;
    public static final int CALLBACK_SCAN_ERROR = 2;
    public static final int CALLBACK_SCAN_COMPLETE = 3;
    public static final int CALLBACK_RESTRICTED_SCAN_RESULTS = 4;
    public static final int INVALID_SCAN_ID = -1;
    private final Looper mLooper;
    private final Messenger mMessenger;
    private final SparseArray<NetworkScanInfo> mScanInfo = new SparseArray();

    public TelephonyScanManager() {
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mLooper = thread.getLooper();
        this.mMessenger = new Messenger(new Handler(this.mLooper){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message message) {
                NetworkScanInfo nsi;
                Preconditions.checkNotNull(message, "message cannot be null");
                SparseArray sparseArray = TelephonyScanManager.this.mScanInfo;
                synchronized (sparseArray) {
                    nsi = (NetworkScanInfo)TelephonyScanManager.this.mScanInfo.get(message.arg2);
                }
                if (nsi == null) {
                    throw new RuntimeException("Failed to find NetworkScanInfo with id " + message.arg2);
                }
                NetworkScanCallback callback = nsi.mCallback;
                Executor executor = nsi.mExecutor;
                if (callback == null) {
                    throw new RuntimeException("Failed to find NetworkScanCallback with id " + message.arg2);
                }
                if (executor == null) {
                    throw new RuntimeException("Failed to find Executor with id " + message.arg2);
                }
                switch (message.what) {
                    case 1: 
                    case 4: {
                        try {
                            Bundle b = message.getData();
                            Parcelable[] parcelables = b.getParcelableArray(TelephonyScanManager.SCAN_RESULT_KEY);
                            CellInfo[] ci = new CellInfo[parcelables.length];
                            for (int i = 0; i < parcelables.length; ++i) {
                                ci[i] = (CellInfo)parcelables[i];
                            }
                            executor.execute(() -> {
                                Rlog.d(TelephonyScanManager.TAG, "onResults: " + ci.toString());
                                callback.onResults(Arrays.asList(ci));
                            });
                        }
                        catch (Exception e) {
                            Rlog.e(TelephonyScanManager.TAG, "Exception in networkscan callback onResults", e);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            int errorCode = message.arg1;
                            executor.execute(() -> {
                                Rlog.d(TelephonyScanManager.TAG, "onError: " + errorCode);
                                callback.onError(errorCode);
                            });
                        }
                        catch (Exception e) {
                            Rlog.e(TelephonyScanManager.TAG, "Exception in networkscan callback onError", e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            executor.execute(() -> {
                                Rlog.d(TelephonyScanManager.TAG, "onComplete");
                                callback.onComplete();
                            });
                            TelephonyScanManager.this.mScanInfo.remove(message.arg2);
                        }
                        catch (Exception e) {
                            Rlog.e(TelephonyScanManager.TAG, "Exception in networkscan callback onComplete", e);
                        }
                        break;
                    }
                    default: {
                        Rlog.e(TelephonyScanManager.TAG, "Unhandled message " + Integer.toHexString(message.what));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkScan requestNetworkScan(int subId, NetworkScanRequest request, Executor executor, NetworkScanCallback callback, String callingPackage, String callingFeatureId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                SparseArray<NetworkScanInfo> sparseArray = this.mScanInfo;
                synchronized (sparseArray) {
                    int scanId = telephony.requestNetworkScan(subId, request, this.mMessenger, new Binder(), callingPackage, callingFeatureId);
                    if (scanId == -1) {
                        Rlog.e(TAG, "Failed to initiate network scan");
                        return null;
                    }
                    this.saveScanInfo(scanId, request, executor, callback);
                    return new NetworkScan(scanId, subId);
                }
            }
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "requestNetworkScan RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e(TAG, "requestNetworkScan NPE", ex);
        }
        return null;
    }

    private void saveScanInfo(int id2, NetworkScanRequest request, Executor executor, NetworkScanCallback callback) {
        this.mScanInfo.put(id2, new NetworkScanInfo(request, executor, callback));
    }

    private ITelephony getITelephony() {
        return ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
    }

    private static class NetworkScanInfo {
        private final NetworkScanRequest mRequest;
        private final Executor mExecutor;
        private final NetworkScanCallback mCallback;

        NetworkScanInfo(NetworkScanRequest request, Executor executor, NetworkScanCallback callback) {
            this.mRequest = request;
            this.mExecutor = executor;
            this.mCallback = callback;
        }
    }

    public static abstract class NetworkScanCallback {
        public void onResults(List<CellInfo> results) {
        }

        public void onComplete() {
        }

        public void onError(int error) {
        }
    }
}

