/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import java.util.Objects;

public class TelephonyDisplayInfo
implements Parcelable {
    public static final int OVERRIDE_NETWORK_TYPE_NONE = 0;
    public static final int OVERRIDE_NETWORK_TYPE_LTE_CA = 1;
    public static final int OVERRIDE_NETWORK_TYPE_LTE_ADVANCED_PRO = 2;
    public static final int OVERRIDE_NETWORK_TYPE_NR_NSA = 3;
    public static final int OVERRIDE_NETWORK_TYPE_NR_NSA_MMWAVE = 4;
    private final int mNetworkType;
    private final int mOverrideNetworkType;
    public static final Parcelable.Creator<TelephonyDisplayInfo> CREATOR = new Parcelable.Creator<TelephonyDisplayInfo>(){

        @Override
        public TelephonyDisplayInfo createFromParcel(Parcel source) {
            return new TelephonyDisplayInfo(source);
        }

        public TelephonyDisplayInfo[] newArray(int size) {
            return new TelephonyDisplayInfo[size];
        }
    };

    public TelephonyDisplayInfo(int networkType, int overrideNetworkType) {
        this.mNetworkType = networkType;
        this.mOverrideNetworkType = overrideNetworkType;
    }

    public TelephonyDisplayInfo(Parcel p) {
        this.mNetworkType = p.readInt();
        this.mOverrideNetworkType = p.readInt();
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public int getOverrideNetworkType() {
        return this.mOverrideNetworkType;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkType);
        dest.writeInt(this.mOverrideNetworkType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyDisplayInfo that = (TelephonyDisplayInfo)o;
        return this.mNetworkType == that.mNetworkType && this.mOverrideNetworkType == that.mOverrideNetworkType;
    }

    public int hashCode() {
        return Objects.hash(this.mNetworkType, this.mOverrideNetworkType);
    }

    public static String overrideNetworkTypeToString(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "LTE_CA";
            }
            case 2: {
                return "LTE_ADV_PRO";
            }
            case 3: {
                return "NR_NSA";
            }
            case 4: {
                return "NR_NSA_MMWAVE";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "TelephonyDisplayInfo {network=" + TelephonyManager.getNetworkTypeName(this.mNetworkType) + ", override=" + TelephonyDisplayInfo.overrideNetworkTypeToString(this.mOverrideNetworkType) + "}";
    }
}

