/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.telephony.CellIdentityNr;
import android.telephony.CellInfo;
import android.telephony.CellSignalStrength;
import android.telephony.CellSignalStrengthNr;
import dalvik.annotation.codegen.CovariantReturnType;
import java.util.Objects;

public class CellInfoNr
extends CellInfo {
    private static final String TAG = "CellInfoNr";
    private final CellIdentityNr mCellIdentity;
    private final CellSignalStrengthNr mCellSignalStrength;
    public static final Parcelable.Creator<CellInfoNr> CREATOR = new Parcelable.Creator<CellInfoNr>(){

        @Override
        public CellInfoNr createFromParcel(Parcel in) {
            in.readInt();
            return new CellInfoNr(in);
        }

        public CellInfoNr[] newArray(int size) {
            return new CellInfoNr[size];
        }
    };

    private CellInfoNr(Parcel in) {
        super(in);
        this.mCellIdentity = CellIdentityNr.CREATOR.createFromParcel(in);
        this.mCellSignalStrength = CellSignalStrengthNr.CREATOR.createFromParcel(in);
    }

    private CellInfoNr(CellInfoNr other, boolean sanitizeLocationInfo) {
        super(other);
        this.mCellIdentity = sanitizeLocationInfo ? other.mCellIdentity.sanitizeLocationInfo() : other.mCellIdentity;
        this.mCellSignalStrength = other.mCellSignalStrength;
    }

    public CellInfoNr(android.hardware.radio.V1_4.CellInfo ci, long timeStamp) {
        super(ci, timeStamp);
        android.hardware.radio.V1_4.CellInfoNr cil = ci.info.nr();
        this.mCellIdentity = new CellIdentityNr(cil.cellidentity);
        this.mCellSignalStrength = new CellSignalStrengthNr(cil.signalStrength);
    }

    public CellInfoNr(android.hardware.radio.V1_5.CellInfo ci, long timeStamp) {
        super(ci, timeStamp);
        android.hardware.radio.V1_5.CellInfoNr cil = ci.ratSpecificInfo.nr();
        this.mCellIdentity = new CellIdentityNr(cil.cellIdentityNr);
        this.mCellSignalStrength = new CellSignalStrengthNr(cil.signalStrengthNr);
    }

    @Override
    @CovariantReturnType(returnType=CellIdentityNr.class, presentAfter=29)
    public CellIdentity getCellIdentity() {
        return this.mCellIdentity;
    }

    @Override
    @CovariantReturnType(returnType=CellSignalStrengthNr.class, presentAfter=29)
    public CellSignalStrength getCellSignalStrength() {
        return this.mCellSignalStrength;
    }

    @Override
    public CellInfo sanitizeLocationInfo() {
        return new CellInfoNr(this, true);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mCellIdentity, this.mCellSignalStrength);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof CellInfoNr)) {
            return false;
        }
        CellInfoNr o = (CellInfoNr)other;
        return super.equals(o) && this.mCellIdentity.equals(o.mCellIdentity) && this.mCellSignalStrength.equals(o.mCellSignalStrength);
    }

    @Override
    public String toString() {
        return "CellInfoNr:{" + (" " + super.toString()) + (" " + this.mCellIdentity) + (" " + this.mCellSignalStrength) + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags, 6);
        this.mCellIdentity.writeToParcel(dest, flags);
        this.mCellSignalStrength.writeToParcel(dest, flags);
    }

    protected static CellInfoNr createFromParcelBody(Parcel in) {
        return new CellInfoNr(in);
    }
}

