/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AvailableNetworkInfo
implements Parcelable {
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_MED = 2;
    public static final int PRIORITY_LOW = 3;
    private int mSubId;
    private int mPriority;
    private ArrayList<String> mMccMncs;
    private ArrayList<Integer> mBands;
    public static final Parcelable.Creator<AvailableNetworkInfo> CREATOR = new Parcelable.Creator<AvailableNetworkInfo>(){

        @Override
        public AvailableNetworkInfo createFromParcel(Parcel in) {
            return new AvailableNetworkInfo(in);
        }

        public AvailableNetworkInfo[] newArray(int size) {
            return new AvailableNetworkInfo[size];
        }
    };

    public int getSubId() {
        return this.mSubId;
    }

    public int getPriority() {
        return this.mPriority;
    }

    public List<String> getMccMncs() {
        return (List)this.mMccMncs.clone();
    }

    public List<Integer> getBands() {
        return (List)this.mBands.clone();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mSubId);
        dest.writeInt(this.mPriority);
        dest.writeStringList(this.mMccMncs);
        dest.writeList(this.mBands);
    }

    private AvailableNetworkInfo(Parcel in) {
        this.mSubId = in.readInt();
        this.mPriority = in.readInt();
        this.mMccMncs = new ArrayList();
        in.readStringList(this.mMccMncs);
        this.mBands = new ArrayList();
        in.readList(this.mBands, Integer.class.getClassLoader());
    }

    public AvailableNetworkInfo(int subId, int priority, List<String> mccMncs, List<Integer> bands) {
        this.mSubId = subId;
        this.mPriority = priority;
        this.mMccMncs = new ArrayList<String>(mccMncs);
        this.mBands = new ArrayList<Integer>(bands);
    }

    public boolean equals(Object o) {
        AvailableNetworkInfo ani;
        try {
            ani = (AvailableNetworkInfo)o;
        }
        catch (ClassCastException ex) {
            return false;
        }
        if (o == null) {
            return false;
        }
        return this.mSubId == ani.mSubId && this.mPriority == ani.mPriority && this.mMccMncs != null && this.mMccMncs.equals(ani.mMccMncs) && this.mBands.equals(ani.mBands);
    }

    public int hashCode() {
        return Objects.hash(this.mSubId, this.mPriority, this.mMccMncs, this.mBands);
    }

    public String toString() {
        return "AvailableNetworkInfo: mSubId: " + this.mSubId + " mPriority: " + this.mPriority + " mMccMncs: " + Arrays.toString(this.mMccMncs.toArray()) + " mBands: " + Arrays.toString(this.mBands.toArray());
    }
}

