/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.CertificateSource;
import android.util.ArraySet;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import libcore.io.IoUtils;

abstract class DirectoryCertificateSource
implements CertificateSource {
    private static final String LOG_TAG = "DirectoryCertificateSrc";
    private final File mDir;
    private final Object mLock = new Object();
    private final CertificateFactory mCertFactory;
    private Set<X509Certificate> mCertificates;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected DirectoryCertificateSource(File caDir) {
        this.mDir = caDir;
        try {
            this.mCertFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Failed to obtain X.509 CertificateFactory", e);
        }
    }

    protected abstract boolean isCertMarkedAsRemoved(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<X509Certificate> getCertificates() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCertificates != null) {
                return this.mCertificates;
            }
            ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>();
            if (this.mDir.isDirectory()) {
                for (String caFile : this.mDir.list()) {
                    X509Certificate cert;
                    if (this.isCertMarkedAsRemoved(caFile) || (cert = this.readCertificate(caFile)) == null) continue;
                    certs.add(cert);
                }
            }
            this.mCertificates = certs;
            return this.mCertificates;
        }
    }

    @Override
    public X509Certificate findBySubjectAndPublicKey(final X509Certificate cert) {
        return this.findCert(cert.getSubjectX500Principal(), new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                return ca.getPublicKey().equals(cert.getPublicKey());
            }
        });
    }

    @Override
    public X509Certificate findByIssuerAndSignature(final X509Certificate cert) {
        return this.findCert(cert.getIssuerX500Principal(), new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    cert.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Override
    public Set<X509Certificate> findAllByIssuerAndSignature(final X509Certificate cert) {
        return this.findCerts(cert.getIssuerX500Principal(), new CertSelector(){

            @Override
            public boolean match(X509Certificate ca) {
                try {
                    cert.verify(ca.getPublicKey());
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleTrustStorageUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            this.mCertificates = null;
        }
    }

    private Set<X509Certificate> findCerts(X500Principal subj, CertSelector selector) {
        String fileName;
        String hash = this.getHash(subj);
        Set<X509Certificate> certs = null;
        for (int index = 0; index >= 0 && new File(this.mDir, fileName = hash + "." + index).exists(); ++index) {
            X509Certificate cert;
            if (this.isCertMarkedAsRemoved(fileName) || (cert = this.readCertificate(fileName)) == null || !subj.equals(cert.getSubjectX500Principal()) || !selector.match(cert)) continue;
            if (certs == null) {
                certs = new ArraySet<X509Certificate>();
            }
            certs.add(cert);
        }
        return certs != null ? certs : Collections.emptySet();
    }

    private X509Certificate findCert(X500Principal subj, CertSelector selector) {
        String fileName;
        String hash = this.getHash(subj);
        for (int index = 0; index >= 0 && new File(this.mDir, fileName = hash + "." + index).exists(); ++index) {
            X509Certificate cert;
            if (this.isCertMarkedAsRemoved(fileName) || (cert = this.readCertificate(fileName)) == null || !subj.equals(cert.getSubjectX500Principal()) || !selector.match(cert)) continue;
            return cert;
        }
        return null;
    }

    private String getHash(X500Principal name) {
        int hash = DirectoryCertificateSource.hashName(name);
        return DirectoryCertificateSource.intToHexString(hash, 8);
    }

    private static String intToHexString(int i, int minWidth) {
        int bufLen = 8;
        char[] buf = new char[bufLen];
        int cursor = bufLen;
        do {
            buf[--cursor] = DIGITS[i & 0xF];
        } while ((i >>>= 4) != 0 || bufLen - cursor < minWidth);
        return new String(buf, cursor, bufLen - cursor);
    }

    private static int hashName(X500Principal principal) {
        try {
            byte[] digest = MessageDigest.getInstance("MD5").digest(principal.getEncoded());
            int offset = 0;
            return (digest[offset++] & 0xFF) << 0 | (digest[offset++] & 0xFF) << 8 | (digest[offset++] & 0xFF) << 16 | (digest[offset] & 0xFF) << 24;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate readCertificate(String file) {
        X509Certificate x509Certificate;
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(new File(this.mDir, file)));
            x509Certificate = (X509Certificate)this.mCertFactory.generateCertificate(is);
        }
        catch (IOException | CertificateException e) {
            X509Certificate x509Certificate2;
            try {
                Log.e(LOG_TAG, "Failed to read certificate from " + file, e);
                x509Certificate2 = null;
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(is);
                throw throwable;
            }
            IoUtils.closeQuietly(is);
            return x509Certificate2;
        }
        IoUtils.closeQuietly(is);
        return x509Certificate;
    }

    private static interface CertSelector {
        public boolean match(X509Certificate var1);
    }
}

