/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.ArrayUtils;
import java.security.PublicKey;
import java.util.Arrays;

public class AndroidKeyStorePublicKey
extends AndroidKeyStoreKey
implements PublicKey {
    private final byte[] mEncoded;

    public AndroidKeyStorePublicKey(String alias, int uid, String algorithm, byte[] x509EncodedForm) {
        super(alias, uid, algorithm);
        this.mEncoded = ArrayUtils.cloneIfNotEmpty(x509EncodedForm);
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return ArrayUtils.cloneIfNotEmpty(this.mEncoded);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.mEncoded);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AndroidKeyStorePublicKey other = (AndroidKeyStorePublicKey)obj;
        return Arrays.equals(this.mEncoded, other.mEncoded);
    }
}

