/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.graphics.Typeface;
import android.graphics.fonts.Font;
import android.graphics.fonts.FontFamily;
import android.graphics.fonts.FontStyle;
import android.graphics.fonts.FontVariationAxis;
import android.net.Uri;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.provider.BaseColumns;
import android.provider.FontRequest;
import android.util.Log;
import android.util.LruCache;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class FontsContract {
    private static final String TAG = "FontsContract";
    private static final Object sLock = new Object();
    @GuardedBy(value={"sLock"})
    private static Handler sHandler;
    @GuardedBy(value={"sLock"})
    private static HandlerThread sThread;
    @GuardedBy(value={"sLock"})
    private static Set<String> sInQueueSet;
    private static volatile Context sContext;
    private static final LruCache<String, Typeface> sTypefaceCache;
    private static final int THREAD_RENEWAL_THRESHOLD_MS = 10000;
    private static final long SYNC_FONT_FETCH_TIMEOUT_MS = 500L;
    private static final Runnable sReplaceDispatcherThreadRunnable;
    private static final Comparator<byte[]> sByteArrayComparator;

    private FontsContract() {
    }

    public static void setApplicationContextForResources(Context context) {
        sContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Typeface getFontSync(FontRequest request) {
        String id2 = request.getIdentifier();
        Typeface cachedTypeface = sTypefaceCache.get(id2);
        if (cachedTypeface != null) {
            return cachedTypeface;
        }
        Object object = sLock;
        synchronized (object) {
            cachedTypeface = sTypefaceCache.get(id2);
            if (cachedTypeface != null) {
                return cachedTypeface;
            }
            if (sHandler == null) {
                sThread = new HandlerThread("fonts", 10);
                sThread.start();
                sHandler = new Handler(sThread.getLooper());
            }
            ReentrantLock lock = new ReentrantLock();
            Condition cond = lock.newCondition();
            AtomicReference holder = new AtomicReference();
            AtomicBoolean waiting = new AtomicBoolean(true);
            AtomicBoolean timeout = new AtomicBoolean(false);
            sHandler.post(() -> {
                try {
                    FontFamilyResult result = FontsContract.fetchFonts(sContext, null, request);
                    if (result.getStatusCode() == 0) {
                        Typeface typeface = FontsContract.buildTypeface(sContext, null, result.getFonts());
                        if (typeface != null) {
                            sTypefaceCache.put(id2, typeface);
                        }
                        holder.set(typeface);
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                lock.lock();
                try {
                    if (!timeout.get()) {
                        waiting.set(false);
                        cond.signal();
                    }
                }
                finally {
                    lock.unlock();
                }
            });
            sHandler.removeCallbacks(sReplaceDispatcherThreadRunnable);
            sHandler.postDelayed(sReplaceDispatcherThreadRunnable, 10000L);
            long remaining = TimeUnit.MILLISECONDS.toNanos(500L);
            lock.lock();
            try {
                if (!waiting.get()) {
                    Typeface typeface = (Typeface)holder.get();
                    return typeface;
                }
                do {
                    try {
                        remaining = cond.awaitNanos(remaining);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (waiting.get()) continue;
                    Typeface typeface = (Typeface)holder.get();
                    return typeface;
                } while (remaining > 0L);
                timeout.set(true);
                Log.w(TAG, "Remote font fetch timed out: " + request.getProviderAuthority() + "/" + request.getQuery());
                Typeface typeface = null;
                return typeface;
            }
            finally {
                lock.unlock();
            }
        }
    }

    public static void requestFonts(Context context, FontRequest request, Handler handler, CancellationSignal cancellationSignal, FontRequestCallback callback) {
        Handler callerThreadHandler = new Handler();
        Typeface cachedTypeface = sTypefaceCache.get(request.getIdentifier());
        if (cachedTypeface != null) {
            callerThreadHandler.post(() -> callback.onTypefaceRetrieved(cachedTypeface));
            return;
        }
        handler.post(() -> {
            FontFamilyResult result;
            try {
                result = FontsContract.fetchFonts(context, cancellationSignal, request);
            }
            catch (PackageManager.NameNotFoundException e) {
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-1));
                return;
            }
            Typeface anotherCachedTypeface = sTypefaceCache.get(request.getIdentifier());
            if (anotherCachedTypeface != null) {
                callerThreadHandler.post(() -> callback.onTypefaceRetrieved(anotherCachedTypeface));
                return;
            }
            if (result.getStatusCode() != 0) {
                switch (result.getStatusCode()) {
                    case 1: {
                        callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-2));
                        return;
                    }
                    case 2: {
                        callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                        return;
                    }
                }
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                return;
            }
            FontInfo[] fonts = result.getFonts();
            if (fonts == null || fonts.length == 0) {
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(1));
                return;
            }
            for (FontInfo font : fonts) {
                if (font.getResultCode() == 0) continue;
                int resultCode = font.getResultCode();
                if (resultCode < 0) {
                    callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                } else {
                    callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(resultCode));
                }
                return;
            }
            Typeface typeface = FontsContract.buildTypeface(context, cancellationSignal, fonts);
            if (typeface == null) {
                callerThreadHandler.post(() -> callback.onTypefaceRequestFailed(-3));
                return;
            }
            sTypefaceCache.put(request.getIdentifier(), typeface);
            callerThreadHandler.post(() -> callback.onTypefaceRetrieved(typeface));
        });
    }

    public static FontFamilyResult fetchFonts(Context context, CancellationSignal cancellationSignal, FontRequest request) throws PackageManager.NameNotFoundException {
        if (context.isRestricted()) {
            return new FontFamilyResult(3, null);
        }
        ProviderInfo providerInfo = FontsContract.getProvider(context.getPackageManager(), request);
        if (providerInfo == null) {
            return new FontFamilyResult(1, null);
        }
        try {
            FontInfo[] fonts = FontsContract.getFontFromProvider(context, request, providerInfo.authority, cancellationSignal);
            return new FontFamilyResult(0, fonts);
        }
        catch (IllegalArgumentException e) {
            return new FontFamilyResult(2, null);
        }
    }

    public static Typeface buildTypeface(Context context, CancellationSignal cancellationSignal, FontInfo[] fonts) {
        if (context.isRestricted()) {
            return null;
        }
        Map<Uri, ByteBuffer> uriBuffer = FontsContract.prepareFontData(context, fonts, cancellationSignal);
        if (uriBuffer.isEmpty()) {
            return null;
        }
        FontFamily.Builder familyBuilder = null;
        for (FontInfo fontInfo : fonts) {
            ByteBuffer buffer = uriBuffer.get(fontInfo.getUri());
            if (buffer == null) continue;
            try {
                Font font = new Font.Builder(buffer).setWeight(fontInfo.getWeight()).setSlant(fontInfo.isItalic() ? 1 : 0).setTtcIndex(fontInfo.getTtcIndex()).setFontVariationSettings(fontInfo.getAxes()).build();
                if (familyBuilder == null) {
                    familyBuilder = new FontFamily.Builder(font);
                    continue;
                }
                familyBuilder.addFont(font);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (familyBuilder == null) {
            return null;
        }
        FontFamily family = familyBuilder.build();
        FontStyle normal = new FontStyle(400, 0);
        Font bestFont = family.getFont(0);
        int bestScore = normal.getMatchScore(bestFont.getStyle());
        for (int i = 1; i < family.getSize(); ++i) {
            Font candidate = family.getFont(i);
            int score = normal.getMatchScore(candidate.getStyle());
            if (score >= bestScore) continue;
            bestFont = candidate;
            bestScore = score;
        }
        return new Typeface.CustomFallbackBuilder(family).setStyle(bestFont.getStyle()).build();
    }

    private static Map<Uri, ByteBuffer> prepareFontData(Context context, FontInfo[] fonts, CancellationSignal cancellationSignal) {
        HashMap<Uri, MappedByteBuffer> out = new HashMap<Uri, MappedByteBuffer>();
        ContentResolver resolver = context.getContentResolver();
        for (FontInfo font : fonts) {
            MappedByteBuffer buffer;
            Uri uri;
            block16: {
                if (font.getResultCode() != 0 || out.containsKey(uri = font.getUri())) continue;
                buffer = null;
                try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(uri, "r", cancellationSignal);){
                    if (pfd == null) break block16;
                    try (FileInputStream fis = new FileInputStream(pfd.getFileDescriptor());){
                        FileChannel fileChannel = fis.getChannel();
                        long size = fileChannel.size();
                        buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            out.put(uri, buffer);
        }
        return Collections.unmodifiableMap(out);
    }

    @VisibleForTesting
    public static ProviderInfo getProvider(PackageManager packageManager, FontRequest request) throws PackageManager.NameNotFoundException {
        String providerAuthority = request.getProviderAuthority();
        ProviderInfo info = packageManager.resolveContentProvider(providerAuthority, 0);
        if (info == null) {
            throw new PackageManager.NameNotFoundException("No package found for authority: " + providerAuthority);
        }
        if (!info.packageName.equals(request.getProviderPackage())) {
            throw new PackageManager.NameNotFoundException("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage());
        }
        if (info.applicationInfo.isSystemApp()) {
            return info;
        }
        PackageInfo packageInfo = packageManager.getPackageInfo(info.packageName, 64);
        List<byte[]> signatures = FontsContract.convertToByteArrayList(packageInfo.signatures);
        Collections.sort(signatures, sByteArrayComparator);
        List<List<byte[]>> requestCertificatesList = request.getCertificates();
        for (int i = 0; i < requestCertificatesList.size(); ++i) {
            ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
            Collections.sort(requestSignatures, sByteArrayComparator);
            if (!FontsContract.equalsByteArrayList(signatures, requestSignatures)) continue;
            return info;
        }
        return null;
    }

    private static boolean equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shas = new ArrayList<byte[]>();
        for (int i = 0; i < signatures.length; ++i) {
            shas.add(signatures[i].toByteArray());
        }
        return shas;
    }

    @VisibleForTesting
    public static FontInfo[] getFontFromProvider(Context context, FontRequest request, String authority, CancellationSignal cancellationSignal) {
        ArrayList<FontInfo> result = new ArrayList<FontInfo>();
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
        try (Cursor cursor = context.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null, cancellationSignal);){
            if (cursor != null && cursor.getCount() > 0) {
                int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                result = new ArrayList();
                int idColumnIndex = cursor.getColumnIndexOrThrow("_id");
                int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int vsColumnIndex = cursor.getColumnIndex("font_variation_settings");
                int weightColumnIndex = cursor.getColumnIndex("font_weight");
                int italicColumnIndex = cursor.getColumnIndex("font_italic");
                while (cursor.moveToNext()) {
                    boolean italic;
                    int weight;
                    Uri fileUri;
                    long id2;
                    String variationSettings;
                    int resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                    int ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                    String string2 = variationSettings = vsColumnIndex != -1 ? cursor.getString(vsColumnIndex) : null;
                    if (fileIdColumnIndex == -1) {
                        id2 = cursor.getLong(idColumnIndex);
                        fileUri = ContentUris.withAppendedId(uri, id2);
                    } else {
                        id2 = cursor.getLong(fileIdColumnIndex);
                        fileUri = ContentUris.withAppendedId(fileBaseUri, id2);
                    }
                    if (weightColumnIndex != -1 && italicColumnIndex != -1) {
                        weight = cursor.getInt(weightColumnIndex);
                        italic = cursor.getInt(italicColumnIndex) == 1;
                    } else {
                        weight = 400;
                        italic = false;
                    }
                    FontVariationAxis[] axes = FontVariationAxis.fromFontVariationSettings(variationSettings);
                    result.add(new FontInfo(fileUri, ttcIndex, axes, weight, italic, resultCode));
                }
            }
        }
        return result.toArray(new FontInfo[0]);
    }

    static {
        sTypefaceCache = new LruCache(16);
        sReplaceDispatcherThreadRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = sLock;
                synchronized (object) {
                    if (sThread != null) {
                        sThread.quitSafely();
                        sThread = null;
                        sHandler = null;
                    }
                }
            }
        };
        sByteArrayComparator = (l, r) -> {
            if (((byte[])l).length != ((byte[])r).length) {
                return ((byte[])l).length - ((byte[])r).length;
            }
            for (int i = 0; i < ((byte[])l).length; ++i) {
                if (l[i] == r[i]) continue;
                return l[i] - r[i];
            }
            return 0;
        };
    }

    public static class FontRequestCallback {
        public static final int FAIL_REASON_PROVIDER_NOT_FOUND = -1;
        public static final int FAIL_REASON_WRONG_CERTIFICATES = -2;
        public static final int FAIL_REASON_FONT_LOAD_ERROR = -3;
        public static final int FAIL_REASON_FONT_NOT_FOUND = 1;
        public static final int FAIL_REASON_FONT_UNAVAILABLE = 2;
        public static final int FAIL_REASON_MALFORMED_QUERY = 3;

        public void onTypefaceRetrieved(Typeface typeface) {
        }

        public void onTypefaceRequestFailed(int reason) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface FontRequestFailReason {
        }
    }

    public static class FontFamilyResult {
        public static final int STATUS_OK = 0;
        public static final int STATUS_WRONG_CERTIFICATES = 1;
        public static final int STATUS_UNEXPECTED_DATA_PROVIDED = 2;
        public static final int STATUS_REJECTED = 3;
        private final int mStatusCode;
        private final FontInfo[] mFonts;

        public FontFamilyResult(int statusCode, FontInfo[] fonts) {
            this.mStatusCode = statusCode;
            this.mFonts = fonts;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public FontInfo[] getFonts() {
            return this.mFonts;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface FontResultStatus {
        }
    }

    public static class FontInfo {
        private final Uri mUri;
        private final int mTtcIndex;
        private final FontVariationAxis[] mAxes;
        private final int mWeight;
        private final boolean mItalic;
        private final int mResultCode;

        public FontInfo(Uri uri, int ttcIndex, FontVariationAxis[] axes, int weight, boolean italic, int resultCode) {
            this.mUri = Preconditions.checkNotNull(uri);
            this.mTtcIndex = ttcIndex;
            this.mAxes = axes;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mResultCode = resultCode;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        public FontVariationAxis[] getAxes() {
            return this.mAxes;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }

        public int getResultCode() {
            return this.mResultCode;
        }
    }

    public static class Columns
    implements BaseColumns {
        public static final String FILE_ID = "file_id";
        public static final String TTC_INDEX = "font_ttc_index";
        public static final String VARIATION_SETTINGS = "font_variation_settings";
        public static final String WEIGHT = "font_weight";
        public static final String ITALIC = "font_italic";
        public static final String RESULT_CODE = "result_code";
        public static final int RESULT_CODE_OK = 0;
        public static final int RESULT_CODE_FONT_NOT_FOUND = 1;
        public static final int RESULT_CODE_FONT_UNAVAILABLE = 2;
        public static final int RESULT_CODE_MALFORMED_QUERY = 3;

        private Columns() {
        }
    }
}

