/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.preference.GenericInflater;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Deprecated
public abstract class PreferenceGroup
extends Preference
implements GenericInflater.Parent<Preference> {
    private List<Preference> mPreferenceList = new ArrayList<Preference>();
    private boolean mOrderingAsAdded = true;
    private int mCurrentPreferenceOrder = 0;
    private boolean mAttachedToActivity = false;

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceGroup, defStyleAttr, defStyleRes);
        this.mOrderingAsAdded = a.getBoolean(0, this.mOrderingAsAdded);
        a.recycle();
    }

    public PreferenceGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public PreferenceGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public void setOrderingAsAdded(boolean orderingAsAdded) {
        this.mOrderingAsAdded = orderingAsAdded;
    }

    public boolean isOrderingAsAdded() {
        return this.mOrderingAsAdded;
    }

    @Override
    public void addItemFromInflater(Preference preference) {
        this.addPreference(preference);
    }

    public int getPreferenceCount() {
        return this.mPreferenceList.size();
    }

    public Preference getPreference(int index) {
        return this.mPreferenceList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPreference(Preference preference) {
        if (this.mPreferenceList.contains(preference)) {
            return true;
        }
        if (preference.getOrder() == Integer.MAX_VALUE) {
            if (this.mOrderingAsAdded) {
                preference.setOrder(this.mCurrentPreferenceOrder++);
            }
            if (preference instanceof PreferenceGroup) {
                ((PreferenceGroup)preference).setOrderingAsAdded(this.mOrderingAsAdded);
            }
        }
        if (!this.onPrepareAddPreference(preference)) {
            return false;
        }
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            int insertionIndex = Collections.binarySearch(this.mPreferenceList, preference);
            if (insertionIndex < 0) {
                insertionIndex = insertionIndex * -1 - 1;
            }
            this.mPreferenceList.add(insertionIndex, preference);
        }
        preference.onAttachedToHierarchy(this.getPreferenceManager());
        preference.assignParent(this);
        if (this.mAttachedToActivity) {
            preference.onAttachedToActivity();
        }
        this.notifyHierarchyChanged();
        return true;
    }

    public boolean removePreference(Preference preference) {
        boolean returnValue = this.removePreferenceInt(preference);
        this.notifyHierarchyChanged();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removePreferenceInt(Preference preference) {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            preference.onPrepareForRemoval();
            if (preference.getParent() == this) {
                preference.assignParent(null);
            }
            return this.mPreferenceList.remove(preference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            List<Preference> preferenceList = this.mPreferenceList;
            for (int i = preferenceList.size() - 1; i >= 0; --i) {
                this.removePreferenceInt(preferenceList.get(0));
            }
        }
        this.notifyHierarchyChanged();
    }

    protected boolean onPrepareAddPreference(Preference preference) {
        preference.onParentChanged(this, this.shouldDisableDependents());
        return true;
    }

    public Preference findPreference(CharSequence key) {
        if (TextUtils.equals(this.getKey(), key)) {
            return this;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            String curKey = preference.getKey();
            if (curKey != null && curKey.equals(key)) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(key)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    protected boolean isOnSameScreenAsChildren() {
        return true;
    }

    @Override
    protected void onAttachedToActivity() {
        super.onAttachedToActivity();
        this.mAttachedToActivity = true;
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onAttachedToActivity();
        }
    }

    @Override
    protected void onPrepareForRemoval() {
        super.onPrepareForRemoval();
        this.mAttachedToActivity = false;
    }

    @Override
    public void notifyDependencyChange(boolean disableDependents) {
        super.notifyDependencyChange(disableDependents);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onParentChanged(this, disableDependents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortPreferences() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            Collections.sort(this.mPreferenceList);
        }
    }

    @Override
    protected void dispatchSaveInstanceState(Bundle container) {
        super.dispatchSaveInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchSaveInstanceState(container);
        }
    }

    @Override
    protected void dispatchRestoreInstanceState(Bundle container) {
        super.dispatchRestoreInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchRestoreInstanceState(container);
        }
    }
}

