/*
 * Decompiled with CFR 0.152.
 */
package android.os.incremental;

import android.content.pm.DataLoaderParams;
import android.content.pm.IDataLoaderStatusListener;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.incremental.IIncrementalService;
import android.os.incremental.IStorageHealthListener;
import android.os.incremental.IncrementalStorage;
import android.os.incremental.StorageHealthCheckParams;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class IncrementalManager {
    private static final String TAG = "IncrementalManager";
    private static final String ALLOWED_PROPERTY = "incremental.allowed";
    public static final int CREATE_MODE_TEMPORARY_BIND = 1;
    public static final int CREATE_MODE_PERMANENT_BIND = 2;
    public static final int CREATE_MODE_CREATE = 4;
    public static final int CREATE_MODE_OPEN_EXISTING = 8;
    private final IIncrementalService mService;
    @GuardedBy(value={"mStorages"})
    private final SparseArray<IncrementalStorage> mStorages = new SparseArray();

    public IncrementalManager(IIncrementalService service) {
        this.mService = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalStorage getStorage(int storageId) {
        SparseArray<IncrementalStorage> sparseArray = this.mStorages;
        synchronized (sparseArray) {
            return this.mStorages.get(storageId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalStorage createStorage(String path, DataLoaderParams params, int createMode, boolean autoStartDataLoader, IDataLoaderStatusListener statusListener, StorageHealthCheckParams healthCheckParams, IStorageHealthListener healthListener) {
        try {
            int id2 = this.mService.createStorage(path, params.getData(), createMode, statusListener, healthCheckParams, healthListener);
            if (id2 < 0) {
                return null;
            }
            IncrementalStorage storage = new IncrementalStorage(this.mService, id2);
            SparseArray<IncrementalStorage> sparseArray = this.mStorages;
            synchronized (sparseArray) {
                this.mStorages.put(id2, storage);
            }
            if (autoStartDataLoader) {
                storage.startLoading();
            }
            return storage;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalStorage openStorage(String path) {
        try {
            int id2 = this.mService.openStorage(path);
            if (id2 < 0) {
                return null;
            }
            IncrementalStorage storage = new IncrementalStorage(this.mService, id2);
            SparseArray<IncrementalStorage> sparseArray = this.mStorages;
            synchronized (sparseArray) {
                this.mStorages.put(id2, storage);
            }
            return storage;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncrementalStorage createStorage(String path, IncrementalStorage linkedStorage, int createMode) {
        try {
            int id2 = this.mService.createLinkedStorage(path, linkedStorage.getId(), createMode);
            if (id2 < 0) {
                return null;
            }
            IncrementalStorage storage = new IncrementalStorage(this.mService, id2);
            SparseArray<IncrementalStorage> sparseArray = this.mStorages;
            synchronized (sparseArray) {
                this.mStorages.put(id2, storage);
            }
            return storage;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void renameCodePath(File beforeCodeFile, File afterCodeFile) throws IllegalArgumentException, IOException {
        File beforeCodeAbsolute = beforeCodeFile.getAbsoluteFile();
        IncrementalStorage apkStorage = this.openStorage(beforeCodeAbsolute.toString());
        if (apkStorage == null) {
            throw new IllegalArgumentException("Not an Incremental path: " + beforeCodeAbsolute);
        }
        String targetStorageDir = afterCodeFile.getAbsoluteFile().getParent();
        IncrementalStorage linkedApkStorage = this.createStorage(targetStorageDir, apkStorage, 6);
        if (linkedApkStorage == null) {
            throw new IOException("Failed to create linked storage at dir: " + targetStorageDir);
        }
        try {
            String afterCodePathName = afterCodeFile.getName();
            this.linkFiles(apkStorage, beforeCodeAbsolute, "", linkedApkStorage, afterCodePathName);
            apkStorage.unBind(beforeCodeAbsolute.toString());
        }
        catch (Exception e) {
            linkedApkStorage.unBind(targetStorageDir);
            throw e;
        }
    }

    private void linkFiles(final IncrementalStorage sourceStorage, File sourceAbsolutePath, String sourceRelativePath, final IncrementalStorage targetStorage, String targetRelativePath) throws IOException {
        final Path sourceBase = sourceAbsolutePath.toPath().resolve(sourceRelativePath);
        final Path targetRelative = Paths.get(targetRelativePath, new String[0]);
        Files.walkFileTree(sourceAbsolutePath.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Path relativeDir = sourceBase.relativize(dir);
                targetStorage.makeDirectory(targetRelative.resolve(relativeDir).toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path relativeFile = sourceBase.relativize(file);
                sourceStorage.makeLink(file.toAbsolutePath().toString(), targetStorage, targetRelative.resolve(relativeFile).toString());
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorage(String path) {
        try {
            int id2 = this.mService.openStorage(path);
            if (id2 < 0) {
                return;
            }
            this.mService.deleteStorage(id2);
            SparseArray<IncrementalStorage> sparseArray = this.mStorages;
            synchronized (sparseArray) {
                this.mStorages.remove(id2);
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static boolean isFeatureEnabled() {
        return IncrementalManager.nativeIsEnabled();
    }

    public static boolean isAllowed() {
        return IncrementalManager.isFeatureEnabled() && SystemProperties.getBoolean(ALLOWED_PROPERTY, true);
    }

    public static boolean isIncrementalPath(String path) {
        return IncrementalManager.nativeIsIncrementalPath(path);
    }

    public static byte[] unsafeGetFileSignature(String path) {
        return IncrementalManager.nativeUnsafeGetFileSignature(path);
    }

    private static boolean nativeIsEnabled() {
        return OverrideMethod.invokeI("android.os.incremental.IncrementalManager#nativeIsEnabled()Z", true, null) != 0;
    }

    private static boolean nativeIsIncrementalPath(String string2) {
        return OverrideMethod.invokeI("android.os.incremental.IncrementalManager#nativeIsIncrementalPath(Ljava/lang/String;)Z", true, null) != 0;
    }

    private static byte[] nativeUnsafeGetFileSignature(String string2) {
        return (byte[])OverrideMethod.invokeA("android.os.incremental.IncrementalManager#nativeUnsafeGetFileSignature(Ljava/lang/String;)[B", true, null);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CreateMode {
    }
}

