/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.MathUtils;
import com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public abstract class VibrationEffect
implements Parcelable {
    private static final int PARCEL_TOKEN_ONE_SHOT = 1;
    private static final int PARCEL_TOKEN_WAVEFORM = 2;
    private static final int PARCEL_TOKEN_EFFECT = 3;
    private static final int PARCEL_TOKEN_COMPOSITION = 4;
    public static final int DEFAULT_AMPLITUDE = -1;
    public static final int MAX_AMPLITUDE = 255;
    public static final int EFFECT_CLICK = 0;
    public static final int EFFECT_DOUBLE_CLICK = 1;
    public static final int EFFECT_TICK = 2;
    @UnsupportedAppUsage
    public static final int EFFECT_THUD = 3;
    @UnsupportedAppUsage
    public static final int EFFECT_POP = 4;
    public static final int EFFECT_HEAVY_CLICK = 5;
    public static final int EFFECT_TEXTURE_TICK = 21;
    public static final int EFFECT_STRENGTH_LIGHT = 0;
    public static final int EFFECT_STRENGTH_MEDIUM = 1;
    public static final int EFFECT_STRENGTH_STRONG = 2;
    @UnsupportedAppUsage
    public static final int[] RINGTONES = new int[]{6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    public static final Parcelable.Creator<VibrationEffect> CREATOR = new Parcelable.Creator<VibrationEffect>(){

        @Override
        public VibrationEffect createFromParcel(Parcel in) {
            int token = in.readInt();
            if (token == 1) {
                return new OneShot(in);
            }
            if (token == 2) {
                return new Waveform(in);
            }
            if (token == 3) {
                return new Prebaked(in);
            }
            if (token == 4) {
                return new Composed(in);
            }
            throw new IllegalStateException("Unexpected vibration event type token in parcel.");
        }

        public VibrationEffect[] newArray(int size) {
            return new VibrationEffect[size];
        }
    };

    public static VibrationEffect createOneShot(long milliseconds, int amplitude) {
        OneShot effect = new OneShot(milliseconds, amplitude);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect createWaveform(long[] timings, int repeat) {
        int[] amplitudes = new int[timings.length];
        for (int i = 0; i < timings.length / 2; ++i) {
            amplitudes[i * 2 + 1] = -1;
        }
        return VibrationEffect.createWaveform(timings, amplitudes, repeat);
    }

    public static VibrationEffect createWaveform(long[] timings, int[] amplitudes, int repeat) {
        Waveform effect = new Waveform(timings, amplitudes, repeat);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect createPredefined(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    public static VibrationEffect get(int effectId) {
        return VibrationEffect.get(effectId, true);
    }

    public static VibrationEffect get(int effectId, boolean fallback) {
        Prebaked effect = new Prebaked(effectId, fallback);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    public static VibrationEffect get(Uri uri, Context context) {
        String[] uris = context.getResources().getStringArray(17236068);
        if (uris.length == 0) {
            return null;
        }
        ContentResolver cr = context.getContentResolver();
        Uri uncanonicalUri = cr.uncanonicalize(uri);
        if (uncanonicalUri == null) {
            uncanonicalUri = uri;
        }
        for (int i = 0; i < uris.length && i < RINGTONES.length; ++i) {
            Uri mappedUri;
            if (uris[i] == null || (mappedUri = cr.uncanonicalize(Uri.parse(uris[i]))) == null || !mappedUri.equals(uncanonicalUri)) continue;
            return VibrationEffect.get(RINGTONES[i]);
        }
        return null;
    }

    public static Composition startComposition() {
        return new Composition();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public abstract void validate();

    public abstract long getDuration();

    protected static int scale(int amplitude, float gamma, int maxAmplitude) {
        float val = MathUtils.pow((float)amplitude / 255.0f, gamma);
        return (int)(val * (float)maxAmplitude);
    }

    public static class Composition {
        public static final int PRIMITIVE_NOOP = 0;
        public static final int PRIMITIVE_CLICK = 1;
        public static final int PRIMITIVE_THUD = 2;
        public static final int PRIMITIVE_SPIN = 3;
        public static final int PRIMITIVE_QUICK_RISE = 4;
        public static final int PRIMITIVE_SLOW_RISE = 5;
        public static final int PRIMITIVE_QUICK_FALL = 6;
        public static final int PRIMITIVE_TICK = 7;
        private ArrayList<PrimitiveEffect> mEffects = new ArrayList();

        Composition() {
        }

        public Composition addPrimitive(int primitiveId) {
            this.addPrimitive(primitiveId, 1.0f, 0);
            return this;
        }

        public Composition addPrimitive(int primitiveId, float scale) {
            this.addPrimitive(primitiveId, scale, 0);
            return this;
        }

        public Composition addPrimitive(int primitiveId, float scale, int delay) {
            this.mEffects.add(new PrimitiveEffect(Composition.checkPrimitive(primitiveId), scale, delay));
            return this;
        }

        public VibrationEffect compose() {
            if (this.mEffects.isEmpty()) {
                throw new IllegalStateException("Composition must have at least one element to compose.");
            }
            return new Composed(this.mEffects);
        }

        static int checkPrimitive(int primitiveId) {
            Preconditions.checkArgumentInRange(primitiveId, 0, 7, "primitiveId");
            return primitiveId;
        }

        public static String primitiveToString(int id2) {
            switch (id2) {
                case 0: {
                    return "PRIMITIVE_NOOP";
                }
                case 1: {
                    return "PRIMITIVE_CLICK";
                }
                case 2: {
                    return "PRIMITIVE_THUD";
                }
                case 3: {
                    return "PRIMITIVE_SPIN";
                }
                case 4: {
                    return "PRIMITIVE_QUICK_RISE";
                }
                case 5: {
                    return "PRIMITIVE_SLOW_RISE";
                }
                case 6: {
                    return "PRIMITIVE_QUICK_FALL";
                }
                case 7: {
                    return "PRIMITIVE_TICK";
                }
            }
            return Integer.toString(id2);
        }

        public static class PrimitiveEffect
        implements Parcelable {
            public int id;
            public float scale;
            public int delay;
            public static final Parcelable.Creator<PrimitiveEffect> CREATOR = new Parcelable.Creator<PrimitiveEffect>(){

                @Override
                public PrimitiveEffect createFromParcel(Parcel in) {
                    return new PrimitiveEffect(in.readInt(), in.readFloat(), in.readInt());
                }

                public PrimitiveEffect[] newArray(int size) {
                    return new PrimitiveEffect[size];
                }
            };

            PrimitiveEffect(int id2, float scale, int delay) {
                this.id = id2;
                this.scale = scale;
                this.delay = delay;
            }

            @Override
            public void writeToParcel(Parcel dest, int flags) {
                dest.writeInt(this.id);
                dest.writeFloat(this.scale);
                dest.writeInt(this.delay);
            }

            @Override
            public int describeContents() {
                return 0;
            }

            public String toString() {
                return "PrimitiveEffect{id=" + Composition.primitiveToString(this.id) + ", scale=" + this.scale + ", delay=" + this.delay + '}';
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                PrimitiveEffect that = (PrimitiveEffect)o;
                return this.id == that.id && Float.compare(that.scale, this.scale) == 0 && this.delay == that.delay;
            }

            public int hashCode() {
                return Objects.hash(this.id, Float.valueOf(this.scale), this.delay);
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Primitive {
        }
    }

    public static class Composed
    extends VibrationEffect
    implements Parcelable {
        private final ArrayList<Composition.PrimitiveEffect> mPrimitiveEffects;
        public static final Parcelable.Creator<Composed> CREATOR = new Parcelable.Creator<Composed>(){

            @Override
            public Composed createFromParcel(Parcel in) {
                in.readInt();
                return new Composed(in);
            }

            public Composed[] newArray(int size) {
                return new Composed[size];
            }
        };

        public Composed(Parcel in) {
            this(in.readArrayList(Composed.class.getClassLoader()));
        }

        public Composed(List<Composition.PrimitiveEffect> effects) {
            this.mPrimitiveEffects = new ArrayList(Objects.requireNonNull(effects));
        }

        public List<Composition.PrimitiveEffect> getPrimitiveEffects() {
            return this.mPrimitiveEffects;
        }

        @Override
        public long getDuration() {
            return -1L;
        }

        public Composed scale(float gamma, int maxAmplitude) {
            if (maxAmplitude > 255 || maxAmplitude < 0) {
                throw new IllegalArgumentException("Amplitude is negative or greater than MAX_AMPLITUDE");
            }
            if (gamma == 1.0f && maxAmplitude == 255) {
                return new Composed(this.mPrimitiveEffects);
            }
            ArrayList<Composition.PrimitiveEffect> scaledPrimitives = new ArrayList<Composition.PrimitiveEffect>();
            for (Composition.PrimitiveEffect primitive : this.mPrimitiveEffects) {
                float adjustedScale = MathUtils.pow(primitive.scale, gamma);
                float newScale = adjustedScale * (float)maxAmplitude / 255.0f;
                scaledPrimitives.add(new Composition.PrimitiveEffect(primitive.id, newScale, primitive.delay));
            }
            return new Composed(scaledPrimitives);
        }

        @Override
        public void validate() {
            for (Composition.PrimitiveEffect effect : this.mPrimitiveEffects) {
                Composition.checkPrimitive(effect.id);
                Preconditions.checkArgumentInRange(effect.scale, 0.0f, 1.0f, "scale");
            }
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(4);
            out.writeList(this.mPrimitiveEffects);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Composed composed = (Composed)o;
            return this.mPrimitiveEffects.equals(composed.mPrimitiveEffects);
        }

        public int hashCode() {
            return Objects.hash(this.mPrimitiveEffects);
        }

        public String toString() {
            return "Composed{mPrimitiveEffects=" + this.mPrimitiveEffects + '}';
        }
    }

    public static class Prebaked
    extends VibrationEffect
    implements Parcelable {
        private final int mEffectId;
        private final boolean mFallback;
        private int mEffectStrength;
        public static final Parcelable.Creator<Prebaked> CREATOR = new Parcelable.Creator<Prebaked>(){

            @Override
            public Prebaked createFromParcel(Parcel in) {
                in.readInt();
                return new Prebaked(in);
            }

            public Prebaked[] newArray(int size) {
                return new Prebaked[size];
            }
        };

        public Prebaked(Parcel in) {
            this(in.readInt(), in.readByte() != 0);
            this.mEffectStrength = in.readInt();
        }

        public Prebaked(int effectId, boolean fallback) {
            this.mEffectId = effectId;
            this.mFallback = fallback;
            this.mEffectStrength = 1;
        }

        public int getId() {
            return this.mEffectId;
        }

        public boolean shouldFallback() {
            return this.mFallback;
        }

        @Override
        public long getDuration() {
            return -1L;
        }

        public void setEffectStrength(int strength) {
            if (!Prebaked.isValidEffectStrength(strength)) {
                throw new IllegalArgumentException("Invalid effect strength: " + strength);
            }
            this.mEffectStrength = strength;
        }

        public int getEffectStrength() {
            return this.mEffectStrength;
        }

        private static boolean isValidEffectStrength(int strength) {
            switch (strength) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void validate() {
            switch (this.mEffectId) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 21: {
                    break;
                }
                default: {
                    if (this.mEffectId >= RINGTONES[0] && this.mEffectId <= RINGTONES[RINGTONES.length - 1]) break;
                    throw new IllegalArgumentException("Unknown prebaked effect type (value=" + this.mEffectId + ")");
                }
            }
            if (!Prebaked.isValidEffectStrength(this.mEffectStrength)) {
                throw new IllegalArgumentException("Unknown prebaked effect strength (value=" + this.mEffectStrength + ")");
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Prebaked)) {
                return false;
            }
            Prebaked other = (Prebaked)o;
            return this.mEffectId == other.mEffectId && this.mFallback == other.mFallback && this.mEffectStrength == other.mEffectStrength;
        }

        public int hashCode() {
            int result = 17;
            result += 37 * this.mEffectId;
            return result += 37 * this.mEffectStrength;
        }

        public String toString() {
            return "Prebaked{mEffectId=" + this.mEffectId + ", mEffectStrength=" + this.mEffectStrength + ", mFallback=" + this.mFallback + "}";
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(3);
            out.writeInt(this.mEffectId);
            out.writeByte((byte)(this.mFallback ? 1 : 0));
            out.writeInt(this.mEffectStrength);
        }
    }

    public static class Waveform
    extends VibrationEffect
    implements Parcelable {
        private final long[] mTimings;
        private final int[] mAmplitudes;
        private final int mRepeat;
        public static final Parcelable.Creator<Waveform> CREATOR = new Parcelable.Creator<Waveform>(){

            @Override
            public Waveform createFromParcel(Parcel in) {
                in.readInt();
                return new Waveform(in);
            }

            public Waveform[] newArray(int size) {
                return new Waveform[size];
            }
        };

        public Waveform(Parcel in) {
            this(in.createLongArray(), in.createIntArray(), in.readInt());
        }

        public Waveform(long[] timings, int[] amplitudes, int repeat) {
            this.mTimings = new long[timings.length];
            System.arraycopy(timings, 0, this.mTimings, 0, timings.length);
            this.mAmplitudes = new int[amplitudes.length];
            System.arraycopy(amplitudes, 0, this.mAmplitudes, 0, amplitudes.length);
            this.mRepeat = repeat;
        }

        public long[] getTimings() {
            return this.mTimings;
        }

        public int[] getAmplitudes() {
            return this.mAmplitudes;
        }

        public int getRepeatIndex() {
            return this.mRepeat;
        }

        @Override
        public long getDuration() {
            if (this.mRepeat >= 0) {
                return Long.MAX_VALUE;
            }
            long duration = 0L;
            for (long d : this.mTimings) {
                duration += d;
            }
            return duration;
        }

        public Waveform scale(float gamma, int maxAmplitude) {
            if (maxAmplitude > 255 || maxAmplitude < 0) {
                throw new IllegalArgumentException("Amplitude is negative or greater than MAX_AMPLITUDE");
            }
            if (gamma == 1.0f && maxAmplitude == 255) {
                return new Waveform(this.mTimings, this.mAmplitudes, this.mRepeat);
            }
            int[] scaledAmplitudes = Arrays.copyOf(this.mAmplitudes, this.mAmplitudes.length);
            for (int i = 0; i < scaledAmplitudes.length; ++i) {
                scaledAmplitudes[i] = Waveform.scale(scaledAmplitudes[i], gamma, maxAmplitude);
            }
            return new Waveform(this.mTimings, scaledAmplitudes, this.mRepeat);
        }

        public Waveform resolve(int defaultAmplitude) {
            if (defaultAmplitude > 255 || defaultAmplitude < 0) {
                throw new IllegalArgumentException("Amplitude is negative or greater than MAX_AMPLITUDE");
            }
            int[] resolvedAmplitudes = Arrays.copyOf(this.mAmplitudes, this.mAmplitudes.length);
            for (int i = 0; i < resolvedAmplitudes.length; ++i) {
                if (resolvedAmplitudes[i] != -1) continue;
                resolvedAmplitudes[i] = defaultAmplitude;
            }
            return new Waveform(this.mTimings, resolvedAmplitudes, this.mRepeat);
        }

        @Override
        public void validate() {
            if (this.mTimings.length != this.mAmplitudes.length) {
                throw new IllegalArgumentException("timing and amplitude arrays must be of equal length (timings.length=" + this.mTimings.length + ", amplitudes.length=" + this.mAmplitudes.length + ")");
            }
            if (!Waveform.hasNonZeroEntry(this.mTimings)) {
                throw new IllegalArgumentException("at least one timing must be non-zero (timings=" + Arrays.toString(this.mTimings) + ")");
            }
            for (long timing : this.mTimings) {
                if (timing >= 0L) continue;
                throw new IllegalArgumentException("timings must all be >= 0 (timings=" + Arrays.toString(this.mTimings) + ")");
            }
            for (int amplitude : this.mAmplitudes) {
                if (amplitude >= -1 && amplitude <= 255) continue;
                throw new IllegalArgumentException("amplitudes must all be DEFAULT_AMPLITUDE or between 0 and 255 (amplitudes=" + Arrays.toString(this.mAmplitudes) + ")");
            }
            if (this.mRepeat < -1 || this.mRepeat >= this.mTimings.length) {
                throw new IllegalArgumentException("repeat index must be within the bounds of the timings array (timings.length=" + this.mTimings.length + ", index=" + this.mRepeat + ")");
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof Waveform)) {
                return false;
            }
            Waveform other = (Waveform)o;
            return Arrays.equals(this.mTimings, other.mTimings) && Arrays.equals(this.mAmplitudes, other.mAmplitudes) && this.mRepeat == other.mRepeat;
        }

        public int hashCode() {
            int result = 17;
            result += 37 * Arrays.hashCode(this.mTimings);
            result += 37 * Arrays.hashCode(this.mAmplitudes);
            return result += 37 * this.mRepeat;
        }

        public String toString() {
            return "Waveform{mTimings=" + Arrays.toString(this.mTimings) + ", mAmplitudes=" + Arrays.toString(this.mAmplitudes) + ", mRepeat=" + this.mRepeat + "}";
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeLongArray(this.mTimings);
            out.writeIntArray(this.mAmplitudes);
            out.writeInt(this.mRepeat);
        }

        private static boolean hasNonZeroEntry(long[] vals) {
            for (long val : vals) {
                if (val == 0L) continue;
                return true;
            }
            return false;
        }
    }

    public static class OneShot
    extends VibrationEffect
    implements Parcelable {
        private final long mDuration;
        private final int mAmplitude;
        @UnsupportedAppUsage
        public static final Parcelable.Creator<OneShot> CREATOR = new Parcelable.Creator<OneShot>(){

            @Override
            public OneShot createFromParcel(Parcel in) {
                in.readInt();
                return new OneShot(in);
            }

            public OneShot[] newArray(int size) {
                return new OneShot[size];
            }
        };

        public OneShot(Parcel in) {
            this.mDuration = in.readLong();
            this.mAmplitude = in.readInt();
        }

        public OneShot(long milliseconds, int amplitude) {
            this.mDuration = milliseconds;
            this.mAmplitude = amplitude;
        }

        @Override
        public long getDuration() {
            return this.mDuration;
        }

        public int getAmplitude() {
            return this.mAmplitude;
        }

        public OneShot scale(float gamma, int maxAmplitude) {
            if (maxAmplitude > 255 || maxAmplitude < 0) {
                throw new IllegalArgumentException("Amplitude is negative or greater than MAX_AMPLITUDE");
            }
            int newAmplitude = OneShot.scale(this.mAmplitude, gamma, maxAmplitude);
            return new OneShot(this.mDuration, newAmplitude);
        }

        public OneShot resolve(int defaultAmplitude) {
            if (defaultAmplitude > 255 || defaultAmplitude < 0) {
                throw new IllegalArgumentException("Amplitude is negative or greater than MAX_AMPLITUDE");
            }
            if (this.mAmplitude == -1) {
                return new OneShot(this.mDuration, defaultAmplitude);
            }
            return this;
        }

        @Override
        public void validate() {
            if (this.mAmplitude < -1 || this.mAmplitude == 0 || this.mAmplitude > 255) {
                throw new IllegalArgumentException("amplitude must either be DEFAULT_AMPLITUDE, or between 1 and 255 inclusive (amplitude=" + this.mAmplitude + ")");
            }
            if (this.mDuration <= 0L) {
                throw new IllegalArgumentException("duration must be positive (duration=" + this.mDuration + ")");
            }
        }

        public boolean equals(Object o) {
            if (!(o instanceof OneShot)) {
                return false;
            }
            OneShot other = (OneShot)o;
            return other.mDuration == this.mDuration && other.mAmplitude == this.mAmplitude;
        }

        public int hashCode() {
            int result = 17;
            result += 37 * (int)this.mDuration;
            return result += 37 * this.mAmplitude;
        }

        public String toString() {
            return "OneShot{mDuration=" + this.mDuration + ", mAmplitude=" + this.mAmplitude + "}";
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(1);
            out.writeLong(this.mDuration);
            out.writeInt(this.mAmplitude);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EffectType {
    }
}

