/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.media.AudioAttributes;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.util.Slog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class VibrationAttributes
implements Parcelable {
    private static final String TAG = "VibrationAttributes";
    public static final int USAGE_CLASS_UNKNOWN = 0;
    public static final int USAGE_CLASS_ALARM = 1;
    public static final int USAGE_CLASS_FEEDBACK = 2;
    public static final int USAGE_CLASS_MASK = 15;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_ALARM = 17;
    public static final int USAGE_RINGTONE = 33;
    public static final int USAGE_NOTIFICATION = 49;
    public static final int USAGE_COMMUNICATION_REQUEST = 65;
    public static final int USAGE_TOUCH = 18;
    public static final int USAGE_PHYSICAL_EMULATION = 34;
    public static final int USAGE_HARDWARE_FEEDBACK = 50;
    public static final int FLAG_BYPASS_INTERRUPTION_POLICY = 1;
    private static final long MAX_HAPTIC_FEEDBACK_DURATION = 5000L;
    private final int mUsage;
    private final int mFlags;
    private final AudioAttributes mAudioAttributes;
    public static final Parcelable.Creator<VibrationAttributes> CREATOR = new Parcelable.Creator<VibrationAttributes>(){

        @Override
        public VibrationAttributes createFromParcel(Parcel p) {
            return new VibrationAttributes(p);
        }

        public VibrationAttributes[] newArray(int size) {
            return new VibrationAttributes[size];
        }
    };

    private VibrationAttributes(int usage, int flags, AudioAttributes audio) {
        this.mUsage = usage;
        this.mFlags = flags;
        this.mAudioAttributes = audio;
    }

    public int getUsageClass() {
        return this.mUsage & 0xF;
    }

    public int getUsage() {
        return this.mUsage;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isFlagSet(int flag) {
        return (this.mFlags & flag) > 0;
    }

    @Deprecated
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mUsage);
        dest.writeInt(this.mFlags);
        dest.writeParcelable(this.mAudioAttributes, flags);
    }

    private VibrationAttributes(Parcel src) {
        this.mUsage = src.readInt();
        this.mFlags = src.readInt();
        this.mAudioAttributes = (AudioAttributes)src.readParcelable(AudioAttributes.class.getClassLoader());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VibrationAttributes rhs = (VibrationAttributes)o;
        return this.mUsage == rhs.mUsage && this.mFlags == rhs.mFlags;
    }

    public int hashCode() {
        return Objects.hash(this.mUsage, this.mFlags);
    }

    public String toString() {
        return "VibrationAttributes: Usage=" + this.usageToString() + " Flags=" + this.mFlags;
    }

    public String usageToString() {
        return this.usageToString(this.mUsage);
    }

    public String usageToString(int usage) {
        switch (usage) {
            case 0: {
                return "UNKNOWN";
            }
            case 17: {
                return "ALARM";
            }
            case 33: {
                return "RIGNTONE";
            }
            case 49: {
                return "NOTIFICATION";
            }
            case 65: {
                return "COMMUNICATION_REQUEST";
            }
            case 18: {
                return "TOUCH";
            }
            case 34: {
                return "PHYSICAL_EMULATION";
            }
            case 50: {
                return "HARDWARE_FEEDBACK";
            }
        }
        return "unknown usage " + usage;
    }

    public static class Builder {
        private int mUsage = 0;
        private int mFlags = 0;
        private AudioAttributes mAudioAttributes = new AudioAttributes.Builder().build();

        public Builder() {
        }

        public Builder(VibrationAttributes vib) {
            if (vib != null) {
                this.mUsage = vib.mUsage;
                this.mFlags = vib.mFlags;
                this.mAudioAttributes = vib.mAudioAttributes;
            }
        }

        public Builder(AudioAttributes audio, VibrationEffect effect) {
            this.mAudioAttributes = audio;
            this.setUsage(audio);
            this.setFlags(audio);
            this.applyHapticFeedbackHeuristics(effect);
        }

        private void applyHapticFeedbackHeuristics(VibrationEffect effect) {
            if (effect != null) {
                if (this.mUsage == 0 && effect instanceof VibrationEffect.Prebaked) {
                    VibrationEffect.Prebaked prebaked = (VibrationEffect.Prebaked)effect;
                    switch (prebaked.getId()) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 21: {
                            this.mUsage = 18;
                            break;
                        }
                        default: {
                            Slog.w(VibrationAttributes.TAG, "Unknown prebaked vibration effect, assuming it isn't haptic feedback");
                        }
                    }
                }
                long duration = effect.getDuration();
                if (this.mUsage == 0 && duration >= 0L && duration < 5000L) {
                    this.mUsage = 18;
                }
            }
        }

        private void setUsage(AudioAttributes audio) {
            switch (audio.getUsage()) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    this.mUsage = 49;
                    break;
                }
                case 7: 
                case 11: {
                    this.mUsage = 65;
                    break;
                }
                case 6: {
                    this.mUsage = 33;
                    break;
                }
                case 13: {
                    this.mUsage = 18;
                    break;
                }
                case 4: {
                    this.mUsage = 17;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
        }

        private void setFlags(AudioAttributes audio) {
            if ((audio.getAllFlags() & 0x40) != 0) {
                this.mFlags |= 1;
            }
        }

        public VibrationAttributes build() {
            VibrationAttributes ans = new VibrationAttributes(this.mUsage, this.mFlags, this.mAudioAttributes);
            return ans;
        }

        public Builder setUsage(int usage) {
            this.mUsage = usage;
            return this;
        }

        public Builder replaceFlags(int flags) {
            this.mFlags = flags;
            return this;
        }

        public Builder setFlags(int flags, int mask) {
            this.mFlags = this.mFlags & ~mask | flags & mask;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flag {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Usage {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UsageClass {
    }
}

