/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.IAlarmManager;
import android.compat.annotation.UnsupportedAppUsage;
import android.location.ILocationManager;
import android.location.LocationTime;
import android.os.DeadSystemException;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SimpleClock;
import android.os.SystemClock_Delegate;
import android.util.Slog;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import dalvik.annotation.optimization.CriticalNative;
import java.time.Clock;
import java.time.DateTimeException;
import java.time.ZoneOffset;

public class SystemClock {
    private static final String TAG = "SystemClock";

    @UnsupportedAppUsage
    private SystemClock() {
    }

    public static void sleep(long ms) {
        long start = SystemClock.uptimeMillis();
        long duration = ms;
        boolean interrupted = false;
        do {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        } while ((duration = start + ms - SystemClock.uptimeMillis()) > 0L);
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean setCurrentTimeMillis(long millis) {
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (mgr == null) {
            Slog.e(TAG, "Unable to set RTC: mgr == null");
            return false;
        }
        try {
            return mgr.setTime(millis);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        catch (SecurityException e) {
            Slog.e(TAG, "Unable to set RTC", e);
        }
        return false;
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long uptimeMillis() {
        return SystemClock_Delegate.uptimeMillis();
    }

    public static Clock uptimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.uptimeMillis();
            }
        };
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long elapsedRealtime() {
        return SystemClock_Delegate.elapsedRealtime();
    }

    public static Clock elapsedRealtimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.elapsedRealtime();
            }
        };
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long elapsedRealtimeNanos() {
        return SystemClock_Delegate.elapsedRealtimeNanos();
    }

    @LayoutlibDelegate
    @CriticalNative
    public static long currentThreadTimeMillis() {
        return SystemClock_Delegate.currentThreadTimeMillis();
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    @CriticalNative
    public static long currentThreadTimeMicro() {
        return SystemClock_Delegate.currentThreadTimeMicro();
    }

    @LayoutlibDelegate
    @UnsupportedAppUsage
    @CriticalNative
    public static long currentTimeMicro() {
        return SystemClock_Delegate.currentTimeMicro();
    }

    public static long currentNetworkTimeMillis() {
        IAlarmManager mgr = IAlarmManager.Stub.asInterface(ServiceManager.getService("alarm"));
        if (mgr != null) {
            try {
                return mgr.currentNetworkTimeMillis();
            }
            catch (ParcelableException e) {
                e.maybeRethrow(DateTimeException.class);
                throw new RuntimeException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        throw new RuntimeException(new DeadSystemException());
    }

    public static Clock currentNetworkTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){

            @Override
            public long millis() {
                return SystemClock.currentNetworkTimeMillis();
            }
        };
    }

    public static Clock currentGnssTimeClock() {
        return new SimpleClock(ZoneOffset.UTC){
            private final ILocationManager mMgr = ILocationManager.Stub.asInterface(ServiceManager.getService("location"));

            @Override
            public long millis() {
                LocationTime time;
                try {
                    time = this.mMgr.getGnssTimeMillis();
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                    return 0L;
                }
                if (time == null) {
                    throw new DateTimeException("Gnss based time is not available.");
                }
                long currentNanos = SystemClock.elapsedRealtimeNanos();
                long deltaMs = (currentNanos - time.getElapsedRealtimeNanos()) / 1000000L;
                return time.getTime() + deltaMs;
            }
        };
    }
}

