/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IVibratorStateListener;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.VibrationAttributes;
import android.os.VibrationEffect;

public interface IVibratorService
extends IInterface {
    public boolean hasVibrator() throws RemoteException;

    public boolean isVibrating() throws RemoteException;

    public boolean registerVibratorStateListener(IVibratorStateListener var1) throws RemoteException;

    public boolean unregisterVibratorStateListener(IVibratorStateListener var1) throws RemoteException;

    public boolean hasAmplitudeControl() throws RemoteException;

    public int[] areEffectsSupported(int[] var1) throws RemoteException;

    public boolean[] arePrimitivesSupported(int[] var1) throws RemoteException;

    public boolean setAlwaysOnEffect(int var1, String var2, int var3, VibrationEffect var4, VibrationAttributes var5) throws RemoteException;

    public void vibrate(int var1, String var2, VibrationEffect var3, VibrationAttributes var4, String var5, IBinder var6) throws RemoteException;

    public void cancelVibrate(IBinder var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVibratorService {
        private static final String DESCRIPTOR = "android.os.IVibratorService";
        static final int TRANSACTION_hasVibrator = 1;
        static final int TRANSACTION_isVibrating = 2;
        static final int TRANSACTION_registerVibratorStateListener = 3;
        static final int TRANSACTION_unregisterVibratorStateListener = 4;
        static final int TRANSACTION_hasAmplitudeControl = 5;
        static final int TRANSACTION_areEffectsSupported = 6;
        static final int TRANSACTION_arePrimitivesSupported = 7;
        static final int TRANSACTION_setAlwaysOnEffect = 8;
        static final int TRANSACTION_vibrate = 9;
        static final int TRANSACTION_cancelVibrate = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IVibratorService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IVibratorService) {
                return (IVibratorService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "hasVibrator";
                }
                case 2: {
                    return "isVibrating";
                }
                case 3: {
                    return "registerVibratorStateListener";
                }
                case 4: {
                    return "unregisterVibratorStateListener";
                }
                case 5: {
                    return "hasAmplitudeControl";
                }
                case 6: {
                    return "areEffectsSupported";
                }
                case 7: {
                    return "arePrimitivesSupported";
                }
                case 8: {
                    return "setAlwaysOnEffect";
                }
                case 9: {
                    return "vibrate";
                }
                case 10: {
                    return "cancelVibrate";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.hasVibrator();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isVibrating();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IVibratorStateListener _arg0 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.registerVibratorStateListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    IVibratorStateListener _arg0 = IVibratorStateListener.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.unregisterVibratorStateListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.hasAmplitudeControl();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    int[] _result = this.areEffectsSupported(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    boolean[] _result = this.arePrimitivesSupported(_arg0);
                    reply.writeNoException();
                    reply.writeBooleanArray(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    VibrationEffect _arg3 = 0 != data.readInt() ? VibrationEffect.CREATOR.createFromParcel(data) : null;
                    VibrationAttributes _arg4 = 0 != data.readInt() ? VibrationAttributes.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.setAlwaysOnEffect(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    VibrationEffect _arg2 = 0 != data.readInt() ? VibrationEffect.CREATOR.createFromParcel(data) : null;
                    VibrationAttributes _arg3 = 0 != data.readInt() ? VibrationAttributes.CREATOR.createFromParcel(data) : null;
                    String _arg4 = data.readString();
                    IBinder _arg5 = data.readStrongBinder();
                    this.vibrate(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    this.cancelVibrate(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IVibratorService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IVibratorService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IVibratorService {
            private IBinder mRemote;
            public static IVibratorService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasVibrator() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasVibrator();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isVibrating() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isVibrating();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerVibratorStateListener(IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().registerVibratorStateListener(listener);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterVibratorStateListener(IVibratorStateListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().unregisterVibratorStateListener(listener);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasAmplitudeControl() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().hasAmplitudeControl();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] areEffectsSupported(int[] effectIds) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(effectIds);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int[] nArray = Stub.getDefaultImpl().areEffectsSupported(effectIds);
                        return nArray;
                    }
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean[] arePrimitivesSupported(int[] primitiveIds) throws RemoteException {
                boolean[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeIntArray(primitiveIds);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean[] blArray = Stub.getDefaultImpl().arePrimitivesSupported(primitiveIds);
                        return blArray;
                    }
                    _reply.readException();
                    _result = _reply.createBooleanArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, VibrationAttributes attributes) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(opPkg);
                    _data.writeInt(alwaysOnId);
                    if (effect != null) {
                        _data.writeInt(1);
                        effect.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setAlwaysOnEffect(uid, opPkg, alwaysOnId, effect, attributes);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void vibrate(int uid, String opPkg, VibrationEffect effect, VibrationAttributes attributes, String reason, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(uid);
                    _data.writeString(opPkg);
                    if (effect != null) {
                        _data.writeInt(1);
                        effect.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (attributes != null) {
                        _data.writeInt(1);
                        attributes.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(reason);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().vibrate(uid, opPkg, effect, attributes, reason, token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelVibrate(IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().cancelVibrate(token);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVibratorService {
        @Override
        public boolean hasVibrator() throws RemoteException {
            return false;
        }

        @Override
        public boolean isVibrating() throws RemoteException {
            return false;
        }

        @Override
        public boolean registerVibratorStateListener(IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterVibratorStateListener(IVibratorStateListener listener) throws RemoteException {
            return false;
        }

        @Override
        public boolean hasAmplitudeControl() throws RemoteException {
            return false;
        }

        @Override
        public int[] areEffectsSupported(int[] effectIds) throws RemoteException {
            return null;
        }

        @Override
        public boolean[] arePrimitivesSupported(int[] primitiveIds) throws RemoteException {
            return null;
        }

        @Override
        public boolean setAlwaysOnEffect(int uid, String opPkg, int alwaysOnId, VibrationEffect effect, VibrationAttributes attributes) throws RemoteException {
            return false;
        }

        @Override
        public void vibrate(int uid, String opPkg, VibrationEffect effect, VibrationAttributes attributes, String reason, IBinder token) throws RemoteException {
        }

        @Override
        public void cancelVibrate(IBinder token) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

