/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.app.AppOpsManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.Trace;
import android.os._Original_Build;
import android.util.Log;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.os.BinderInternal;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import libcore.util.NativeAllocationRegistry;

public class BinderProxy
implements IBinder {
    volatile boolean mWarnOnBlocking = Binder.sWarnOnBlocking;
    private static volatile Binder.ProxyTransactListener sTransactListener = null;
    @GuardedBy(value={"sProxyMap"})
    private static final ProxyMap sProxyMap = new ProxyMap();
    private static final int NATIVE_ALLOCATION_SIZE = 1000;
    private final long mNativeData;

    public static void setTransactListener(Binder.ProxyTransactListener listener) {
        sTransactListener = listener;
    }

    public static InterfaceCount[] getSortedInterfaceCounts(int num) {
        return BinderProxy.sProxyMap.getSortedInterfaceCounts(num);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getProxyCount() {
        ProxyMap proxyMap = sProxyMap;
        synchronized (proxyMap) {
            return BinderProxy.sProxyMap.size();
        }
    }

    public static void dumpProxyDebugInfo() {
        if (_Original_Build.IS_DEBUGGABLE) {
            BinderProxy.sProxyMap.dumpProxyInterfaceCounts();
            BinderProxy.sProxyMap.dumpPerUidProxyCounts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BinderProxy getInstance(long nativeData, long iBinder) {
        BinderProxy result;
        ProxyMap proxyMap = sProxyMap;
        synchronized (proxyMap) {
            try {
                result = sProxyMap.get(iBinder);
                if (result != null) {
                    return result;
                }
                result = new BinderProxy(nativeData);
            }
            catch (Throwable e) {
                NativeAllocationRegistry.applyFreeFunction(NoImagePreloadHolder.sNativeFinalizer, nativeData);
                throw e;
            }
            NoImagePreloadHolder.sRegistry.registerNativeAllocation(result, nativeData);
            sProxyMap.set(iBinder, result);
        }
        return result;
    }

    private BinderProxy(long nativeData) {
        this.mNativeData = nativeData;
    }

    @Override
    public boolean pingBinder() {
        return OverrideMethod.invokeI("android.os.BinderProxy#pingBinder()Z", true, this) != 0;
    }

    @Override
    public boolean isBinderAlive() {
        return OverrideMethod.invokeI("android.os.BinderProxy#isBinderAlive()Z", true, this) != 0;
    }

    @Override
    public IInterface queryLocalInterface(String descriptor) {
        return null;
    }

    @Override
    public IBinder getExtension() throws RemoteException {
        return (IBinder)OverrideMethod.invokeA("android.os.BinderProxy#getExtension()Landroid/os/IBinder;", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        boolean tracingEnabled;
        Binder.checkParcel(this, code, data, "Unreasonably large binder buffer");
        if (this.mWarnOnBlocking && (flags & 1) == 0 && Binder.sWarnOnBlockingOnCurrentThread.get().booleanValue()) {
            this.mWarnOnBlocking = false;
            if (_Original_Build.IS_USERDEBUG) {
                Log.wtf("Binder", "Outgoing transactions from this process must be FLAG_ONEWAY", new Throwable());
            } else {
                Log.w("Binder", "Outgoing transactions from this process must be FLAG_ONEWAY", new Throwable());
            }
        }
        if (tracingEnabled = Binder.isTracingEnabled()) {
            Throwable tr = new Throwable();
            Binder.getTransactionTracker().addTrace(tr);
            StackTraceElement stackTraceElement = tr.getStackTrace()[1];
            Trace.traceBegin(1L, stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName());
        }
        Binder.ProxyTransactListener transactListener = sTransactListener;
        Object session = null;
        if (transactListener != null) {
            int origWorkSourceUid = Binder.getCallingWorkSourceUid();
            session = transactListener.onTransactStarted(this, code, flags);
            int updatedWorkSourceUid = Binder.getCallingWorkSourceUid();
            if (origWorkSourceUid != updatedWorkSourceUid) {
                data.replaceCallingWorkSourceUid(updatedWorkSourceUid);
            }
        }
        AppOpsManager.PausedNotedAppOpsCollection prevCollection = AppOpsManager.pauseNotedAppOpsCollection();
        if ((flags & 1) == 0 && AppOpsManager.isListeningForOpNoted()) {
            flags |= 2;
        }
        try {
            boolean bl = this.transactNative(code, data, reply, flags);
            return bl;
        }
        finally {
            AppOpsManager.resumeNotedAppOpsCollection(prevCollection);
            if (transactListener != null) {
                transactListener.onTransactEnded(session);
            }
            if (tracingEnabled) {
                Trace.traceEnd(1L);
            }
        }
    }

    private static long getNativeFinalizer() {
        return OverrideMethod.invokeL("android.os.BinderProxy#getNativeFinalizer()J", true, null);
    }

    @Override
    public String getInterfaceDescriptor() throws RemoteException {
        return (String)OverrideMethod.invokeA("android.os.BinderProxy#getInterfaceDescriptor()Ljava/lang/String;", true, this);
    }

    public boolean transactNative(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return OverrideMethod.invokeI("android.os.BinderProxy#transactNative(ILandroid/os/Parcel;Landroid/os/Parcel;I)Z", true, this) != 0;
    }

    @Override
    public void linkToDeath(IBinder.DeathRecipient deathRecipient, int n) throws RemoteException {
        OverrideMethod.invokeV("android.os.BinderProxy#linkToDeath(Landroid/os/IBinder$DeathRecipient;I)V", true, this);
    }

    @Override
    public boolean unlinkToDeath(IBinder.DeathRecipient deathRecipient, int n) {
        return OverrideMethod.invokeI("android.os.BinderProxy#unlinkToDeath(Landroid/os/IBinder$DeathRecipient;I)Z", true, this) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpAsync(FileDescriptor fd, String[] args) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(fd);
        data.writeStringArray(args);
        try {
            this.transact(1598311760, data, reply, 1);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        data.writeFileDescriptor(in);
        data.writeFileDescriptor(out);
        data.writeFileDescriptor(err);
        data.writeStringArray(args);
        ShellCallback.writeToParcel(callback, data);
        resultReceiver.writeToParcel(data, 0);
        try {
            this.transact(1598246212, data, reply, 0);
            reply.readException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    private static void sendDeathNotice(IBinder.DeathRecipient recipient, IBinder binderProxy) {
        try {
            recipient.binderDied(binderProxy);
        }
        catch (RuntimeException exc) {
            Log.w("BinderNative", "Uncaught exception from death notification", exc);
        }
    }

    static /* synthetic */ long access$600() {
        return BinderProxy.getNativeFinalizer();
    }

    private static class NoImagePreloadHolder {
        public static final long sNativeFinalizer = BinderProxy.access$600();
        public static final NativeAllocationRegistry sRegistry = new NativeAllocationRegistry(BinderProxy.class.getClassLoader(), sNativeFinalizer, 1000L);

        private NoImagePreloadHolder() {
        }
    }

    public static class InterfaceCount {
        private final String mInterfaceName;
        private final int mCount;

        InterfaceCount(String interfaceName, int count) {
            this.mInterfaceName = interfaceName;
            this.mCount = count;
        }

        public String toString() {
            return this.mInterfaceName + " x" + Integer.toString(this.mCount);
        }
    }

    private static class ProxyMap {
        private static final int LOG_MAIN_INDEX_SIZE = 8;
        private static final int MAIN_INDEX_SIZE = 256;
        private static final int MAIN_INDEX_MASK = 255;
        private static final int CRASH_AT_SIZE = 20000;
        private int mWarnBucketSize = 20;
        private static final int WARN_INCREMENT = 10;
        private int mRandom;
        static final int MAX_NUM_INTERFACES_TO_DUMP = 10;
        private final Long[][] mMainIndexKeys = new Long[256][];
        private final ArrayList<WeakReference<BinderProxy>>[] mMainIndexValues = new ArrayList[256];

        private ProxyMap() {
        }

        private static int hash(long arg) {
            return (int)(arg >> 2 ^ arg >> 10) & 0xFF;
        }

        private int size() {
            int size = 0;
            for (ArrayList<WeakReference<BinderProxy>> a : this.mMainIndexValues) {
                if (a == null) continue;
                size += a.size();
            }
            return size;
        }

        private int unclearedSize() {
            int size = 0;
            for (ArrayList<WeakReference<BinderProxy>> a : this.mMainIndexValues) {
                if (a == null) continue;
                for (WeakReference<BinderProxy> ref : a) {
                    if (ref.get() == null) continue;
                    ++size;
                }
            }
            return size;
        }

        private void remove(int hash, int index) {
            Long[] keyArray = this.mMainIndexKeys[hash];
            ArrayList<WeakReference<BinderProxy>> valueArray = this.mMainIndexValues[hash];
            int size = valueArray.size();
            if (index != size - 1) {
                keyArray[index] = keyArray[size - 1];
                valueArray.set(index, valueArray.get(size - 1));
            }
            valueArray.remove(size - 1);
        }

        BinderProxy get(long key) {
            int myHash = ProxyMap.hash(key);
            Long[] keyArray = this.mMainIndexKeys[myHash];
            if (keyArray == null) {
                return null;
            }
            ArrayList<WeakReference<BinderProxy>> valueArray = this.mMainIndexValues[myHash];
            int bucketSize = valueArray.size();
            for (int i = 0; i < bucketSize; ++i) {
                long foundKey = keyArray[i];
                if (key != foundKey) continue;
                WeakReference<BinderProxy> wr = valueArray.get(i);
                BinderProxy bp = (BinderProxy)wr.get();
                if (bp != null) {
                    return bp;
                }
                this.remove(myHash, i);
                return null;
            }
            return null;
        }

        void set(long key, BinderProxy value) {
            int myHash = ProxyMap.hash(key);
            ArrayList<WeakReference<BinderProxy>> valueArray = this.mMainIndexValues[myHash];
            if (valueArray == null) {
                this.mMainIndexValues[myHash] = new ArrayList();
                valueArray = this.mMainIndexValues[myHash];
                this.mMainIndexKeys[myHash] = new Long[1];
            }
            int size = valueArray.size();
            WeakReference<BinderProxy> newWr = new WeakReference<BinderProxy>(value);
            for (int i = 0; i < size; ++i) {
                int rnd;
                if (valueArray.get(i).get() != null) continue;
                valueArray.set(i, newWr);
                Long[] keyArray = this.mMainIndexKeys[myHash];
                keyArray[i] = key;
                if (i < size - 1 && valueArray.get(i + 1 + (rnd = Math.floorMod(++this.mRandom, size - (i + 1)))).get() == null) {
                    this.remove(myHash, i + 1 + rnd);
                }
                return;
            }
            valueArray.add(size, newWr);
            Long[] keyArray = this.mMainIndexKeys[myHash];
            if (keyArray.length == size) {
                Long[] newArray = new Long[size + size / 2 + 2];
                System.arraycopy(keyArray, 0, newArray, 0, size);
                newArray[size] = key;
                this.mMainIndexKeys[myHash] = newArray;
            } else {
                keyArray[size] = key;
            }
            if (size >= this.mWarnBucketSize) {
                int totalSize = this.size();
                Log.v("Binder", "BinderProxy map growth! bucket size = " + size + " total = " + totalSize);
                this.mWarnBucketSize += 10;
                if (_Original_Build.IS_DEBUGGABLE && totalSize >= 20000) {
                    int totalUnclearedSize = this.unclearedSize();
                    if (totalUnclearedSize >= 20000) {
                        this.dumpProxyInterfaceCounts();
                        this.dumpPerUidProxyCounts();
                        Runtime.getRuntime().gc();
                        throw new AssertionError((Object)("Binder ProxyMap has too many entries: " + totalSize + " (total), " + totalUnclearedSize + " (uncleared), " + this.unclearedSize() + " (uncleared after GC). BinderProxy leak?"));
                    }
                    if (totalSize > 3 * totalUnclearedSize / 2) {
                        Log.v("Binder", "BinderProxy map has many cleared entries: " + (totalSize - totalUnclearedSize) + " of " + totalSize + " are cleared");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InterfaceCount[] getSortedInterfaceCounts(int maxToReturn) {
            if (maxToReturn < 0) {
                throw new IllegalArgumentException("negative interface count");
            }
            HashMap<String, Integer> counts = new HashMap<String, Integer>();
            ArrayList<WeakReference<BinderProxy>> proxiesToQuery = new ArrayList<WeakReference<BinderProxy>>();
            ProxyMap proxyMap = sProxyMap;
            synchronized (proxyMap) {
                for (ArrayList<WeakReference<BinderProxy>> a2 : this.mMainIndexValues) {
                    if (a2 == null) continue;
                    proxiesToQuery.addAll(a2);
                }
            }
            Process.enableFreezer(false);
            for (WeakReference weakReference : proxiesToQuery) {
                String key;
                BinderProxy bp = (BinderProxy)weakReference.get();
                if (bp == null) {
                    key = "<cleared weak-ref>";
                } else {
                    try {
                        key = bp.getInterfaceDescriptor();
                        if ((key == null || key.isEmpty()) && !bp.isBinderAlive()) {
                            key = "<proxy to dead node>";
                        }
                    }
                    catch (Throwable t) {
                        key = "<exception during getDescriptor>";
                    }
                }
                Integer i = (Integer)counts.get(key);
                if (i == null) {
                    counts.put(key, 1);
                    continue;
                }
                counts.put(key, i + 1);
            }
            Process.enableFreezer(true);
            Map.Entry[] sorted = counts.entrySet().toArray(new Map.Entry[counts.size()]);
            Arrays.sort(sorted, (a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
            int n = Math.min(maxToReturn, sorted.length);
            InterfaceCount[] ifaceCounts = new InterfaceCount[n];
            for (int i = 0; i < n; ++i) {
                ifaceCounts[i] = new InterfaceCount((String)sorted[i].getKey(), (Integer)sorted[i].getValue());
            }
            return ifaceCounts;
        }

        private void dumpProxyInterfaceCounts() {
            InterfaceCount[] sorted = this.getSortedInterfaceCounts(10);
            Log.v("Binder", "BinderProxy descriptor histogram (top " + Integer.toString(10) + "):");
            for (int i = 0; i < sorted.length; ++i) {
                Log.v("Binder", " #" + (i + 1) + ": " + sorted[i]);
            }
        }

        private void dumpPerUidProxyCounts() {
            SparseIntArray counts = BinderInternal.nGetBinderProxyPerUidCounts();
            if (counts.size() == 0) {
                return;
            }
            Log.d("Binder", "Per Uid Binder Proxy Counts:");
            for (int i = 0; i < counts.size(); ++i) {
                int uid = counts.keyAt(i);
                int binderCount = counts.valueAt(i);
                Log.d("Binder", "UID : " + uid + "  count = " + binderCount);
            }
        }
    }
}

