/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;

public class NfcA
extends BasicTagTechnology {
    private static final String TAG = "NFC";
    public static final String EXTRA_SAK = "sak";
    public static final String EXTRA_ATQA = "atqa";
    private short mSak;
    private byte[] mAtqa;

    public static NfcA get(Tag tag) {
        if (!tag.hasTech(1)) {
            return null;
        }
        try {
            return new NfcA(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public NfcA(Tag tag) throws RemoteException {
        super(tag, 1);
        Bundle extras = tag.getTechExtras(1);
        this.mSak = extras.getShort(EXTRA_SAK);
        this.mAtqa = extras.getByteArray(EXTRA_ATQA);
    }

    public byte[] getAtqa() {
        return this.mAtqa;
    }

    public short getSak() {
        return this.mSak;
    }

    public byte[] transceive(byte[] data) throws IOException {
        return this.transceive(data, true);
    }

    public int getMaxTransceiveLength() {
        return this.getMaxTransceiveLengthInternal();
    }

    public void setTimeout(int timeout) {
        try {
            int err = this.mTag.getTagService().setTimeout(1, timeout);
            if (err != 0) {
                throw new IllegalArgumentException("The supplied timeout is not valid");
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
        }
    }

    public int getTimeout() {
        try {
            return this.mTag.getTagService().getTimeout(1);
        }
        catch (RemoteException e) {
            Log.e(TAG, "NFC service dead", e);
            return 0;
        }
    }
}

