/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.rtt;

import android.annotation.SystemApi;
import android.net.MacAddress;
import android.net.wifi.ScanResult;
import android.net.wifi.aware.PeerHandle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class ResponderConfig
implements Parcelable {
    private static final String TAG = "ResponderConfig";
    private static final int AWARE_BAND_2_DISCOVERY_CHANNEL = 2437;
    public static final int RESPONDER_AP = 0;
    public static final int RESPONDER_STA = 1;
    public static final int RESPONDER_P2P_GO = 2;
    public static final int RESPONDER_P2P_CLIENT = 3;
    public static final int RESPONDER_AWARE = 4;
    public static final int CHANNEL_WIDTH_20MHZ = 0;
    public static final int CHANNEL_WIDTH_40MHZ = 1;
    public static final int CHANNEL_WIDTH_80MHZ = 2;
    public static final int CHANNEL_WIDTH_160MHZ = 3;
    public static final int CHANNEL_WIDTH_80MHZ_PLUS_MHZ = 4;
    public static final int PREAMBLE_LEGACY = 0;
    public static final int PREAMBLE_HT = 1;
    public static final int PREAMBLE_VHT = 2;
    public static final int PREAMBLE_HE = 3;
    public final MacAddress macAddress;
    public final PeerHandle peerHandle;
    public final int responderType;
    public final boolean supports80211mc;
    public final int channelWidth;
    public final int frequency;
    public final int centerFreq0;
    public final int centerFreq1;
    public final int preamble;
    public static final Parcelable.Creator<ResponderConfig> CREATOR = new Parcelable.Creator<ResponderConfig>(){

        public ResponderConfig[] newArray(int size) {
            return new ResponderConfig[size];
        }

        @Override
        public ResponderConfig createFromParcel(Parcel in) {
            boolean macAddressPresent = in.readBoolean();
            MacAddress macAddress = null;
            if (macAddressPresent) {
                macAddress = MacAddress.CREATOR.createFromParcel(in);
            }
            boolean peerHandlePresent = in.readBoolean();
            PeerHandle peerHandle = null;
            if (peerHandlePresent) {
                peerHandle = new PeerHandle(in.readInt());
            }
            int responderType = in.readInt();
            boolean supports80211mc = in.readInt() == 1;
            int channelWidth = in.readInt();
            int frequency = in.readInt();
            int centerFreq0 = in.readInt();
            int centerFreq1 = in.readInt();
            int preamble = in.readInt();
            if (peerHandle == null) {
                return new ResponderConfig(macAddress, responderType, supports80211mc, channelWidth, frequency, centerFreq0, centerFreq1, preamble);
            }
            return new ResponderConfig(peerHandle, responderType, supports80211mc, channelWidth, frequency, centerFreq0, centerFreq1, preamble);
        }
    };

    public ResponderConfig(MacAddress macAddress, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        if (macAddress == null) {
            throw new IllegalArgumentException("Invalid ResponderConfig - must specify a MAC address");
        }
        this.macAddress = macAddress;
        this.peerHandle = null;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
    }

    public ResponderConfig(PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        this.macAddress = null;
        this.peerHandle = peerHandle;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
    }

    public ResponderConfig(MacAddress macAddress, PeerHandle peerHandle, int responderType, boolean supports80211mc, int channelWidth, int frequency, int centerFreq0, int centerFreq1, int preamble) {
        this.macAddress = macAddress;
        this.peerHandle = peerHandle;
        this.responderType = responderType;
        this.supports80211mc = supports80211mc;
        this.channelWidth = channelWidth;
        this.frequency = frequency;
        this.centerFreq0 = centerFreq0;
        this.centerFreq1 = centerFreq1;
        this.preamble = preamble;
    }

    public static ResponderConfig fromScanResult(ScanResult scanResult) {
        int preamble;
        MacAddress macAddress = MacAddress.fromString(scanResult.BSSID);
        int responderType = 0;
        boolean supports80211mc = scanResult.is80211mcResponder();
        int channelWidth = ResponderConfig.translateScanResultChannelWidth(scanResult.channelWidth);
        int frequency = scanResult.frequency;
        int centerFreq0 = scanResult.centerFreq0;
        int centerFreq1 = scanResult.centerFreq1;
        if (scanResult.informationElements != null && scanResult.informationElements.length != 0) {
            boolean htCapabilitiesPresent = false;
            boolean vhtCapabilitiesPresent = false;
            boolean heCapabilitiesPresent = false;
            for (ScanResult.InformationElement ie : scanResult.informationElements) {
                if (ie.id == 45) {
                    htCapabilitiesPresent = true;
                    continue;
                }
                if (ie.id == 191) {
                    vhtCapabilitiesPresent = true;
                    continue;
                }
                if (ie.id != 255 || ie.idExt != 35) continue;
                heCapabilitiesPresent = true;
            }
            preamble = heCapabilitiesPresent ? 3 : (vhtCapabilitiesPresent ? 2 : (htCapabilitiesPresent ? 1 : 0));
        } else {
            Log.e(TAG, "Scan Results do not contain IEs - using backup method to select preamble");
            preamble = channelWidth == 2 || channelWidth == 3 ? 2 : 1;
        }
        return new ResponderConfig(macAddress, responderType, supports80211mc, channelWidth, frequency, centerFreq0, centerFreq1, preamble);
    }

    public static ResponderConfig fromWifiAwarePeerMacAddressWithDefaults(MacAddress macAddress) {
        return new ResponderConfig(macAddress, 4, true, 0, 2437, 0, 0, 1);
    }

    public static ResponderConfig fromWifiAwarePeerHandleWithDefaults(PeerHandle peerHandle) {
        return new ResponderConfig(peerHandle, 4, true, 0, 2437, 0, 0, 1);
    }

    public boolean isValid(boolean awareSupported) {
        if (this.macAddress == null && this.peerHandle == null || this.macAddress != null && this.peerHandle != null) {
            return false;
        }
        return awareSupported || this.responderType != 4;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        if (this.macAddress == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            this.macAddress.writeToParcel(dest, flags);
        }
        if (this.peerHandle == null) {
            dest.writeBoolean(false);
        } else {
            dest.writeBoolean(true);
            dest.writeInt(this.peerHandle.peerId);
        }
        dest.writeInt(this.responderType);
        dest.writeInt(this.supports80211mc ? 1 : 0);
        dest.writeInt(this.channelWidth);
        dest.writeInt(this.frequency);
        dest.writeInt(this.centerFreq0);
        dest.writeInt(this.centerFreq1);
        dest.writeInt(this.preamble);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponderConfig)) {
            return false;
        }
        ResponderConfig lhs = (ResponderConfig)o;
        return Objects.equals(this.macAddress, lhs.macAddress) && Objects.equals(this.peerHandle, lhs.peerHandle) && this.responderType == lhs.responderType && this.supports80211mc == lhs.supports80211mc && this.channelWidth == lhs.channelWidth && this.frequency == lhs.frequency && this.centerFreq0 == lhs.centerFreq0 && this.centerFreq1 == lhs.centerFreq1 && this.preamble == lhs.preamble;
    }

    public int hashCode() {
        return Objects.hash(this.macAddress, this.peerHandle, this.responderType, this.supports80211mc, this.channelWidth, this.frequency, this.centerFreq0, this.centerFreq1, this.preamble);
    }

    public String toString() {
        return new StringBuffer("ResponderConfig: macAddress=").append(this.macAddress).append(", peerHandle=").append(this.peerHandle == null ? "<null>" : Integer.valueOf(this.peerHandle.peerId)).append(", responderType=").append(this.responderType).append(", supports80211mc=").append(this.supports80211mc).append(", channelWidth=").append(this.channelWidth).append(", frequency=").append(this.frequency).append(", centerFreq0=").append(this.centerFreq0).append(", centerFreq1=").append(this.centerFreq1).append(", preamble=").append(this.preamble).toString();
    }

    static int translateScanResultChannelWidth(int scanResultChannelWidth) {
        switch (scanResultChannelWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("translateScanResultChannelWidth: bad " + scanResultChannelWidth);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PreambleType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChannelWidth {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ResponderType {
    }
}

