/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.IpConfiguration;
import android.net.MacAddress;
import android.net.ProxyInfo;
import android.net.StaticIpConfiguration;
import android.net.Uri;
import android.net.util.MacAddressUtils;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiEnterpriseConfig;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiSsid;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.HashMap;

@Deprecated
public class WifiConfiguration
implements Parcelable {
    private static final String TAG = "WifiConfiguration";
    private static final int BACKUP_VERSION = 3;
    public static final String ssidVarName = "ssid";
    public static final String bssidVarName = "bssid";
    public static final String pskVarName = "psk";
    @Deprecated
    @UnsupportedAppUsage
    public static final String[] wepKeyVarNames = new String[]{"wep_key0", "wep_key1", "wep_key2", "wep_key3"};
    @Deprecated
    public static final String wepTxKeyIdxVarName = "wep_tx_keyidx";
    public static final String priorityVarName = "priority";
    public static final String hiddenSSIDVarName = "scan_ssid";
    public static final String pmfVarName = "ieee80211w";
    public static final String updateIdentiferVarName = "update_identifier";
    @SystemApi
    public static final int INVALID_NETWORK_ID = -1;
    public static final int LOCAL_ONLY_NETWORK_ID = -2;
    private String mPasspointManagementObjectTree;
    private static final int MAXIMUM_RANDOM_MAC_GENERATION_RETRY = 3;
    public static final int SECURITY_TYPE_OPEN = 0;
    public static final int SECURITY_TYPE_WEP = 1;
    public static final int SECURITY_TYPE_PSK = 2;
    public static final int SECURITY_TYPE_EAP = 3;
    public static final int SECURITY_TYPE_SAE = 4;
    public static final int SECURITY_TYPE_EAP_SUITE_B = 5;
    public static final int SECURITY_TYPE_OWE = 6;
    public static final int SECURITY_TYPE_WAPI_PSK = 7;
    public static final int SECURITY_TYPE_WAPI_CERT = 8;
    public static final int UNKNOWN_UID = -1;
    public int networkId;
    public int status;
    public String SSID;
    public String BSSID;
    public static final int AP_BAND_2GHZ = 0;
    public static final int AP_BAND_5GHZ = 1;
    public static final int AP_BAND_ANY = -1;
    @UnsupportedAppUsage
    public int apBand = 0;
    @UnsupportedAppUsage
    public int apChannel = 0;
    public String preSharedKey;
    @Deprecated
    public String[] wepKeys;
    @Deprecated
    public int wepTxKeyIndex;
    @Deprecated
    public int priority;
    public boolean hiddenSSID;
    @SystemApi
    public boolean requirePmf;
    public String updateIdentifier;
    public BitSet allowedKeyManagement;
    public BitSet allowedProtocols;
    public BitSet allowedAuthAlgorithms;
    public BitSet allowedPairwiseCiphers;
    public BitSet allowedGroupCiphers;
    public BitSet allowedGroupManagementCiphers;
    public BitSet allowedSuiteBCiphers;
    public WifiEnterpriseConfig enterpriseConfig;
    public String FQDN;
    public String providerFriendlyName;
    public boolean isHomeProviderNetwork;
    public long[] roamingConsortiumIds;
    @SystemApi
    public boolean shared;
    @UnsupportedAppUsage
    private IpConfiguration mIpConfiguration;
    public String dhcpServer;
    @UnsupportedAppUsage
    public String defaultGwMacAddress;
    @UnsupportedAppUsage
    public boolean validatedInternetAccess;
    public int dtimInterval = 0;
    public boolean isLegacyPasspointConfig = false;
    @SystemApi
    public int creatorUid;
    @UnsupportedAppUsage
    public int lastConnectUid;
    @SystemApi
    public int lastUpdateUid;
    @SystemApi
    public String creatorName;
    @SystemApi
    public String lastUpdateName;
    @SystemApi
    public int carrierId = -1;
    @SystemApi
    public boolean allowAutojoin = true;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public static int INVALID_RSSI = -127;
    @UnsupportedAppUsage
    public int numNoInternetAccessReports;
    @UnsupportedAppUsage
    public boolean noInternetAccessExpected;
    public boolean osu;
    public long lastConnected;
    public long lastDisconnected;
    @UnsupportedAppUsage
    public boolean selfAdded;
    public String peerWifiConfiguration;
    public boolean ephemeral;
    public boolean trusted;
    @SystemApi
    public boolean fromWifiNetworkSuggestion;
    @SystemApi
    public boolean fromWifiNetworkSpecifier;
    @SystemApi
    public boolean meteredHint;
    @SystemApi
    public static final int METERED_OVERRIDE_NONE = 0;
    @SystemApi
    public static final int METERED_OVERRIDE_METERED = 1;
    @SystemApi
    public static final int METERED_OVERRIDE_NOT_METERED = 2;
    @SystemApi
    public int meteredOverride = 0;
    @SystemApi
    public boolean useExternalScores;
    @SystemApi
    public int numScorerOverride;
    @SystemApi
    public int numScorerOverrideAndSwitchedNetwork;
    @SystemApi
    public int numAssociation;
    @SystemApi
    public static final int RANDOMIZATION_NONE = 0;
    @SystemApi
    public static final int RANDOMIZATION_PERSISTENT = 1;
    @SystemApi
    public int macRandomizationSetting = 1;
    private MacAddress mRandomizedMacAddress;
    public long randomizedMacExpirationTimeMs = 0L;
    public static final int HOME_NETWORK_RSSI_BOOST = 5;
    private NetworkSelectionStatus mNetworkSelectionStatus = new NetworkSelectionStatus();
    public final RecentFailure recentFailure = new RecentFailure();
    @SystemApi
    public static final int RECENT_FAILURE_NONE = 0;
    @SystemApi
    public static final int RECENT_FAILURE_AP_UNABLE_TO_HANDLE_NEW_STA = 17;
    public HashMap<String, Integer> linkedConfigurations;
    @UnsupportedAppUsage
    public static final Parcelable.Creator<WifiConfiguration> CREATOR = new Parcelable.Creator<WifiConfiguration>(){

        @Override
        public WifiConfiguration createFromParcel(Parcel in) {
            int i;
            WifiConfiguration config = new WifiConfiguration();
            config.networkId = in.readInt();
            config.status = in.readInt();
            config.mNetworkSelectionStatus.readFromParcel(in);
            config.SSID = in.readString();
            config.BSSID = in.readString();
            config.apBand = in.readInt();
            config.apChannel = in.readInt();
            config.FQDN = in.readString();
            config.providerFriendlyName = in.readString();
            config.isHomeProviderNetwork = in.readInt() != 0;
            int numRoamingConsortiumIds = in.readInt();
            config.roamingConsortiumIds = new long[numRoamingConsortiumIds];
            for (i = 0; i < numRoamingConsortiumIds; ++i) {
                config.roamingConsortiumIds[i] = in.readLong();
            }
            config.preSharedKey = in.readString();
            for (i = 0; i < config.wepKeys.length; ++i) {
                config.wepKeys[i] = in.readString();
            }
            config.wepTxKeyIndex = in.readInt();
            config.priority = in.readInt();
            config.hiddenSSID = in.readInt() != 0;
            config.requirePmf = in.readInt() != 0;
            config.updateIdentifier = in.readString();
            config.allowedKeyManagement = WifiConfiguration.readBitSet(in);
            config.allowedProtocols = WifiConfiguration.readBitSet(in);
            config.allowedAuthAlgorithms = WifiConfiguration.readBitSet(in);
            config.allowedPairwiseCiphers = WifiConfiguration.readBitSet(in);
            config.allowedGroupCiphers = WifiConfiguration.readBitSet(in);
            config.allowedGroupManagementCiphers = WifiConfiguration.readBitSet(in);
            config.allowedSuiteBCiphers = WifiConfiguration.readBitSet(in);
            config.enterpriseConfig = (WifiEnterpriseConfig)in.readParcelable(null);
            config.setIpConfiguration((IpConfiguration)in.readParcelable(null));
            config.dhcpServer = in.readString();
            config.defaultGwMacAddress = in.readString();
            config.validatedInternetAccess = in.readInt() != 0;
            config.isLegacyPasspointConfig = in.readInt() != 0;
            config.ephemeral = in.readInt() != 0;
            config.trusted = in.readInt() != 0;
            config.fromWifiNetworkSuggestion = in.readInt() != 0;
            config.fromWifiNetworkSpecifier = in.readInt() != 0;
            config.meteredHint = in.readInt() != 0;
            config.meteredOverride = in.readInt();
            config.useExternalScores = in.readInt() != 0;
            config.creatorUid = in.readInt();
            config.lastConnectUid = in.readInt();
            config.lastUpdateUid = in.readInt();
            config.creatorName = in.readString();
            config.lastUpdateName = in.readString();
            config.numScorerOverride = in.readInt();
            config.numScorerOverrideAndSwitchedNetwork = in.readInt();
            config.numAssociation = in.readInt();
            config.allowAutojoin = in.readBoolean();
            config.numNoInternetAccessReports = in.readInt();
            config.noInternetAccessExpected = in.readInt() != 0;
            config.shared = in.readInt() != 0;
            config.mPasspointManagementObjectTree = in.readString();
            config.recentFailure.setAssociationStatus(in.readInt());
            config.mRandomizedMacAddress = (MacAddress)in.readParcelable(null);
            config.macRandomizationSetting = in.readInt();
            config.osu = in.readInt() != 0;
            config.randomizedMacExpirationTimeMs = in.readLong();
            config.carrierId = in.readInt();
            config.mPasspointUniqueId = in.readString();
            return config;
        }

        public WifiConfiguration[] newArray(int size) {
            return new WifiConfiguration[size];
        }
    };
    private String mPasspointUniqueId = null;
    public boolean isMostRecentlyConnected = false;

    public void setSecurityParams(int securityType) {
        this.allowedKeyManagement.clear();
        this.allowedProtocols.clear();
        this.allowedAuthAlgorithms.clear();
        this.allowedPairwiseCiphers.clear();
        this.allowedGroupCiphers.clear();
        this.allowedGroupManagementCiphers.clear();
        this.allowedSuiteBCiphers.clear();
        switch (securityType) {
            case 0: {
                this.allowedKeyManagement.set(0);
                break;
            }
            case 1: {
                this.allowedKeyManagement.set(0);
                this.allowedAuthAlgorithms.set(0);
                this.allowedAuthAlgorithms.set(1);
                break;
            }
            case 2: {
                this.allowedKeyManagement.set(1);
                break;
            }
            case 3: {
                this.allowedKeyManagement.set(2);
                this.allowedKeyManagement.set(3);
                break;
            }
            case 4: {
                this.allowedProtocols.set(1);
                this.allowedKeyManagement.set(8);
                this.allowedPairwiseCiphers.set(2);
                this.allowedPairwiseCiphers.set(3);
                this.allowedGroupCiphers.set(3);
                this.allowedGroupCiphers.set(5);
                this.requirePmf = true;
                break;
            }
            case 5: {
                this.allowedProtocols.set(1);
                this.allowedKeyManagement.set(2);
                this.allowedKeyManagement.set(3);
                this.allowedKeyManagement.set(10);
                this.allowedPairwiseCiphers.set(3);
                this.allowedGroupCiphers.set(5);
                this.allowedGroupManagementCiphers.set(2);
                this.requirePmf = true;
                break;
            }
            case 6: {
                this.allowedProtocols.set(1);
                this.allowedKeyManagement.set(9);
                this.allowedPairwiseCiphers.set(2);
                this.allowedPairwiseCiphers.set(3);
                this.allowedGroupCiphers.set(3);
                this.allowedGroupCiphers.set(5);
                this.requirePmf = true;
                break;
            }
            case 7: {
                this.allowedKeyManagement.set(13);
                this.allowedProtocols.set(3);
                this.allowedPairwiseCiphers.set(4);
                this.allowedGroupCiphers.set(6);
                break;
            }
            case 8: {
                this.allowedKeyManagement.set(14);
                this.allowedProtocols.set(3);
                this.allowedPairwiseCiphers.set(4);
                this.allowedGroupCiphers.set(6);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security type " + securityType);
            }
        }
    }

    @SystemApi
    public boolean hasNoInternetAccess() {
        return this.numNoInternetAccessReports > 0 && !this.validatedInternetAccess;
    }

    @SystemApi
    public boolean isNoInternetAccessExpected() {
        return this.noInternetAccessExpected;
    }

    @SystemApi
    public boolean isEphemeral() {
        return this.ephemeral;
    }

    @SystemApi
    public static boolean isMetered(WifiConfiguration config, WifiInfo info) {
        boolean metered = false;
        if (info != null && info.getMeteredHint()) {
            metered = true;
        }
        if (config != null && config.meteredHint) {
            metered = true;
        }
        if (config != null && config.meteredOverride == 1) {
            metered = true;
        }
        if (config != null && config.meteredOverride == 2) {
            metered = false;
        }
        return metered;
    }

    public boolean isOpenNetwork() {
        int cardinality = this.allowedKeyManagement.cardinality();
        boolean hasNoKeyMgmt = cardinality == 0 || cardinality == 1 && (this.allowedKeyManagement.get(0) || this.allowedKeyManagement.get(9));
        boolean hasNoWepKeys = true;
        if (this.wepKeys != null) {
            for (int i = 0; i < this.wepKeys.length; ++i) {
                if (this.wepKeys[i] == null) continue;
                hasNoWepKeys = false;
                break;
            }
        }
        return hasNoKeyMgmt && hasNoWepKeys;
    }

    public static boolean isValidMacAddressForRandomization(MacAddress mac) {
        return mac != null && !MacAddressUtils.isMulticastAddress(mac) && mac.isLocallyAssigned() && !MacAddress.fromString("02:00:00:00:00:00").equals(mac);
    }

    public MacAddress getRandomizedMacAddress() {
        return this.mRandomizedMacAddress;
    }

    public void setRandomizedMacAddress(MacAddress mac) {
        if (mac == null) {
            Log.e(TAG, "setRandomizedMacAddress received null MacAddress.");
            return;
        }
        this.mRandomizedMacAddress = mac;
    }

    @SystemApi
    public int getRecentFailureReason() {
        return this.recentFailure.getAssociationStatus();
    }

    @SystemApi
    public NetworkSelectionStatus getNetworkSelectionStatus() {
        return this.mNetworkSelectionStatus;
    }

    @SystemApi
    public void setNetworkSelectionStatus(NetworkSelectionStatus status) {
        this.mNetworkSelectionStatus = status;
    }

    public WifiConfiguration() {
        this.networkId = -1;
        this.SSID = null;
        this.BSSID = null;
        this.FQDN = null;
        this.roamingConsortiumIds = new long[0];
        this.priority = 0;
        this.hiddenSSID = false;
        this.allowedKeyManagement = new BitSet();
        this.allowedProtocols = new BitSet();
        this.allowedAuthAlgorithms = new BitSet();
        this.allowedPairwiseCiphers = new BitSet();
        this.allowedGroupCiphers = new BitSet();
        this.allowedGroupManagementCiphers = new BitSet();
        this.allowedSuiteBCiphers = new BitSet();
        this.wepKeys = new String[4];
        for (int i = 0; i < this.wepKeys.length; ++i) {
            this.wepKeys[i] = null;
        }
        this.enterpriseConfig = new WifiEnterpriseConfig();
        this.ephemeral = false;
        this.osu = false;
        this.trusted = true;
        this.fromWifiNetworkSuggestion = false;
        this.fromWifiNetworkSpecifier = false;
        this.meteredHint = false;
        this.meteredOverride = 0;
        this.useExternalScores = false;
        this.validatedInternetAccess = false;
        this.mIpConfiguration = new IpConfiguration();
        this.lastUpdateUid = -1;
        this.creatorUid = -1;
        this.shared = true;
        this.dtimInterval = 0;
        this.mRandomizedMacAddress = MacAddress.fromString("02:00:00:00:00:00");
    }

    public boolean isPasspoint() {
        return !TextUtils.isEmpty(this.FQDN) && !TextUtils.isEmpty(this.providerFriendlyName) && this.enterpriseConfig != null && this.enterpriseConfig.getEapMethod() != -1 && !TextUtils.isEmpty(this.mPasspointUniqueId);
    }

    public boolean isLinked(WifiConfiguration config) {
        return config != null && config.linkedConfigurations != null && this.linkedConfigurations != null && config.linkedConfigurations.get(this.getKey()) != null && this.linkedConfigurations.get(config.getKey()) != null;
    }

    @UnsupportedAppUsage
    public boolean isEnterprise() {
        return (this.allowedKeyManagement.get(2) || this.allowedKeyManagement.get(3) || this.allowedKeyManagement.get(10) || this.allowedKeyManagement.get(14)) && this.enterpriseConfig != null && this.enterpriseConfig.getEapMethod() != -1;
    }

    private static String logTimeOfDay(long millis) {
        Calendar c = Calendar.getInstance();
        if (millis >= 0L) {
            c.setTimeInMillis(millis);
            return String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c);
        }
        return Long.toString(millis);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder();
        if (this.status == 0) {
            sbuf.append("* ");
        } else if (this.status == 1) {
            sbuf.append("- DSBLE ");
        }
        sbuf.append("ID: ").append(this.networkId).append(" SSID: ").append(this.SSID).append(" PROVIDER-NAME: ").append(this.providerFriendlyName).append(" BSSID: ").append(this.BSSID).append(" FQDN: ").append(this.FQDN).append(" HOME-PROVIDER-NETWORK: ").append(this.isHomeProviderNetwork).append(" PRIO: ").append(this.priority).append(" HIDDEN: ").append(this.hiddenSSID).append(" PMF: ").append(this.requirePmf).append("CarrierId: ").append(this.carrierId).append('\n');
        sbuf.append(" NetworkSelectionStatus ").append(this.mNetworkSelectionStatus.getNetworkStatusString()).append("\n");
        if (this.mNetworkSelectionStatus.getNetworkSelectionDisableReason() > 0) {
            sbuf.append(" mNetworkSelectionDisableReason ").append(this.mNetworkSelectionStatus.getNetworkSelectionDisableReasonString()).append("\n");
            for (int index = 0; index < 10; ++index) {
                if (this.mNetworkSelectionStatus.getDisableReasonCounter(index) == 0) continue;
                sbuf.append(NetworkSelectionStatus.getNetworkSelectionDisableReasonString(index)).append(" counter:").append(this.mNetworkSelectionStatus.getDisableReasonCounter(index)).append("\n");
            }
        }
        if (this.mNetworkSelectionStatus.getConnectChoice() != null) {
            sbuf.append(" connect choice: ").append(this.mNetworkSelectionStatus.getConnectChoice());
        }
        sbuf.append(" hasEverConnected: ").append(this.mNetworkSelectionStatus.hasEverConnected()).append("\n");
        if (this.numAssociation > 0) {
            sbuf.append(" numAssociation ").append(this.numAssociation).append("\n");
        }
        if (this.numNoInternetAccessReports > 0) {
            sbuf.append(" numNoInternetAccessReports ");
            sbuf.append(this.numNoInternetAccessReports).append("\n");
        }
        if (this.validatedInternetAccess) {
            sbuf.append(" validatedInternetAccess");
        }
        if (this.ephemeral) {
            sbuf.append(" ephemeral");
        }
        if (this.osu) {
            sbuf.append(" osu");
        }
        if (this.trusted) {
            sbuf.append(" trusted");
        }
        if (this.fromWifiNetworkSuggestion) {
            sbuf.append(" fromWifiNetworkSuggestion");
        }
        if (this.fromWifiNetworkSpecifier) {
            sbuf.append(" fromWifiNetworkSpecifier");
        }
        if (this.meteredHint) {
            sbuf.append(" meteredHint");
        }
        if (this.useExternalScores) {
            sbuf.append(" useExternalScores");
        }
        if (this.validatedInternetAccess || this.ephemeral || this.trusted || this.fromWifiNetworkSuggestion || this.fromWifiNetworkSpecifier || this.meteredHint || this.useExternalScores) {
            sbuf.append("\n");
        }
        if (this.meteredOverride != 0) {
            sbuf.append(" meteredOverride ").append(this.meteredOverride).append("\n");
        }
        sbuf.append(" macRandomizationSetting: ").append(this.macRandomizationSetting).append("\n");
        sbuf.append(" mRandomizedMacAddress: ").append(this.mRandomizedMacAddress).append("\n");
        sbuf.append(" randomizedMacExpirationTimeMs: ").append(this.randomizedMacExpirationTimeMs == 0L ? "<none>" : WifiConfiguration.logTimeOfDay(this.randomizedMacExpirationTimeMs)).append("\n");
        sbuf.append(" KeyMgmt:");
        for (int k = 0; k < this.allowedKeyManagement.size(); ++k) {
            if (!this.allowedKeyManagement.get(k)) continue;
            sbuf.append(" ");
            if (k < KeyMgmt.strings.length) {
                sbuf.append(KeyMgmt.strings[k]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append(" Protocols:");
        for (int p = 0; p < this.allowedProtocols.size(); ++p) {
            if (!this.allowedProtocols.get(p)) continue;
            sbuf.append(" ");
            if (p < Protocol.strings.length) {
                sbuf.append(Protocol.strings[p]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" AuthAlgorithms:");
        for (int a = 0; a < this.allowedAuthAlgorithms.size(); ++a) {
            if (!this.allowedAuthAlgorithms.get(a)) continue;
            sbuf.append(" ");
            if (a < AuthAlgorithm.strings.length) {
                sbuf.append(AuthAlgorithm.strings[a]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" PairwiseCiphers:");
        for (int pc = 0; pc < this.allowedPairwiseCiphers.size(); ++pc) {
            if (!this.allowedPairwiseCiphers.get(pc)) continue;
            sbuf.append(" ");
            if (pc < PairwiseCipher.strings.length) {
                sbuf.append(PairwiseCipher.strings[pc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupCiphers:");
        for (int gc = 0; gc < this.allowedGroupCiphers.size(); ++gc) {
            if (!this.allowedGroupCiphers.get(gc)) continue;
            sbuf.append(" ");
            if (gc < GroupCipher.strings.length) {
                sbuf.append(GroupCipher.strings[gc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" GroupMgmtCiphers:");
        for (int gmc = 0; gmc < this.allowedGroupManagementCiphers.size(); ++gmc) {
            if (!this.allowedGroupManagementCiphers.get(gmc)) continue;
            sbuf.append(" ");
            if (gmc < GroupMgmtCipher.strings.length) {
                sbuf.append(GroupMgmtCipher.strings[gmc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n');
        sbuf.append(" SuiteBCiphers:");
        for (int sbc = 0; sbc < this.allowedSuiteBCiphers.size(); ++sbc) {
            if (!this.allowedSuiteBCiphers.get(sbc)) continue;
            sbuf.append(" ");
            if (sbc < SuiteBCipher.strings.length) {
                sbuf.append(SuiteBCipher.strings[sbc]);
                continue;
            }
            sbuf.append("??");
        }
        sbuf.append('\n').append(" PSK/SAE: ");
        if (this.preSharedKey != null) {
            sbuf.append('*');
        }
        sbuf.append("\nEnterprise config:\n");
        sbuf.append(this.enterpriseConfig);
        sbuf.append("IP config:\n");
        sbuf.append(this.mIpConfiguration.toString());
        if (this.mNetworkSelectionStatus.getNetworkSelectionBSSID() != null) {
            sbuf.append(" networkSelectionBSSID=" + this.mNetworkSelectionStatus.getNetworkSelectionBSSID());
        }
        long now_ms = SystemClock.elapsedRealtime();
        if (this.mNetworkSelectionStatus.getDisableTime() != -1L) {
            sbuf.append('\n');
            long diff = now_ms - this.mNetworkSelectionStatus.getDisableTime();
            if (diff <= 0L) {
                sbuf.append(" blackListed since <incorrect>");
            } else {
                sbuf.append(" blackListed: ").append(Long.toString(diff / 1000L)).append("sec ");
            }
        }
        if (this.creatorUid != 0) {
            sbuf.append(" cuid=" + this.creatorUid);
        }
        if (this.creatorName != null) {
            sbuf.append(" cname=" + this.creatorName);
        }
        if (this.lastUpdateUid != 0) {
            sbuf.append(" luid=" + this.lastUpdateUid);
        }
        if (this.lastUpdateName != null) {
            sbuf.append(" lname=" + this.lastUpdateName);
        }
        if (this.updateIdentifier != null) {
            sbuf.append(" updateIdentifier=" + this.updateIdentifier);
        }
        sbuf.append(" lcuid=" + this.lastConnectUid);
        sbuf.append(" allowAutojoin=" + this.allowAutojoin);
        sbuf.append(" noInternetAccessExpected=" + this.noInternetAccessExpected);
        sbuf.append(" mostRecentlyConnected=" + this.isMostRecentlyConnected);
        sbuf.append(" ");
        if (this.lastConnected != 0L) {
            sbuf.append('\n');
            sbuf.append("lastConnected: ").append(WifiConfiguration.logTimeOfDay(this.lastConnected));
            sbuf.append(" ");
        }
        sbuf.append('\n');
        if (this.linkedConfigurations != null) {
            for (String key : this.linkedConfigurations.keySet()) {
                sbuf.append(" linked: ").append(key);
                sbuf.append('\n');
            }
        }
        sbuf.append("recentFailure: ").append("Association Rejection code: ").append(this.recentFailure.getAssociationStatus()).append("\n");
        return sbuf.toString();
    }

    @SystemApi
    public String getPrintableSsid() {
        if (this.SSID == null) {
            return "";
        }
        int length = this.SSID.length();
        if (length > 2 && this.SSID.charAt(0) == '\"' && this.SSID.charAt(length - 1) == '\"') {
            return this.SSID.substring(1, length - 1);
        }
        if (length > 3 && this.SSID.charAt(0) == 'P' && this.SSID.charAt(1) == '\"' && this.SSID.charAt(length - 1) == '\"') {
            WifiSsid wifiSsid = WifiSsid.createFromAsciiEncoded(this.SSID.substring(2, length - 1));
            return wifiSsid.toString();
        }
        return this.SSID;
    }

    public String getKeyIdForCredentials(WifiConfiguration current) {
        String keyMgmt = "";
        try {
            if (TextUtils.isEmpty(this.SSID)) {
                this.SSID = current.SSID;
            }
            if (this.allowedKeyManagement.cardinality() == 0) {
                this.allowedKeyManagement = current.allowedKeyManagement;
            }
            if (this.allowedKeyManagement.get(2)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[2];
            }
            if (this.allowedKeyManagement.get(5)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[5];
            }
            if (this.allowedKeyManagement.get(3)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[3];
            }
            if (this.allowedKeyManagement.get(10)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[10];
            }
            if (this.allowedKeyManagement.get(14)) {
                keyMgmt = keyMgmt + KeyMgmt.strings[14];
            }
            if (TextUtils.isEmpty(keyMgmt)) {
                throw new IllegalStateException("Not an EAP network");
            }
            String keyId = this.trimStringForKeyId(this.SSID) + "_" + keyMgmt + "_" + this.trimStringForKeyId(this.enterpriseConfig.getKeyId(current != null ? current.enterpriseConfig : null));
            if (!this.fromWifiNetworkSuggestion) {
                return keyId;
            }
            return keyId + "_" + this.trimStringForKeyId(this.BSSID) + "_" + this.trimStringForKeyId(this.creatorName);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("Invalid config details");
        }
    }

    private String trimStringForKeyId(String string2) {
        if (string2 == null) {
            return "";
        }
        return string2.replace("\"", "").replace(" ", "");
    }

    private static BitSet readBitSet(Parcel src) {
        int cardinality = src.readInt();
        BitSet set = new BitSet();
        for (int i = 0; i < cardinality; ++i) {
            set.set(src.readInt());
        }
        return set;
    }

    private static void writeBitSet(Parcel dest, BitSet set) {
        int nextSetBit = -1;
        dest.writeInt(set.cardinality());
        while ((nextSetBit = set.nextSetBit(nextSetBit + 1)) != -1) {
            dest.writeInt(nextSetBit);
        }
    }

    @SystemApi
    public int getAuthType() {
        if (this.allowedKeyManagement.cardinality() > 1) {
            throw new IllegalStateException("More than one auth type set");
        }
        if (this.allowedKeyManagement.get(1)) {
            return 1;
        }
        if (this.allowedKeyManagement.get(4)) {
            return 4;
        }
        if (this.allowedKeyManagement.get(2)) {
            return 2;
        }
        if (this.allowedKeyManagement.get(3)) {
            return 3;
        }
        if (this.allowedKeyManagement.get(8)) {
            return 8;
        }
        if (this.allowedKeyManagement.get(9)) {
            return 9;
        }
        if (this.allowedKeyManagement.get(10)) {
            return 10;
        }
        if (this.allowedKeyManagement.get(13)) {
            return 13;
        }
        if (this.allowedKeyManagement.get(14)) {
            return 14;
        }
        return 0;
    }

    public String getKey() {
        if (this.mPasspointUniqueId != null) {
            return this.mPasspointUniqueId;
        }
        String key = this.getSsidAndSecurityTypeString();
        if (!this.shared) {
            key = key + "-" + UserHandle.getUserHandleForUid(this.creatorUid).getIdentifier();
        }
        return key;
    }

    public String getSsidAndSecurityTypeString() {
        String key = this.allowedKeyManagement.get(1) ? this.SSID + KeyMgmt.strings[1] : (this.allowedKeyManagement.get(2) || this.allowedKeyManagement.get(3) ? this.SSID + KeyMgmt.strings[2] : (this.wepTxKeyIndex >= 0 && this.wepTxKeyIndex < this.wepKeys.length && this.wepKeys[this.wepTxKeyIndex] != null ? this.SSID + "WEP" : (this.allowedKeyManagement.get(9) ? this.SSID + KeyMgmt.strings[9] : (this.allowedKeyManagement.get(8) ? this.SSID + KeyMgmt.strings[8] : (this.allowedKeyManagement.get(10) ? this.SSID + KeyMgmt.strings[10] : (this.allowedKeyManagement.get(13) ? this.SSID + KeyMgmt.strings[13] : (this.allowedKeyManagement.get(14) ? this.SSID + KeyMgmt.strings[14] : (this.allowedKeyManagement.get(5) ? this.SSID + KeyMgmt.strings[5] : this.SSID + KeyMgmt.strings[0]))))))));
        return key;
    }

    @SystemApi
    public IpConfiguration getIpConfiguration() {
        return new IpConfiguration(this.mIpConfiguration);
    }

    @SystemApi
    public void setIpConfiguration(IpConfiguration ipConfiguration) {
        if (ipConfiguration == null) {
            ipConfiguration = new IpConfiguration();
        }
        this.mIpConfiguration = ipConfiguration;
    }

    @UnsupportedAppUsage
    public StaticIpConfiguration getStaticIpConfiguration() {
        return this.mIpConfiguration.getStaticIpConfiguration();
    }

    @UnsupportedAppUsage
    public void setStaticIpConfiguration(StaticIpConfiguration staticIpConfiguration) {
        this.mIpConfiguration.setStaticIpConfiguration(staticIpConfiguration);
    }

    @UnsupportedAppUsage
    public IpConfiguration.IpAssignment getIpAssignment() {
        return this.mIpConfiguration.getIpAssignment();
    }

    @UnsupportedAppUsage
    public void setIpAssignment(IpConfiguration.IpAssignment ipAssignment) {
        this.mIpConfiguration.setIpAssignment(ipAssignment);
    }

    @UnsupportedAppUsage
    public IpConfiguration.ProxySettings getProxySettings() {
        return this.mIpConfiguration.getProxySettings();
    }

    @UnsupportedAppUsage
    public void setProxySettings(IpConfiguration.ProxySettings proxySettings) {
        this.mIpConfiguration.setProxySettings(proxySettings);
    }

    public ProxyInfo getHttpProxy() {
        if (this.mIpConfiguration.getProxySettings() == IpConfiguration.ProxySettings.NONE) {
            return null;
        }
        return new ProxyInfo(this.mIpConfiguration.getHttpProxy());
    }

    public void setHttpProxy(ProxyInfo httpProxy) {
        ProxyInfo httpProxyCopy;
        IpConfiguration.ProxySettings proxySettingCopy;
        if (httpProxy == null) {
            this.mIpConfiguration.setProxySettings(IpConfiguration.ProxySettings.NONE);
            this.mIpConfiguration.setHttpProxy(null);
            return;
        }
        if (!Uri.EMPTY.equals(httpProxy.getPacFileUrl())) {
            proxySettingCopy = IpConfiguration.ProxySettings.PAC;
            httpProxyCopy = ProxyInfo.buildPacProxy(httpProxy.getPacFileUrl(), httpProxy.getPort());
        } else {
            proxySettingCopy = IpConfiguration.ProxySettings.STATIC;
            httpProxyCopy = ProxyInfo.buildDirectProxy(httpProxy.getHost(), httpProxy.getPort(), Arrays.asList(httpProxy.getExclusionList()));
        }
        if (!httpProxyCopy.isValid()) {
            throw new IllegalArgumentException("Invalid ProxyInfo: " + httpProxyCopy.toString());
        }
        this.mIpConfiguration.setProxySettings(proxySettingCopy);
        this.mIpConfiguration.setHttpProxy(httpProxyCopy);
    }

    @UnsupportedAppUsage
    public void setProxy(IpConfiguration.ProxySettings settings, ProxyInfo proxy) {
        this.mIpConfiguration.setProxySettings(settings);
        this.mIpConfiguration.setHttpProxy(proxy);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public void setPasspointManagementObjectTree(String passpointManagementObjectTree) {
        this.mPasspointManagementObjectTree = passpointManagementObjectTree;
    }

    public String getMoTree() {
        return this.mPasspointManagementObjectTree;
    }

    public WifiConfiguration(WifiConfiguration source) {
        if (source != null) {
            this.networkId = source.networkId;
            this.status = source.status;
            this.SSID = source.SSID;
            this.BSSID = source.BSSID;
            this.FQDN = source.FQDN;
            this.roamingConsortiumIds = (long[])source.roamingConsortiumIds.clone();
            this.providerFriendlyName = source.providerFriendlyName;
            this.isHomeProviderNetwork = source.isHomeProviderNetwork;
            this.preSharedKey = source.preSharedKey;
            this.mNetworkSelectionStatus.copy(source.getNetworkSelectionStatus());
            this.apBand = source.apBand;
            this.apChannel = source.apChannel;
            this.wepKeys = new String[4];
            for (int i = 0; i < this.wepKeys.length; ++i) {
                this.wepKeys[i] = source.wepKeys[i];
            }
            this.wepTxKeyIndex = source.wepTxKeyIndex;
            this.priority = source.priority;
            this.hiddenSSID = source.hiddenSSID;
            this.allowedKeyManagement = (BitSet)source.allowedKeyManagement.clone();
            this.allowedProtocols = (BitSet)source.allowedProtocols.clone();
            this.allowedAuthAlgorithms = (BitSet)source.allowedAuthAlgorithms.clone();
            this.allowedPairwiseCiphers = (BitSet)source.allowedPairwiseCiphers.clone();
            this.allowedGroupCiphers = (BitSet)source.allowedGroupCiphers.clone();
            this.allowedGroupManagementCiphers = (BitSet)source.allowedGroupManagementCiphers.clone();
            this.allowedSuiteBCiphers = (BitSet)source.allowedSuiteBCiphers.clone();
            this.enterpriseConfig = new WifiEnterpriseConfig(source.enterpriseConfig);
            this.defaultGwMacAddress = source.defaultGwMacAddress;
            this.mIpConfiguration = new IpConfiguration(source.mIpConfiguration);
            if (source.linkedConfigurations != null && source.linkedConfigurations.size() > 0) {
                this.linkedConfigurations = new HashMap();
                this.linkedConfigurations.putAll(source.linkedConfigurations);
            }
            this.validatedInternetAccess = source.validatedInternetAccess;
            this.isLegacyPasspointConfig = source.isLegacyPasspointConfig;
            this.ephemeral = source.ephemeral;
            this.osu = source.osu;
            this.trusted = source.trusted;
            this.fromWifiNetworkSuggestion = source.fromWifiNetworkSuggestion;
            this.fromWifiNetworkSpecifier = source.fromWifiNetworkSpecifier;
            this.meteredHint = source.meteredHint;
            this.meteredOverride = source.meteredOverride;
            this.useExternalScores = source.useExternalScores;
            this.lastConnectUid = source.lastConnectUid;
            this.lastUpdateUid = source.lastUpdateUid;
            this.creatorUid = source.creatorUid;
            this.creatorName = source.creatorName;
            this.lastUpdateName = source.lastUpdateName;
            this.peerWifiConfiguration = source.peerWifiConfiguration;
            this.lastConnected = source.lastConnected;
            this.lastDisconnected = source.lastDisconnected;
            this.numScorerOverride = source.numScorerOverride;
            this.numScorerOverrideAndSwitchedNetwork = source.numScorerOverrideAndSwitchedNetwork;
            this.numAssociation = source.numAssociation;
            this.allowAutojoin = source.allowAutojoin;
            this.numNoInternetAccessReports = source.numNoInternetAccessReports;
            this.noInternetAccessExpected = source.noInternetAccessExpected;
            this.shared = source.shared;
            this.recentFailure.setAssociationStatus(source.recentFailure.getAssociationStatus());
            this.mRandomizedMacAddress = source.mRandomizedMacAddress;
            this.macRandomizationSetting = source.macRandomizationSetting;
            this.randomizedMacExpirationTimeMs = source.randomizedMacExpirationTimeMs;
            this.requirePmf = source.requirePmf;
            this.updateIdentifier = source.updateIdentifier;
            this.carrierId = source.carrierId;
            this.mPasspointUniqueId = source.mPasspointUniqueId;
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.networkId);
        dest.writeInt(this.status);
        this.mNetworkSelectionStatus.writeToParcel(dest);
        dest.writeString(this.SSID);
        dest.writeString(this.BSSID);
        dest.writeInt(this.apBand);
        dest.writeInt(this.apChannel);
        dest.writeString(this.FQDN);
        dest.writeString(this.providerFriendlyName);
        dest.writeInt(this.isHomeProviderNetwork ? 1 : 0);
        dest.writeInt(this.roamingConsortiumIds.length);
        for (long roamingConsortiumId : this.roamingConsortiumIds) {
            dest.writeLong(roamingConsortiumId);
        }
        dest.writeString(this.preSharedKey);
        for (String wepKey : this.wepKeys) {
            dest.writeString(wepKey);
        }
        dest.writeInt(this.wepTxKeyIndex);
        dest.writeInt(this.priority);
        dest.writeInt(this.hiddenSSID ? 1 : 0);
        dest.writeInt(this.requirePmf ? 1 : 0);
        dest.writeString(this.updateIdentifier);
        WifiConfiguration.writeBitSet(dest, this.allowedKeyManagement);
        WifiConfiguration.writeBitSet(dest, this.allowedProtocols);
        WifiConfiguration.writeBitSet(dest, this.allowedAuthAlgorithms);
        WifiConfiguration.writeBitSet(dest, this.allowedPairwiseCiphers);
        WifiConfiguration.writeBitSet(dest, this.allowedGroupCiphers);
        WifiConfiguration.writeBitSet(dest, this.allowedGroupManagementCiphers);
        WifiConfiguration.writeBitSet(dest, this.allowedSuiteBCiphers);
        dest.writeParcelable(this.enterpriseConfig, flags);
        dest.writeParcelable(this.mIpConfiguration, flags);
        dest.writeString(this.dhcpServer);
        dest.writeString(this.defaultGwMacAddress);
        dest.writeInt(this.validatedInternetAccess ? 1 : 0);
        dest.writeInt(this.isLegacyPasspointConfig ? 1 : 0);
        dest.writeInt(this.ephemeral ? 1 : 0);
        dest.writeInt(this.trusted ? 1 : 0);
        dest.writeInt(this.fromWifiNetworkSuggestion ? 1 : 0);
        dest.writeInt(this.fromWifiNetworkSpecifier ? 1 : 0);
        dest.writeInt(this.meteredHint ? 1 : 0);
        dest.writeInt(this.meteredOverride);
        dest.writeInt(this.useExternalScores ? 1 : 0);
        dest.writeInt(this.creatorUid);
        dest.writeInt(this.lastConnectUid);
        dest.writeInt(this.lastUpdateUid);
        dest.writeString(this.creatorName);
        dest.writeString(this.lastUpdateName);
        dest.writeInt(this.numScorerOverride);
        dest.writeInt(this.numScorerOverrideAndSwitchedNetwork);
        dest.writeInt(this.numAssociation);
        dest.writeBoolean(this.allowAutojoin);
        dest.writeInt(this.numNoInternetAccessReports);
        dest.writeInt(this.noInternetAccessExpected ? 1 : 0);
        dest.writeInt(this.shared ? 1 : 0);
        dest.writeString(this.mPasspointManagementObjectTree);
        dest.writeInt(this.recentFailure.getAssociationStatus());
        dest.writeParcelable(this.mRandomizedMacAddress, flags);
        dest.writeInt(this.macRandomizationSetting);
        dest.writeInt(this.osu ? 1 : 0);
        dest.writeLong(this.randomizedMacExpirationTimeMs);
        dest.writeInt(this.carrierId);
        dest.writeString(this.mPasspointUniqueId);
    }

    public void setPasspointUniqueId(String uniqueId) {
        this.mPasspointUniqueId = uniqueId;
    }

    public String getPasspointUniqueId() {
        return this.mPasspointUniqueId;
    }

    public boolean needsPreSharedKey() {
        return this.allowedKeyManagement.get(1) || this.allowedKeyManagement.get(8) || this.allowedKeyManagement.get(13);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecentFailureReason {
    }

    public static class RecentFailure {
        private int mAssociationStatus = 0;

        private RecentFailure() {
        }

        public void setAssociationStatus(int status) {
            this.mAssociationStatus = status;
        }

        public void clear() {
            this.mAssociationStatus = 0;
        }

        public int getAssociationStatus() {
            return this.mAssociationStatus;
        }
    }

    @SystemApi
    public static class NetworkSelectionStatus {
        public static final int NETWORK_SELECTION_ENABLED = 0;
        public static final int NETWORK_SELECTION_TEMPORARY_DISABLED = 1;
        public static final int NETWORK_SELECTION_PERMANENTLY_DISABLED = 2;
        public static final int NETWORK_SELECTION_STATUS_MAX = 3;
        public static final String[] QUALITY_NETWORK_SELECTION_STATUS = new String[]{"NETWORK_SELECTION_ENABLED", "NETWORK_SELECTION_TEMPORARY_DISABLED", "NETWORK_SELECTION_PERMANENTLY_DISABLED"};
        public static final int DISABLED_NONE = 0;
        public static final int NETWORK_SELECTION_DISABLED_STARTING_INDEX = 1;
        public static final int TEMPORARILY_DISABLED_STARTING_INDEX = 1;
        public static final int DISABLED_ASSOCIATION_REJECTION = 1;
        public static final int DISABLED_AUTHENTICATION_FAILURE = 2;
        public static final int DISABLED_DHCP_FAILURE = 3;
        public static final int DISABLED_NO_INTERNET_TEMPORARY = 4;
        public static final int PERMANENTLY_DISABLED_STARTING_INDEX = 5;
        public static final int DISABLED_AUTHENTICATION_NO_CREDENTIALS = 5;
        public static final int DISABLED_NO_INTERNET_PERMANENT = 6;
        public static final int DISABLED_BY_WIFI_MANAGER = 7;
        public static final int DISABLED_BY_WRONG_PASSWORD = 8;
        public static final int DISABLED_AUTHENTICATION_NO_SUBSCRIPTION = 9;
        public static final int NETWORK_SELECTION_DISABLED_MAX = 10;
        public static final SparseArray<DisableReasonInfo> DISABLE_REASON_INFOS = NetworkSelectionStatus.buildDisableReasonInfos();
        public static final long INVALID_NETWORK_SELECTION_DISABLE_TIMESTAMP = -1L;
        private static final int CONNECT_CHOICE_EXISTS = 1;
        private static final int CONNECT_CHOICE_NOT_EXISTS = -1;
        private int mStatus;
        private int mNetworkSelectionDisableReason;
        private long mTemporarilyDisabledTimestamp = -1L;
        private int[] mNetworkSeclectionDisableCounter = new int[10];
        private String mConnectChoice;
        private ScanResult mCandidate;
        private int mCandidateScore;
        private boolean mSeenInLastQualifiedNetworkSelection;
        private boolean mHasEverConnected = false;
        private String mNetworkSelectionBSSID;

        public static int getMaxNetworkSelectionDisableReason() {
            return 9;
        }

        private static SparseArray<DisableReasonInfo> buildDisableReasonInfos() {
            SparseArray<DisableReasonInfo> reasons = new SparseArray<DisableReasonInfo>();
            reasons.append(0, new DisableReasonInfo("NETWORK_SELECTION_ENABLE", -1, Integer.MAX_VALUE));
            reasons.append(1, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_ASSOCIATION_REJECTION ", 5, 300000));
            reasons.append(2, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_AUTHENTICATION_FAILURE", 5, 300000));
            reasons.append(3, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_DHCP_FAILURE", 5, 300000));
            reasons.append(4, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_NO_INTERNET_TEMPORARY", 1, 600000));
            reasons.append(5, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_AUTHENTICATION_NO_CREDENTIALS", 1, Integer.MAX_VALUE));
            reasons.append(6, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_NO_INTERNET_PERMANENT", 1, Integer.MAX_VALUE));
            reasons.append(7, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_BY_WIFI_MANAGER", 1, Integer.MAX_VALUE));
            reasons.append(8, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_BY_WRONG_PASSWORD", 1, Integer.MAX_VALUE));
            reasons.append(9, new DisableReasonInfo("NETWORK_SELECTION_DISABLED_AUTHENTICATION_NO_SUBSCRIPTION", 1, Integer.MAX_VALUE));
            return reasons;
        }

        public static int getDisableReasonByString(String reasonString) {
            for (int i = 0; i < DISABLE_REASON_INFOS.size(); ++i) {
                int key = DISABLE_REASON_INFOS.keyAt(i);
                DisableReasonInfo value = DISABLE_REASON_INFOS.valueAt(i);
                if (value == null || !TextUtils.equals(reasonString, value.mReasonStr)) continue;
                return key;
            }
            Log.e(WifiConfiguration.TAG, "Unrecognized network disable reason: " + reasonString);
            return -1;
        }

        public void setSeenInLastQualifiedNetworkSelection(boolean seen) {
            this.mSeenInLastQualifiedNetworkSelection = seen;
        }

        public boolean getSeenInLastQualifiedNetworkSelection() {
            return this.mSeenInLastQualifiedNetworkSelection;
        }

        public void setCandidate(ScanResult scanCandidate) {
            this.mCandidate = scanCandidate;
        }

        public ScanResult getCandidate() {
            return this.mCandidate;
        }

        public void setCandidateScore(int score) {
            this.mCandidateScore = score;
        }

        public int getCandidateScore() {
            return this.mCandidateScore;
        }

        public String getConnectChoice() {
            return this.mConnectChoice;
        }

        public void setConnectChoice(String newConnectChoice) {
            this.mConnectChoice = newConnectChoice;
        }

        public String getNetworkStatusString() {
            return QUALITY_NETWORK_SELECTION_STATUS[this.mStatus];
        }

        public void setHasEverConnected(boolean value) {
            this.mHasEverConnected = value;
        }

        public boolean hasEverConnected() {
            return this.mHasEverConnected;
        }

        public static String getNetworkSelectionDisableReasonString(int reason) {
            DisableReasonInfo info = DISABLE_REASON_INFOS.get(reason);
            if (info == null) {
                return null;
            }
            return info.mReasonStr;
        }

        public String getNetworkSelectionDisableReasonString() {
            return NetworkSelectionStatus.getNetworkSelectionDisableReasonString(this.mNetworkSelectionDisableReason);
        }

        public int getNetworkSelectionStatus() {
            return this.mStatus;
        }

        public boolean isNetworkEnabled() {
            return this.mStatus == 0;
        }

        public boolean isNetworkTemporaryDisabled() {
            return this.mStatus == 1;
        }

        public boolean isNetworkPermanentlyDisabled() {
            return this.mStatus == 2;
        }

        public void setNetworkSelectionStatus(int status) {
            if (status >= 0 && status < 3) {
                this.mStatus = status;
            }
        }

        public int getNetworkSelectionDisableReason() {
            return this.mNetworkSelectionDisableReason;
        }

        public void setNetworkSelectionDisableReason(int reason) {
            if (reason < 0 || reason >= 10) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            this.mNetworkSelectionDisableReason = reason;
        }

        public void setDisableTime(long timeStamp) {
            this.mTemporarilyDisabledTimestamp = timeStamp;
        }

        public long getDisableTime() {
            return this.mTemporarilyDisabledTimestamp;
        }

        public int getDisableReasonCounter(int reason) {
            if (reason >= 0 && reason < 10) {
                return this.mNetworkSeclectionDisableCounter[reason];
            }
            throw new IllegalArgumentException("Illegal reason value: " + reason);
        }

        public void setDisableReasonCounter(int reason, int value) {
            if (reason < 0 || reason >= 10) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            this.mNetworkSeclectionDisableCounter[reason] = value;
        }

        public void incrementDisableReasonCounter(int reason) {
            if (reason < 0 || reason >= 10) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            int n = reason;
            this.mNetworkSeclectionDisableCounter[n] = this.mNetworkSeclectionDisableCounter[n] + 1;
        }

        public void clearDisableReasonCounter(int reason) {
            if (reason < 0 || reason >= 10) {
                throw new IllegalArgumentException("Illegal reason value: " + reason);
            }
            this.mNetworkSeclectionDisableCounter[reason] = 0;
        }

        public void clearDisableReasonCounter() {
            Arrays.fill(this.mNetworkSeclectionDisableCounter, 0);
        }

        public String getNetworkSelectionBSSID() {
            return this.mNetworkSelectionBSSID;
        }

        public void setNetworkSelectionBSSID(String bssid) {
            this.mNetworkSelectionBSSID = bssid;
        }

        public void copy(NetworkSelectionStatus source) {
            this.mStatus = source.mStatus;
            this.mNetworkSelectionDisableReason = source.mNetworkSelectionDisableReason;
            for (int index = 0; index < 10; ++index) {
                this.mNetworkSeclectionDisableCounter[index] = source.mNetworkSeclectionDisableCounter[index];
            }
            this.mTemporarilyDisabledTimestamp = source.mTemporarilyDisabledTimestamp;
            this.mNetworkSelectionBSSID = source.mNetworkSelectionBSSID;
            this.setSeenInLastQualifiedNetworkSelection(source.getSeenInLastQualifiedNetworkSelection());
            this.setCandidate(source.getCandidate());
            this.setCandidateScore(source.getCandidateScore());
            this.setConnectChoice(source.getConnectChoice());
            this.setHasEverConnected(source.hasEverConnected());
        }

        public void writeToParcel(Parcel dest) {
            dest.writeInt(this.getNetworkSelectionStatus());
            dest.writeInt(this.getNetworkSelectionDisableReason());
            for (int index = 0; index < 10; ++index) {
                dest.writeInt(this.getDisableReasonCounter(index));
            }
            dest.writeLong(this.getDisableTime());
            dest.writeString(this.getNetworkSelectionBSSID());
            if (this.getConnectChoice() != null) {
                dest.writeInt(1);
                dest.writeString(this.getConnectChoice());
            } else {
                dest.writeInt(-1);
            }
            dest.writeInt(this.hasEverConnected() ? 1 : 0);
        }

        public void readFromParcel(Parcel in) {
            this.setNetworkSelectionStatus(in.readInt());
            this.setNetworkSelectionDisableReason(in.readInt());
            for (int index = 0; index < 10; ++index) {
                this.setDisableReasonCounter(index, in.readInt());
            }
            this.setDisableTime(in.readLong());
            this.setNetworkSelectionBSSID(in.readString());
            if (in.readInt() == 1) {
                this.setConnectChoice(in.readString());
            } else {
                this.setConnectChoice(null);
            }
            this.setHasEverConnected(in.readInt() != 0);
        }

        @VisibleForTesting
        public static class Builder {
            private final NetworkSelectionStatus mNetworkSelectionStatus = new NetworkSelectionStatus();

            public Builder setNetworkSelectionStatus(int status) {
                this.mNetworkSelectionStatus.setNetworkSelectionStatus(status);
                return this;
            }

            public Builder setNetworkSelectionDisableReason(int reason) {
                this.mNetworkSelectionStatus.setNetworkSelectionDisableReason(reason);
                return this;
            }

            public NetworkSelectionStatus build() {
                NetworkSelectionStatus status = new NetworkSelectionStatus();
                status.copy(this.mNetworkSelectionStatus);
                return status;
            }
        }

        public static class DisableReasonInfo {
            public final String mReasonStr;
            public final int mDisableThreshold;
            public final int mDisableTimeoutMillis;

            public DisableReasonInfo(String reasonStr, int disableThreshold, int disableTimeoutMillis) {
                this.mReasonStr = reasonStr;
                this.mDisableThreshold = disableThreshold;
                this.mDisableTimeoutMillis = disableTimeoutMillis;
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NetworkSelectionDisableReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface NetworkEnabledStatus {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MacRandomizationSetting {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MeteredOverride {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ApBand {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SecurityType {
    }

    public static class Status {
        public static final int CURRENT = 0;
        public static final int DISABLED = 1;
        public static final int ENABLED = 2;
        public static final String[] strings = new String[]{"current", "disabled", "enabled"};

        private Status() {
        }
    }

    public static class SuiteBCipher {
        public static final int ECDHE_ECDSA = 0;
        public static final int ECDHE_RSA = 1;
        private static final String varName = "SuiteB";
        private static final String[] strings = new String[]{"ECDHE_ECDSA", "ECDHE_RSA"};

        private SuiteBCipher() {
        }
    }

    public static class GroupMgmtCipher {
        public static final int BIP_CMAC_256 = 0;
        public static final int BIP_GMAC_128 = 1;
        public static final int BIP_GMAC_256 = 2;
        private static final String varName = "groupMgmt";
        private static final String[] strings = new String[]{"BIP_CMAC_256", "BIP_GMAC_128", "BIP_GMAC_256"};

        private GroupMgmtCipher() {
        }
    }

    public static class GroupCipher {
        @Deprecated
        public static final int WEP40 = 0;
        @Deprecated
        public static final int WEP104 = 1;
        public static final int TKIP = 2;
        public static final int CCMP = 3;
        public static final int GTK_NOT_USED = 4;
        public static final int GCMP_256 = 5;
        public static final int SMS4 = 6;
        public static final String varName = "group";
        public static final String[] strings = new String[]{"WEP40", "WEP104", "TKIP", "CCMP", "GTK_NOT_USED", "GCMP_256", "SMS4"};

        private GroupCipher() {
        }
    }

    public static class PairwiseCipher {
        public static final int NONE = 0;
        @Deprecated
        public static final int TKIP = 1;
        public static final int CCMP = 2;
        public static final int GCMP_256 = 3;
        public static final int SMS4 = 4;
        public static final String varName = "pairwise";
        public static final String[] strings = new String[]{"NONE", "TKIP", "CCMP", "GCMP_256", "SMS4"};

        private PairwiseCipher() {
        }
    }

    public static class AuthAlgorithm {
        public static final int OPEN = 0;
        @Deprecated
        public static final int SHARED = 1;
        public static final int LEAP = 2;
        public static final int SAE = 3;
        public static final String varName = "auth_alg";
        public static final String[] strings = new String[]{"OPEN", "SHARED", "LEAP", "SAE"};

        private AuthAlgorithm() {
        }
    }

    public static class Protocol {
        @Deprecated
        public static final int WPA = 0;
        public static final int RSN = 1;
        public static final int OSEN = 2;
        public static final int WAPI = 3;
        public static final String varName = "proto";
        public static final String[] strings = new String[]{"WPA", "RSN", "OSEN", "WAPI"};

        private Protocol() {
        }
    }

    public static class KeyMgmt {
        public static final int NONE = 0;
        public static final int WPA_PSK = 1;
        public static final int WPA_EAP = 2;
        public static final int IEEE8021X = 3;
        @SystemApi
        public static final int WPA2_PSK = 4;
        public static final int OSEN = 5;
        public static final int FT_PSK = 6;
        public static final int FT_EAP = 7;
        public static final int SAE = 8;
        public static final int OWE = 9;
        public static final int SUITE_B_192 = 10;
        public static final int WPA_PSK_SHA256 = 11;
        public static final int WPA_EAP_SHA256 = 12;
        @SystemApi
        public static final int WAPI_PSK = 13;
        @SystemApi
        public static final int WAPI_CERT = 14;
        public static final int FILS_SHA256 = 15;
        public static final int FILS_SHA384 = 16;
        public static final String varName = "key_mgmt";
        public static final String[] strings = new String[]{"NONE", "WPA_PSK", "WPA_EAP", "IEEE8021X", "WPA2_PSK", "OSEN", "FT_PSK", "FT_EAP", "SAE", "OWE", "SUITE_B_192", "WPA_PSK_SHA256", "WPA_EAP_SHA256", "WAPI_PSK", "WAPI_CERT", "FILS_SHA256", "FILS_SHA384"};

        private KeyMgmt() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface KeyMgmtScheme {
        }
    }
}

