/*
 * Decompiled with CFR 0.152.
 */
package android.net.util;

import android.net.MacAddress;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;

public class MacAddressUtils {
    private static final long VALID_LONG_MASK = 0xFFFFFFFFFFFFL;
    private static final long LOCALLY_ASSIGNED_MASK = MacAddressUtils.longAddrFromByteAddr(MacAddress.fromString("2:0:0:0:0:0").toByteArray());
    private static final long MULTICAST_MASK = MacAddressUtils.longAddrFromByteAddr(MacAddress.fromString("1:0:0:0:0:0").toByteArray());
    private static final long OUI_MASK = MacAddressUtils.longAddrFromByteAddr(MacAddress.fromString("ff:ff:ff:0:0:0").toByteArray());
    private static final long NIC_MASK = MacAddressUtils.longAddrFromByteAddr(MacAddress.fromString("0:0:0:ff:ff:ff").toByteArray());
    private static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    private static final int ETHER_ADDR_LEN = 6;

    public static boolean isMulticastAddress(MacAddress address) {
        return (MacAddressUtils.longAddrFromByteAddr(address.toByteArray()) & MULTICAST_MASK) != 0L;
    }

    public static MacAddress createRandomUnicastAddress() {
        return MacAddressUtils.createRandomUnicastAddress(null, new SecureRandom());
    }

    public static MacAddress createRandomUnicastAddress(MacAddress base, Random r) {
        long addr = base == null ? r.nextLong() & 0xFFFFFFFFFFFFL : MacAddressUtils.longAddrFromByteAddr(base.toByteArray()) & OUI_MASK | NIC_MASK & r.nextLong();
        addr |= LOCALLY_ASSIGNED_MASK;
        MacAddress mac = MacAddress.fromBytes(MacAddressUtils.byteAddrFromLongAddr(addr &= MULTICAST_MASK ^ 0xFFFFFFFFFFFFFFFFL));
        if (mac.equals(DEFAULT_MAC_ADDRESS)) {
            return MacAddressUtils.createRandomUnicastAddress(base, r);
        }
        return mac;
    }

    public static long longAddrFromByteAddr(byte[] addr) {
        Objects.requireNonNull(addr);
        if (!MacAddressUtils.isMacAddress(addr)) {
            throw new IllegalArgumentException(Arrays.toString(addr) + " was not a valid MAC address");
        }
        long longAddr = 0L;
        for (byte b : addr) {
            int uint8Byte = b & 0xFF;
            longAddr = (longAddr << 8) + (long)uint8Byte;
        }
        return longAddr;
    }

    public static byte[] byteAddrFromLongAddr(long addr) {
        byte[] bytes = new byte[6];
        int index = 6;
        while (index-- > 0) {
            bytes[index] = (byte)addr;
            addr >>= 8;
        }
        return bytes;
    }

    public static boolean isMacAddress(byte[] addr) {
        return addr != null && addr.length == 6;
    }
}

