/*
 * Decompiled with CFR 0.152.
 */
package android.net.lowpan;

import android.net.lowpan.ILowpanInterface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ILowpanManagerListener
extends IInterface {
    public void onInterfaceAdded(ILowpanInterface var1) throws RemoteException;

    public void onInterfaceRemoved(ILowpanInterface var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILowpanManagerListener {
        private static final String DESCRIPTOR = "android.net.lowpan.ILowpanManagerListener";
        static final int TRANSACTION_onInterfaceAdded = 1;
        static final int TRANSACTION_onInterfaceRemoved = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILowpanManagerListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILowpanManagerListener) {
                return (ILowpanManagerListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onInterfaceAdded";
                }
                case 2: {
                    return "onInterfaceRemoved";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ILowpanInterface _arg0 = ILowpanInterface.Stub.asInterface(data.readStrongBinder());
                    this.onInterfaceAdded(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ILowpanInterface _arg0 = ILowpanInterface.Stub.asInterface(data.readStrongBinder());
                    this.onInterfaceRemoved(_arg0);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ILowpanManagerListener impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ILowpanManagerListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ILowpanManagerListener {
            private IBinder mRemote;
            public static ILowpanManagerListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterfaceAdded(ILowpanInterface lowpanInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lowpanInterface != null ? lowpanInterface.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onInterfaceAdded(lowpanInterface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onInterfaceRemoved(ILowpanInterface lowpanInterface) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lowpanInterface != null ? lowpanInterface.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onInterfaceRemoved(lowpanInterface);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILowpanManagerListener {
        @Override
        public void onInterfaceAdded(ILowpanInterface lowpanInterface) throws RemoteException {
        }

        @Override
        public void onInterfaceRemoved(ILowpanInterface lowpanInterface) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

