/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;

@SystemApi
public class NetworkProvider {
    public static final int ID_NONE = -1;
    public static final int ID_VPN = -2;
    public static final int FIRST_PROVIDER_ID = 1;
    public static final int CMD_REQUEST_NETWORK = 1;
    public static final int CMD_CANCEL_REQUEST = 2;
    private final Messenger mMessenger;
    private final String mName;
    private final ConnectivityManager mCm;
    private int mProviderId = -1;

    @SystemApi
    public NetworkProvider(Context context, Looper looper, String name) {
        this.mCm = ConnectivityManager.from(context);
        Handler handler = new Handler(looper){

            @Override
            public void handleMessage(Message m) {
                switch (m.what) {
                    case 1: {
                        NetworkProvider.this.onNetworkRequested((NetworkRequest)m.obj, m.arg1, m.arg2);
                        break;
                    }
                    case 2: {
                        NetworkProvider.this.onNetworkRequestWithdrawn((NetworkRequest)m.obj);
                        break;
                    }
                    default: {
                        Log.e(NetworkProvider.this.mName, "Unhandled message: " + m.what);
                    }
                }
            }
        };
        this.mMessenger = new Messenger(handler);
        this.mName = name;
    }

    public Messenger getMessenger() {
        return this.mMessenger;
    }

    public String getName() {
        return this.mName;
    }

    public int getProviderId() {
        return this.mProviderId;
    }

    public void setProviderId(int providerId) {
        this.mProviderId = providerId;
    }

    @SystemApi
    public void onNetworkRequested(NetworkRequest request, int score, int providerId) {
    }

    @SystemApi
    public void onNetworkRequestWithdrawn(NetworkRequest request) {
    }

    @SystemApi
    public void declareNetworkRequestUnfulfillable(NetworkRequest request) {
        this.mCm.declareNetworkRequestUnfulfillable(request);
    }
}

