/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.net.CaptivePortalData;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.Uri;
import android.net.util.LinkPropertiesUtils;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public class LinkProperties
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private String mIfaceName;
    private final ArrayList<LinkAddress> mLinkAddresses = new ArrayList();
    private final ArrayList<InetAddress> mDnses = new ArrayList();
    private final ArrayList<InetAddress> mPcscfs = new ArrayList();
    private final ArrayList<InetAddress> mValidatedPrivateDnses = new ArrayList();
    private boolean mUsePrivateDns;
    private String mPrivateDnsServerName;
    private String mDomains;
    private ArrayList<RouteInfo> mRoutes = new ArrayList();
    private Inet4Address mDhcpServerAddress;
    private ProxyInfo mHttpProxy;
    private int mMtu;
    private String mTcpBufferSizes;
    private IpPrefix mNat64Prefix;
    private boolean mWakeOnLanSupported;
    private Uri mCaptivePortalApiUrl;
    private CaptivePortalData mCaptivePortalData;
    private final transient boolean mParcelSensitiveFields;
    private static final int MIN_MTU = 68;
    static final int MIN_MTU_V6 = 1280;
    private static final int MAX_MTU = 10000;
    private static final int INET6_ADDR_LENGTH = 16;
    private Hashtable<String, LinkProperties> mStackedLinks = new Hashtable();
    public static final Parcelable.Creator<LinkProperties> CREATOR = new Parcelable.Creator<LinkProperties>(){

        @Override
        public LinkProperties createFromParcel(Parcel in) {
            int i;
            LinkProperties netProp = new LinkProperties();
            String iface = in.readString();
            if (iface != null) {
                netProp.setInterfaceName(iface);
            }
            int addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                netProp.addLinkAddress((LinkAddress)in.readParcelable(null));
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addDnsServer(LinkProperties.readAddress(in));
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addValidatedPrivateDnsServer(LinkProperties.readAddress(in));
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            netProp.setUsePrivateDns(in.readBoolean());
            netProp.setPrivateDnsServerName(in.readString());
            addressCount = in.readInt();
            for (i = 0; i < addressCount; ++i) {
                try {
                    netProp.addPcscfServer(LinkProperties.readAddress(in));
                    continue;
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            netProp.setDomains(in.readString());
            try {
                netProp.setDhcpServerAddress((Inet4Address)InetAddress.getByAddress(in.createByteArray()));
            }
            catch (UnknownHostException i2) {
                // empty catch block
            }
            netProp.setMtu(in.readInt());
            netProp.setTcpBufferSizes(in.readString());
            addressCount = in.readInt();
            for (int i3 = 0; i3 < addressCount; ++i3) {
                netProp.addRoute((RouteInfo)in.readParcelable(null));
            }
            if (in.readByte() == 1) {
                netProp.setHttpProxy((ProxyInfo)in.readParcelable(null));
            }
            netProp.setNat64Prefix((IpPrefix)in.readParcelable(null));
            ArrayList stackedLinks = new ArrayList();
            in.readList(stackedLinks, LinkProperties.class.getClassLoader());
            for (LinkProperties stackedLink : stackedLinks) {
                netProp.addStackedLink(stackedLink);
            }
            netProp.setWakeOnLanSupported(in.readBoolean());
            netProp.setCaptivePortalApiUrl((Uri)in.readParcelable(null));
            netProp.setCaptivePortalData((CaptivePortalData)in.readParcelable(null));
            return netProp;
        }

        public LinkProperties[] newArray(int size) {
            return new LinkProperties[size];
        }
    };

    @UnsupportedAppUsage
    public static ProvisioningChange compareProvisioning(LinkProperties before, LinkProperties after) {
        if (before.isProvisioned() && after.isProvisioned()) {
            if (before.isIpv4Provisioned() && !after.isIpv4Provisioned() || before.isIpv6Provisioned() && !after.isIpv6Provisioned()) {
                return ProvisioningChange.LOST_PROVISIONING;
            }
            return ProvisioningChange.STILL_PROVISIONED;
        }
        if (before.isProvisioned() && !after.isProvisioned()) {
            return ProvisioningChange.LOST_PROVISIONING;
        }
        if (!before.isProvisioned() && after.isProvisioned()) {
            return ProvisioningChange.GAINED_PROVISIONING;
        }
        return ProvisioningChange.STILL_NOT_PROVISIONED;
    }

    public LinkProperties() {
        this.mParcelSensitiveFields = false;
    }

    @SystemApi
    public LinkProperties(LinkProperties source) {
        this(source, false);
    }

    @SystemApi
    public LinkProperties(LinkProperties source, boolean parcelSensitiveFields) {
        this.mParcelSensitiveFields = parcelSensitiveFields;
        if (source == null) {
            return;
        }
        this.mIfaceName = source.mIfaceName;
        this.mLinkAddresses.addAll(source.mLinkAddresses);
        this.mDnses.addAll(source.mDnses);
        this.mValidatedPrivateDnses.addAll(source.mValidatedPrivateDnses);
        this.mUsePrivateDns = source.mUsePrivateDns;
        this.mPrivateDnsServerName = source.mPrivateDnsServerName;
        this.mPcscfs.addAll(source.mPcscfs);
        this.mDomains = source.mDomains;
        this.mRoutes.addAll(source.mRoutes);
        this.mHttpProxy = source.mHttpProxy == null ? null : new ProxyInfo(source.mHttpProxy);
        for (LinkProperties l : source.mStackedLinks.values()) {
            this.addStackedLink(l);
        }
        this.setMtu(source.mMtu);
        this.setDhcpServerAddress(source.getDhcpServerAddress());
        this.mTcpBufferSizes = source.mTcpBufferSizes;
        this.mNat64Prefix = source.mNat64Prefix;
        this.mWakeOnLanSupported = source.mWakeOnLanSupported;
        this.mCaptivePortalApiUrl = source.mCaptivePortalApiUrl;
        this.mCaptivePortalData = source.mCaptivePortalData;
    }

    public void setInterfaceName(String iface) {
        this.mIfaceName = iface;
        ArrayList<RouteInfo> newRoutes = new ArrayList<RouteInfo>(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            newRoutes.add(this.routeWithInterface(route));
        }
        this.mRoutes = newRoutes;
    }

    public String getInterfaceName() {
        return this.mIfaceName;
    }

    @SystemApi
    public List<String> getAllInterfaceNames() {
        ArrayList<String> interfaceNames = new ArrayList<String>(this.mStackedLinks.size() + 1);
        if (this.mIfaceName != null) {
            interfaceNames.add(this.mIfaceName);
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            interfaceNames.addAll(stacked.getAllInterfaceNames());
        }
        return interfaceNames;
    }

    @SystemApi
    public List<InetAddress> getAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        return Collections.unmodifiableList(addresses);
    }

    @UnsupportedAppUsage
    public List<InetAddress> getAllAddresses() {
        ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            addresses.add(linkAddress.getAddress());
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllAddresses());
        }
        return addresses;
    }

    private int findLinkAddressIndex(LinkAddress address) {
        for (int i = 0; i < this.mLinkAddresses.size(); ++i) {
            if (!this.mLinkAddresses.get(i).isSameAddressAs(address)) continue;
            return i;
        }
        return -1;
    }

    @SystemApi
    public boolean addLinkAddress(LinkAddress address) {
        if (address == null) {
            return false;
        }
        int i = this.findLinkAddressIndex(address);
        if (i < 0) {
            this.mLinkAddresses.add(address);
            return true;
        }
        if (this.mLinkAddresses.get(i).equals(address)) {
            return false;
        }
        this.mLinkAddresses.set(i, address);
        return true;
    }

    @SystemApi
    public boolean removeLinkAddress(LinkAddress toRemove) {
        int i = this.findLinkAddressIndex(toRemove);
        if (i >= 0) {
            this.mLinkAddresses.remove(i);
            return true;
        }
        return false;
    }

    public List<LinkAddress> getLinkAddresses() {
        return Collections.unmodifiableList(this.mLinkAddresses);
    }

    @SystemApi
    public List<LinkAddress> getAllLinkAddresses() {
        ArrayList<LinkAddress> addresses = new ArrayList<LinkAddress>(this.mLinkAddresses);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            addresses.addAll(stacked.getAllLinkAddresses());
        }
        return addresses;
    }

    public void setLinkAddresses(Collection<LinkAddress> addresses) {
        this.mLinkAddresses.clear();
        for (LinkAddress address : addresses) {
            this.addLinkAddress(address);
        }
    }

    @SystemApi
    public boolean addDnsServer(InetAddress dnsServer) {
        if (dnsServer != null && !this.mDnses.contains(dnsServer)) {
            this.mDnses.add(dnsServer);
            return true;
        }
        return false;
    }

    @SystemApi
    public boolean removeDnsServer(InetAddress dnsServer) {
        return this.mDnses.remove(dnsServer);
    }

    public void setDnsServers(Collection<InetAddress> dnsServers) {
        this.mDnses.clear();
        for (InetAddress dnsServer : dnsServers) {
            this.addDnsServer(dnsServer);
        }
    }

    public List<InetAddress> getDnsServers() {
        return Collections.unmodifiableList(this.mDnses);
    }

    @SystemApi
    public void setUsePrivateDns(boolean usePrivateDns) {
        this.mUsePrivateDns = usePrivateDns;
    }

    public boolean isPrivateDnsActive() {
        return this.mUsePrivateDns;
    }

    @SystemApi
    public void setPrivateDnsServerName(String privateDnsServerName) {
        this.mPrivateDnsServerName = privateDnsServerName;
    }

    public void setDhcpServerAddress(Inet4Address serverAddress) {
        this.mDhcpServerAddress = serverAddress;
    }

    public Inet4Address getDhcpServerAddress() {
        return this.mDhcpServerAddress;
    }

    public String getPrivateDnsServerName() {
        return this.mPrivateDnsServerName;
    }

    public boolean addValidatedPrivateDnsServer(InetAddress dnsServer) {
        if (dnsServer != null && !this.mValidatedPrivateDnses.contains(dnsServer)) {
            this.mValidatedPrivateDnses.add(dnsServer);
            return true;
        }
        return false;
    }

    public boolean removeValidatedPrivateDnsServer(InetAddress dnsServer) {
        return this.mValidatedPrivateDnses.remove(dnsServer);
    }

    @SystemApi
    public void setValidatedPrivateDnsServers(Collection<InetAddress> dnsServers) {
        this.mValidatedPrivateDnses.clear();
        for (InetAddress dnsServer : dnsServers) {
            this.addValidatedPrivateDnsServer(dnsServer);
        }
    }

    @SystemApi
    public List<InetAddress> getValidatedPrivateDnsServers() {
        return Collections.unmodifiableList(this.mValidatedPrivateDnses);
    }

    @SystemApi
    public boolean addPcscfServer(InetAddress pcscfServer) {
        if (pcscfServer != null && !this.mPcscfs.contains(pcscfServer)) {
            this.mPcscfs.add(pcscfServer);
            return true;
        }
        return false;
    }

    public boolean removePcscfServer(InetAddress pcscfServer) {
        return this.mPcscfs.remove(pcscfServer);
    }

    @SystemApi
    public void setPcscfServers(Collection<InetAddress> pcscfServers) {
        this.mPcscfs.clear();
        for (InetAddress pcscfServer : pcscfServers) {
            this.addPcscfServer(pcscfServer);
        }
    }

    @SystemApi
    public List<InetAddress> getPcscfServers() {
        return Collections.unmodifiableList(this.mPcscfs);
    }

    public void setDomains(String domains) {
        this.mDomains = domains;
    }

    public String getDomains() {
        return this.mDomains;
    }

    public void setMtu(int mtu) {
        this.mMtu = mtu;
    }

    public int getMtu() {
        return this.mMtu;
    }

    @SystemApi
    public void setTcpBufferSizes(String tcpBufferSizes) {
        this.mTcpBufferSizes = tcpBufferSizes;
    }

    @SystemApi
    public String getTcpBufferSizes() {
        return this.mTcpBufferSizes;
    }

    private RouteInfo routeWithInterface(RouteInfo route) {
        return new RouteInfo(route.getDestination(), route.getGateway(), this.mIfaceName, route.getType(), route.getMtu());
    }

    private int findRouteIndexByRouteKey(RouteInfo route) {
        for (int i = 0; i < this.mRoutes.size(); ++i) {
            if (!this.mRoutes.get(i).getRouteKey().equals(route.getRouteKey())) continue;
            return i;
        }
        return -1;
    }

    public boolean addRoute(RouteInfo route) {
        String routeIface = route.getInterface();
        if (routeIface != null && !routeIface.equals(this.mIfaceName)) {
            throw new IllegalArgumentException("Route added with non-matching interface: " + routeIface + " vs. " + this.mIfaceName);
        }
        int i = this.findRouteIndexByRouteKey(route = this.routeWithInterface(route));
        if (i == -1) {
            this.mRoutes.add(route);
            return true;
        }
        if (this.mRoutes.get(i).equals(route)) {
            return false;
        }
        this.mRoutes.set(i, route);
        return true;
    }

    @SystemApi
    public boolean removeRoute(RouteInfo route) {
        return Objects.equals(this.mIfaceName, route.getInterface()) && this.mRoutes.remove(route);
    }

    public List<RouteInfo> getRoutes() {
        return Collections.unmodifiableList(this.mRoutes);
    }

    public void ensureDirectlyConnectedRoutes() {
        for (LinkAddress addr : this.mLinkAddresses) {
            this.addRoute(new RouteInfo(addr, null, this.mIfaceName));
        }
    }

    @SystemApi
    public List<RouteInfo> getAllRoutes() {
        ArrayList<RouteInfo> routes = new ArrayList<RouteInfo>(this.mRoutes);
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            routes.addAll(stacked.getAllRoutes());
        }
        return routes;
    }

    public void setHttpProxy(ProxyInfo proxy) {
        this.mHttpProxy = proxy;
    }

    public ProxyInfo getHttpProxy() {
        return this.mHttpProxy;
    }

    public IpPrefix getNat64Prefix() {
        return this.mNat64Prefix;
    }

    public void setNat64Prefix(IpPrefix prefix) {
        if (prefix != null && prefix.getPrefixLength() != 96) {
            throw new IllegalArgumentException("Only 96-bit prefixes are supported: " + prefix);
        }
        this.mNat64Prefix = prefix;
    }

    @UnsupportedAppUsage
    public boolean addStackedLink(LinkProperties link) {
        if (link.getInterfaceName() != null) {
            this.mStackedLinks.put(link.getInterfaceName(), link);
            return true;
        }
        return false;
    }

    public boolean removeStackedLink(String iface) {
        LinkProperties removed = this.mStackedLinks.remove(iface);
        return removed != null;
    }

    @UnsupportedAppUsage
    public List<LinkProperties> getStackedLinks() {
        if (this.mStackedLinks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LinkProperties> stacked = new ArrayList<LinkProperties>();
        for (LinkProperties link : this.mStackedLinks.values()) {
            stacked.add(new LinkProperties(link));
        }
        return Collections.unmodifiableList(stacked);
    }

    public void clear() {
        if (this.mParcelSensitiveFields) {
            throw new UnsupportedOperationException("Cannot clear LinkProperties when parcelSensitiveFields is set");
        }
        this.mIfaceName = null;
        this.mLinkAddresses.clear();
        this.mDnses.clear();
        this.mUsePrivateDns = false;
        this.mPrivateDnsServerName = null;
        this.mPcscfs.clear();
        this.mDomains = null;
        this.mRoutes.clear();
        this.mHttpProxy = null;
        this.mStackedLinks.clear();
        this.mMtu = 0;
        this.mDhcpServerAddress = null;
        this.mTcpBufferSizes = null;
        this.mNat64Prefix = null;
        this.mWakeOnLanSupported = false;
        this.mCaptivePortalApiUrl = null;
        this.mCaptivePortalData = null;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        Collection<LinkProperties> stackedLinksValues;
        StringJoiner resultJoiner = new StringJoiner(" ", "{", "}");
        if (this.mIfaceName != null) {
            resultJoiner.add("InterfaceName:");
            resultJoiner.add(this.mIfaceName);
        }
        resultJoiner.add("LinkAddresses: [");
        if (!this.mLinkAddresses.isEmpty()) {
            resultJoiner.add(TextUtils.join((CharSequence)",", this.mLinkAddresses));
        }
        resultJoiner.add("]");
        resultJoiner.add("DnsAddresses: [");
        if (!this.mDnses.isEmpty()) {
            resultJoiner.add(TextUtils.join((CharSequence)",", this.mDnses));
        }
        resultJoiner.add("]");
        if (this.mUsePrivateDns) {
            resultJoiner.add("UsePrivateDns: true");
        }
        if (this.mPrivateDnsServerName != null) {
            resultJoiner.add("PrivateDnsServerName:");
            resultJoiner.add(this.mPrivateDnsServerName);
        }
        if (!this.mPcscfs.isEmpty()) {
            resultJoiner.add("PcscfAddresses: [");
            resultJoiner.add(TextUtils.join((CharSequence)",", this.mPcscfs));
            resultJoiner.add("]");
        }
        if (!this.mValidatedPrivateDnses.isEmpty()) {
            StringJoiner validatedPrivateDnsesJoiner = new StringJoiner(",", "ValidatedPrivateDnsAddresses: [", "]");
            for (InetAddress addr : this.mValidatedPrivateDnses) {
                validatedPrivateDnsesJoiner.add(addr.getHostAddress());
            }
            resultJoiner.add(validatedPrivateDnsesJoiner.toString());
        }
        resultJoiner.add("Domains:");
        resultJoiner.add(this.mDomains);
        resultJoiner.add("MTU:");
        resultJoiner.add(Integer.toString(this.mMtu));
        if (this.mWakeOnLanSupported) {
            resultJoiner.add("WakeOnLanSupported: true");
        }
        if (this.mDhcpServerAddress != null) {
            resultJoiner.add("ServerAddress:");
            resultJoiner.add(this.mDhcpServerAddress.toString());
        }
        if (this.mCaptivePortalApiUrl != null) {
            resultJoiner.add("CaptivePortalApiUrl: " + this.mCaptivePortalApiUrl);
        }
        if (this.mCaptivePortalData != null) {
            resultJoiner.add("CaptivePortalData: " + this.mCaptivePortalData);
        }
        if (this.mTcpBufferSizes != null) {
            resultJoiner.add("TcpBufferSizes:");
            resultJoiner.add(this.mTcpBufferSizes);
        }
        resultJoiner.add("Routes: [");
        if (!this.mRoutes.isEmpty()) {
            resultJoiner.add(TextUtils.join((CharSequence)",", this.mRoutes));
        }
        resultJoiner.add("]");
        if (this.mHttpProxy != null) {
            resultJoiner.add("HttpProxy:");
            resultJoiner.add(this.mHttpProxy.toString());
        }
        if (this.mNat64Prefix != null) {
            resultJoiner.add("Nat64Prefix:");
            resultJoiner.add(this.mNat64Prefix.toString());
        }
        if (!(stackedLinksValues = this.mStackedLinks.values()).isEmpty()) {
            StringJoiner stackedLinksJoiner = new StringJoiner(",", "Stacked: [", "]");
            for (LinkProperties lp : stackedLinksValues) {
                stackedLinksJoiner.add("[ " + lp + " ]");
            }
            resultJoiner.add(stackedLinksJoiner.toString());
        }
        return resultJoiner.toString();
    }

    @SystemApi
    public boolean hasIpv4Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean hasIPv4Address() {
        return this.hasIpv4Address();
    }

    private boolean hasIpv4AddressOnInterface(String iface) {
        return Objects.equals(iface, this.mIfaceName) && this.hasIpv4Address() || iface != null && this.mStackedLinks.containsKey(iface) && this.mStackedLinks.get(iface).hasIpv4Address();
    }

    @SystemApi
    public boolean hasGlobalIpv6Address() {
        for (LinkAddress address : this.mLinkAddresses) {
            if (!(address.getAddress() instanceof Inet6Address) || !address.isGlobalPreferred()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIpv4UnreachableDefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv4UnreachableDefault()) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean hasGlobalIPv6Address() {
        return this.hasGlobalIpv6Address();
    }

    @SystemApi
    public boolean hasIpv4DefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv4Default()) continue;
            return true;
        }
        return false;
    }

    public boolean hasIpv6UnreachableDefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv6UnreachableDefault()) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean hasIPv4DefaultRoute() {
        return this.hasIpv4DefaultRoute();
    }

    @SystemApi
    public boolean hasIpv6DefaultRoute() {
        for (RouteInfo r : this.mRoutes) {
            if (!r.isIPv6Default()) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean hasIPv6DefaultRoute() {
        return this.hasIpv6DefaultRoute();
    }

    @SystemApi
    public boolean hasIpv4DnsServer() {
        for (InetAddress ia : this.mDnses) {
            if (!(ia instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean hasIPv4DnsServer() {
        return this.hasIpv4DnsServer();
    }

    @SystemApi
    public boolean hasIpv6DnsServer() {
        for (InetAddress ia : this.mDnses) {
            if (!(ia instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean hasIPv6DnsServer() {
        return this.hasIpv6DnsServer();
    }

    public boolean hasIpv4PcscfServer() {
        for (InetAddress ia : this.mPcscfs) {
            if (!(ia instanceof Inet4Address)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIpv6PcscfServer() {
        for (InetAddress ia : this.mPcscfs) {
            if (!(ia instanceof Inet6Address)) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    public boolean isIpv4Provisioned() {
        return this.hasIpv4Address() && this.hasIpv4DefaultRoute() && this.hasIpv4DnsServer();
    }

    @SystemApi
    public boolean isIpv6Provisioned() {
        return this.hasGlobalIpv6Address() && this.hasIpv6DefaultRoute() && this.hasIpv6DnsServer();
    }

    @UnsupportedAppUsage(maxTargetSdk=28)
    public boolean isIPv6Provisioned() {
        return this.isIpv6Provisioned();
    }

    @SystemApi
    public boolean isProvisioned() {
        return this.isIpv4Provisioned() || this.isIpv6Provisioned();
    }

    @SystemApi
    public boolean isReachable(InetAddress ip) {
        List<RouteInfo> allRoutes = this.getAllRoutes();
        RouteInfo bestRoute = RouteInfo.selectBestRoute(allRoutes, ip);
        if (bestRoute == null) {
            return false;
        }
        if (ip instanceof Inet4Address) {
            return this.hasIpv4AddressOnInterface(bestRoute.getInterface());
        }
        if (ip instanceof Inet6Address) {
            if (ip.isLinkLocalAddress()) {
                return ((Inet6Address)ip).getScopeId() != 0;
            }
            return !bestRoute.hasGateway() || this.hasGlobalIpv6Address();
        }
        return false;
    }

    @UnsupportedAppUsage
    public boolean isIdenticalInterfaceName(LinkProperties target) {
        return LinkPropertiesUtils.isIdenticalInterfaceName(target, this);
    }

    public boolean isIdenticalDhcpServerAddress(LinkProperties target) {
        return Objects.equals(this.mDhcpServerAddress, target.mDhcpServerAddress);
    }

    @UnsupportedAppUsage
    public boolean isIdenticalAddresses(LinkProperties target) {
        return LinkPropertiesUtils.isIdenticalAddresses(target, this);
    }

    @UnsupportedAppUsage
    public boolean isIdenticalDnses(LinkProperties target) {
        return LinkPropertiesUtils.isIdenticalDnses(target, this);
    }

    public boolean isIdenticalPrivateDns(LinkProperties target) {
        return this.isPrivateDnsActive() == target.isPrivateDnsActive() && TextUtils.equals(this.getPrivateDnsServerName(), target.getPrivateDnsServerName());
    }

    public boolean isIdenticalValidatedPrivateDnses(LinkProperties target) {
        List<InetAddress> targetDnses = target.getValidatedPrivateDnsServers();
        return this.mValidatedPrivateDnses.size() == targetDnses.size() ? this.mValidatedPrivateDnses.containsAll(targetDnses) : false;
    }

    public boolean isIdenticalPcscfs(LinkProperties target) {
        List<InetAddress> targetPcscfs = target.getPcscfServers();
        return this.mPcscfs.size() == targetPcscfs.size() ? this.mPcscfs.containsAll(targetPcscfs) : false;
    }

    @UnsupportedAppUsage
    public boolean isIdenticalRoutes(LinkProperties target) {
        return LinkPropertiesUtils.isIdenticalRoutes(target, this);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public boolean isIdenticalHttpProxy(LinkProperties target) {
        return LinkPropertiesUtils.isIdenticalHttpProxy(target, this);
    }

    @UnsupportedAppUsage
    public boolean isIdenticalStackedLinks(LinkProperties target) {
        if (!this.mStackedLinks.keySet().equals(target.mStackedLinks.keySet())) {
            return false;
        }
        for (LinkProperties stacked : this.mStackedLinks.values()) {
            String iface;
            if (stacked.equals(target.mStackedLinks.get(iface = stacked.getInterfaceName()))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdenticalMtu(LinkProperties target) {
        return this.getMtu() == target.getMtu();
    }

    public boolean isIdenticalTcpBufferSizes(LinkProperties target) {
        return Objects.equals(this.mTcpBufferSizes, target.mTcpBufferSizes);
    }

    public boolean isIdenticalNat64Prefix(LinkProperties target) {
        return Objects.equals(this.mNat64Prefix, target.mNat64Prefix);
    }

    public boolean isIdenticalWakeOnLan(LinkProperties target) {
        return this.isWakeOnLanSupported() == target.isWakeOnLanSupported();
    }

    public boolean isIdenticalCaptivePortalApiUrl(LinkProperties target) {
        return Objects.equals(this.mCaptivePortalApiUrl, target.mCaptivePortalApiUrl);
    }

    public boolean isIdenticalCaptivePortalData(LinkProperties target) {
        return Objects.equals(this.mCaptivePortalData, target.mCaptivePortalData);
    }

    public void setWakeOnLanSupported(boolean supported) {
        this.mWakeOnLanSupported = supported;
    }

    public boolean isWakeOnLanSupported() {
        return this.mWakeOnLanSupported;
    }

    @SystemApi
    public void setCaptivePortalApiUrl(Uri url) {
        this.mCaptivePortalApiUrl = url;
    }

    @SystemApi
    public Uri getCaptivePortalApiUrl() {
        return this.mCaptivePortalApiUrl;
    }

    @SystemApi
    public void setCaptivePortalData(CaptivePortalData data) {
        this.mCaptivePortalData = data;
    }

    @SystemApi
    public CaptivePortalData getCaptivePortalData() {
        return this.mCaptivePortalData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LinkProperties)) {
            return false;
        }
        LinkProperties target = (LinkProperties)obj;
        return this.isIdenticalInterfaceName(target) && this.isIdenticalAddresses(target) && this.isIdenticalDhcpServerAddress(target) && this.isIdenticalDnses(target) && this.isIdenticalPrivateDns(target) && this.isIdenticalValidatedPrivateDnses(target) && this.isIdenticalPcscfs(target) && this.isIdenticalRoutes(target) && this.isIdenticalHttpProxy(target) && this.isIdenticalStackedLinks(target) && this.isIdenticalMtu(target) && this.isIdenticalTcpBufferSizes(target) && this.isIdenticalNat64Prefix(target) && this.isIdenticalWakeOnLan(target) && this.isIdenticalCaptivePortalApiUrl(target) && this.isIdenticalCaptivePortalData(target);
    }

    public LinkPropertiesUtils.CompareResult<InetAddress> compareDnses(LinkProperties target) {
        return new LinkPropertiesUtils.CompareResult<InetAddress>(this.mDnses, target != null ? target.getDnsServers() : null);
    }

    public LinkPropertiesUtils.CompareResult<InetAddress> compareValidatedPrivateDnses(LinkProperties target) {
        return new LinkPropertiesUtils.CompareResult<InetAddress>(this.mValidatedPrivateDnses, target != null ? target.getValidatedPrivateDnsServers() : null);
    }

    public LinkPropertiesUtils.CompareResult<RouteInfo> compareAllRoutes(LinkProperties target) {
        return new LinkPropertiesUtils.CompareResult<RouteInfo>(this.getAllRoutes(), target != null ? target.getAllRoutes() : null);
    }

    public LinkPropertiesUtils.CompareResult<String> compareAllInterfaceNames(LinkProperties target) {
        return new LinkPropertiesUtils.CompareResult<String>(this.getAllInterfaceNames(), target != null ? target.getAllInterfaceNames() : null);
    }

    public int hashCode() {
        return (null == this.mIfaceName ? 0 : this.mIfaceName.hashCode() + this.mLinkAddresses.size() * 31 + this.mDnses.size() * 37 + this.mValidatedPrivateDnses.size() * 61 + (null == this.mDomains ? 0 : this.mDomains.hashCode()) + this.mRoutes.size() * 41 + (null == this.mHttpProxy ? 0 : this.mHttpProxy.hashCode()) + this.mStackedLinks.hashCode() * 47) + this.mMtu * 51 + (null == this.mTcpBufferSizes ? 0 : this.mTcpBufferSizes.hashCode()) + (this.mUsePrivateDns ? 57 : 0) + (null == this.mDhcpServerAddress ? 0 : this.mDhcpServerAddress.hashCode()) + this.mPcscfs.size() * 67 + (null == this.mPrivateDnsServerName ? 0 : this.mPrivateDnsServerName.hashCode()) + Objects.hash(this.mNat64Prefix) + (this.mWakeOnLanSupported ? 71 : 0) + Objects.hash(this.mCaptivePortalApiUrl, this.mCaptivePortalData);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getInterfaceName());
        dest.writeInt(this.mLinkAddresses.size());
        for (LinkAddress linkAddress : this.mLinkAddresses) {
            dest.writeParcelable(linkAddress, flags);
        }
        LinkProperties.writeAddresses(dest, this.mDnses);
        LinkProperties.writeAddresses(dest, this.mValidatedPrivateDnses);
        dest.writeBoolean(this.mUsePrivateDns);
        dest.writeString(this.mPrivateDnsServerName);
        LinkProperties.writeAddresses(dest, this.mPcscfs);
        dest.writeString(this.mDomains);
        LinkProperties.writeAddress(dest, this.mDhcpServerAddress);
        dest.writeInt(this.mMtu);
        dest.writeString(this.mTcpBufferSizes);
        dest.writeInt(this.mRoutes.size());
        for (RouteInfo route : this.mRoutes) {
            dest.writeParcelable(route, flags);
        }
        if (this.mHttpProxy != null) {
            dest.writeByte((byte)1);
            dest.writeParcelable(this.mHttpProxy, flags);
        } else {
            dest.writeByte((byte)0);
        }
        dest.writeParcelable(this.mNat64Prefix, 0);
        ArrayList<LinkProperties> stackedLinks = new ArrayList<LinkProperties>(this.mStackedLinks.values());
        dest.writeList(stackedLinks);
        dest.writeBoolean(this.mWakeOnLanSupported);
        dest.writeParcelable(this.mParcelSensitiveFields ? this.mCaptivePortalApiUrl : null, 0);
        dest.writeParcelable(this.mParcelSensitiveFields ? this.mCaptivePortalData : null, 0);
    }

    private static void writeAddresses(Parcel dest, List<InetAddress> list) {
        dest.writeInt(list.size());
        for (InetAddress d : list) {
            LinkProperties.writeAddress(dest, d);
        }
    }

    private static void writeAddress(Parcel dest, InetAddress addr) {
        byte[] addressBytes = addr == null ? null : addr.getAddress();
        dest.writeByteArray(addressBytes);
        if (addr instanceof Inet6Address) {
            Inet6Address v6Addr = (Inet6Address)addr;
            boolean hasScopeId = v6Addr.getScopeId() != 0;
            dest.writeBoolean(hasScopeId);
            if (hasScopeId) {
                dest.writeInt(v6Addr.getScopeId());
            }
        }
    }

    private static InetAddress readAddress(Parcel p) throws UnknownHostException {
        byte[] addr = p.createByteArray();
        if (addr == null) {
            return null;
        }
        if (addr.length == 16) {
            boolean hasScopeId = p.readBoolean();
            int scopeId = hasScopeId ? p.readInt() : 0;
            return Inet6Address.getByAddress(null, addr, scopeId);
        }
        return InetAddress.getByAddress(addr);
    }

    public static boolean isValidMtu(int mtu, boolean ipv6) {
        if (ipv6) {
            return mtu >= 1280 && mtu <= 10000;
        }
        return mtu >= 68 && mtu <= 10000;
    }

    @UnsupportedAppUsage(implicitMember="values()[Landroid/net/LinkProperties$ProvisioningChange;")
    public static enum ProvisioningChange {
        STILL_NOT_PROVISIONED,
        LOST_PROVISIONING,
        GAINED_PROVISIONING,
        STILL_PROVISIONED;

    }
}

