/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.SubtitleTrack;
import android.media.TextTrackCueSpan;
import android.media.TextTrackRegion;
import android.media.WebVttParser;
import java.util.Arrays;

class TextTrackCue
extends SubtitleTrack.Cue {
    static final int WRITING_DIRECTION_HORIZONTAL = 100;
    static final int WRITING_DIRECTION_VERTICAL_RL = 101;
    static final int WRITING_DIRECTION_VERTICAL_LR = 102;
    static final int ALIGNMENT_MIDDLE = 200;
    static final int ALIGNMENT_START = 201;
    static final int ALIGNMENT_END = 202;
    static final int ALIGNMENT_LEFT = 203;
    static final int ALIGNMENT_RIGHT = 204;
    private static final String TAG = "TTCue";
    String mId = "";
    boolean mPauseOnExit = false;
    int mWritingDirection = 100;
    String mRegionId = "";
    boolean mSnapToLines = true;
    Integer mLinePosition = null;
    boolean mAutoLinePosition;
    int mTextPosition = 50;
    int mSize = 100;
    int mAlignment = 200;
    String[] mStrings;
    TextTrackCueSpan[][] mLines = null;
    TextTrackRegion mRegion = null;

    TextTrackCue() {
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextTrackCue)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        try {
            boolean res;
            TextTrackCue cue = (TextTrackCue)o;
            boolean bl = res = this.mId.equals(cue.mId) && this.mPauseOnExit == cue.mPauseOnExit && this.mWritingDirection == cue.mWritingDirection && this.mRegionId.equals(cue.mRegionId) && this.mSnapToLines == cue.mSnapToLines && this.mAutoLinePosition == cue.mAutoLinePosition && (this.mAutoLinePosition || this.mLinePosition != null && this.mLinePosition.equals(cue.mLinePosition) || this.mLinePosition == null && cue.mLinePosition == null) && this.mTextPosition == cue.mTextPosition && this.mSize == cue.mSize && this.mAlignment == cue.mAlignment && this.mLines.length == cue.mLines.length;
            if (res) {
                for (int line = 0; line < this.mLines.length; ++line) {
                    if (Arrays.equals(this.mLines[line], cue.mLines[line])) continue;
                    return false;
                }
            }
            return res;
        }
        catch (IncompatibleClassChangeError e) {
            return false;
        }
    }

    public StringBuilder appendStringsToBuilder(StringBuilder builder) {
        if (this.mStrings == null) {
            builder.append("null");
        } else {
            builder.append("[");
            boolean first = true;
            for (String s : this.mStrings) {
                if (!first) {
                    builder.append(", ");
                }
                if (s == null) {
                    builder.append("null");
                } else {
                    builder.append("\"");
                    builder.append(s);
                    builder.append("\"");
                }
                first = false;
            }
            builder.append("]");
        }
        return builder;
    }

    public StringBuilder appendLinesToBuilder(StringBuilder builder) {
        if (this.mLines == null) {
            builder.append("null");
        } else {
            builder.append("[");
            boolean first = true;
            for (TextTrackCueSpan[] spans : this.mLines) {
                if (!first) {
                    builder.append(", ");
                }
                if (spans == null) {
                    builder.append("null");
                } else {
                    builder.append("\"");
                    boolean innerFirst = true;
                    long lastTimestamp = -1L;
                    for (TextTrackCueSpan span : spans) {
                        if (!innerFirst) {
                            builder.append(" ");
                        }
                        if (span.mTimestampMs != lastTimestamp) {
                            builder.append("<").append(WebVttParser.timeToString(span.mTimestampMs)).append(">");
                            lastTimestamp = span.mTimestampMs;
                        }
                        builder.append(span.mText);
                        innerFirst = false;
                    }
                    builder.append("\"");
                }
                first = false;
            }
            builder.append("]");
        }
        return builder;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(WebVttParser.timeToString(this.mStartTimeMs)).append(" --> ").append(WebVttParser.timeToString(this.mEndTimeMs)).append(" {id:\"").append(this.mId).append("\", pauseOnExit:").append(this.mPauseOnExit).append(", direction:").append(this.mWritingDirection == 100 ? "horizontal" : (this.mWritingDirection == 102 ? "vertical_lr" : (this.mWritingDirection == 101 ? "vertical_rl" : "INVALID"))).append(", regionId:\"").append(this.mRegionId).append("\", snapToLines:").append(this.mSnapToLines).append(", linePosition:").append(this.mAutoLinePosition ? "auto" : this.mLinePosition).append(", textPosition:").append(this.mTextPosition).append(", size:").append(this.mSize).append(", alignment:").append(this.mAlignment == 202 ? "end" : (this.mAlignment == 203 ? "left" : (this.mAlignment == 200 ? "middle" : (this.mAlignment == 204 ? "right" : (this.mAlignment == 201 ? "start" : "INVALID"))))).append(", text:");
        this.appendStringsToBuilder(res).append("}");
        return res.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public void onTime(long timeMs) {
        TextTrackCueSpan[][] textTrackCueSpanArray = this.mLines;
        int n = textTrackCueSpanArray.length;
        for (int i = 0; i < n; ++i) {
            TextTrackCueSpan[] line;
            for (TextTrackCueSpan span : line = textTrackCueSpanArray[i]) {
                span.mEnabled = timeMs >= span.mTimestampMs;
            }
        }
    }
}

