/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.usb;

import android.hardware.usb.UsbInterface;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

public class UsbConfiguration
implements Parcelable {
    private final int mId;
    private final String mName;
    private final int mAttributes;
    private final int mMaxPower;
    private Parcelable[] mInterfaces;
    private static final int ATTR_SELF_POWERED = 64;
    private static final int ATTR_REMOTE_WAKEUP = 32;
    public static final Parcelable.Creator<UsbConfiguration> CREATOR = new Parcelable.Creator<UsbConfiguration>(){

        @Override
        public UsbConfiguration createFromParcel(Parcel in) {
            int id2 = in.readInt();
            String name = in.readString();
            int attributes = in.readInt();
            int maxPower = in.readInt();
            Parcelable[] interfaces = in.readParcelableArray(UsbInterface.class.getClassLoader());
            UsbConfiguration configuration = new UsbConfiguration(id2, name, attributes, maxPower);
            configuration.setInterfaces(interfaces);
            return configuration;
        }

        public UsbConfiguration[] newArray(int size) {
            return new UsbConfiguration[size];
        }
    };

    public UsbConfiguration(int id2, String name, int attributes, int maxPower) {
        this.mId = id2;
        this.mName = name;
        this.mAttributes = attributes;
        this.mMaxPower = maxPower;
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public boolean isSelfPowered() {
        return (this.mAttributes & 0x40) != 0;
    }

    public boolean isRemoteWakeup() {
        return (this.mAttributes & 0x20) != 0;
    }

    public int getAttributes() {
        return this.mAttributes;
    }

    public int getMaxPower() {
        return this.mMaxPower * 2;
    }

    public int getInterfaceCount() {
        return this.mInterfaces.length;
    }

    public UsbInterface getInterface(int index) {
        return (UsbInterface)this.mInterfaces[index];
    }

    public void setInterfaces(Parcelable[] interfaces) {
        this.mInterfaces = Preconditions.checkArrayElementsNotNull(interfaces, "interfaces");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsbConfiguration[mId=" + this.mId + ",mName=" + this.mName + ",mAttributes=" + this.mAttributes + ",mMaxPower=" + this.mMaxPower + ",mInterfaces=[");
        for (int i = 0; i < this.mInterfaces.length; ++i) {
            builder.append("\n");
            builder.append(this.mInterfaces[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mId);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mAttributes);
        parcel.writeInt(this.mMaxPower);
        parcel.writeParcelableArray(this.mInterfaces, 0);
    }
}

