/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.location;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

@SystemApi
public class NanoAppBinary
implements Parcelable {
    private static final String TAG = "NanoAppBinary";
    private byte[] mNanoAppBinary;
    private int mHeaderVersion;
    private int mMagic;
    private long mNanoAppId;
    private int mNanoAppVersion;
    private int mFlags;
    private long mHwHubType;
    private byte mTargetChreApiMajorVersion;
    private byte mTargetChreApiMinorVersion;
    private boolean mHasValidHeader = false;
    private static final int EXPECTED_HEADER_VERSION = 1;
    private static final int EXPECTED_MAGIC_VALUE = 1330528590;
    private static final ByteOrder HEADER_ORDER = ByteOrder.LITTLE_ENDIAN;
    private static final int HEADER_SIZE_BYTES = 40;
    private static final int NANOAPP_SIGNED_FLAG_BIT = 1;
    private static final int NANOAPP_ENCRYPTED_FLAG_BIT = 2;
    public static final Parcelable.Creator<NanoAppBinary> CREATOR = new Parcelable.Creator<NanoAppBinary>(){

        @Override
        public NanoAppBinary createFromParcel(Parcel in) {
            return new NanoAppBinary(in);
        }

        public NanoAppBinary[] newArray(int size) {
            return new NanoAppBinary[size];
        }
    };

    public NanoAppBinary(byte[] appBinary) {
        this.mNanoAppBinary = appBinary;
        this.parseBinaryHeader();
    }

    private void parseBinaryHeader() {
        ByteBuffer buf = ByteBuffer.wrap(this.mNanoAppBinary).order(HEADER_ORDER);
        this.mHasValidHeader = false;
        try {
            this.mHeaderVersion = buf.getInt();
            if (this.mHeaderVersion != 1) {
                Log.e(TAG, "Unexpected header version " + this.mHeaderVersion + " while parsing header (expected " + 1 + ")");
                return;
            }
            this.mMagic = buf.getInt();
            this.mNanoAppId = buf.getLong();
            this.mNanoAppVersion = buf.getInt();
            this.mFlags = buf.getInt();
            this.mHwHubType = buf.getLong();
            this.mTargetChreApiMajorVersion = buf.get();
            this.mTargetChreApiMinorVersion = buf.get();
        }
        catch (BufferUnderflowException e) {
            Log.e(TAG, "Not enough contents in nanoapp header");
            return;
        }
        if (this.mMagic != 1330528590) {
            Log.e(TAG, "Unexpected magic value " + String.format("0x%08X", this.mMagic) + "while parsing header (expected " + String.format("0x%08X", 1330528590) + ")");
        } else {
            this.mHasValidHeader = true;
        }
    }

    public byte[] getBinary() {
        return this.mNanoAppBinary;
    }

    public byte[] getBinaryNoHeader() {
        if (this.mNanoAppBinary.length < 40) {
            throw new IndexOutOfBoundsException("NanoAppBinary binary byte size (" + this.mNanoAppBinary.length + ") is less than header size (" + 40 + ")");
        }
        return Arrays.copyOfRange(this.mNanoAppBinary, 40, this.mNanoAppBinary.length);
    }

    public boolean hasValidHeader() {
        return this.mHasValidHeader;
    }

    public int getHeaderVersion() {
        return this.mHeaderVersion;
    }

    public long getNanoAppId() {
        return this.mNanoAppId;
    }

    public int getNanoAppVersion() {
        return this.mNanoAppVersion;
    }

    public long getHwHubType() {
        return this.mHwHubType;
    }

    public byte getTargetChreApiMajorVersion() {
        return this.mTargetChreApiMajorVersion;
    }

    public byte getTargetChreApiMinorVersion() {
        return this.mTargetChreApiMinorVersion;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public boolean isSigned() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isEncrypted() {
        return (this.mFlags & 2) != 0;
    }

    private NanoAppBinary(Parcel in) {
        int binaryLength = in.readInt();
        this.mNanoAppBinary = new byte[binaryLength];
        in.readByteArray(this.mNanoAppBinary);
        this.parseBinaryHeader();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mNanoAppBinary.length);
        out.writeByteArray(this.mNanoAppBinary);
    }
}

