/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.hdmi;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.hardware.hdmi.HdmiAudioSystemClient;
import android.hardware.hdmi.HdmiClient;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiHotplugEvent;
import android.hardware.hdmi.HdmiPlaybackClient;
import android.hardware.hdmi.HdmiPortInfo;
import android.hardware.hdmi.HdmiSwitchClient;
import android.hardware.hdmi.HdmiTvClient;
import android.hardware.hdmi.HdmiUtils;
import android.hardware.hdmi.IHdmiCecVolumeControlFeatureListener;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiControlStatusChangeListener;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.os.Binder;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class HdmiControlManager {
    private static final String TAG = "HdmiControlManager";
    private final IHdmiControlService mService;
    private static final int INVALID_PHYSICAL_ADDRESS = 65535;
    @GuardedBy(value={"mLock"})
    private int mLocalPhysicalAddress = 65535;
    private final Object mLock = new Object();
    public static final String ACTION_OSD_MESSAGE = "android.hardware.hdmi.action.OSD_MESSAGE";
    public static final int OSD_MESSAGE_ARC_CONNECTED_INVALID_PORT = 1;
    public static final int OSD_MESSAGE_AVR_VOLUME_CHANGED = 2;
    public static final String EXTRA_MESSAGE_ID = "android.hardware.hdmi.extra.MESSAGE_ID";
    public static final String EXTRA_MESSAGE_EXTRA_PARAM1 = "android.hardware.hdmi.extra.MESSAGE_EXTRA_PARAM1";
    public static final int AVR_VOLUME_MUTED = 101;
    public static final int POWER_STATUS_UNKNOWN = -1;
    public static final int POWER_STATUS_ON = 0;
    public static final int POWER_STATUS_STANDBY = 1;
    public static final int POWER_STATUS_TRANSIENT_TO_ON = 2;
    public static final int POWER_STATUS_TRANSIENT_TO_STANDBY = 3;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_TIMEOUT = 1;
    public static final int RESULT_SOURCE_NOT_AVAILABLE = 2;
    public static final int RESULT_TARGET_NOT_AVAILABLE = 3;
    @Deprecated
    public static final int RESULT_ALREADY_IN_PROGRESS = 4;
    public static final int RESULT_EXCEPTION = 5;
    public static final int RESULT_INCORRECT_MODE = 6;
    public static final int RESULT_COMMUNICATION_FAILED = 7;
    public static final int DEVICE_EVENT_ADD_DEVICE = 1;
    public static final int DEVICE_EVENT_REMOVE_DEVICE = 2;
    public static final int DEVICE_EVENT_UPDATE_DEVICE = 3;
    public static final int ONE_TOUCH_RECORD_RECORDING_CURRENTLY_SELECTED_SOURCE = 1;
    public static final int ONE_TOUCH_RECORD_RECORDING_DIGITAL_SERVICE = 2;
    public static final int ONE_TOUCH_RECORD_RECORDING_ANALOGUE_SERVICE = 3;
    public static final int ONE_TOUCH_RECORD_RECORDING_EXTERNAL_INPUT = 4;
    public static final int ONE_TOUCH_RECORD_UNABLE_DIGITAL_SERVICE = 5;
    public static final int ONE_TOUCH_RECORD_UNABLE_ANALOGUE_SERVICE = 6;
    public static final int ONE_TOUCH_RECORD_UNABLE_SELECTED_SERVICE = 7;
    public static final int ONE_TOUCH_RECORD_INVALID_EXTERNAL_PLUG_NUMBER = 9;
    public static final int ONE_TOUCH_RECORD_INVALID_EXTERNAL_PHYSICAL_ADDRESS = 10;
    public static final int ONE_TOUCH_RECORD_UNSUPPORTED_CA = 11;
    public static final int ONE_TOUCH_RECORD_NO_OR_INSUFFICIENT_CA_ENTITLEMENTS = 12;
    public static final int ONE_TOUCH_RECORD_DISALLOW_TO_COPY = 13;
    public static final int ONE_TOUCH_RECORD_DISALLOW_TO_FUTHER_COPIES = 14;
    public static final int ONE_TOUCH_RECORD_NO_MEDIA = 16;
    public static final int ONE_TOUCH_RECORD_PLAYING = 17;
    public static final int ONE_TOUCH_RECORD_ALREADY_RECORDING = 18;
    public static final int ONE_TOUCH_RECORD_MEDIA_PROTECTED = 19;
    public static final int ONE_TOUCH_RECORD_NO_SOURCE_SIGNAL = 20;
    public static final int ONE_TOUCH_RECORD_MEDIA_PROBLEM = 21;
    public static final int ONE_TOUCH_RECORD_NOT_ENOUGH_SPACE = 22;
    public static final int ONE_TOUCH_RECORD_PARENT_LOCK_ON = 23;
    public static final int ONE_TOUCH_RECORD_RECORDING_TERMINATED_NORMALLY = 26;
    public static final int ONE_TOUCH_RECORD_RECORDING_ALREADY_TERMINATED = 27;
    public static final int ONE_TOUCH_RECORD_OTHER_REASON = 31;
    public static final int ONE_TOUCH_RECORD_PREVIOUS_RECORDING_IN_PROGRESS = 48;
    public static final int ONE_TOUCH_RECORD_CHECK_RECORDER_CONNECTION = 49;
    public static final int ONE_TOUCH_RECORD_FAIL_TO_RECORD_DISPLAYED_SCREEN = 50;
    public static final int ONE_TOUCH_RECORD_CEC_DISABLED = 51;
    public static final int TIMER_RECORDING_TYPE_DIGITAL = 1;
    public static final int TIMER_RECORDING_TYPE_ANALOGUE = 2;
    public static final int TIMER_RECORDING_TYPE_EXTERNAL = 3;
    public static final int TIMER_STATUS_MEDIA_INFO_PRESENT_NOT_PROTECTED = 0;
    public static final int TIMER_STATUS_MEDIA_INFO_PRESENT_PROTECTED = 1;
    public static final int TIMER_STATUS_MEDIA_INFO_NOT_PRESENT = 2;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_ENOUGH_SPACE = 8;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_NOT_ENOUGH_SPACE = 9;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_MIGHT_NOT_ENOUGH_SPACE = 11;
    public static final int TIMER_STATUS_PROGRAMMED_INFO_NO_MEDIA_INFO = 10;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_NO_FREE_TIME = 1;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_DATE_OUT_OF_RANGE = 2;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_INVALID_SEQUENCE = 3;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_INVALID_EXTERNAL_PLUG_NUMBER = 4;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_INVALID_EXTERNAL_PHYSICAL_NUMBER = 5;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_CA_NOT_SUPPORTED = 6;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_NO_CA_ENTITLEMENTS = 7;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_UNSUPPORTED_RESOLUTION = 8;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_PARENTAL_LOCK_ON = 9;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_CLOCK_FAILURE = 10;
    public static final int TIMER_STATUS_NOT_PROGRAMMED_DUPLICATED = 14;
    public static final int TIMER_RECORDING_RESULT_EXTRA_NO_ERROR = 0;
    public static final int TIMER_RECORDING_RESULT_EXTRA_CHECK_RECORDER_CONNECTION = 1;
    public static final int TIMER_RECORDING_RESULT_EXTRA_FAIL_TO_RECORD_SELECTED_SOURCE = 2;
    public static final int TIMER_RECORDING_RESULT_EXTRA_CEC_DISABLED = 3;
    public static final int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_RECORDING = 0;
    public static final int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_NO_MATCHING = 1;
    public static final int CLEAR_TIMER_STATUS_TIMER_NOT_CLEARED_NO_INFO_AVAILABLE = 2;
    public static final int CLEAR_TIMER_STATUS_TIMER_CLEARED = 128;
    public static final int CLEAR_TIMER_STATUS_CHECK_RECORDER_CONNECTION = 160;
    public static final int CLEAR_TIMER_STATUS_FAIL_TO_CLEAR_SELECTED_SOURCE = 161;
    public static final int CLEAR_TIMER_STATUS_CEC_DISABLE = 162;
    public static final int CONTROL_STATE_CHANGED_REASON_START = 0;
    public static final int CONTROL_STATE_CHANGED_REASON_SETTING = 1;
    public static final int CONTROL_STATE_CHANGED_REASON_WAKEUP = 2;
    public static final int CONTROL_STATE_CHANGED_REASON_STANDBY = 3;
    private final boolean mHasPlaybackDevice;
    private final boolean mHasTvDevice;
    private final boolean mHasAudioSystemDevice;
    private final boolean mHasSwitchDevice;
    private final boolean mIsSwitchDevice;
    private final ArrayMap<HotplugEventListener, IHdmiHotplugEventListener> mHotplugEventListeners = new ArrayMap();
    private final ArrayMap<HdmiControlStatusChangeListener, IHdmiControlStatusChangeListener> mHdmiControlStatusChangeListeners = new ArrayMap();
    private final ArrayMap<HdmiCecVolumeControlFeatureListener, IHdmiCecVolumeControlFeatureListener> mHdmiCecVolumeControlFeatureListeners = new ArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLocalPhysicalAddress(int physicalAddress) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalPhysicalAddress = physicalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLocalPhysicalAddress() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mLocalPhysicalAddress;
        }
    }

    public HdmiControlManager(IHdmiControlService service) {
        this.mService = service;
        int[] types = null;
        if (this.mService != null) {
            try {
                types = this.mService.getSupportedTypes();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mHasTvDevice = HdmiControlManager.hasDeviceType(types, 0);
        this.mHasPlaybackDevice = HdmiControlManager.hasDeviceType(types, 4);
        this.mHasAudioSystemDevice = HdmiControlManager.hasDeviceType(types, 5);
        this.mHasSwitchDevice = HdmiControlManager.hasDeviceType(types, 6);
        this.mIsSwitchDevice = SystemProperties.getBoolean("ro.hdmi.property_is_device_hdmi_cec_switch", false);
        this.addHotplugEventListener(new ClientHotplugEventListener());
    }

    private static boolean hasDeviceType(int[] types, int type) {
        if (types == null) {
            return false;
        }
        for (int t : types) {
            if (t != type) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    public HdmiClient getClient(int type) {
        if (this.mService == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return this.mHasTvDevice ? new HdmiTvClient(this.mService) : null;
            }
            case 4: {
                return this.mHasPlaybackDevice ? new HdmiPlaybackClient(this.mService) : null;
            }
            case 5: {
                return this.mHasAudioSystemDevice ? new HdmiAudioSystemClient(this.mService) : null;
            }
            case 6: {
                return this.mHasSwitchDevice || this.mIsSwitchDevice ? new HdmiSwitchClient(this.mService) : null;
            }
        }
        return null;
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    public HdmiPlaybackClient getPlaybackClient() {
        return (HdmiPlaybackClient)this.getClient(4);
    }

    @SystemApi
    @SuppressLint(value={"Doclava125"})
    public HdmiTvClient getTvClient() {
        return (HdmiTvClient)this.getClient(0);
    }

    @SuppressLint(value={"Doclava125"})
    public HdmiAudioSystemClient getAudioSystemClient() {
        return (HdmiAudioSystemClient)this.getClient(5);
    }

    @SuppressLint(value={"Doclava125"})
    public HdmiSwitchClient getSwitchClient() {
        return (HdmiSwitchClient)this.getClient(6);
    }

    @SystemApi
    public List<HdmiDeviceInfo> getConnectedDevices() {
        try {
            return this.mService.getDeviceList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public List<HdmiDeviceInfo> getConnectedDevicesList() {
        try {
            return this.mService.getDeviceList();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void powerOffDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOffRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public void powerOffRemoteDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOffRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void powerOnDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOnRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public void powerOnRemoteDevice(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.powerOnRemoteDevice(deviceInfo.getLogicalAddress(), deviceInfo.getDevicePowerStatus());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void setActiveSource(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.askRemoteDeviceToBecomeActiveSource(deviceInfo.getPhysicalAddress());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    public void requestRemoteDeviceToBecomeActiveSource(HdmiDeviceInfo deviceInfo) {
        Objects.requireNonNull(deviceInfo);
        try {
            this.mService.askRemoteDeviceToBecomeActiveSource(deviceInfo.getPhysicalAddress());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setStandbyMode(boolean isStandbyModeOn) {
        try {
            this.mService.setStandbyMode(isStandbyModeOn);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setHdmiCecVolumeControlEnabled(boolean isHdmiCecVolumeControlEnabled) {
        try {
            this.mService.setHdmiCecVolumeControlEnabled(isHdmiCecVolumeControlEnabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isHdmiCecVolumeControlEnabled() {
        try {
            return this.mService.isHdmiCecVolumeControlEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean getSystemAudioMode() {
        try {
            return this.mService.getSystemAudioMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public int getPhysicalAddress() {
        return this.getLocalPhysicalAddress();
    }

    @SystemApi
    public boolean isDeviceConnected(HdmiDeviceInfo targetDevice) {
        Objects.requireNonNull(targetDevice);
        int physicalAddress = this.getLocalPhysicalAddress();
        if (physicalAddress == 65535) {
            return false;
        }
        int targetPhysicalAddress = targetDevice.getPhysicalAddress();
        if (targetPhysicalAddress == 65535) {
            return false;
        }
        return HdmiUtils.getLocalPortFromPhysicalAddress(targetPhysicalAddress, physicalAddress) != -1;
    }

    @Deprecated
    @SystemApi
    public boolean isRemoteDeviceConnected(HdmiDeviceInfo targetDevice) {
        Objects.requireNonNull(targetDevice);
        int physicalAddress = this.getLocalPhysicalAddress();
        if (physicalAddress == 65535) {
            return false;
        }
        int targetPhysicalAddress = targetDevice.getPhysicalAddress();
        if (targetPhysicalAddress == 65535) {
            return false;
        }
        return HdmiUtils.getLocalPortFromPhysicalAddress(targetPhysicalAddress, physicalAddress) != -1;
    }

    @SystemApi
    public void addHotplugEventListener(HotplugEventListener listener) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mHotplugEventListeners.containsKey(listener)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiHotplugEventListener wrappedListener = this.getHotplugEventListenerWrapper(listener);
        this.mHotplugEventListeners.put(listener, wrappedListener);
        try {
            this.mService.addHotplugEventListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public void removeHotplugEventListener(HotplugEventListener listener) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiHotplugEventListener wrappedListener = this.mHotplugEventListeners.remove(listener);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHotplugEventListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiHotplugEventListener getHotplugEventListenerWrapper(final HotplugEventListener listener) {
        return new IHdmiHotplugEventListener.Stub(){

            @Override
            public void onReceived(HdmiHotplugEvent event) {
                listener.onReceived(event);
            }
        };
    }

    public void addHdmiControlStatusChangeListener(HdmiControlStatusChangeListener listener) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mHdmiControlStatusChangeListeners.containsKey(listener)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiControlStatusChangeListener wrappedListener = this.getHdmiControlStatusChangeListenerWrapper(listener);
        this.mHdmiControlStatusChangeListeners.put(listener, wrappedListener);
        try {
            this.mService.addHdmiControlStatusChangeListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeHdmiControlStatusChangeListener(HdmiControlStatusChangeListener listener) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiControlStatusChangeListener wrappedListener = this.mHdmiControlStatusChangeListeners.remove(listener);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHdmiControlStatusChangeListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiControlStatusChangeListener getHdmiControlStatusChangeListenerWrapper(final HdmiControlStatusChangeListener listener) {
        return new IHdmiControlStatusChangeListener.Stub(){

            @Override
            public void onStatusChange(boolean isCecEnabled, boolean isCecAvailable) {
                listener.onStatusChange(isCecEnabled, isCecAvailable);
            }
        };
    }

    public void addHdmiCecVolumeControlFeatureListener(Executor executor, HdmiCecVolumeControlFeatureListener listener) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        if (this.mHdmiCecVolumeControlFeatureListeners.containsKey(listener)) {
            Log.e(TAG, "listener is already registered");
            return;
        }
        IHdmiCecVolumeControlFeatureListener wrappedListener = this.createHdmiCecVolumeControlFeatureListenerWrapper(executor, listener);
        this.mHdmiCecVolumeControlFeatureListeners.put(listener, wrappedListener);
        try {
            this.mService.addHdmiCecVolumeControlFeatureListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeHdmiCecVolumeControlFeatureListener(HdmiCecVolumeControlFeatureListener listener) {
        if (this.mService == null) {
            Log.e(TAG, "HdmiControlService is not available");
            return;
        }
        IHdmiCecVolumeControlFeatureListener wrappedListener = this.mHdmiCecVolumeControlFeatureListeners.remove(listener);
        if (wrappedListener == null) {
            Log.e(TAG, "tried to remove not-registered listener");
            return;
        }
        try {
            this.mService.removeHdmiCecVolumeControlFeatureListener(wrappedListener);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private IHdmiCecVolumeControlFeatureListener createHdmiCecVolumeControlFeatureListenerWrapper(final Executor executor, final HdmiCecVolumeControlFeatureListener listener) {
        return new IHdmiCecVolumeControlFeatureListener.Stub(){

            @Override
            public void onHdmiCecVolumeControlFeature(boolean enabled) {
                Binder.clearCallingIdentity();
                executor.execute(() -> listener.onHdmiCecVolumeControlFeature(enabled));
            }
        };
    }

    @SystemApi
    public static interface VendorCommandListener {
        public void onReceived(int var1, int var2, byte[] var3, boolean var4);

        public void onControlStateChanged(boolean var1, int var2);
    }

    public static interface HdmiCecVolumeControlFeatureListener {
        public void onHdmiCecVolumeControlFeature(boolean var1);
    }

    public static interface HdmiControlStatusChangeListener {
        public void onStatusChange(boolean var1, boolean var2);
    }

    @SystemApi
    public static interface HotplugEventListener {
        public void onReceived(HdmiHotplugEvent var1);
    }

    private class ClientHotplugEventListener
    implements HotplugEventListener {
        private ClientHotplugEventListener() {
        }

        @Override
        public void onReceived(HdmiHotplugEvent event) {
            List<Object> ports = new ArrayList();
            try {
                ports = HdmiControlManager.this.mService.getPortInfo();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
            if (ports.isEmpty()) {
                Log.e(HdmiControlManager.TAG, "Can't find port info, not updating connected status. Hotplug event:" + event);
                return;
            }
            for (HdmiPortInfo hdmiPortInfo : ports) {
                if (hdmiPortInfo.getId() != event.getPort()) continue;
                if (hdmiPortInfo.getType() != 1) break;
                HdmiControlManager.this.setLocalPhysicalAddress(event.isConnected() ? hdmiPortInfo.getAddress() : 65535);
                break;
            }
        }
    }

    @SystemApi
    public static @interface ControlCallbackResult {
    }
}

