/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.fingerprint;

import android.hardware.fingerprint.Fingerprint;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IFingerprintServiceReceiver
extends IInterface {
    public void onEnrollResult(long var1, int var3, int var4, int var5) throws RemoteException;

    public void onAcquired(long var1, int var3, int var4) throws RemoteException;

    public void onAuthenticationSucceeded(long var1, Fingerprint var3, int var4, boolean var5) throws RemoteException;

    public void onAuthenticationFailed(long var1) throws RemoteException;

    public void onError(long var1, int var3, int var4) throws RemoteException;

    public void onRemoved(long var1, int var3, int var4, int var5) throws RemoteException;

    public void onEnumerated(long var1, int var3, int var4, int var5) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IFingerprintServiceReceiver {
        private static final String DESCRIPTOR = "android.hardware.fingerprint.IFingerprintServiceReceiver";
        static final int TRANSACTION_onEnrollResult = 1;
        static final int TRANSACTION_onAcquired = 2;
        static final int TRANSACTION_onAuthenticationSucceeded = 3;
        static final int TRANSACTION_onAuthenticationFailed = 4;
        static final int TRANSACTION_onError = 5;
        static final int TRANSACTION_onRemoved = 6;
        static final int TRANSACTION_onEnumerated = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IFingerprintServiceReceiver asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IFingerprintServiceReceiver) {
                return (IFingerprintServiceReceiver)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onEnrollResult";
                }
                case 2: {
                    return "onAcquired";
                }
                case 3: {
                    return "onAuthenticationSucceeded";
                }
                case 4: {
                    return "onAuthenticationFailed";
                }
                case 5: {
                    return "onError";
                }
                case 6: {
                    return "onRemoved";
                }
                case 7: {
                    return "onEnumerated";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.onEnrollResult(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onAcquired(_arg0, _arg1, _arg2);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    Fingerprint _arg1 = 0 != data.readInt() ? Fingerprint.CREATOR.createFromParcel(data) : null;
                    int _arg2 = data.readInt();
                    boolean _arg3 = 0 != data.readInt();
                    this.onAuthenticationSucceeded(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    this.onAuthenticationFailed(_arg0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onError(_arg0, _arg1, _arg2);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.onRemoved(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    this.onEnumerated(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IFingerprintServiceReceiver impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IFingerprintServiceReceiver getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IFingerprintServiceReceiver {
            private IBinder mRemote;
            public static IFingerprintServiceReceiver sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnrollResult(long deviceId, int fingerId, int groupId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(fingerId);
                    _data.writeInt(groupId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnrollResult(deviceId, fingerId, groupId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(acquiredInfo);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAcquired(deviceId, acquiredInfo, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationSucceeded(long deviceId, Fingerprint fp, int userId, boolean isStrongBiometric) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    if (fp != null) {
                        _data.writeInt(1);
                        fp.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    _data.writeInt(isStrongBiometric ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationSucceeded(deviceId, fp, userId, isStrongBiometric);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAuthenticationFailed(long deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAuthenticationFailed(deviceId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(long deviceId, int error, int vendorCode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(error);
                    _data.writeInt(vendorCode);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onError(deviceId, error, vendorCode);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoved(long deviceId, int fingerId, int groupId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(fingerId);
                    _data.writeInt(groupId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoved(deviceId, fingerId, groupId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEnumerated(long deviceId, int fingerId, int groupId, int remaining) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(deviceId);
                    _data.writeInt(fingerId);
                    _data.writeInt(groupId);
                    _data.writeInt(remaining);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onEnumerated(deviceId, fingerId, groupId, remaining);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IFingerprintServiceReceiver {
        @Override
        public void onEnrollResult(long deviceId, int fingerId, int groupId, int remaining) throws RemoteException {
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo, int vendorCode) throws RemoteException {
        }

        @Override
        public void onAuthenticationSucceeded(long deviceId, Fingerprint fp, int userId, boolean isStrongBiometric) throws RemoteException {
        }

        @Override
        public void onAuthenticationFailed(long deviceId) throws RemoteException {
        }

        @Override
        public void onError(long deviceId, int error, int vendorCode) throws RemoteException {
        }

        @Override
        public void onRemoved(long deviceId, int fingerId, int groupId, int remaining) throws RemoteException {
        }

        @Override
        public void onEnumerated(long deviceId, int fingerId, int groupId, int remaining) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

