/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Objects;

public class DeviceProductInfo
implements Parcelable {
    private final String mName;
    private final String mManufacturerPnpId;
    private final String mProductId;
    private final Integer mModelYear;
    private final ManufactureDate mManufactureDate;
    private final int[] mRelativeAddress;
    public static final Parcelable.Creator<DeviceProductInfo> CREATOR = new Parcelable.Creator<DeviceProductInfo>(){

        @Override
        public DeviceProductInfo createFromParcel(Parcel in) {
            return new DeviceProductInfo(in);
        }

        public DeviceProductInfo[] newArray(int size) {
            return new DeviceProductInfo[size];
        }
    };

    public DeviceProductInfo(String name, String manufacturerPnpId, String productId, Integer modelYear, ManufactureDate manufactureDate, int[] relativeAddress) {
        this.mName = name;
        this.mManufacturerPnpId = manufacturerPnpId;
        this.mProductId = productId;
        this.mModelYear = modelYear;
        this.mManufactureDate = manufactureDate;
        this.mRelativeAddress = relativeAddress;
    }

    private DeviceProductInfo(Parcel in) {
        this.mName = in.readString();
        this.mManufacturerPnpId = in.readString();
        this.mProductId = (String)in.readValue(null);
        this.mModelYear = (Integer)in.readValue(null);
        this.mManufactureDate = (ManufactureDate)in.readValue(null);
        this.mRelativeAddress = in.createIntArray();
    }

    public String getName() {
        return this.mName;
    }

    public String getManufacturerPnpId() {
        return this.mManufacturerPnpId;
    }

    public String getProductId() {
        return this.mProductId;
    }

    public Integer getModelYear() {
        return this.mModelYear;
    }

    public ManufactureDate getManufactureDate() {
        return this.mManufactureDate;
    }

    public int[] getRelativeAddress() {
        return this.mRelativeAddress;
    }

    public String toString() {
        return "DeviceProductInfo{name=" + this.mName + ", manufacturerPnpId=" + this.mManufacturerPnpId + ", productId=" + this.mProductId + ", modelYear=" + this.mModelYear + ", manufactureDate=" + this.mManufactureDate + ", relativeAddress=" + Arrays.toString(this.mRelativeAddress) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceProductInfo that = (DeviceProductInfo)o;
        return Objects.equals(this.mName, that.mName) && Objects.equals(this.mManufacturerPnpId, that.mManufacturerPnpId) && Objects.equals(this.mProductId, that.mProductId) && Objects.equals(this.mModelYear, that.mModelYear) && Objects.equals(this.mManufactureDate, that.mManufactureDate) && Arrays.equals(this.mRelativeAddress, that.mRelativeAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mName, this.mManufacturerPnpId, this.mProductId, this.mModelYear, this.mManufactureDate, Arrays.hashCode(this.mRelativeAddress));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mName);
        dest.writeString(this.mManufacturerPnpId);
        dest.writeValue(this.mProductId);
        dest.writeValue(this.mModelYear);
        dest.writeValue(this.mManufactureDate);
        dest.writeIntArray(this.mRelativeAddress);
    }

    public static class ManufactureDate
    implements Parcelable {
        private final Integer mWeek;
        private final Integer mYear;
        public static final Parcelable.Creator<ManufactureDate> CREATOR = new Parcelable.Creator<ManufactureDate>(){

            @Override
            public ManufactureDate createFromParcel(Parcel in) {
                return new ManufactureDate(in);
            }

            public ManufactureDate[] newArray(int size) {
                return new ManufactureDate[size];
            }
        };

        public ManufactureDate(Integer week, Integer year) {
            this.mWeek = week;
            this.mYear = year;
        }

        protected ManufactureDate(Parcel in) {
            this.mWeek = (Integer)in.readValue(null);
            this.mYear = (Integer)in.readValue(null);
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeValue(this.mWeek);
            dest.writeValue(this.mYear);
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Integer getYear() {
            return this.mYear;
        }

        public Integer getWeek() {
            return this.mWeek;
        }

        public String toString() {
            return "ManufactureDate{week=" + this.mWeek + ", year=" + this.mYear + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManufactureDate that = (ManufactureDate)o;
            return Objects.equals(this.mWeek, that.mWeek) && Objects.equals(this.mYear, that.mYear);
        }

        public int hashCode() {
            return Objects.hash(this.mWeek, this.mYear);
        }
    }
}

