/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.display;

import android.annotation.SystemApi;
import android.hardware.display.BrightnessCorrection;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@SystemApi
public class BrightnessConfiguration
implements Parcelable {
    private static final String TAG_BRIGHTNESS_CURVE = "brightness-curve";
    private static final String TAG_BRIGHTNESS_POINT = "brightness-point";
    private static final String TAG_BRIGHTNESS_CORRECTIONS = "brightness-corrections";
    private static final String TAG_BRIGHTNESS_CORRECTION = "brightness-correction";
    private static final String TAG_BRIGHTNESS_PARAMS = "brightness-params";
    private static final String ATTR_LUX = "lux";
    private static final String ATTR_NITS = "nits";
    private static final String ATTR_DESCRIPTION = "description";
    private static final String ATTR_PACKAGE_NAME = "package-name";
    private static final String ATTR_CATEGORY = "category";
    private static final String ATTR_COLLECT_COLOR = "collect-color";
    private static final String ATTR_MODEL_TIMEOUT = "model-timeout";
    private static final String ATTR_MODEL_LOWER_BOUND = "model-lower-bound";
    private static final String ATTR_MODEL_UPPER_BOUND = "model-upper-bound";
    public static final long SHORT_TERM_TIMEOUT_UNSET = -1L;
    private final float[] mLux;
    private final float[] mNits;
    private final Map<String, BrightnessCorrection> mCorrectionsByPackageName;
    private final Map<Integer, BrightnessCorrection> mCorrectionsByCategory;
    private final String mDescription;
    private final boolean mShouldCollectColorSamples;
    private final long mShortTermModelTimeout;
    private final float mShortTermModelLowerLuxMultiplier;
    private final float mShortTermModelUpperLuxMultiplier;
    public static final Parcelable.Creator<BrightnessConfiguration> CREATOR = new Parcelable.Creator<BrightnessConfiguration>(){

        @Override
        public BrightnessConfiguration createFromParcel(Parcel in) {
            BrightnessCorrection correction;
            int i;
            float[] lux = in.createFloatArray();
            float[] nits = in.createFloatArray();
            Builder builder = new Builder(lux, nits);
            int n = in.readInt();
            for (i = 0; i < n; ++i) {
                String packageName = in.readString();
                correction = BrightnessCorrection.CREATOR.createFromParcel(in);
                builder.addCorrectionByPackageName(packageName, correction);
            }
            n = in.readInt();
            for (i = 0; i < n; ++i) {
                int category = in.readInt();
                correction = BrightnessCorrection.CREATOR.createFromParcel(in);
                builder.addCorrectionByCategory(category, correction);
            }
            String description = in.readString();
            builder.setDescription(description);
            boolean shouldCollectColorSamples = in.readBoolean();
            builder.setShouldCollectColorSamples(shouldCollectColorSamples);
            builder.setShortTermModelTimeoutMillis(in.readLong());
            builder.setShortTermModelLowerLuxMultiplier(in.readFloat());
            builder.setShortTermModelUpperLuxMultiplier(in.readFloat());
            return builder.build();
        }

        public BrightnessConfiguration[] newArray(int size) {
            return new BrightnessConfiguration[size];
        }
    };

    private BrightnessConfiguration(float[] lux, float[] nits, Map<String, BrightnessCorrection> correctionsByPackageName, Map<Integer, BrightnessCorrection> correctionsByCategory, String description, boolean shouldCollectColorSamples, long shortTermModelTimeout, float shortTermModelLowerLuxMultiplier, float shortTermModelUpperLuxMultiplier) {
        this.mLux = lux;
        this.mNits = nits;
        this.mCorrectionsByPackageName = correctionsByPackageName;
        this.mCorrectionsByCategory = correctionsByCategory;
        this.mDescription = description;
        this.mShouldCollectColorSamples = shouldCollectColorSamples;
        this.mShortTermModelTimeout = shortTermModelTimeout;
        this.mShortTermModelLowerLuxMultiplier = shortTermModelLowerLuxMultiplier;
        this.mShortTermModelUpperLuxMultiplier = shortTermModelUpperLuxMultiplier;
    }

    public Pair<float[], float[]> getCurve() {
        return Pair.create(Arrays.copyOf(this.mLux, this.mLux.length), Arrays.copyOf(this.mNits, this.mNits.length));
    }

    public BrightnessCorrection getCorrectionByPackageName(String packageName) {
        return this.mCorrectionsByPackageName.get(packageName);
    }

    public BrightnessCorrection getCorrectionByCategory(int category) {
        return this.mCorrectionsByCategory.get(category);
    }

    public String getDescription() {
        return this.mDescription;
    }

    public boolean shouldCollectColorSamples() {
        return this.mShouldCollectColorSamples;
    }

    public long getShortTermModelTimeoutMillis() {
        return this.mShortTermModelTimeout;
    }

    public float getShortTermModelUpperLuxMultiplier() {
        return this.mShortTermModelUpperLuxMultiplier;
    }

    public float getShortTermModelLowerLuxMultiplier() {
        return this.mShortTermModelLowerLuxMultiplier;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        BrightnessCorrection correction;
        dest.writeFloatArray(this.mLux);
        dest.writeFloatArray(this.mNits);
        dest.writeInt(this.mCorrectionsByPackageName.size());
        for (Map.Entry<String, BrightnessCorrection> entry : this.mCorrectionsByPackageName.entrySet()) {
            String packageName = entry.getKey();
            correction = entry.getValue();
            dest.writeString(packageName);
            correction.writeToParcel(dest, flags);
        }
        dest.writeInt(this.mCorrectionsByCategory.size());
        for (Map.Entry<Object, BrightnessCorrection> entry : this.mCorrectionsByCategory.entrySet()) {
            int category = (Integer)entry.getKey();
            correction = entry.getValue();
            dest.writeInt(category);
            correction.writeToParcel(dest, flags);
        }
        dest.writeString(this.mDescription);
        dest.writeBoolean(this.mShouldCollectColorSamples);
        dest.writeLong(this.mShortTermModelTimeout);
        dest.writeFloat(this.mShortTermModelLowerLuxMultiplier);
        dest.writeFloat(this.mShortTermModelUpperLuxMultiplier);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BrightnessConfiguration{[");
        int size = this.mLux.length;
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append("(").append(this.mLux[i]).append(", ").append(this.mNits[i]).append(")");
        }
        sb.append("], {");
        for (Map.Entry<String, BrightnessCorrection> entry : this.mCorrectionsByPackageName.entrySet()) {
            sb.append("'" + entry.getKey() + "': " + entry.getValue() + ", ");
        }
        for (Map.Entry<Object, BrightnessCorrection> entry : this.mCorrectionsByCategory.entrySet()) {
            sb.append(entry.getKey() + ": " + entry.getValue() + ", ");
        }
        sb.append("}, '");
        if (this.mDescription != null) {
            sb.append(this.mDescription);
        }
        sb.append(", shouldCollectColorSamples = " + this.mShouldCollectColorSamples);
        if (this.mShortTermModelTimeout >= 0L) {
            sb.append(", shortTermModelTimeout = " + this.mShortTermModelTimeout);
        }
        if (!Float.isNaN(this.mShortTermModelLowerLuxMultiplier)) {
            sb.append(", shortTermModelLowerLuxMultiplier = " + this.mShortTermModelLowerLuxMultiplier);
        }
        if (!Float.isNaN(this.mShortTermModelLowerLuxMultiplier)) {
            sb.append(", shortTermModelUpperLuxMultiplier = " + this.mShortTermModelUpperLuxMultiplier);
        }
        sb.append("'}");
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + Arrays.hashCode(this.mLux);
        result = result * 31 + Arrays.hashCode(this.mNits);
        result = result * 31 + this.mCorrectionsByPackageName.hashCode();
        result = result * 31 + this.mCorrectionsByCategory.hashCode();
        if (this.mDescription != null) {
            result = result * 31 + this.mDescription.hashCode();
        }
        result = result * 31 + Boolean.hashCode(this.mShouldCollectColorSamples);
        result = result * 31 + Long.hashCode(this.mShortTermModelTimeout);
        result = result * 31 + Float.hashCode(this.mShortTermModelLowerLuxMultiplier);
        result = result * 31 + Float.hashCode(this.mShortTermModelUpperLuxMultiplier);
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrightnessConfiguration)) {
            return false;
        }
        BrightnessConfiguration other = (BrightnessConfiguration)o;
        return Arrays.equals(this.mLux, other.mLux) && Arrays.equals(this.mNits, other.mNits) && this.mCorrectionsByPackageName.equals(other.mCorrectionsByPackageName) && this.mCorrectionsByCategory.equals(other.mCorrectionsByCategory) && Objects.equals(this.mDescription, other.mDescription) && this.mShouldCollectColorSamples == other.mShouldCollectColorSamples && this.mShortTermModelTimeout == other.mShortTermModelTimeout && this.checkFloatEquals(this.mShortTermModelLowerLuxMultiplier, other.mShortTermModelLowerLuxMultiplier) && this.checkFloatEquals(this.mShortTermModelUpperLuxMultiplier, other.mShortTermModelUpperLuxMultiplier);
    }

    private boolean checkFloatEquals(float one, float two) {
        if (Float.isNaN(one) && Float.isNaN(two)) {
            return true;
        }
        return one == two;
    }

    public void saveToXml(XmlSerializer serializer) throws IOException {
        BrightnessCorrection correction;
        serializer.startTag(null, TAG_BRIGHTNESS_CURVE);
        if (this.mDescription != null) {
            serializer.attribute(null, ATTR_DESCRIPTION, this.mDescription);
        }
        for (int i = 0; i < this.mLux.length; ++i) {
            serializer.startTag(null, TAG_BRIGHTNESS_POINT);
            serializer.attribute(null, ATTR_LUX, Float.toString(this.mLux[i]));
            serializer.attribute(null, ATTR_NITS, Float.toString(this.mNits[i]));
            serializer.endTag(null, TAG_BRIGHTNESS_POINT);
        }
        serializer.endTag(null, TAG_BRIGHTNESS_CURVE);
        serializer.startTag(null, TAG_BRIGHTNESS_CORRECTIONS);
        for (Map.Entry<String, BrightnessCorrection> entry : this.mCorrectionsByPackageName.entrySet()) {
            String packageName = entry.getKey();
            correction = entry.getValue();
            serializer.startTag(null, TAG_BRIGHTNESS_CORRECTION);
            serializer.attribute(null, ATTR_PACKAGE_NAME, packageName);
            correction.saveToXml(serializer);
            serializer.endTag(null, TAG_BRIGHTNESS_CORRECTION);
        }
        for (Map.Entry<Object, BrightnessCorrection> entry : this.mCorrectionsByCategory.entrySet()) {
            int category = (Integer)entry.getKey();
            correction = entry.getValue();
            serializer.startTag(null, TAG_BRIGHTNESS_CORRECTION);
            serializer.attribute(null, ATTR_CATEGORY, Integer.toString(category));
            correction.saveToXml(serializer);
            serializer.endTag(null, TAG_BRIGHTNESS_CORRECTION);
        }
        serializer.endTag(null, TAG_BRIGHTNESS_CORRECTIONS);
        serializer.startTag(null, TAG_BRIGHTNESS_PARAMS);
        if (this.mShouldCollectColorSamples) {
            serializer.attribute(null, ATTR_COLLECT_COLOR, Boolean.toString(true));
        }
        if (this.mShortTermModelTimeout >= 0L) {
            serializer.attribute(null, ATTR_MODEL_TIMEOUT, Long.toString(this.mShortTermModelTimeout));
        }
        if (!Float.isNaN(this.mShortTermModelLowerLuxMultiplier)) {
            serializer.attribute(null, ATTR_MODEL_LOWER_BOUND, Float.toString(this.mShortTermModelLowerLuxMultiplier));
        }
        if (!Float.isNaN(this.mShortTermModelUpperLuxMultiplier)) {
            serializer.attribute(null, ATTR_MODEL_UPPER_BOUND, Float.toString(this.mShortTermModelUpperLuxMultiplier));
        }
        serializer.endTag(null, TAG_BRIGHTNESS_PARAMS);
    }

    public static BrightnessConfiguration loadFromXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        BrightnessCorrection correction;
        String description = null;
        ArrayList<Float> luxList = new ArrayList<Float>();
        ArrayList<Float> nitsList = new ArrayList<Float>();
        HashMap<String, BrightnessCorrection> correctionsByPackageName = new HashMap<String, BrightnessCorrection>();
        HashMap<Integer, BrightnessCorrection> correctionsByCategory = new HashMap<Integer, BrightnessCorrection>();
        boolean shouldCollectColorSamples = false;
        long shortTermModelTimeout = -1L;
        float shortTermModelLowerLuxMultiplier = Float.NaN;
        float shortTermModelUpperLuxMultiplier = Float.NaN;
        int configDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, configDepth)) {
            if (TAG_BRIGHTNESS_CURVE.equals(parser.getName())) {
                description = parser.getAttributeValue(null, ATTR_DESCRIPTION);
                int curveDepth = parser.getDepth();
                while (XmlUtils.nextElementWithin(parser, curveDepth)) {
                    if (!TAG_BRIGHTNESS_POINT.equals(parser.getName())) continue;
                    float lux = BrightnessConfiguration.loadFloatFromXml(parser, ATTR_LUX);
                    float nits = BrightnessConfiguration.loadFloatFromXml(parser, ATTR_NITS);
                    luxList.add(Float.valueOf(lux));
                    nitsList.add(Float.valueOf(nits));
                }
                continue;
            }
            if (TAG_BRIGHTNESS_CORRECTIONS.equals(parser.getName())) {
                int correctionsDepth = parser.getDepth();
                while (XmlUtils.nextElementWithin(parser, correctionsDepth)) {
                    if (!TAG_BRIGHTNESS_CORRECTION.equals(parser.getName())) continue;
                    String packageName = parser.getAttributeValue(null, ATTR_PACKAGE_NAME);
                    String categoryText = parser.getAttributeValue(null, ATTR_CATEGORY);
                    BrightnessCorrection correction2 = BrightnessCorrection.loadFromXml(parser);
                    if (packageName != null) {
                        correctionsByPackageName.put(packageName, correction2);
                        continue;
                    }
                    if (categoryText == null) continue;
                    try {
                        int category = Integer.parseInt(categoryText);
                        correctionsByCategory.put(category, correction2);
                    }
                    catch (NullPointerException | NumberFormatException e) {}
                }
                continue;
            }
            if (!TAG_BRIGHTNESS_PARAMS.equals(parser.getName())) continue;
            shouldCollectColorSamples = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_COLLECT_COLOR));
            Long timeout = BrightnessConfiguration.loadLongFromXml(parser, ATTR_MODEL_TIMEOUT);
            if (timeout != null) {
                shortTermModelTimeout = timeout;
            }
            shortTermModelLowerLuxMultiplier = BrightnessConfiguration.loadFloatFromXml(parser, ATTR_MODEL_LOWER_BOUND);
            shortTermModelUpperLuxMultiplier = BrightnessConfiguration.loadFloatFromXml(parser, ATTR_MODEL_UPPER_BOUND);
        }
        int n = luxList.size();
        float[] lux = new float[n];
        float[] nits = new float[n];
        for (int i = 0; i < n; ++i) {
            lux[i] = ((Float)luxList.get(i)).floatValue();
            nits[i] = ((Float)nitsList.get(i)).floatValue();
        }
        Builder builder = new Builder(lux, nits);
        builder.setDescription(description);
        for (Map.Entry entry : correctionsByPackageName.entrySet()) {
            String packageName = (String)entry.getKey();
            correction = (BrightnessCorrection)entry.getValue();
            builder.addCorrectionByPackageName(packageName, correction);
        }
        for (Map.Entry entry : correctionsByCategory.entrySet()) {
            int category = (Integer)entry.getKey();
            correction = (BrightnessCorrection)entry.getValue();
            builder.addCorrectionByCategory(category, correction);
        }
        builder.setShouldCollectColorSamples(shouldCollectColorSamples);
        builder.setShortTermModelTimeoutMillis(shortTermModelTimeout);
        builder.setShortTermModelLowerLuxMultiplier(shortTermModelLowerLuxMultiplier);
        builder.setShortTermModelUpperLuxMultiplier(shortTermModelUpperLuxMultiplier);
        return builder.build();
    }

    private static float loadFloatFromXml(XmlPullParser parser, String attribute) {
        String string2 = parser.getAttributeValue(null, attribute);
        try {
            return Float.parseFloat(string2);
        }
        catch (NullPointerException | NumberFormatException e) {
            return Float.NaN;
        }
    }

    private static Long loadLongFromXml(XmlPullParser parser, String attribute) {
        String string2 = parser.getAttributeValue(null, attribute);
        try {
            return Long.parseLong(string2);
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            return null;
        }
    }

    public static class Builder {
        private static final int MAX_CORRECTIONS_BY_PACKAGE_NAME = 20;
        private static final int MAX_CORRECTIONS_BY_CATEGORY = 20;
        private float[] mCurveLux;
        private float[] mCurveNits;
        private Map<String, BrightnessCorrection> mCorrectionsByPackageName;
        private Map<Integer, BrightnessCorrection> mCorrectionsByCategory;
        private String mDescription;
        private boolean mShouldCollectColorSamples;
        private long mShortTermModelTimeout = -1L;
        private float mShortTermModelLowerLuxMultiplier = Float.NaN;
        private float mShortTermModelUpperLuxMultiplier = Float.NaN;

        public Builder(float[] lux, float[] nits) {
            Objects.requireNonNull(lux);
            Objects.requireNonNull(nits);
            if (lux.length == 0 || nits.length == 0) {
                throw new IllegalArgumentException("Lux and nits arrays must not be empty");
            }
            if (lux.length != nits.length) {
                throw new IllegalArgumentException("Lux and nits arrays must be the same length");
            }
            if (lux[0] != 0.0f) {
                throw new IllegalArgumentException("Initial control point must be for 0 lux");
            }
            Preconditions.checkArrayElementsInRange(lux, 0.0f, Float.MAX_VALUE, BrightnessConfiguration.ATTR_LUX);
            Preconditions.checkArrayElementsInRange(nits, 0.0f, Float.MAX_VALUE, BrightnessConfiguration.ATTR_NITS);
            Builder.checkMonotonic(lux, true, BrightnessConfiguration.ATTR_LUX);
            Builder.checkMonotonic(nits, false, BrightnessConfiguration.ATTR_NITS);
            this.mCurveLux = lux;
            this.mCurveNits = nits;
            this.mCorrectionsByPackageName = new HashMap<String, BrightnessCorrection>();
            this.mCorrectionsByCategory = new HashMap<Integer, BrightnessCorrection>();
        }

        public int getMaxCorrectionsByPackageName() {
            return 20;
        }

        public int getMaxCorrectionsByCategory() {
            return 20;
        }

        public Builder addCorrectionByPackageName(String packageName, BrightnessCorrection correction) {
            Objects.requireNonNull(packageName, "packageName must not be null");
            Objects.requireNonNull(correction, "correction must not be null");
            if (this.mCorrectionsByPackageName.size() >= this.getMaxCorrectionsByPackageName()) {
                throw new IllegalArgumentException("Too many corrections by package name");
            }
            this.mCorrectionsByPackageName.put(packageName, correction);
            return this;
        }

        public Builder addCorrectionByCategory(int category, BrightnessCorrection correction) {
            Objects.requireNonNull(correction, "correction must not be null");
            if (this.mCorrectionsByCategory.size() >= this.getMaxCorrectionsByCategory()) {
                throw new IllegalArgumentException("Too many corrections by category");
            }
            this.mCorrectionsByCategory.put(category, correction);
            return this;
        }

        public Builder setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        public Builder setShouldCollectColorSamples(boolean shouldCollectColorSamples) {
            this.mShouldCollectColorSamples = shouldCollectColorSamples;
            return this;
        }

        public Builder setShortTermModelTimeoutMillis(long shortTermModelTimeoutMillis) {
            this.mShortTermModelTimeout = shortTermModelTimeoutMillis;
            return this;
        }

        public Builder setShortTermModelUpperLuxMultiplier(float shortTermModelUpperLuxMultiplier) {
            if (shortTermModelUpperLuxMultiplier < 0.0f) {
                throw new IllegalArgumentException("Negative lux multiplier");
            }
            this.mShortTermModelUpperLuxMultiplier = shortTermModelUpperLuxMultiplier;
            return this;
        }

        public Builder setShortTermModelLowerLuxMultiplier(float shortTermModelLowerLuxMultiplier) {
            if (shortTermModelLowerLuxMultiplier < 0.0f) {
                throw new IllegalArgumentException("Negative lux multiplier");
            }
            this.mShortTermModelLowerLuxMultiplier = shortTermModelLowerLuxMultiplier;
            return this;
        }

        public BrightnessConfiguration build() {
            if (this.mCurveLux == null || this.mCurveNits == null) {
                throw new IllegalStateException("A curve must be set!");
            }
            return new BrightnessConfiguration(this.mCurveLux, this.mCurveNits, this.mCorrectionsByPackageName, this.mCorrectionsByCategory, this.mDescription, this.mShouldCollectColorSamples, this.mShortTermModelTimeout, this.mShortTermModelLowerLuxMultiplier, this.mShortTermModelUpperLuxMultiplier);
        }

        private static void checkMonotonic(float[] vals, boolean strictlyIncreasing, String name) {
            if (vals.length <= 1) {
                return;
            }
            float prev = vals[0];
            for (int i = 1; i < vals.length; ++i) {
                if (prev > vals[i] || prev == vals[i] && strictlyIncreasing) {
                    String condition = strictlyIncreasing ? "strictly increasing" : "monotonic";
                    throw new IllegalArgumentException(name + " values must be " + condition);
                }
                prev = vals[i];
            }
        }
    }
}

