/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.impl;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.GetCommand;
import android.hardware.camera2.impl.SetCommand;
import android.hardware.camera2.marshal.MarshalQueryable;
import android.hardware.camera2.marshal.MarshalRegistry;
import android.hardware.camera2.marshal.Marshaler;
import android.hardware.camera2.marshal.impl.MarshalQueryableArray;
import android.hardware.camera2.marshal.impl.MarshalQueryableBlackLevelPattern;
import android.hardware.camera2.marshal.impl.MarshalQueryableBoolean;
import android.hardware.camera2.marshal.impl.MarshalQueryableColorSpaceTransform;
import android.hardware.camera2.marshal.impl.MarshalQueryableEnum;
import android.hardware.camera2.marshal.impl.MarshalQueryableHighSpeedVideoConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableMeteringRectangle;
import android.hardware.camera2.marshal.impl.MarshalQueryableNativeByteToInteger;
import android.hardware.camera2.marshal.impl.MarshalQueryablePair;
import android.hardware.camera2.marshal.impl.MarshalQueryableParcelable;
import android.hardware.camera2.marshal.impl.MarshalQueryablePrimitive;
import android.hardware.camera2.marshal.impl.MarshalQueryableRange;
import android.hardware.camera2.marshal.impl.MarshalQueryableRecommendedStreamConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableRect;
import android.hardware.camera2.marshal.impl.MarshalQueryableReprocessFormatsMap;
import android.hardware.camera2.marshal.impl.MarshalQueryableRggbChannelVector;
import android.hardware.camera2.marshal.impl.MarshalQueryableSize;
import android.hardware.camera2.marshal.impl.MarshalQueryableSizeF;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfiguration;
import android.hardware.camera2.marshal.impl.MarshalQueryableStreamConfigurationDuration;
import android.hardware.camera2.marshal.impl.MarshalQueryableString;
import android.hardware.camera2.params.Capability;
import android.hardware.camera2.params.Face;
import android.hardware.camera2.params.HighSpeedVideoConfiguration;
import android.hardware.camera2.params.LensShadingMap;
import android.hardware.camera2.params.MandatoryStreamCombination;
import android.hardware.camera2.params.OisSample;
import android.hardware.camera2.params.RecommendedStreamConfiguration;
import android.hardware.camera2.params.RecommendedStreamConfigurationMap;
import android.hardware.camera2.params.ReprocessFormatsMap;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.params.StreamConfigurationDuration;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.hardware.camera2.params.TonemapCurve;
import android.hardware.camera2.utils.TypeReference;
import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ServiceSpecificException;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CameraMetadataNative
implements Parcelable {
    private static final String TAG = "CameraMetadataJV";
    private static final boolean DEBUG = false;
    public static final int NATIVE_JPEG_FORMAT = 33;
    private static final String CELLID_PROCESS = "CELLID";
    private static final String GPS_PROCESS = "GPS";
    private static final int FACE_LANDMARK_SIZE = 6;
    public static final Parcelable.Creator<CameraMetadataNative> CREATOR = new Parcelable.Creator<CameraMetadataNative>(){

        @Override
        public CameraMetadataNative createFromParcel(Parcel in) {
            CameraMetadataNative metadata = new CameraMetadataNative();
            metadata.readFromParcel(in);
            return metadata;
        }

        public CameraMetadataNative[] newArray(int size) {
            return new CameraMetadataNative[size];
        }
    };
    public static final int TYPE_BYTE = 0;
    public static final int TYPE_INT32 = 1;
    public static final int TYPE_FLOAT = 2;
    public static final int TYPE_INT64 = 3;
    public static final int TYPE_DOUBLE = 4;
    public static final int TYPE_RATIONAL = 5;
    public static final int NUM_TYPES = 6;
    private static final HashMap<Key<?>, GetCommand> sGetCommandMap = new HashMap();
    private static final HashMap<Key<?>, SetCommand> sSetCommandMap;
    private int mCameraId = -1;
    private boolean mHasMandatoryConcurrentStreams = false;
    private Size mDisplaySize = new Size(0, 0);
    @UnsupportedAppUsage
    private long mMetadataPtr;

    private static String translateLocationProviderToProcess(String provider) {
        if (provider == null) {
            return null;
        }
        switch (provider) {
            case "gps": {
                return GPS_PROCESS;
            }
            case "network": {
                return CELLID_PROCESS;
            }
        }
        return null;
    }

    private static String translateProcessToLocationProvider(String process) {
        if (process == null) {
            return null;
        }
        switch (process) {
            case "GPS": {
                return "gps";
            }
            case "CELLID": {
                return "network";
            }
        }
        return null;
    }

    public CameraMetadataNative() {
        this.mMetadataPtr = CameraMetadataNative.nativeAllocate();
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    public CameraMetadataNative(CameraMetadataNative other) {
        this.mMetadataPtr = CameraMetadataNative.nativeAllocateCopy(other.mMetadataPtr);
        if (this.mMetadataPtr == 0L) {
            throw new OutOfMemoryError("Failed to allocate native CameraMetadata");
        }
    }

    public static CameraMetadataNative move(CameraMetadataNative other) {
        CameraMetadataNative newObject = new CameraMetadataNative();
        newObject.swap(other);
        return newObject;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        CameraMetadataNative.nativeWriteToParcel(dest, this.mMetadataPtr);
    }

    public <T> T get(CameraCharacteristics.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(CaptureResult.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(CaptureRequest.Key<T> key) {
        return this.get(key.getNativeKey());
    }

    public <T> T get(Key<T> key) {
        Objects.requireNonNull(key, "key must not be null");
        GetCommand g = sGetCommandMap.get(key);
        if (g != null) {
            return g.getValue(this, key);
        }
        return this.getBase(key);
    }

    public void readFromParcel(Parcel in) {
        CameraMetadataNative.nativeReadFromParcel(in, this.mMetadataPtr);
    }

    public static void setupGlobalVendorTagDescriptor() throws ServiceSpecificException {
        int err = CameraMetadataNative.nativeSetupGlobalVendorTagDescriptor();
        if (err != 0) {
            throw new ServiceSpecificException(err, "Failure to set up global vendor tags");
        }
    }

    private static int nativeSetupGlobalVendorTagDescriptor() {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeSetupGlobalVendorTagDescriptor()I", true, null);
    }

    public <T> void set(Key<T> key, T value) {
        SetCommand s = sSetCommandMap.get(key);
        if (s != null) {
            s.setValue(this, value);
            return;
        }
        this.setBase(key, value);
    }

    public <T> void set(CaptureRequest.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    public <T> void set(CaptureResult.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    public <T> void set(CameraCharacteristics.Key<T> key, T value) {
        this.set(key.getNativeKey(), value);
    }

    private void close() {
        CameraMetadataNative.nativeClose(this.mMetadataPtr);
        this.mMetadataPtr = 0L;
    }

    private <T> T getBase(CameraCharacteristics.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(CaptureResult.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(CaptureRequest.Key<T> key) {
        return this.getBase(key.getNativeKey());
    }

    private <T> T getBase(Key<T> key) {
        int tag;
        if (key.hasTag()) {
            tag = key.getTag();
        } else {
            tag = CameraMetadataNative.nativeGetTagFromKeyLocal(this.mMetadataPtr, key.getName());
            key.cacheTag(tag);
        }
        byte[] values = this.readValues(tag);
        if (values == null) {
            if (((Key)key).mFallbackName == null) {
                return null;
            }
            tag = CameraMetadataNative.nativeGetTagFromKeyLocal(this.mMetadataPtr, ((Key)key).mFallbackName);
            values = this.readValues(tag);
            if (values == null) {
                return null;
            }
        }
        int nativeType = CameraMetadataNative.nativeGetTypeFromTagLocal(this.mMetadataPtr, tag);
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key, nativeType);
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        return marshaler.unmarshal(buffer);
    }

    private int[] getAvailableFormats() {
        int[] availableFormats = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS);
        if (availableFormats != null) {
            for (int i = 0; i < availableFormats.length; ++i) {
                if (availableFormats[i] != 33) continue;
                availableFormats[i] = 256;
            }
        }
        return availableFormats;
    }

    private boolean setFaces(Face[] faces) {
        if (faces == null) {
            return false;
        }
        int numFaces = faces.length;
        boolean fullMode = true;
        for (Face face : faces) {
            if (face == null) {
                --numFaces;
                Log.w(TAG, "setFaces - null face detected, skipping");
                continue;
            }
            if (face.getId() != -1) continue;
            fullMode = false;
        }
        Rect[] faceRectangles = new Rect[numFaces];
        byte[] faceScores = new byte[numFaces];
        int[] faceIds = null;
        int[] faceLandmarks = null;
        if (fullMode) {
            faceIds = new int[numFaces];
            faceLandmarks = new int[numFaces * 6];
        }
        int i = 0;
        for (Face face : faces) {
            if (face == null) continue;
            faceRectangles[i] = face.getBounds();
            faceScores[i] = (byte)face.getScore();
            if (fullMode) {
                faceIds[i] = face.getId();
                int j = 0;
                faceLandmarks[i * 6 + j++] = face.getLeftEyePosition().x;
                faceLandmarks[i * 6 + j++] = face.getLeftEyePosition().y;
                faceLandmarks[i * 6 + j++] = face.getRightEyePosition().x;
                faceLandmarks[i * 6 + j++] = face.getRightEyePosition().y;
                faceLandmarks[i * 6 + j++] = face.getMouthPosition().x;
                faceLandmarks[i * 6 + j++] = face.getMouthPosition().y;
            }
            ++i;
        }
        this.set(CaptureResult.STATISTICS_FACE_RECTANGLES, faceRectangles);
        this.set(CaptureResult.STATISTICS_FACE_IDS, faceIds);
        this.set(CaptureResult.STATISTICS_FACE_LANDMARKS, faceLandmarks);
        this.set(CaptureResult.STATISTICS_FACE_SCORES, faceScores);
        return true;
    }

    private Face[] getFaces() {
        int i;
        int[] faceLandmarks;
        int[] faceIds;
        Rect[] faceRectangles;
        byte[] faceScores;
        Integer faceDetectMode = this.get(CaptureResult.STATISTICS_FACE_DETECT_MODE);
        if (CameraMetadataNative.areValuesAllNull(faceDetectMode, faceScores = this.get(CaptureResult.STATISTICS_FACE_SCORES), faceRectangles = this.get(CaptureResult.STATISTICS_FACE_RECTANGLES), faceIds = this.get(CaptureResult.STATISTICS_FACE_IDS), faceLandmarks = this.get(CaptureResult.STATISTICS_FACE_LANDMARKS))) {
            return null;
        }
        if (faceDetectMode == null) {
            Log.w(TAG, "Face detect mode metadata is null, assuming the mode is SIMPLE");
            faceDetectMode = 1;
        } else if (faceDetectMode > 2) {
            faceDetectMode = 2;
        } else {
            if (faceDetectMode == 0) {
                return new Face[0];
            }
            if (faceDetectMode != 1 && faceDetectMode != 2) {
                Log.w(TAG, "Unknown face detect mode: " + faceDetectMode);
                return new Face[0];
            }
        }
        if (faceScores == null || faceRectangles == null) {
            Log.w(TAG, "Expect face scores and rectangles to be non-null");
            return new Face[0];
        }
        if (faceScores.length != faceRectangles.length) {
            Log.w(TAG, String.format("Face score size(%d) doesn match face rectangle size(%d)!", faceScores.length, faceRectangles.length));
        }
        int numFaces = Math.min(faceScores.length, faceRectangles.length);
        if (faceDetectMode == 2) {
            if (faceIds == null || faceLandmarks == null) {
                Log.w(TAG, "Expect face ids and landmarks to be non-null for FULL mode,fallback to SIMPLE mode");
                faceDetectMode = 1;
            } else {
                if (faceIds.length != numFaces || faceLandmarks.length != numFaces * 6) {
                    Log.w(TAG, String.format("Face id size(%d), or face landmark size(%d) don'tmatch face number(%d)!", faceIds.length, faceLandmarks.length * 6, numFaces));
                }
                numFaces = Math.min(numFaces, faceIds.length);
                numFaces = Math.min(numFaces, faceLandmarks.length / 6);
            }
        }
        ArrayList<Face> faceList = new ArrayList<Face>();
        if (faceDetectMode == 1) {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1) continue;
                faceList.add(new Face(faceRectangles[i], faceScores[i]));
            }
        } else {
            for (i = 0; i < numFaces; ++i) {
                if (faceScores[i] > 100 || faceScores[i] < 1 || faceIds[i] < 0) continue;
                Point leftEye = new Point(faceLandmarks[i * 6], faceLandmarks[i * 6 + 1]);
                Point rightEye = new Point(faceLandmarks[i * 6 + 2], faceLandmarks[i * 6 + 3]);
                Point mouth = new Point(faceLandmarks[i * 6 + 4], faceLandmarks[i * 6 + 5]);
                Face face = new Face(faceRectangles[i], faceScores[i], faceIds[i], leftEye, rightEye, mouth);
                faceList.add(face);
            }
        }
        Face[] faces = new Face[faceList.size()];
        faceList.toArray(faces);
        return faces;
    }

    private Rect[] getFaceRectangles() {
        Rect[] faceRectangles = this.getBase(CaptureResult.STATISTICS_FACE_RECTANGLES);
        if (faceRectangles == null) {
            return null;
        }
        Rect[] fixedFaceRectangles = new Rect[faceRectangles.length];
        for (int i = 0; i < faceRectangles.length; ++i) {
            fixedFaceRectangles[i] = new Rect(faceRectangles[i].left, faceRectangles[i].top, faceRectangles[i].right - faceRectangles[i].left, faceRectangles[i].bottom - faceRectangles[i].top);
        }
        return fixedFaceRectangles;
    }

    private LensShadingMap getLensShadingMap() {
        float[] lsmArray = this.getBase(CaptureResult.STATISTICS_LENS_SHADING_MAP);
        Size s = this.get(CameraCharacteristics.LENS_INFO_SHADING_MAP_SIZE);
        if (lsmArray == null) {
            return null;
        }
        if (s == null) {
            Log.w(TAG, "getLensShadingMap - Lens shading map size was null.");
            return null;
        }
        LensShadingMap map = new LensShadingMap(lsmArray, s.getHeight(), s.getWidth());
        return map;
    }

    private Location getGpsLocation() {
        String processingMethod = this.get(CaptureResult.JPEG_GPS_PROCESSING_METHOD);
        double[] coords = this.get(CaptureResult.JPEG_GPS_COORDINATES);
        Long timeStamp = this.get(CaptureResult.JPEG_GPS_TIMESTAMP);
        if (CameraMetadataNative.areValuesAllNull(processingMethod, coords, timeStamp)) {
            return null;
        }
        Location l = new Location(CameraMetadataNative.translateProcessToLocationProvider(processingMethod));
        if (timeStamp != null) {
            l.setTime(timeStamp * 1000L);
        } else {
            Log.w(TAG, "getGpsLocation - No timestamp for GPS location.");
        }
        if (coords != null) {
            l.setLatitude(coords[0]);
            l.setLongitude(coords[1]);
            l.setAltitude(coords[2]);
        } else {
            Log.w(TAG, "getGpsLocation - No coordinates for GPS location");
        }
        return l;
    }

    private boolean setGpsLocation(Location l) {
        if (l == null) {
            return false;
        }
        double[] coords = new double[]{l.getLatitude(), l.getLongitude(), l.getAltitude()};
        String processMethod = CameraMetadataNative.translateLocationProviderToProcess(l.getProvider());
        long timestamp = l.getTime() / 1000L;
        this.set(CaptureRequest.JPEG_GPS_TIMESTAMP, Long.valueOf(timestamp));
        this.set(CaptureRequest.JPEG_GPS_COORDINATES, coords);
        if (processMethod == null) {
            Log.w(TAG, "setGpsLocation - No process method, Location is not from a GPS or NETWORKprovider");
        } else {
            this.setBase(CaptureRequest.JPEG_GPS_PROCESSING_METHOD, processMethod);
        }
        return true;
    }

    private void parseRecommendedConfigurations(RecommendedStreamConfiguration[] configurations, StreamConfigurationMap fullMap, boolean isDepth, ArrayList<ArrayList<StreamConfiguration>> streamConfigList, ArrayList<ArrayList<StreamConfigurationDuration>> streamDurationList, ArrayList<ArrayList<StreamConfigurationDuration>> streamStallList, boolean[] supportsPrivate) {
        streamConfigList.ensureCapacity(32);
        streamDurationList.ensureCapacity(32);
        streamStallList.ensureCapacity(32);
        for (int i = 0; i < 32; ++i) {
            streamConfigList.add(new ArrayList());
            streamDurationList.add(new ArrayList());
            streamStallList.add(new ArrayList());
        }
        for (RecommendedStreamConfiguration c : configurations) {
            int width = c.getWidth();
            int height = c.getHeight();
            int internalFormat = c.getFormat();
            int publicFormat = isDepth ? StreamConfigurationMap.depthFormatToPublic(internalFormat) : StreamConfigurationMap.imageFormatToPublic(internalFormat);
            Size sz = new Size(width, height);
            int usecaseBitmap = c.getUsecaseBitmap();
            if (!c.isInput()) {
                long stallDuration;
                StreamConfigurationDuration minDurationConfiguration = null;
                StreamConfigurationDuration stallDurationConfiguration = null;
                StreamConfiguration streamConfiguration = new StreamConfiguration(internalFormat, width, height, false);
                long minFrameDuration = fullMap.getOutputMinFrameDuration(publicFormat, sz);
                if (minFrameDuration > 0L) {
                    minDurationConfiguration = new StreamConfigurationDuration(internalFormat, width, height, minFrameDuration);
                }
                if ((stallDuration = fullMap.getOutputStallDuration(publicFormat, sz)) > 0L) {
                    stallDurationConfiguration = new StreamConfigurationDuration(internalFormat, width, height, stallDuration);
                }
                for (int i = 0; i < 32; ++i) {
                    if ((usecaseBitmap & 1 << i) == 0) continue;
                    ArrayList<StreamConfiguration> sc = streamConfigList.get(i);
                    sc.add(streamConfiguration);
                    if (minFrameDuration > 0L) {
                        ArrayList<StreamConfigurationDuration> scd = streamDurationList.get(i);
                        scd.add(minDurationConfiguration);
                    }
                    if (stallDuration > 0L) {
                        ArrayList<StreamConfigurationDuration> scs = streamStallList.get(i);
                        scs.add(stallDurationConfiguration);
                    }
                    if (supportsPrivate == null || supportsPrivate[i] || publicFormat != 34) continue;
                    supportsPrivate[i] = true;
                }
                continue;
            }
            if (usecaseBitmap != 16) {
                throw new IllegalArgumentException("Recommended input stream configurations should only be advertised in the ZSL use case!");
            }
            ArrayList<StreamConfiguration> sc = streamConfigList.get(4);
            sc.add(new StreamConfiguration(internalFormat, width, height, true));
        }
    }

    public void initializeStreamConfigurationData(ArrayList<StreamConfiguration> sc, ArrayList<StreamConfigurationDuration> scd, ArrayList<StreamConfigurationDuration> scs, StreamConfigurationData scData) {
        if (scData == null || sc == null) {
            return;
        }
        scData.streamConfigurationArray = new StreamConfiguration[sc.size()];
        scData.streamConfigurationArray = sc.toArray(scData.streamConfigurationArray);
        if (scd != null && !scd.isEmpty()) {
            scData.minDurationArray = new StreamConfigurationDuration[scd.size()];
            scData.minDurationArray = scd.toArray(scData.minDurationArray);
        } else {
            scData.minDurationArray = new StreamConfigurationDuration[0];
        }
        if (scs != null && !scs.isEmpty()) {
            scData.stallDurationArray = new StreamConfigurationDuration[scs.size()];
            scData.stallDurationArray = scs.toArray(scData.stallDurationArray);
        } else {
            scData.stallDurationArray = new StreamConfigurationDuration[0];
        }
    }

    public ArrayList<RecommendedStreamConfigurationMap> getRecommendedStreamConfigurations() {
        RecommendedStreamConfiguration[] configurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_RECOMMENDED_STREAM_CONFIGURATIONS);
        RecommendedStreamConfiguration[] depthConfigurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_RECOMMENDED_DEPTH_STREAM_CONFIGURATIONS);
        if (configurations == null && depthConfigurations == null) {
            return null;
        }
        StreamConfigurationMap fullMap = this.getStreamConfigurationMap();
        ArrayList<RecommendedStreamConfigurationMap> recommendedConfigurations = new ArrayList<RecommendedStreamConfigurationMap>();
        ArrayList<ArrayList<StreamConfiguration>> streamConfigList = new ArrayList<ArrayList<StreamConfiguration>>();
        ArrayList<ArrayList<StreamConfigurationDuration>> streamDurationList = new ArrayList<ArrayList<StreamConfigurationDuration>>();
        ArrayList<ArrayList<StreamConfigurationDuration>> streamStallList = new ArrayList<ArrayList<StreamConfigurationDuration>>();
        boolean[] supportsPrivate = new boolean[32];
        try {
            if (configurations != null) {
                this.parseRecommendedConfigurations(configurations, fullMap, false, streamConfigList, streamDurationList, streamStallList, supportsPrivate);
            }
        }
        catch (IllegalArgumentException e) {
            Log.e(TAG, "Failed parsing the recommended stream configurations!");
            return null;
        }
        ArrayList<ArrayList<StreamConfiguration>> depthStreamConfigList = new ArrayList<ArrayList<StreamConfiguration>>();
        ArrayList<ArrayList<StreamConfigurationDuration>> depthStreamDurationList = new ArrayList<ArrayList<StreamConfigurationDuration>>();
        ArrayList<ArrayList<StreamConfigurationDuration>> depthStreamStallList = new ArrayList<ArrayList<StreamConfigurationDuration>>();
        if (depthConfigurations != null) {
            try {
                this.parseRecommendedConfigurations(depthConfigurations, fullMap, true, depthStreamConfigList, depthStreamDurationList, depthStreamStallList, null);
            }
            catch (IllegalArgumentException e) {
                Log.e(TAG, "Failed parsing the recommended depth stream configurations!");
                return null;
            }
        }
        ReprocessFormatsMap inputOutputFormatsMap = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_RECOMMENDED_INPUT_OUTPUT_FORMATS_MAP);
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurations = this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS);
        boolean listHighResolution = this.isBurstSupported();
        recommendedConfigurations.ensureCapacity(32);
        for (int i = 0; i < 32; ++i) {
            StreamConfigurationData scData = new StreamConfigurationData();
            if (configurations != null) {
                this.initializeStreamConfigurationData(streamConfigList.get(i), streamDurationList.get(i), streamStallList.get(i), scData);
            }
            StreamConfigurationData depthScData = new StreamConfigurationData();
            if (depthConfigurations != null) {
                this.initializeStreamConfigurationData(depthStreamConfigList.get(i), depthStreamDurationList.get(i), depthStreamStallList.get(i), depthScData);
            }
            if (!(scData.streamConfigurationArray != null && scData.streamConfigurationArray.length != 0 || depthScData.streamConfigurationArray != null && depthScData.streamConfigurationArray.length != 0)) {
                recommendedConfigurations.add(null);
                continue;
            }
            StreamConfigurationMap map = null;
            switch (i) {
                case 0: 
                case 2: 
                case 5: 
                case 6: {
                    map = new StreamConfigurationMap(scData.streamConfigurationArray, scData.minDurationArray, scData.stallDurationArray, null, null, null, null, null, null, null, null, null, null, null, listHighResolution, supportsPrivate[i]);
                    break;
                }
                case 1: {
                    map = new StreamConfigurationMap(scData.streamConfigurationArray, scData.minDurationArray, scData.stallDurationArray, null, null, null, null, null, null, null, null, null, highSpeedVideoConfigurations, null, listHighResolution, supportsPrivate[i]);
                    break;
                }
                case 4: {
                    map = new StreamConfigurationMap(scData.streamConfigurationArray, scData.minDurationArray, scData.stallDurationArray, depthScData.streamConfigurationArray, depthScData.minDurationArray, depthScData.stallDurationArray, null, null, null, null, null, null, null, inputOutputFormatsMap, listHighResolution, supportsPrivate[i]);
                    break;
                }
                default: {
                    map = new StreamConfigurationMap(scData.streamConfigurationArray, scData.minDurationArray, scData.stallDurationArray, depthScData.streamConfigurationArray, depthScData.minDurationArray, depthScData.stallDurationArray, null, null, null, null, null, null, null, null, listHighResolution, supportsPrivate[i]);
                }
            }
            recommendedConfigurations.add(new RecommendedStreamConfigurationMap(map, i, supportsPrivate[i]));
        }
        return recommendedConfigurations;
    }

    private boolean isBurstSupported() {
        int[] capabilities;
        boolean ret = false;
        for (int capability : capabilities = this.getBase(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES)) {
            if (capability != 6) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private MandatoryStreamCombination[] getMandatoryStreamCombinationsHelper(boolean getConcurrent) {
        int[] capabilities = this.getBase(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        ArrayList<Integer> caps = new ArrayList<Integer>();
        caps.ensureCapacity(capabilities.length);
        for (int c : capabilities) {
            caps.add(new Integer(c));
        }
        int hwLevel = this.getBase(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        MandatoryStreamCombination.Builder build = new MandatoryStreamCombination.Builder(this.mCameraId, hwLevel, this.mDisplaySize, caps, this.getStreamConfigurationMap());
        List<MandatoryStreamCombination> combs = null;
        combs = getConcurrent ? build.getAvailableMandatoryConcurrentStreamCombinations() : build.getAvailableMandatoryStreamCombinations();
        if (combs != null && !combs.isEmpty()) {
            MandatoryStreamCombination[] combArray = new MandatoryStreamCombination[combs.size()];
            combArray = combs.toArray(combArray);
            return combArray;
        }
        return null;
    }

    private MandatoryStreamCombination[] getMandatoryConcurrentStreamCombinations() {
        if (!this.mHasMandatoryConcurrentStreams) {
            return null;
        }
        return this.getMandatoryStreamCombinationsHelper(true);
    }

    private MandatoryStreamCombination[] getMandatoryStreamCombinations() {
        return this.getMandatoryStreamCombinationsHelper(false);
    }

    private StreamConfigurationMap getStreamConfigurationMap() {
        StreamConfiguration[] configurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] minFrameDurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] stallDurations = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_STALL_DURATIONS);
        StreamConfiguration[] depthConfigurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] depthMinFrameDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] depthStallDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DEPTH_STALL_DURATIONS);
        StreamConfiguration[] dynamicDepthConfigurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DYNAMIC_DEPTH_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] dynamicDepthMinFrameDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DYNAMIC_DEPTH_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] dynamicDepthStallDurations = this.getBase(CameraCharacteristics.DEPTH_AVAILABLE_DYNAMIC_DEPTH_STALL_DURATIONS);
        StreamConfiguration[] heicConfigurations = this.getBase(CameraCharacteristics.HEIC_AVAILABLE_HEIC_STREAM_CONFIGURATIONS);
        StreamConfigurationDuration[] heicMinFrameDurations = this.getBase(CameraCharacteristics.HEIC_AVAILABLE_HEIC_MIN_FRAME_DURATIONS);
        StreamConfigurationDuration[] heicStallDurations = this.getBase(CameraCharacteristics.HEIC_AVAILABLE_HEIC_STALL_DURATIONS);
        HighSpeedVideoConfiguration[] highSpeedVideoConfigurations = this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS);
        ReprocessFormatsMap inputOutputFormatsMap = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP);
        boolean listHighResolution = this.isBurstSupported();
        return new StreamConfigurationMap(configurations, minFrameDurations, stallDurations, depthConfigurations, depthMinFrameDurations, depthStallDurations, dynamicDepthConfigurations, dynamicDepthMinFrameDurations, dynamicDepthStallDurations, heicConfigurations, heicMinFrameDurations, heicStallDurations, highSpeedVideoConfigurations, inputOutputFormatsMap, listHighResolution);
    }

    private <T> Integer getMaxRegions(Key<T> key) {
        boolean AE = false;
        boolean AWB = true;
        int AF = 2;
        int[] maxRegions = this.getBase(CameraCharacteristics.CONTROL_MAX_REGIONS);
        if (maxRegions == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AE)) {
            return maxRegions[0];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB)) {
            return maxRegions[1];
        }
        if (key.equals(CameraCharacteristics.CONTROL_MAX_REGIONS_AF)) {
            return maxRegions[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private <T> Integer getMaxNumOutputs(Key<T> key) {
        boolean RAW = false;
        boolean PROC = true;
        int PROC_STALLING = 2;
        int[] maxNumOutputs = this.getBase(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_STREAMS);
        if (maxNumOutputs == null) {
            return null;
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW)) {
            return maxNumOutputs[0];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC)) {
            return maxNumOutputs[1];
        }
        if (key.equals(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING)) {
            return maxNumOutputs[2];
        }
        throw new AssertionError((Object)("Invalid key " + key));
    }

    private <T> TonemapCurve getTonemapCurve() {
        float[] blue;
        float[] green;
        float[] red = this.getBase(CaptureRequest.TONEMAP_CURVE_RED);
        if (CameraMetadataNative.areValuesAllNull(red, green = this.getBase(CaptureRequest.TONEMAP_CURVE_GREEN), blue = this.getBase(CaptureRequest.TONEMAP_CURVE_BLUE))) {
            return null;
        }
        if (red == null || green == null || blue == null) {
            Log.w(TAG, "getTonemapCurve - missing tone curve components");
            return null;
        }
        TonemapCurve tc = new TonemapCurve(red, green, blue);
        return tc;
    }

    private OisSample[] getOisSamples() {
        long[] timestamps = this.getBase(CaptureResult.STATISTICS_OIS_TIMESTAMPS);
        float[] xShifts = this.getBase(CaptureResult.STATISTICS_OIS_X_SHIFTS);
        float[] yShifts = this.getBase(CaptureResult.STATISTICS_OIS_Y_SHIFTS);
        if (timestamps == null) {
            if (xShifts != null) {
                throw new AssertionError((Object)"timestamps is null but xShifts is not");
            }
            if (yShifts != null) {
                throw new AssertionError((Object)"timestamps is null but yShifts is not");
            }
            return null;
        }
        if (xShifts == null) {
            throw new AssertionError((Object)"timestamps is not null but xShifts is");
        }
        if (yShifts == null) {
            throw new AssertionError((Object)"timestamps is not null but yShifts is");
        }
        if (xShifts.length != timestamps.length) {
            throw new AssertionError((Object)String.format("timestamps has %d entries but xShifts has %d", timestamps.length, xShifts.length));
        }
        if (yShifts.length != timestamps.length) {
            throw new AssertionError((Object)String.format("timestamps has %d entries but yShifts has %d", timestamps.length, yShifts.length));
        }
        OisSample[] samples = new OisSample[timestamps.length];
        for (int i = 0; i < timestamps.length; ++i) {
            samples[i] = new OisSample(timestamps[i], xShifts[i], yShifts[i]);
        }
        return samples;
    }

    private Capability[] getExtendedSceneModeCapabilities() {
        int[] maxSizes = this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_EXTENDED_SCENE_MODE_MAX_SIZES);
        float[] zoomRanges = this.getBase(CameraCharacteristics.CONTROL_AVAILABLE_EXTENDED_SCENE_MODE_ZOOM_RATIO_RANGES);
        Range<Float> zoomRange = this.getBase(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
        float maxDigitalZoom = this.getBase(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM).floatValue();
        if (maxSizes == null) {
            return null;
        }
        if (maxSizes.length % 3 != 0) {
            throw new AssertionError((Object)"availableExtendedSceneModeMaxSizes must be tuples of [mode, width, height]");
        }
        int numExtendedSceneModes = maxSizes.length / 3;
        int numExtendedSceneModeZoomRanges = 0;
        if (zoomRanges != null) {
            if (zoomRanges.length % 2 != 0) {
                throw new AssertionError((Object)"availableExtendedSceneModeZoomRanges must be tuples of [minZoom, maxZoom]");
            }
            numExtendedSceneModeZoomRanges = zoomRanges.length / 2;
            if (numExtendedSceneModes - numExtendedSceneModeZoomRanges != 1) {
                throw new AssertionError((Object)"Number of extended scene mode zoom ranges must be 1 less than number of supported modes");
            }
        }
        float modeOffMinZoomRatio = 1.0f;
        float modeOffMaxZoomRatio = maxDigitalZoom;
        if (zoomRange != null) {
            modeOffMinZoomRatio = zoomRange.getLower().floatValue();
            modeOffMaxZoomRatio = zoomRange.getUpper().floatValue();
        }
        Capability[] capabilities = new Capability[numExtendedSceneModes];
        int j = 0;
        for (int i = 0; i < numExtendedSceneModes; ++i) {
            int mode = maxSizes[3 * i];
            int width = maxSizes[3 * i + 1];
            int height = maxSizes[3 * i + 2];
            if (mode != 0 && j < numExtendedSceneModeZoomRanges) {
                capabilities[i] = new Capability(mode, width, height, zoomRanges[2 * j], zoomRanges[2 * j + 1]);
                ++j;
                continue;
            }
            capabilities[i] = new Capability(mode, width, height, modeOffMinZoomRatio, modeOffMaxZoomRatio);
        }
        return capabilities;
    }

    private <T> void setBase(CameraCharacteristics.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private <T> void setBase(CaptureResult.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private <T> void setBase(CaptureRequest.Key<T> key, T value) {
        this.setBase(key.getNativeKey(), value);
    }

    private <T> void setBase(Key<T> key, T value) {
        int tag;
        if (key.hasTag()) {
            tag = key.getTag();
        } else {
            tag = CameraMetadataNative.nativeGetTagFromKeyLocal(this.mMetadataPtr, key.getName());
            key.cacheTag(tag);
        }
        if (value == null) {
            this.writeValues(tag, null);
            return;
        }
        int nativeType = CameraMetadataNative.nativeGetTypeFromTagLocal(this.mMetadataPtr, tag);
        Marshaler<T> marshaler = CameraMetadataNative.getMarshalerForKey(key, nativeType);
        int size = marshaler.calculateMarshalSize(value);
        byte[] values = new byte[size];
        ByteBuffer buffer = ByteBuffer.wrap(values).order(ByteOrder.nativeOrder());
        marshaler.marshal(value, buffer);
        this.writeValues(tag, values);
    }

    private boolean setAvailableFormats(int[] value) {
        int[] availableFormat = value;
        if (value == null) {
            return false;
        }
        int[] newValues = new int[availableFormat.length];
        for (int i = 0; i < availableFormat.length; ++i) {
            newValues[i] = availableFormat[i];
            if (availableFormat[i] != 256) continue;
            newValues[i] = 33;
        }
        this.setBase(CameraCharacteristics.SCALER_AVAILABLE_FORMATS, newValues);
        return true;
    }

    private boolean setFaceRectangles(Rect[] faceRects) {
        if (faceRects == null) {
            return false;
        }
        Rect[] newFaceRects = new Rect[faceRects.length];
        for (int i = 0; i < newFaceRects.length; ++i) {
            newFaceRects[i] = new Rect(faceRects[i].left, faceRects[i].top, faceRects[i].right + faceRects[i].left, faceRects[i].bottom + faceRects[i].top);
        }
        this.setBase(CaptureResult.STATISTICS_FACE_RECTANGLES, newFaceRects);
        return true;
    }

    private <T> boolean setTonemapCurve(TonemapCurve tc) {
        if (tc == null) {
            return false;
        }
        float[][] curve = new float[3][];
        for (int i = 0; i <= 2; ++i) {
            int pointCount = tc.getPointCount(i);
            curve[i] = new float[pointCount * 2];
            tc.copyColorCurve(i, curve[i], 0);
        }
        this.setBase(CaptureRequest.TONEMAP_CURVE_RED, curve[0]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_GREEN, curve[1]);
        this.setBase(CaptureRequest.TONEMAP_CURVE_BLUE, curve[2]);
        return true;
    }

    public void setCameraId(int cameraId) {
        this.mCameraId = cameraId;
    }

    public void setHasMandatoryConcurrentStreams(boolean hasMandatoryConcurrentStreams) {
        this.mHasMandatoryConcurrentStreams = hasMandatoryConcurrentStreams;
    }

    public void setDisplaySize(Size displaySize) {
        this.mDisplaySize = displaySize;
    }

    @FastNative
    private static long nativeAllocate() {
        return OverrideMethod.invokeL("android.hardware.camera2.impl.CameraMetadataNative#nativeAllocate()J", true, null);
    }

    @FastNative
    private static long nativeAllocateCopy(long l) throws NullPointerException {
        return OverrideMethod.invokeL("android.hardware.camera2.impl.CameraMetadataNative#nativeAllocateCopy(J)J", true, null);
    }

    @FastNative
    private static synchronized void nativeWriteToParcel(Parcel parcel, long l) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeWriteToParcel(Landroid/os/Parcel;J)V", true, null);
    }

    @FastNative
    private static synchronized void nativeReadFromParcel(Parcel parcel, long l) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeReadFromParcel(Landroid/os/Parcel;J)V", true, null);
    }

    @FastNative
    private static synchronized void nativeSwap(long l, long l2) throws NullPointerException {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeSwap(JJ)V", true, null);
    }

    @FastNative
    private static synchronized void nativeClose(long l) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeClose(J)V", true, null);
    }

    @FastNative
    private static synchronized boolean nativeIsEmpty(long l) {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeIsEmpty(J)Z", true, null) != 0;
    }

    @FastNative
    private static synchronized int nativeGetEntryCount(long l) {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetEntryCount(J)I", true, null);
    }

    @UnsupportedAppUsage
    @FastNative
    private static synchronized byte[] nativeReadValues(int n, long l) {
        return (byte[])OverrideMethod.invokeA("android.hardware.camera2.impl.CameraMetadataNative#nativeReadValues(IJ)[B", true, null);
    }

    @FastNative
    private static synchronized void nativeWriteValues(int n, byte[] byArray, long l) {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeWriteValues(I[BJ)V", true, null);
    }

    private static synchronized void nativeDump(long l) throws IOException {
        OverrideMethod.invokeV("android.hardware.camera2.impl.CameraMetadataNative#nativeDump(J)V", true, null);
    }

    @FastNative
    private static synchronized ArrayList nativeGetAllVendorKeys(long l, Class clazz) {
        return (ArrayList)OverrideMethod.invokeA("android.hardware.camera2.impl.CameraMetadataNative#nativeGetAllVendorKeys(JLjava/lang/Class;)Ljava/util/ArrayList;", true, null);
    }

    @UnsupportedAppUsage
    @FastNative
    private static synchronized int nativeGetTagFromKeyLocal(long l, String string2) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetTagFromKeyLocal(JLjava/lang/String;)I", true, null);
    }

    @UnsupportedAppUsage
    @FastNative
    private static synchronized int nativeGetTypeFromTagLocal(long l, int n) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetTypeFromTagLocal(JI)I", true, null);
    }

    @FastNative
    private static int nativeGetTagFromKey(String string2, long l) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetTagFromKey(Ljava/lang/String;J)I", true, null);
    }

    @FastNative
    private static int nativeGetTypeFromTag(int n, long l) throws IllegalArgumentException {
        return OverrideMethod.invokeI("android.hardware.camera2.impl.CameraMetadataNative#nativeGetTypeFromTag(IJ)I", true, null);
    }

    public void swap(CameraMetadataNative other) {
        CameraMetadataNative.nativeSwap(this.mMetadataPtr, other.mMetadataPtr);
        this.mCameraId = other.mCameraId;
        this.mHasMandatoryConcurrentStreams = other.mHasMandatoryConcurrentStreams;
        this.mDisplaySize = other.mDisplaySize;
    }

    public int getEntryCount() {
        return CameraMetadataNative.nativeGetEntryCount(this.mMetadataPtr);
    }

    public boolean isEmpty() {
        return CameraMetadataNative.nativeIsEmpty(this.mMetadataPtr);
    }

    public long getMetadataPtr() {
        return this.mMetadataPtr;
    }

    public <K> ArrayList<K> getAllVendorKeys(Class<K> keyClass) {
        if (keyClass == null) {
            throw new NullPointerException();
        }
        return CameraMetadataNative.nativeGetAllVendorKeys(this.mMetadataPtr, keyClass);
    }

    public static int getTag(String key) {
        return CameraMetadataNative.nativeGetTagFromKey(key, Long.MAX_VALUE);
    }

    public static int getTag(String key, long vendorId) {
        return CameraMetadataNative.nativeGetTagFromKey(key, vendorId);
    }

    public static int getNativeType(int tag, long vendorId) {
        return CameraMetadataNative.nativeGetTypeFromTag(tag, vendorId);
    }

    public void writeValues(int tag, byte[] src) {
        CameraMetadataNative.nativeWriteValues(tag, src, this.mMetadataPtr);
    }

    public byte[] readValues(int tag) {
        return CameraMetadataNative.nativeReadValues(tag, this.mMetadataPtr);
    }

    public void dumpToLog() {
        try {
            CameraMetadataNative.nativeDump(this.mMetadataPtr);
        }
        catch (IOException e) {
            Log.wtf(TAG, "Dump logging failed", e);
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private static <T> Marshaler<T> getMarshalerForKey(Key<T> key, int nativeType) {
        return MarshalRegistry.getMarshaler(key.getTypeReference(), nativeType);
    }

    private static void registerAllMarshalers() {
        MarshalQueryable[] queryList;
        for (MarshalQueryable query : queryList = new MarshalQueryable[]{new MarshalQueryablePrimitive(), new MarshalQueryableEnum(), new MarshalQueryableArray(), new MarshalQueryableBoolean(), new MarshalQueryableNativeByteToInteger(), new MarshalQueryableRect(), new MarshalQueryableSize(), new MarshalQueryableSizeF(), new MarshalQueryableString(), new MarshalQueryableReprocessFormatsMap(), new MarshalQueryableRange(), new MarshalQueryablePair(), new MarshalQueryableMeteringRectangle(), new MarshalQueryableColorSpaceTransform(), new MarshalQueryableStreamConfiguration(), new MarshalQueryableStreamConfigurationDuration(), new MarshalQueryableRggbChannelVector(), new MarshalQueryableBlackLevelPattern(), new MarshalQueryableHighSpeedVideoConfiguration(), new MarshalQueryableRecommendedStreamConfiguration(), new MarshalQueryableParcelable()}) {
            MarshalRegistry.registerMarshalQueryable(query);
        }
    }

    private static boolean areValuesAllNull(Object ... objs) {
        for (Object o : objs) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    static {
        sGetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getAvailableFormats();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getFaces();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getFaceRectangles();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getStreamConfigurationMap();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.SCALER_MANDATORY_STREAM_COMBINATIONS.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMandatoryStreamCombinations();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.SCALER_MANDATORY_CONCURRENT_STREAM_COMBINATIONS.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMandatoryConcurrentStreamCombinations();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AE.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AWB.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_MAX_REGIONS_AF.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxRegions(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_RAW.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CameraCharacteristics.REQUEST_MAX_NUM_OUTPUT_PROC_STALLING.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getMaxNumOutputs(key);
            }
        });
        sGetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getTonemapCurve();
            }
        });
        sGetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getGpsLocation();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_LENS_SHADING_CORRECTION_MAP.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getLensShadingMap();
            }
        });
        sGetCommandMap.put(CaptureResult.STATISTICS_OIS_SAMPLES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getOisSamples();
            }
        });
        sGetCommandMap.put(CameraCharacteristics.CONTROL_AVAILABLE_EXTENDED_SCENE_MODE_CAPABILITIES.getNativeKey(), new GetCommand(){

            @Override
            public <T> T getValue(CameraMetadataNative metadata, Key<T> key) {
                return (T)metadata.getExtendedSceneModeCapabilities();
            }
        });
        sSetCommandMap = new HashMap();
        sSetCommandMap.put(CameraCharacteristics.SCALER_AVAILABLE_FORMATS.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setAvailableFormats((int[])value);
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACE_RECTANGLES.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setFaceRectangles((Rect[])value);
            }
        });
        sSetCommandMap.put(CaptureResult.STATISTICS_FACES.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setFaces((Face[])value);
            }
        });
        sSetCommandMap.put(CaptureRequest.TONEMAP_CURVE.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setTonemapCurve((TonemapCurve)value);
            }
        });
        sSetCommandMap.put(CaptureResult.JPEG_GPS_LOCATION.getNativeKey(), new SetCommand(){

            @Override
            public <T> void setValue(CameraMetadataNative metadata, T value) {
                metadata.setGpsLocation((Location)value);
            }
        });
        CameraMetadataNative.registerAllMarshalers();
    }

    private class StreamConfigurationData {
        StreamConfiguration[] streamConfigurationArray = null;
        StreamConfigurationDuration[] minDurationArray = null;
        StreamConfigurationDuration[] stallDurationArray = null;

        private StreamConfigurationData() {
        }
    }

    public static class Key<T> {
        private boolean mHasTag;
        private int mTag;
        private long mVendorId = Long.MAX_VALUE;
        private final Class<T> mType;
        private final TypeReference<T> mTypeReference;
        private final String mName;
        private final String mFallbackName;
        private final int mHash;

        public Key(String name, Class<T> type, long vendorId) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (type == null) {
                throw new NullPointerException("Type needs to be non-null");
            }
            this.mName = name;
            this.mFallbackName = null;
            this.mType = type;
            this.mVendorId = vendorId;
            this.mTypeReference = TypeReference.createSpecializedTypeReference(type);
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public Key(String name, String fallbackName, Class<T> type) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (type == null) {
                throw new NullPointerException("Type needs to be non-null");
            }
            this.mName = name;
            this.mFallbackName = fallbackName;
            this.mType = type;
            this.mTypeReference = TypeReference.createSpecializedTypeReference(type);
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public Key(String name, Class<T> type) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (type == null) {
                throw new NullPointerException("Type needs to be non-null");
            }
            this.mName = name;
            this.mFallbackName = null;
            this.mType = type;
            this.mTypeReference = TypeReference.createSpecializedTypeReference(type);
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public Key(String name, TypeReference<T> typeReference) {
            if (name == null) {
                throw new NullPointerException("Key needs a valid name");
            }
            if (typeReference == null) {
                throw new NullPointerException("TypeReference needs to be non-null");
            }
            this.mName = name;
            this.mFallbackName = null;
            this.mType = typeReference.getRawType();
            this.mTypeReference = typeReference;
            this.mHash = this.mName.hashCode() ^ this.mTypeReference.hashCode();
        }

        public String getName() {
            return this.mName;
        }

        public int hashCode() {
            return this.mHash;
        }

        public boolean equals(Object o) {
            Key lhs;
            if (this == o) {
                return true;
            }
            if (o == null || this.hashCode() != o.hashCode()) {
                return false;
            }
            if (o instanceof CaptureResult.Key) {
                lhs = ((CaptureResult.Key)o).getNativeKey();
            } else if (o instanceof CaptureRequest.Key) {
                lhs = ((CaptureRequest.Key)o).getNativeKey();
            } else if (o instanceof CameraCharacteristics.Key) {
                lhs = ((CameraCharacteristics.Key)o).getNativeKey();
            } else if (o instanceof Key) {
                lhs = (Key)o;
            } else {
                return false;
            }
            return this.mName.equals(lhs.mName) && this.mTypeReference.equals(lhs.mTypeReference);
        }

        @UnsupportedAppUsage
        public int getTag() {
            if (!this.mHasTag) {
                this.mTag = CameraMetadataNative.getTag(this.mName, this.mVendorId);
                this.mHasTag = true;
            }
            return this.mTag;
        }

        @UnsupportedAppUsage
        public boolean hasTag() {
            return this.mHasTag;
        }

        @UnsupportedAppUsage
        public void cacheTag(int tag) {
            this.mHasTag = true;
            this.mTag = tag;
        }

        public Class<T> getType() {
            return this.mType;
        }

        public long getVendorId() {
            return this.mVendorId;
        }

        public TypeReference<T> getTypeReference() {
            return this.mTypeReference;
        }
    }
}

