/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.text;

import android.graphics.text.BaseLineBreaker;
import android.graphics.text.LineWidth;
import android.graphics.text.Primitive;
import android.graphics.text.TabStops;
import java.util.List;

public class GreedyLineBreaker
extends BaseLineBreaker {
    public GreedyLineBreaker(List<Primitive> primitives, LineWidth lineWidth, TabStops tabStops) {
        super(primitives, lineWidth, tabStops);
    }

    @Override
    public BaseLineBreaker.Result computeBreaks() {
        int lineNum = 0;
        float width = 0.0f;
        float printedWidth = 0.0f;
        boolean breakFound = false;
        boolean goodBreakFound = false;
        int breakIndex = 0;
        int goodBreakIndex = 0;
        float breakWidth = 0.0f;
        float goodBreakWidth = 0.0f;
        int firstTabIndex = Integer.MAX_VALUE;
        float maxWidth = this.mLineWidth.getLineWidth(lineNum);
        int numPrimitives = this.mPrimitives.size();
        BaseLineBreaker.Result result = new BaseLineBreaker.Result();
        for (int i = 0; i < numPrimitives; ++i) {
            Primitive p = (Primitive)this.mPrimitives.get(i);
            if (p.type == Primitive.PrimitiveType.BOX || p.type == Primitive.PrimitiveType.GLUE) {
                width += p.width;
                if (p.type == Primitive.PrimitiveType.BOX) {
                    printedWidth = width;
                }
            } else if (p.type == Primitive.PrimitiveType.VARIABLE) {
                width = this.mTabStops.width(width);
                firstTabIndex = Math.min(firstTabIndex, i);
            }
            if (printedWidth > maxWidth && (breakFound || goodBreakFound)) {
                if (goodBreakFound) {
                    i = goodBreakIndex;
                    maxWidth = this.mLineWidth.getLineWidth(++lineNum);
                    result.mLineBreakOffset.add(((Primitive)this.mPrimitives.get((int)goodBreakIndex)).location);
                    result.mLineWidths.add(Float.valueOf(goodBreakWidth));
                    result.mLineAscents.add(Float.valueOf(0.0f));
                    result.mLineDescents.add(Float.valueOf(0.0f));
                    result.mLineFlags.add(firstTabIndex < goodBreakIndex ? 0x20000000 : 0);
                    firstTabIndex = Integer.MAX_VALUE;
                } else {
                    i = breakIndex;
                    maxWidth = this.mLineWidth.getLineWidth(++lineNum);
                    result.mLineBreakOffset.add(((Primitive)this.mPrimitives.get((int)breakIndex)).location);
                    result.mLineWidths.add(Float.valueOf(breakWidth));
                    result.mLineAscents.add(Float.valueOf(0.0f));
                    result.mLineDescents.add(Float.valueOf(0.0f));
                    result.mLineFlags.add(firstTabIndex < breakIndex ? 0x20000000 : 0);
                    firstTabIndex = Integer.MAX_VALUE;
                }
                width = 0.0f;
                printedWidth = 0.0f;
                breakFound = false;
                goodBreakFound = false;
                breakWidth = 0.0f;
                goodBreakWidth = 0.0f;
                continue;
            }
            if (p.type == Primitive.PrimitiveType.PENALTY && p.penalty < 1.0E7f) {
                if (p.penalty == -1.0E7f) {
                    maxWidth = this.mLineWidth.getLineWidth(++lineNum);
                    result.mLineBreakOffset.add(p.location);
                    result.mLineWidths.add(Float.valueOf(printedWidth));
                    result.mLineAscents.add(Float.valueOf(0.0f));
                    result.mLineDescents.add(Float.valueOf(0.0f));
                    result.mLineFlags.add(firstTabIndex < i ? 0x20000000 : 0);
                    firstTabIndex = Integer.MAX_VALUE;
                    width = 0.0f;
                    printedWidth = 0.0f;
                    breakFound = false;
                    goodBreakFound = false;
                    breakWidth = 0.0f;
                    goodBreakWidth = 0.0f;
                    continue;
                }
                if (i > breakIndex && (printedWidth <= maxWidth || !breakFound)) {
                    breakFound = true;
                    breakIndex = i;
                    breakWidth = printedWidth;
                }
                if (i <= goodBreakIndex || !(printedWidth <= maxWidth)) continue;
                goodBreakFound = true;
                goodBreakIndex = i;
                goodBreakWidth = printedWidth;
                continue;
            }
            if (p.type != Primitive.PrimitiveType.WORD_BREAK || i <= breakIndex || !(printedWidth <= maxWidth) && breakFound) continue;
            breakFound = true;
            breakIndex = i;
            breakWidth = printedWidth;
        }
        if (breakFound || goodBreakFound) {
            if (goodBreakFound) {
                result.mLineBreakOffset.add(((Primitive)this.mPrimitives.get((int)goodBreakIndex)).location);
                result.mLineWidths.add(Float.valueOf(goodBreakWidth));
                result.mLineAscents.add(Float.valueOf(0.0f));
                result.mLineDescents.add(Float.valueOf(0.0f));
                result.mLineFlags.add(firstTabIndex < goodBreakIndex ? 0x20000000 : 0);
            } else {
                result.mLineBreakOffset.add(((Primitive)this.mPrimitives.get((int)breakIndex)).location);
                result.mLineWidths.add(Float.valueOf(breakWidth));
                result.mLineAscents.add(Float.valueOf(0.0f));
                result.mLineDescents.add(Float.valueOf(0.0f));
                result.mLineFlags.add(firstTabIndex < breakIndex ? 0x20000000 : 0);
            }
        }
        return result;
    }
}

