/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DashPathEffect;
import android.graphics.Insets;
import android.graphics.LinearGradient;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.SweepGradient;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable_Delegate;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class GradientDrawable
extends Drawable {
    public static boolean sWrapNegativeAngleMeasurements = true;
    public static final int RECTANGLE = 0;
    public static final int OVAL = 1;
    public static final int LINE = 2;
    public static final int RING = 3;
    public static final int LINEAR_GRADIENT = 0;
    public static final int RADIAL_GRADIENT = 1;
    public static final int SWEEP_GRADIENT = 2;
    private static final int RADIUS_TYPE_PIXELS = 0;
    private static final int RADIUS_TYPE_FRACTION = 1;
    private static final int RADIUS_TYPE_FRACTION_PARENT = 2;
    private static final Orientation DEFAULT_ORIENTATION = Orientation.TOP_BOTTOM;
    private static final float DEFAULT_INNER_RADIUS_RATIO = 3.0f;
    private static final float DEFAULT_THICKNESS_RATIO = 9.0f;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
    private GradientState mGradientState;
    @UnsupportedAppUsage
    private final Paint mFillPaint = new Paint(1);
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124051827L)
    private Rect mPadding;
    @UnsupportedAppUsage
    private Paint mStrokePaint;
    private ColorFilter mColorFilter;
    private BlendModeColorFilter mBlendModeColorFilter;
    private int mAlpha = 255;
    private final Path mPath = new Path();
    private final RectF mRect = new RectF();
    private Paint mLayerPaint;
    private boolean mGradientIsDirty;
    private boolean mMutated;
    private Path mRingPath;
    private boolean mPathIsDirty = true;
    private float mGradientRadius;

    public GradientDrawable() {
        this(new GradientState(DEFAULT_ORIENTATION, null), null);
    }

    public GradientDrawable(Orientation orientation, int[] colors) {
        this(new GradientState(orientation, colors), null);
    }

    @Override
    public boolean getPadding(Rect padding) {
        if (this.mPadding != null) {
            padding.set(this.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    public void setCornerRadii(float[] radii) {
        this.mGradientState.setCornerRadii(radii);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public float[] getCornerRadii() {
        return (float[])this.mGradientState.mRadiusArray.clone();
    }

    public void setCornerRadius(float radius) {
        this.mGradientState.setCornerRadius(radius);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public float getCornerRadius() {
        return this.mGradientState.mRadius;
    }

    public void setStroke(int width, int color2) {
        this.setStroke(width, color2, 0.0f, 0.0f);
    }

    public void setStroke(int width, ColorStateList colorStateList) {
        this.setStroke(width, colorStateList, 0.0f, 0.0f);
    }

    public void setStroke(int width, int color2, float dashWidth, float dashGap) {
        this.mGradientState.setStroke(width, ColorStateList.valueOf(color2), dashWidth, dashGap);
        this.setStrokeInternal(width, color2, dashWidth, dashGap);
    }

    public void setStroke(int width, ColorStateList colorStateList, float dashWidth, float dashGap) {
        int color2;
        this.mGradientState.setStroke(width, colorStateList, dashWidth, dashGap);
        if (colorStateList == null) {
            color2 = 0;
        } else {
            int[] stateSet = this.getState();
            color2 = colorStateList.getColorForState(stateSet, 0);
        }
        this.setStrokeInternal(width, color2, dashWidth, dashGap);
    }

    private void setStrokeInternal(int width, int color2, float dashWidth, float dashGap) {
        if (this.mStrokePaint == null) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
        }
        this.mStrokePaint.setStrokeWidth(width);
        this.mStrokePaint.setColor(color2);
        DashPathEffect e = null;
        if (dashWidth > 0.0f) {
            e = new DashPathEffect(new float[]{dashWidth, dashGap}, 0.0f);
        }
        this.mStrokePaint.setPathEffect(e);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setSize(int width, int height) {
        this.mGradientState.setSize(width, height);
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public void setShape(int shape) {
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientState.setShape(shape);
        this.invalidateSelf();
    }

    public int getShape() {
        return this.mGradientState.mShape;
    }

    public void setGradientType(int gradient) {
        this.mGradientState.setGradientType(gradient);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public int getGradientType() {
        return this.mGradientState.mGradient;
    }

    public void setGradientCenter(float x, float y) {
        this.mGradientState.setGradientCenter(x, y);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public float getGradientCenterX() {
        return this.mGradientState.mCenterX;
    }

    public float getGradientCenterY() {
        return this.mGradientState.mCenterY;
    }

    public void setGradientRadius(float gradientRadius) {
        this.mGradientState.setGradientRadius(gradientRadius, 0);
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public float getGradientRadius() {
        if (this.mGradientState.mGradient != 1) {
            return 0.0f;
        }
        this.ensureValidRect();
        return this.mGradientRadius;
    }

    public void setUseLevel(boolean useLevel) {
        this.mGradientState.mUseLevel = useLevel;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public boolean getUseLevel() {
        return this.mGradientState.mUseLevel;
    }

    private int modulateAlpha(int alpha) {
        int scale = this.mAlpha + (this.mAlpha >> 7);
        return alpha * scale >> 8;
    }

    public Orientation getOrientation() {
        return this.mGradientState.mOrientation;
    }

    public void setOrientation(Orientation orientation) {
        this.mGradientState.mOrientation = orientation;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public void setColors(int[] colors) {
        this.setColors(colors, null);
    }

    public void setColors(int[] colors, float[] offsets) {
        this.mGradientState.setGradientColors(colors);
        this.mGradientState.mPositions = offsets;
        this.mGradientIsDirty = true;
        this.invalidateSelf();
    }

    public int[] getColors() {
        return this.mGradientState.mGradientColors == null ? null : (int[])this.mGradientState.mGradientColors.clone();
    }

    @Override
    public void draw(Canvas canvas) {
        float rad;
        boolean useLayer;
        if (!this.ensureValidRect()) {
            return;
        }
        int prevFillAlpha = this.mFillPaint.getAlpha();
        int prevStrokeAlpha = this.mStrokePaint != null ? this.mStrokePaint.getAlpha() : 0;
        int currFillAlpha = this.modulateAlpha(prevFillAlpha);
        int currStrokeAlpha = this.modulateAlpha(prevStrokeAlpha);
        boolean haveStroke = currStrokeAlpha > 0 && this.mStrokePaint != null && this.mStrokePaint.getStrokeWidth() > 0.0f;
        boolean haveFill = currFillAlpha > 0;
        GradientState st = this.mGradientState;
        ColorFilter colorFilter = this.mColorFilter != null ? this.mColorFilter : this.mBlendModeColorFilter;
        boolean bl = useLayer = haveStroke && haveFill && st.mShape != 2 && currStrokeAlpha < 255 && (this.mAlpha < 255 || colorFilter != null);
        if (useLayer) {
            if (this.mLayerPaint == null) {
                this.mLayerPaint = new Paint();
            }
            this.mLayerPaint.setDither(st.mDither);
            this.mLayerPaint.setAlpha(this.mAlpha);
            this.mLayerPaint.setColorFilter(colorFilter);
            rad = this.mStrokePaint.getStrokeWidth();
            canvas.saveLayer(this.mRect.left - rad, this.mRect.top - rad, this.mRect.right + rad, this.mRect.bottom + rad, this.mLayerPaint);
            this.mFillPaint.setColorFilter(null);
            this.mStrokePaint.setColorFilter(null);
        } else {
            this.mFillPaint.setAlpha(currFillAlpha);
            this.mFillPaint.setDither(st.mDither);
            this.mFillPaint.setColorFilter(colorFilter);
            if (colorFilter != null && st.mSolidColors == null) {
                this.mFillPaint.setColor(this.mAlpha << 24);
            }
            if (haveStroke) {
                this.mStrokePaint.setAlpha(currStrokeAlpha);
                this.mStrokePaint.setDither(st.mDither);
                this.mStrokePaint.setColorFilter(colorFilter);
            }
        }
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    canvas.drawPath(this.mPath, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawPath(this.mPath, this.mStrokePaint);
                    break;
                }
                if (st.mRadius > 0.0f) {
                    rad = Math.min(st.mRadius, Math.min(this.mRect.width(), this.mRect.height()) * 0.5f);
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mFillPaint);
                    if (!haveStroke) break;
                    canvas.drawRoundRect(this.mRect, rad, rad, this.mStrokePaint);
                    break;
                }
                if (this.mFillPaint.getColor() != 0 || colorFilter != null || this.mFillPaint.getShader() != null) {
                    canvas.drawRect(this.mRect, this.mFillPaint);
                }
                if (!haveStroke) break;
                canvas.drawRect(this.mRect, this.mStrokePaint);
                break;
            }
            case 1: {
                canvas.drawOval(this.mRect, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawOval(this.mRect, this.mStrokePaint);
                break;
            }
            case 2: {
                RectF r = this.mRect;
                float y = r.centerY();
                if (!haveStroke) break;
                canvas.drawLine(r.left, y, r.right, y, this.mStrokePaint);
                break;
            }
            case 3: {
                Path path = this.buildRing(st);
                canvas.drawPath(path, this.mFillPaint);
                if (!haveStroke) break;
                canvas.drawPath(path, this.mStrokePaint);
            }
        }
        if (useLayer) {
            canvas.restore();
        } else {
            this.mFillPaint.setAlpha(prevFillAlpha);
            if (haveStroke) {
                this.mStrokePaint.setAlpha(prevStrokeAlpha);
            }
        }
    }

    @Override
    public void setXfermode(Xfermode mode) {
        super.setXfermode(mode);
        this.mFillPaint.setXfermode(mode);
    }

    public void setAntiAlias(boolean aa) {
        this.mFillPaint.setAntiAlias(aa);
    }

    private void buildPathIfDirty() {
        GradientState st = this.mGradientState;
        if (this.mPathIsDirty) {
            this.ensureValidRect();
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, st.mRadiusArray, Path.Direction.CW);
            this.mPathIsDirty = false;
        }
    }

    public void setInnerRadiusRatio(float innerRadiusRatio) {
        if (innerRadiusRatio <= 0.0f) {
            throw new IllegalArgumentException("Ratio must be greater than zero");
        }
        this.mGradientState.mInnerRadiusRatio = innerRadiusRatio;
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public float getInnerRadiusRatio() {
        return this.mGradientState.mInnerRadiusRatio;
    }

    public void setInnerRadius(int innerRadius) {
        this.mGradientState.mInnerRadius = innerRadius;
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public int getInnerRadius() {
        return this.mGradientState.mInnerRadius;
    }

    public void setThicknessRatio(float thicknessRatio) {
        if (thicknessRatio <= 0.0f) {
            throw new IllegalArgumentException("Ratio must be greater than zero");
        }
        this.mGradientState.mThicknessRatio = thicknessRatio;
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public float getThicknessRatio() {
        return this.mGradientState.mThicknessRatio;
    }

    public void setThickness(int thickness) {
        this.mGradientState.mThickness = thickness;
        this.mPathIsDirty = true;
        this.invalidateSelf();
    }

    public int getThickness() {
        return this.mGradientState.mThickness;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.mGradientState.mPadding == null) {
            this.mGradientState.mPadding = new Rect();
        }
        this.mGradientState.mPadding.set(left, top, right, bottom);
        this.mPadding = this.mGradientState.mPadding;
        this.invalidateSelf();
    }

    Path buildRing_Original(GradientState st) {
        if (!(this.mRingPath == null || st.mUseLevelForShape && this.mPathIsDirty)) {
            return this.mRingPath;
        }
        this.mPathIsDirty = false;
        float sweep = st.mUseLevelForShape ? 360.0f * (float)this.getLevel() / 10000.0f : 360.0f;
        RectF bounds = new RectF(this.mRect);
        float x = bounds.width() / 2.0f;
        float y = bounds.height() / 2.0f;
        float thickness = st.mThickness != -1 ? (float)st.mThickness : bounds.width() / st.mThicknessRatio;
        float radius = st.mInnerRadius != -1 ? (float)st.mInnerRadius : bounds.width() / st.mInnerRadiusRatio;
        RectF innerBounds = new RectF(bounds);
        innerBounds.inset(x - radius, y - radius);
        bounds = new RectF(innerBounds);
        bounds.inset(-thickness, -thickness);
        if (this.mRingPath == null) {
            this.mRingPath = new Path();
        } else {
            this.mRingPath.reset();
        }
        Path ringPath = this.mRingPath;
        if (sweep < 360.0f && sweep > -360.0f) {
            ringPath.setFillType(Path.FillType.EVEN_ODD);
            ringPath.moveTo(x + radius, y);
            ringPath.lineTo(x + radius + thickness, y);
            ringPath.arcTo(bounds, 0.0f, sweep, false);
            ringPath.arcTo(innerBounds, sweep, -sweep, false);
            ringPath.close();
        } else {
            ringPath.addOval(bounds, Path.Direction.CW);
            ringPath.addOval(innerBounds, Path.Direction.CCW);
        }
        return ringPath;
    }

    @LayoutlibDelegate
    private Path buildRing(GradientState gradientState) {
        return GradientDrawable_Delegate.buildRing(this, gradientState);
    }

    public void setColor(int argb) {
        this.mGradientState.setSolidColors(ColorStateList.valueOf(argb));
        this.mFillPaint.setColor(argb);
        this.invalidateSelf();
    }

    public void setColor(ColorStateList colorStateList) {
        if (colorStateList == null) {
            this.setColor(0);
        } else {
            int[] stateSet = this.getState();
            int color2 = colorStateList.getColorForState(stateSet, 0);
            this.mGradientState.setSolidColors(colorStateList);
            this.mFillPaint.setColor(color2);
            this.invalidateSelf();
        }
    }

    public ColorStateList getColor() {
        return this.mGradientState.mSolidColors;
    }

    @Override
    protected boolean onStateChange(int[] stateSet) {
        ColorStateList strokeColors;
        Paint strokePaint;
        boolean invalidateSelf = false;
        GradientState s = this.mGradientState;
        ColorStateList solidColors = s.mSolidColors;
        if (solidColors != null) {
            int newColor = solidColors.getColorForState(stateSet, 0);
            int oldColor = this.mFillPaint.getColor();
            if (oldColor != newColor) {
                this.mFillPaint.setColor(newColor);
                invalidateSelf = true;
            }
        }
        if ((strokePaint = this.mStrokePaint) != null && (strokeColors = s.mStrokeColors) != null) {
            int newColor = strokeColors.getColorForState(stateSet, 0);
            int oldColor = strokePaint.getColor();
            if (oldColor != newColor) {
                strokePaint.setColor(newColor);
                invalidateSelf = true;
            }
        }
        if (s.mTint != null && s.mBlendMode != null) {
            this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, s.mTint, s.mBlendMode);
            invalidateSelf = true;
        }
        if (invalidateSelf) {
            this.invalidateSelf();
            return true;
        }
        return false;
    }

    @Override
    public boolean isStateful() {
        GradientState s = this.mGradientState;
        return super.isStateful() || s.mSolidColors != null && s.mSolidColors.isStateful() || s.mStrokeColors != null && s.mStrokeColors.isStateful() || s.mTint != null && s.mTint.isStateful();
    }

    @Override
    public boolean hasFocusStateSpecified() {
        GradientState s = this.mGradientState;
        return s.mSolidColors != null && s.mSolidColors.hasFocusStateSpecified() || s.mStrokeColors != null && s.mStrokeColors.hasFocusStateSpecified() || s.mTint != null && s.mTint.hasFocusStateSpecified();
    }

    @Override
    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mGradientState.getChangingConfigurations();
    }

    @Override
    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    @Override
    public int getAlpha() {
        return this.mAlpha;
    }

    @Override
    public void setDither(boolean dither) {
        if (dither != this.mGradientState.mDither) {
            this.mGradientState.mDither = dither;
            this.invalidateSelf();
        }
    }

    @Override
    public ColorFilter getColorFilter() {
        return this.mColorFilter;
    }

    @Override
    public void setColorFilter(ColorFilter colorFilter) {
        if (colorFilter != this.mColorFilter) {
            this.mColorFilter = colorFilter;
            this.invalidateSelf();
        }
    }

    @Override
    public void setTintList(ColorStateList tint) {
        this.mGradientState.mTint = tint;
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, tint, this.mGradientState.mBlendMode);
        this.invalidateSelf();
    }

    @Override
    public void setTintBlendMode(BlendMode blendMode) {
        this.mGradientState.mBlendMode = blendMode;
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, this.mGradientState.mTint, blendMode);
        this.invalidateSelf();
    }

    @Override
    public int getOpacity() {
        return this.mAlpha == 255 && this.mGradientState.mOpaqueOverBounds && this.isOpaqueForState() ? -1 : -3;
    }

    @Override
    protected void onBoundsChange(Rect r) {
        super.onBoundsChange(r);
        this.mRingPath = null;
        this.mPathIsDirty = true;
        this.mGradientIsDirty = true;
    }

    @Override
    protected boolean onLevelChange(int level) {
        super.onLevelChange(level);
        this.mGradientIsDirty = true;
        this.mPathIsDirty = true;
        this.invalidateSelf();
        return true;
    }

    private boolean ensureValidRect() {
        if (this.mGradientIsDirty) {
            this.mGradientIsDirty = false;
            Rect bounds = this.getBounds();
            float inset = 0.0f;
            if (this.mStrokePaint != null) {
                inset = this.mStrokePaint.getStrokeWidth() * 0.5f;
            }
            GradientState st = this.mGradientState;
            this.mRect.set((float)bounds.left + inset, (float)bounds.top + inset, (float)bounds.right - inset, (float)bounds.bottom - inset);
            int[] gradientColors = st.mGradientColors;
            if (gradientColors != null) {
                RectF r = this.mRect;
                if (st.mGradient == 0) {
                    float y1;
                    float x1;
                    float y0;
                    float x0;
                    float level = st.mUseLevel ? (float)this.getLevel() / 10000.0f : 1.0f;
                    switch (st.mOrientation) {
                        case TOP_BOTTOM: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = x0;
                            y1 = level * r.bottom;
                            break;
                        }
                        case TR_BL: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = level * r.bottom;
                            break;
                        }
                        case RIGHT_LEFT: {
                            x0 = r.right;
                            y0 = r.top;
                            x1 = level * r.left;
                            y1 = y0;
                            break;
                        }
                        case BR_TL: {
                            x0 = r.right;
                            y0 = r.bottom;
                            x1 = level * r.left;
                            y1 = level * r.top;
                            break;
                        }
                        case BOTTOM_TOP: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = x0;
                            y1 = level * r.top;
                            break;
                        }
                        case BL_TR: {
                            x0 = r.left;
                            y0 = r.bottom;
                            x1 = level * r.right;
                            y1 = level * r.top;
                            break;
                        }
                        case LEFT_RIGHT: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = y0;
                            break;
                        }
                        default: {
                            x0 = r.left;
                            y0 = r.top;
                            x1 = level * r.right;
                            y1 = level * r.bottom;
                        }
                    }
                    this.mFillPaint.setShader(new LinearGradient(x0, y0, x1, y1, gradientColors, st.mPositions, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 1) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    float radius = st.mGradientRadius;
                    if (st.mGradientRadiusType == 1) {
                        float width = st.mWidth >= 0 ? (float)st.mWidth : r.width();
                        float height = st.mHeight >= 0 ? (float)st.mHeight : r.height();
                        radius *= Math.min(width, height);
                    } else if (st.mGradientRadiusType == 2) {
                        radius *= Math.min(r.width(), r.height());
                    }
                    if (st.mUseLevel) {
                        radius *= (float)this.getLevel() / 10000.0f;
                    }
                    this.mGradientRadius = radius;
                    if (radius <= 0.0f) {
                        radius = 0.001f;
                    }
                    this.mFillPaint.setShader(new RadialGradient(x0, y0, radius, gradientColors, null, Shader.TileMode.CLAMP));
                } else if (st.mGradient == 2) {
                    float x0 = r.left + (r.right - r.left) * st.mCenterX;
                    float y0 = r.top + (r.bottom - r.top) * st.mCenterY;
                    int[] tempColors = gradientColors;
                    float[] tempPositions = null;
                    if (st.mUseLevel) {
                        tempColors = st.mTempColors;
                        int length = gradientColors.length;
                        if (tempColors == null || tempColors.length != length + 1) {
                            st.mTempColors = new int[length + 1];
                            tempColors = st.mTempColors;
                        }
                        System.arraycopy(gradientColors, 0, tempColors, 0, length);
                        tempColors[length] = gradientColors[length - 1];
                        tempPositions = st.mTempPositions;
                        float fraction2 = 1.0f / (float)(length - 1);
                        if (tempPositions == null || tempPositions.length != length + 1) {
                            tempPositions = st.mTempPositions = new float[length + 1];
                        }
                        float level = (float)this.getLevel() / 10000.0f;
                        for (int i = 0; i < length; ++i) {
                            tempPositions[i] = (float)i * fraction2 * level;
                        }
                        tempPositions[length] = 1.0f;
                    }
                    this.mFillPaint.setShader(new SweepGradient(x0, y0, tempColors, tempPositions));
                }
                if (st.mSolidColors == null) {
                    this.mFillPaint.setColor(-16777216);
                }
            }
        }
        return !this.mRect.isEmpty();
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        super.inflate(r, parser, attrs, theme);
        this.mGradientState.setDensity(Drawable.resolveDensity(r, 0));
        TypedArray a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawable);
        this.updateStateFromTypedArray(a);
        a.recycle();
        this.inflateChildElements(r, parser, attrs, theme);
        this.updateLocalState(r);
    }

    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        GradientState state = this.mGradientState;
        if (state == null) {
            return;
        }
        state.setDensity(Drawable.resolveDensity(t.getResources(), 0));
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.GradientDrawable);
            this.updateStateFromTypedArray(a);
            a.recycle();
        }
        if (state.mTint != null && state.mTint.canApplyTheme()) {
            state.mTint = state.mTint.obtainForTheme(t);
        }
        if (state.mSolidColors != null && state.mSolidColors.canApplyTheme()) {
            state.mSolidColors = state.mSolidColors.obtainForTheme(t);
        }
        if (state.mStrokeColors != null && state.mStrokeColors.canApplyTheme()) {
            state.mStrokeColors = state.mStrokeColors.obtainForTheme(t);
        }
        this.applyThemeChildElements(t);
        this.updateLocalState(t.getResources());
    }

    private void updateStateFromTypedArray(TypedArray a) {
        ColorStateList tint;
        int tintMode;
        GradientState state = this.mGradientState;
        state.mChangingConfigurations |= a.getChangingConfigurations();
        state.mThemeAttrs = a.extractThemeAttrs();
        state.mShape = a.getInt(3, state.mShape);
        state.mDither = a.getBoolean(0, state.mDither);
        if (state.mShape == 3) {
            state.mInnerRadius = a.getDimensionPixelSize(7, state.mInnerRadius);
            if (state.mInnerRadius == -1) {
                state.mInnerRadiusRatio = a.getFloat(4, state.mInnerRadiusRatio);
            }
            state.mThickness = a.getDimensionPixelSize(8, state.mThickness);
            if (state.mThickness == -1) {
                state.mThicknessRatio = a.getFloat(5, state.mThicknessRatio);
            }
            state.mUseLevelForShape = a.getBoolean(6, state.mUseLevelForShape);
        }
        if ((tintMode = a.getInt(9, -1)) != -1) {
            state.mBlendMode = Drawable.parseBlendMode(tintMode, BlendMode.SRC_IN);
        }
        if ((tint = a.getColorStateList(1)) != null) {
            state.mTint = tint;
        }
        int insetLeft = a.getDimensionPixelSize(10, state.mOpticalInsets.left);
        int insetTop = a.getDimensionPixelSize(11, state.mOpticalInsets.top);
        int insetRight = a.getDimensionPixelSize(12, state.mOpticalInsets.right);
        int insetBottom = a.getDimensionPixelSize(13, state.mOpticalInsets.bottom);
        state.mOpticalInsets = Insets.of(insetLeft, insetTop, insetRight, insetBottom);
    }

    @Override
    public boolean canApplyTheme() {
        return this.mGradientState != null && this.mGradientState.canApplyTheme() || super.canApplyTheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyThemeChildElements(Resources.Theme t) {
        TypedArray a;
        GradientState st = this.mGradientState;
        if (st.mAttrSize != null) {
            a = t.resolveAttributes(st.mAttrSize, R.styleable.GradientDrawableSize);
            this.updateGradientDrawableSize(a);
            a.recycle();
        }
        if (st.mAttrGradient != null) {
            a = t.resolveAttributes(st.mAttrGradient, R.styleable.GradientDrawableGradient);
            try {
                this.updateGradientDrawableGradient(t.getResources(), a);
            }
            finally {
                a.recycle();
            }
        }
        if (st.mAttrSolid != null) {
            a = t.resolveAttributes(st.mAttrSolid, R.styleable.GradientDrawableSolid);
            this.updateGradientDrawableSolid(a);
            a.recycle();
        }
        if (st.mAttrStroke != null) {
            a = t.resolveAttributes(st.mAttrStroke, R.styleable.GradientDrawableStroke);
            this.updateGradientDrawableStroke(a);
            a.recycle();
        }
        if (st.mAttrCorners != null) {
            a = t.resolveAttributes(st.mAttrCorners, R.styleable.DrawableCorners);
            this.updateDrawableCorners(a);
            a.recycle();
        }
        if (st.mAttrPadding != null) {
            a = t.resolveAttributes(st.mAttrPadding, R.styleable.GradientDrawablePadding);
            this.updateGradientDrawablePadding(a);
            a.recycle();
        }
    }

    private void inflateChildElements(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            TypedArray a;
            if (type != 2 || depth > innerDepth) continue;
            String name = parser.getName();
            if (name.equals("size")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableSize);
                this.updateGradientDrawableSize(a);
                a.recycle();
                continue;
            }
            if (name.equals("gradient")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableGradient);
                this.updateGradientDrawableGradient(r, a);
                a.recycle();
                continue;
            }
            if (name.equals("solid")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableSolid);
                this.updateGradientDrawableSolid(a);
                a.recycle();
                continue;
            }
            if (name.equals("stroke")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawableStroke);
                this.updateGradientDrawableStroke(a);
                a.recycle();
                continue;
            }
            if (name.equals("corners")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.DrawableCorners);
                this.updateDrawableCorners(a);
                a.recycle();
                continue;
            }
            if (name.equals("padding")) {
                a = GradientDrawable.obtainAttributes(r, theme, attrs, R.styleable.GradientDrawablePadding);
                this.updateGradientDrawablePadding(a);
                a.recycle();
                continue;
            }
            Log.w("drawable", "Bad element under <shape>: " + name);
        }
    }

    private void updateGradientDrawablePadding(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrPadding = a.extractThemeAttrs();
        if (st.mPadding == null) {
            st.mPadding = new Rect();
        }
        Rect pad = st.mPadding;
        pad.set(a.getDimensionPixelOffset(0, pad.left), a.getDimensionPixelOffset(1, pad.top), a.getDimensionPixelOffset(2, pad.right), a.getDimensionPixelOffset(3, pad.bottom));
        this.mPadding = pad;
    }

    private void updateDrawableCorners(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrCorners = a.extractThemeAttrs();
        int radius = a.getDimensionPixelSize(0, (int)st.mRadius);
        this.setCornerRadius(radius);
        int topLeftRadius = a.getDimensionPixelSize(1, radius);
        int topRightRadius = a.getDimensionPixelSize(2, radius);
        int bottomLeftRadius = a.getDimensionPixelSize(3, radius);
        int bottomRightRadius = a.getDimensionPixelSize(4, radius);
        if (topLeftRadius != radius || topRightRadius != radius || bottomLeftRadius != radius || bottomRightRadius != radius) {
            this.setCornerRadii(new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius});
        }
    }

    private void updateGradientDrawableStroke(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrStroke = a.extractThemeAttrs();
        int defaultStrokeWidth = Math.max(0, st.mStrokeWidth);
        int width = a.getDimensionPixelSize(0, defaultStrokeWidth);
        float dashWidth = a.getDimension(2, st.mStrokeDashWidth);
        ColorStateList colorStateList = a.getColorStateList(1);
        if (colorStateList == null) {
            colorStateList = st.mStrokeColors;
        }
        if (dashWidth != 0.0f) {
            float dashGap = a.getDimension(3, st.mStrokeDashGap);
            this.setStroke(width, colorStateList, dashWidth, dashGap);
        } else {
            this.setStroke(width, colorStateList);
        }
    }

    private void updateGradientDrawableSolid(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrSolid = a.extractThemeAttrs();
        ColorStateList colorStateList = a.getColorStateList(0);
        if (colorStateList != null) {
            this.setColor(colorStateList);
        }
    }

    private void updateGradientDrawableGradient(Resources r, TypedArray a) {
        int prevCenter;
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrGradient = a.extractThemeAttrs();
        st.mCenterX = GradientDrawable.getFloatOrFraction(a, 5, st.mCenterX);
        st.mCenterY = GradientDrawable.getFloatOrFraction(a, 6, st.mCenterY);
        st.mUseLevel = a.getBoolean(2, st.mUseLevel);
        st.mGradient = a.getInt(4, st.mGradient);
        boolean hasGradientColors = st.mGradientColors != null;
        boolean hasGradientCenter = st.hasCenterColor();
        int prevStart = hasGradientColors ? st.mGradientColors[0] : 0;
        int n = prevCenter = hasGradientCenter ? st.mGradientColors[1] : 0;
        int prevEnd = st.hasCenterColor() ? st.mGradientColors[2] : (hasGradientColors ? st.mGradientColors[1] : 0);
        int startColor = a.getColor(0, prevStart);
        boolean hasCenterColor = a.hasValue(8) || hasGradientCenter;
        int centerColor = a.getColor(8, prevCenter);
        int endColor = a.getColor(1, prevEnd);
        if (hasCenterColor) {
            st.mGradientColors = new int[3];
            st.mGradientColors[0] = startColor;
            st.mGradientColors[1] = centerColor;
            st.mGradientColors[2] = endColor;
            st.mPositions = new float[3];
            st.mPositions[0] = 0.0f;
            st.mPositions[1] = st.mCenterX != 0.5f ? st.mCenterX : st.mCenterY;
            st.mPositions[2] = 1.0f;
        } else {
            st.mGradientColors = new int[2];
            st.mGradientColors[0] = startColor;
            st.mGradientColors[1] = endColor;
        }
        int angle = (int)a.getFloat(3, st.mAngle);
        st.mAngle = sWrapNegativeAngleMeasurements ? (angle % 360 + 360) % 360 : angle % 360;
        if (st.mAngle >= 0) {
            switch (st.mAngle) {
                case 0: {
                    st.mOrientation = Orientation.LEFT_RIGHT;
                    break;
                }
                case 45: {
                    st.mOrientation = Orientation.BL_TR;
                    break;
                }
                case 90: {
                    st.mOrientation = Orientation.BOTTOM_TOP;
                    break;
                }
                case 135: {
                    st.mOrientation = Orientation.BR_TL;
                    break;
                }
                case 180: {
                    st.mOrientation = Orientation.RIGHT_LEFT;
                    break;
                }
                case 225: {
                    st.mOrientation = Orientation.TR_BL;
                    break;
                }
                case 270: {
                    st.mOrientation = Orientation.TOP_BOTTOM;
                    break;
                }
                case 315: {
                    st.mOrientation = Orientation.TL_BR;
                }
            }
        } else {
            st.mOrientation = DEFAULT_ORIENTATION;
        }
        TypedValue tv = a.peekValue(7);
        if (tv != null) {
            int radiusType;
            float radius;
            if (tv.type == 6) {
                radius = tv.getFraction(1.0f, 1.0f);
                int unit = tv.data >> 0 & 0xF;
                radiusType = unit == 1 ? 2 : 1;
            } else if (tv.type == 5) {
                radius = tv.getDimension(r.getDisplayMetrics());
                radiusType = 0;
            } else {
                radius = tv.getFloat();
                radiusType = 0;
            }
            st.mGradientRadius = radius;
            st.mGradientRadiusType = radiusType;
        }
    }

    private void updateGradientDrawableSize(TypedArray a) {
        GradientState st = this.mGradientState;
        st.mChangingConfigurations |= a.getChangingConfigurations();
        st.mAttrSize = a.extractThemeAttrs();
        st.mWidth = a.getDimensionPixelSize(1, st.mWidth);
        st.mHeight = a.getDimensionPixelSize(0, st.mHeight);
    }

    private static float getFloatOrFraction(TypedArray a, int index, float defaultValue) {
        TypedValue tv = a.peekValue(index);
        float v = defaultValue;
        if (tv != null) {
            boolean vIsFraction = tv.type == 6;
            v = vIsFraction ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        return v;
    }

    @Override
    public int getIntrinsicWidth() {
        return this.mGradientState.mWidth;
    }

    @Override
    public int getIntrinsicHeight() {
        return this.mGradientState.mHeight;
    }

    @Override
    public Insets getOpticalInsets() {
        return this.mGradientState.mOpticalInsets;
    }

    @Override
    public Drawable.ConstantState getConstantState() {
        this.mGradientState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mGradientState;
    }

    private boolean isOpaqueForState() {
        if (this.mGradientState.mStrokeWidth >= 0 && this.mStrokePaint != null && !GradientDrawable.isOpaque(this.mStrokePaint.getColor())) {
            return false;
        }
        return this.mGradientState.mGradientColors != null || GradientDrawable.isOpaque(this.mFillPaint.getColor());
    }

    @Override
    public void getOutline(Outline outline) {
        GradientState st = this.mGradientState;
        Rect bounds = this.getBounds();
        boolean useFillOpacity = st.mOpaqueOverShape && (this.mGradientState.mStrokeWidth <= 0 || this.mStrokePaint == null || this.mStrokePaint.getAlpha() == this.mFillPaint.getAlpha());
        outline.setAlpha(useFillOpacity ? (float)this.modulateAlpha(this.mFillPaint.getAlpha()) / 255.0f : 0.0f);
        switch (st.mShape) {
            case 0: {
                if (st.mRadiusArray != null) {
                    this.buildPathIfDirty();
                    outline.setPath(this.mPath);
                    return;
                }
                float rad = 0.0f;
                if (st.mRadius > 0.0f) {
                    rad = Math.min(st.mRadius, (float)Math.min(bounds.width(), bounds.height()) * 0.5f);
                }
                outline.setRoundRect(bounds, rad);
                return;
            }
            case 1: {
                outline.setOval(bounds);
                return;
            }
            case 2: {
                float halfStrokeWidth = this.mStrokePaint == null ? 1.0E-4f : this.mStrokePaint.getStrokeWidth() * 0.5f;
                float centerY = bounds.centerY();
                int top = (int)Math.floor(centerY - halfStrokeWidth);
                int bottom = (int)Math.ceil(centerY + halfStrokeWidth);
                outline.setRect(bounds.left, top, bounds.right, bottom);
                return;
            }
        }
    }

    @Override
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mGradientState = new GradientState(this.mGradientState, null);
            this.updateLocalState(null);
            this.mMutated = true;
        }
        return this;
    }

    @Override
    public void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    static boolean isOpaque(int color2) {
        return (color2 >> 24 & 0xFF) == 255;
    }

    private GradientDrawable(GradientState state, Resources res) {
        this.mGradientState = state;
        this.updateLocalState(res);
    }

    private void updateLocalState(Resources res) {
        int[] currentState;
        GradientState state = this.mGradientState;
        if (state.mSolidColors != null) {
            currentState = this.getState();
            int stateColor = state.mSolidColors.getColorForState(currentState, 0);
            this.mFillPaint.setColor(stateColor);
        } else if (state.mGradientColors == null) {
            this.mFillPaint.setColor(0);
        } else {
            this.mFillPaint.setColor(-16777216);
        }
        this.mPadding = state.mPadding;
        if (state.mStrokeWidth >= 0) {
            this.mStrokePaint = new Paint(1);
            this.mStrokePaint.setStyle(Paint.Style.STROKE);
            this.mStrokePaint.setStrokeWidth(state.mStrokeWidth);
            if (state.mStrokeColors != null) {
                currentState = this.getState();
                int strokeStateColor = state.mStrokeColors.getColorForState(currentState, 0);
                this.mStrokePaint.setColor(strokeStateColor);
            }
            if (state.mStrokeDashWidth != 0.0f) {
                DashPathEffect e = new DashPathEffect(new float[]{state.mStrokeDashWidth, state.mStrokeDashGap}, 0.0f);
                this.mStrokePaint.setPathEffect(e);
            }
        }
        this.mBlendModeColorFilter = this.updateBlendModeFilter(this.mBlendModeColorFilter, state.mTint, state.mBlendMode);
        this.mGradientIsDirty = true;
        state.computeOpacity();
    }

    static class GradientState
    extends Drawable.ConstantState {
        public int mChangingConfigurations;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int mShape = 0;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int mGradient = 0;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int mAngle = 0;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public Orientation mOrientation;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public ColorStateList mSolidColors;
        public ColorStateList mStrokeColors;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int[] mGradientColors;
        public int[] mTempColors;
        public float[] mTempPositions;
        @UnsupportedAppUsage
        public float[] mPositions;
        @UnsupportedAppUsage(trackingBug=124050917L)
        public int mStrokeWidth = -1;
        @UnsupportedAppUsage(trackingBug=124050917L)
        public float mStrokeDashWidth = 0.0f;
        @UnsupportedAppUsage(trackingBug=124050917L)
        public float mStrokeDashGap = 0.0f;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public float mRadius = 0.0f;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public float[] mRadiusArray = null;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public Rect mPadding = null;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int mWidth = -1;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int mHeight = -1;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public float mInnerRadiusRatio = 3.0f;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050218L)
        public float mThicknessRatio = 9.0f;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050917L)
        public int mInnerRadius = -1;
        @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=124050218L)
        public int mThickness = -1;
        public boolean mDither = false;
        public Insets mOpticalInsets = Insets.NONE;
        float mCenterX = 0.5f;
        float mCenterY = 0.5f;
        float mGradientRadius = 0.5f;
        int mGradientRadiusType = 0;
        boolean mUseLevel = false;
        boolean mUseLevelForShape = true;
        boolean mOpaqueOverBounds;
        boolean mOpaqueOverShape;
        ColorStateList mTint = null;
        BlendMode mBlendMode = Drawable.DEFAULT_BLEND_MODE;
        int mDensity = 160;
        int[] mThemeAttrs;
        int[] mAttrSize;
        int[] mAttrGradient;
        int[] mAttrSolid;
        int[] mAttrStroke;
        int[] mAttrCorners;
        int[] mAttrPadding;

        public GradientState(Orientation orientation, int[] gradientColors) {
            this.mOrientation = orientation;
            this.setGradientColors(gradientColors);
        }

        public GradientState(GradientState orig, Resources res) {
            this.mChangingConfigurations = orig.mChangingConfigurations;
            this.mShape = orig.mShape;
            this.mGradient = orig.mGradient;
            this.mAngle = orig.mAngle;
            this.mOrientation = orig.mOrientation;
            this.mSolidColors = orig.mSolidColors;
            if (orig.mGradientColors != null) {
                this.mGradientColors = (int[])orig.mGradientColors.clone();
            }
            if (orig.mPositions != null) {
                this.mPositions = (float[])orig.mPositions.clone();
            }
            this.mStrokeColors = orig.mStrokeColors;
            this.mStrokeWidth = orig.mStrokeWidth;
            this.mStrokeDashWidth = orig.mStrokeDashWidth;
            this.mStrokeDashGap = orig.mStrokeDashGap;
            this.mRadius = orig.mRadius;
            if (orig.mRadiusArray != null) {
                this.mRadiusArray = (float[])orig.mRadiusArray.clone();
            }
            if (orig.mPadding != null) {
                this.mPadding = new Rect(orig.mPadding);
            }
            this.mWidth = orig.mWidth;
            this.mHeight = orig.mHeight;
            this.mInnerRadiusRatio = orig.mInnerRadiusRatio;
            this.mThicknessRatio = orig.mThicknessRatio;
            this.mInnerRadius = orig.mInnerRadius;
            this.mThickness = orig.mThickness;
            this.mDither = orig.mDither;
            this.mOpticalInsets = orig.mOpticalInsets;
            this.mCenterX = orig.mCenterX;
            this.mCenterY = orig.mCenterY;
            this.mGradientRadius = orig.mGradientRadius;
            this.mGradientRadiusType = orig.mGradientRadiusType;
            this.mUseLevel = orig.mUseLevel;
            this.mUseLevelForShape = orig.mUseLevelForShape;
            this.mOpaqueOverBounds = orig.mOpaqueOverBounds;
            this.mOpaqueOverShape = orig.mOpaqueOverShape;
            this.mTint = orig.mTint;
            this.mBlendMode = orig.mBlendMode;
            this.mThemeAttrs = orig.mThemeAttrs;
            this.mAttrSize = orig.mAttrSize;
            this.mAttrGradient = orig.mAttrGradient;
            this.mAttrSolid = orig.mAttrSolid;
            this.mAttrStroke = orig.mAttrStroke;
            this.mAttrCorners = orig.mAttrCorners;
            this.mAttrPadding = orig.mAttrPadding;
            this.mDensity = Drawable.resolveDensity(res, orig.mDensity);
            if (orig.mDensity != this.mDensity) {
                this.applyDensityScaling(orig.mDensity, this.mDensity);
            }
        }

        public void setDensity(int targetDensity) {
            if (this.mDensity != targetDensity) {
                int sourceDensity = this.mDensity;
                this.mDensity = targetDensity;
                this.applyDensityScaling(sourceDensity, targetDensity);
            }
        }

        public boolean hasCenterColor() {
            return this.mGradientColors != null && this.mGradientColors.length == 3;
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            if (this.mInnerRadius > 0) {
                this.mInnerRadius = Drawable.scaleFromDensity(this.mInnerRadius, sourceDensity, targetDensity, true);
            }
            if (this.mThickness > 0) {
                this.mThickness = Drawable.scaleFromDensity(this.mThickness, sourceDensity, targetDensity, true);
            }
            if (this.mOpticalInsets != Insets.NONE) {
                int left = Drawable.scaleFromDensity(this.mOpticalInsets.left, sourceDensity, targetDensity, true);
                int top = Drawable.scaleFromDensity(this.mOpticalInsets.top, sourceDensity, targetDensity, true);
                int right = Drawable.scaleFromDensity(this.mOpticalInsets.right, sourceDensity, targetDensity, true);
                int bottom = Drawable.scaleFromDensity(this.mOpticalInsets.bottom, sourceDensity, targetDensity, true);
                this.mOpticalInsets = Insets.of(left, top, right, bottom);
            }
            if (this.mPadding != null) {
                this.mPadding.left = Drawable.scaleFromDensity(this.mPadding.left, sourceDensity, targetDensity, false);
                this.mPadding.top = Drawable.scaleFromDensity(this.mPadding.top, sourceDensity, targetDensity, false);
                this.mPadding.right = Drawable.scaleFromDensity(this.mPadding.right, sourceDensity, targetDensity, false);
                this.mPadding.bottom = Drawable.scaleFromDensity(this.mPadding.bottom, sourceDensity, targetDensity, false);
            }
            if (this.mRadius > 0.0f) {
                this.mRadius = Drawable.scaleFromDensity(this.mRadius, sourceDensity, targetDensity);
            }
            if (this.mRadiusArray != null) {
                this.mRadiusArray[0] = Drawable.scaleFromDensity((int)this.mRadiusArray[0], sourceDensity, targetDensity, true);
                this.mRadiusArray[1] = Drawable.scaleFromDensity((int)this.mRadiusArray[1], sourceDensity, targetDensity, true);
                this.mRadiusArray[2] = Drawable.scaleFromDensity((int)this.mRadiusArray[2], sourceDensity, targetDensity, true);
                this.mRadiusArray[3] = Drawable.scaleFromDensity((int)this.mRadiusArray[3], sourceDensity, targetDensity, true);
            }
            if (this.mStrokeWidth > 0) {
                this.mStrokeWidth = Drawable.scaleFromDensity(this.mStrokeWidth, sourceDensity, targetDensity, true);
            }
            if (this.mStrokeDashWidth > 0.0f) {
                this.mStrokeDashWidth = Drawable.scaleFromDensity(this.mStrokeDashGap, sourceDensity, targetDensity);
            }
            if (this.mStrokeDashGap > 0.0f) {
                this.mStrokeDashGap = Drawable.scaleFromDensity(this.mStrokeDashGap, sourceDensity, targetDensity);
            }
            if (this.mGradientRadiusType == 0) {
                this.mGradientRadius = Drawable.scaleFromDensity(this.mGradientRadius, sourceDensity, targetDensity);
            }
            if (this.mWidth > 0) {
                this.mWidth = Drawable.scaleFromDensity(this.mWidth, sourceDensity, targetDensity, true);
            }
            if (this.mHeight > 0) {
                this.mHeight = Drawable.scaleFromDensity(this.mHeight, sourceDensity, targetDensity, true);
            }
        }

        @Override
        public boolean canApplyTheme() {
            return this.mThemeAttrs != null || this.mAttrSize != null || this.mAttrGradient != null || this.mAttrSolid != null || this.mAttrStroke != null || this.mAttrCorners != null || this.mAttrPadding != null || this.mTint != null && this.mTint.canApplyTheme() || this.mStrokeColors != null && this.mStrokeColors.canApplyTheme() || this.mSolidColors != null && this.mSolidColors.canApplyTheme() || super.canApplyTheme();
        }

        @Override
        public Drawable newDrawable() {
            return new GradientDrawable(this, null);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            int density = Drawable.resolveDensity(res, this.mDensity);
            GradientState state = density != this.mDensity ? new GradientState(this, res) : this;
            return new GradientDrawable(state, res);
        }

        @Override
        public int getChangingConfigurations() {
            return this.mChangingConfigurations | (this.mStrokeColors != null ? this.mStrokeColors.getChangingConfigurations() : 0) | (this.mSolidColors != null ? this.mSolidColors.getChangingConfigurations() : 0) | (this.mTint != null ? this.mTint.getChangingConfigurations() : 0);
        }

        public void setShape(int shape) {
            this.mShape = shape;
            this.computeOpacity();
        }

        public void setGradientType(int gradient) {
            this.mGradient = gradient;
        }

        public void setGradientCenter(float x, float y) {
            this.mCenterX = x;
            this.mCenterY = y;
        }

        public Orientation getOrientation() {
            return this.mOrientation;
        }

        public void setGradientColors(int[] colors) {
            this.mGradientColors = colors;
            this.mSolidColors = null;
            this.computeOpacity();
        }

        public void setSolidColors(ColorStateList colors) {
            this.mGradientColors = null;
            this.mSolidColors = colors;
            this.computeOpacity();
        }

        private void computeOpacity() {
            this.mOpaqueOverBounds = false;
            this.mOpaqueOverShape = false;
            if (this.mGradientColors != null) {
                for (int i = 0; i < this.mGradientColors.length; ++i) {
                    if (GradientDrawable.isOpaque(this.mGradientColors[i])) continue;
                    return;
                }
            }
            if (this.mGradientColors == null && this.mSolidColors == null) {
                return;
            }
            this.mOpaqueOverShape = true;
            this.mOpaqueOverBounds = this.mShape == 0 && this.mRadius <= 0.0f && this.mRadiusArray == null;
        }

        public void setStroke(int width, ColorStateList colors, float dashWidth, float dashGap) {
            this.mStrokeWidth = width;
            this.mStrokeColors = colors;
            this.mStrokeDashWidth = dashWidth;
            this.mStrokeDashGap = dashGap;
            this.computeOpacity();
        }

        public void setCornerRadius(float radius) {
            if (radius < 0.0f) {
                radius = 0.0f;
            }
            this.mRadius = radius;
            this.mRadiusArray = null;
            this.computeOpacity();
        }

        public void setCornerRadii(float[] radii) {
            this.mRadiusArray = radii;
            if (radii == null) {
                this.mRadius = 0.0f;
            }
            this.computeOpacity();
        }

        public void setSize(int width, int height) {
            this.mWidth = width;
            this.mHeight = height;
        }

        public void setGradientRadius(float gradientRadius, int type) {
            this.mGradientRadius = gradientRadius;
            this.mGradientRadiusType = type;
        }
    }

    public static enum Orientation {
        TOP_BOTTOM,
        TR_BL,
        RIGHT_LEFT,
        BR_TL,
        BOTTOM_TOP,
        BL_TR,
        LEFT_RIGHT,
        TL_BR;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RadiusType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GradientType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Shape {
    }
}

