/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.MaskFilter;
import com.android.tools.layoutlib.create.OverrideMethod;

public class TableMaskFilter
extends MaskFilter {
    public TableMaskFilter(byte[] table) {
        if (table.length < 256) {
            throw new RuntimeException("table.length must be >= 256");
        }
        this.native_instance = TableMaskFilter.nativeNewTable(table);
    }

    private TableMaskFilter(long ni) {
        this.native_instance = ni;
    }

    @UnsupportedAppUsage
    public static TableMaskFilter CreateClipTable(int min, int max) {
        return new TableMaskFilter(TableMaskFilter.nativeNewClip(min, max));
    }

    public static TableMaskFilter CreateGammaTable(float gamma) {
        return new TableMaskFilter(TableMaskFilter.nativeNewGamma(gamma));
    }

    private static long nativeNewTable(byte[] byArray) {
        return OverrideMethod.invokeL("android.graphics.TableMaskFilter#nativeNewTable([B)J", true, null);
    }

    private static long nativeNewClip(int n, int n2) {
        return OverrideMethod.invokeL("android.graphics.TableMaskFilter#nativeNewClip(II)J", true, null);
    }

    private static long nativeNewGamma(float f) {
        return OverrideMethod.invokeL("android.graphics.TableMaskFilter#nativeNewGamma(F)J", true, null);
    }
}

