/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.Shader;
import android.graphics.SweepGradient_Delegate;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class SweepGradient
extends Shader {
    @UnsupportedAppUsage
    private float mCx;
    @UnsupportedAppUsage
    private float mCy;
    @UnsupportedAppUsage
    private float[] mPositions;
    @UnsupportedAppUsage
    private int[] mColors;
    @UnsupportedAppUsage
    private int mColor0;
    @UnsupportedAppUsage
    private int mColor1;
    private final long[] mColorLongs;

    public SweepGradient(float cx, float cy, int[] colors, float[] positions) {
        this(cx, cy, SweepGradient.convertColors(colors), positions, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public SweepGradient(float cx, float cy, long[] colors, float[] positions) {
        this(cx, cy, (long[])colors.clone(), positions, SweepGradient.detectColorSpace(colors));
    }

    private SweepGradient(float cx, float cy, long[] colors, float[] positions, ColorSpace colorSpace) {
        super(colorSpace);
        if (positions != null && colors.length != positions.length) {
            throw new IllegalArgumentException("color and position arrays must be of equal length");
        }
        this.mCx = cx;
        this.mCy = cy;
        this.mColorLongs = colors;
        this.mPositions = positions != null ? (float[])positions.clone() : null;
    }

    public SweepGradient(float cx, float cy, int color0, int color1) {
        this(cx, cy, Color.pack(color0), Color.pack(color1));
    }

    public SweepGradient(float cx, float cy, long color0, long color1) {
        this(cx, cy, new long[]{color0, color1}, null);
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        return SweepGradient.nativeCreate(nativeMatrix, this.mCx, this.mCy, this.mColorLongs, this.mPositions, this.colorSpace().getNativeInstance());
    }

    @LayoutlibDelegate
    private static long nativeCreate(long l, float f, float f2, long[] lArray, float[] fArray, long l2) {
        return SweepGradient_Delegate.nativeCreate(l, f, f2, lArray, fArray, l2);
    }
}

