/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.ColorSpace;
import android.graphics.Color_Delegate;
import android.util.Half;
import com.android.internal.util.XmlUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.DoubleUnaryOperator;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private final float[] mComponents;
    private final ColorSpace mColorSpace;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public Color() {
        this.mComponents = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        this.mColorSpace = ColorSpace.get(ColorSpace.Named.SRGB);
    }

    private Color(float r, float g, float b, float a) {
        this(r, g, b, a, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    private Color(float r, float g, float b, float a, ColorSpace colorSpace) {
        this.mComponents = new float[]{r, g, b, a};
        this.mColorSpace = colorSpace;
    }

    private Color(float[] components, ColorSpace colorSpace) {
        this.mComponents = components;
        this.mColorSpace = colorSpace;
    }

    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    public ColorSpace.Model getModel() {
        return this.mColorSpace.getModel();
    }

    public boolean isWideGamut() {
        return this.getColorSpace().isWideGamut();
    }

    public boolean isSrgb() {
        return this.getColorSpace().isSrgb();
    }

    public int getComponentCount() {
        return this.mColorSpace.getComponentCount() + 1;
    }

    public long pack() {
        return Color.pack(this.mComponents[0], this.mComponents[1], this.mComponents[2], this.mComponents[3], this.mColorSpace);
    }

    public Color convert(ColorSpace colorSpace) {
        ColorSpace.Connector connector = ColorSpace.connect(this.mColorSpace, colorSpace);
        float[] color2 = new float[]{this.mComponents[0], this.mComponents[1], this.mComponents[2], this.mComponents[3]};
        connector.transform(color2);
        return new Color(color2, colorSpace);
    }

    public int toArgb() {
        if (this.mColorSpace.isSrgb()) {
            return (int)(this.mComponents[3] * 255.0f + 0.5f) << 24 | (int)(this.mComponents[0] * 255.0f + 0.5f) << 16 | (int)(this.mComponents[1] * 255.0f + 0.5f) << 8 | (int)(this.mComponents[2] * 255.0f + 0.5f);
        }
        float[] color2 = new float[]{this.mComponents[0], this.mComponents[1], this.mComponents[2], this.mComponents[3]};
        ColorSpace.connect(this.mColorSpace).transform(color2);
        return (int)(color2[3] * 255.0f + 0.5f) << 24 | (int)(color2[0] * 255.0f + 0.5f) << 16 | (int)(color2[1] * 255.0f + 0.5f) << 8 | (int)(color2[2] * 255.0f + 0.5f);
    }

    public float red() {
        return this.mComponents[0];
    }

    public float green() {
        return this.mComponents[1];
    }

    public float blue() {
        return this.mComponents[2];
    }

    public float alpha() {
        return this.mComponents[this.mComponents.length - 1];
    }

    public float[] getComponents() {
        return Arrays.copyOf(this.mComponents, this.mComponents.length);
    }

    public float[] getComponents(float[] components) {
        if (components == null) {
            return Arrays.copyOf(this.mComponents, this.mComponents.length);
        }
        if (components.length < this.mComponents.length) {
            throw new IllegalArgumentException("The specified array's length must be at least " + this.mComponents.length);
        }
        System.arraycopy(this.mComponents, 0, components, 0, this.mComponents.length);
        return components;
    }

    public float getComponent(int component) {
        return this.mComponents[component];
    }

    public float luminance() {
        if (this.mColorSpace.getModel() != ColorSpace.Model.RGB) {
            throw new IllegalArgumentException("The specified color must be encoded in an RGB color space. The supplied color space is " + (Object)((Object)this.mColorSpace.getModel()));
        }
        DoubleUnaryOperator eotf = ((ColorSpace.Rgb)this.mColorSpace).getEotf();
        double r = eotf.applyAsDouble(this.mComponents[0]);
        double g = eotf.applyAsDouble(this.mComponents[1]);
        double b = eotf.applyAsDouble(this.mComponents[2]);
        return Color.saturate((float)(0.2126 * r + 0.7152 * g + 0.0722 * b));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Color color2 = (Color)o;
        if (!Arrays.equals(this.mComponents, color2.mComponents)) {
            return false;
        }
        return this.mColorSpace.equals(color2.mColorSpace);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.mComponents);
        result = 31 * result + this.mColorSpace.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("Color(");
        for (float c : this.mComponents) {
            b.append(c).append(", ");
        }
        b.append(this.mColorSpace.getName());
        b.append(')');
        return b.toString();
    }

    public static ColorSpace colorSpace(long color2) {
        return ColorSpace.get((int)(color2 & 0x3FL));
    }

    public static float red(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 48 & 0xFFL) / 255.0f;
        }
        return Half.toFloat((short)(color2 >> 48 & 0xFFFFL));
    }

    public static float green(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 40 & 0xFFL) / 255.0f;
        }
        return Half.toFloat((short)(color2 >> 32 & 0xFFFFL));
    }

    public static float blue(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 32 & 0xFFL) / 255.0f;
        }
        return Half.toFloat((short)(color2 >> 16 & 0xFFFFL));
    }

    public static float alpha(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (float)(color2 >> 56 & 0xFFL) / 255.0f;
        }
        return (float)(color2 >> 6 & 0x3FFL) / 1023.0f;
    }

    public static boolean isSrgb(long color2) {
        return Color.colorSpace(color2).isSrgb();
    }

    public static boolean isWideGamut(long color2) {
        return Color.colorSpace(color2).isWideGamut();
    }

    public static boolean isInColorSpace(long color2, ColorSpace colorSpace) {
        return (int)(color2 & 0x3FL) == colorSpace.getId();
    }

    public static int toArgb(long color2) {
        if ((color2 & 0x3FL) == 0L) {
            return (int)(color2 >> 32);
        }
        float r = Color.red(color2);
        float g = Color.green(color2);
        float b = Color.blue(color2);
        float a = Color.alpha(color2);
        float[] c = ColorSpace.connect(Color.colorSpace(color2)).transform(r, g, b);
        return (int)(a * 255.0f + 0.5f) << 24 | (int)(c[0] * 255.0f + 0.5f) << 16 | (int)(c[1] * 255.0f + 0.5f) << 8 | (int)(c[2] * 255.0f + 0.5f);
    }

    public static Color valueOf(int color2) {
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
        return new Color(r, g, b, a, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public static Color valueOf(long color2) {
        return new Color(Color.red(color2), Color.green(color2), Color.blue(color2), Color.alpha(color2), Color.colorSpace(color2));
    }

    public static Color valueOf(float r, float g, float b) {
        return new Color(r, g, b, 1.0f);
    }

    public static Color valueOf(float r, float g, float b, float a) {
        return new Color(Color.saturate(r), Color.saturate(g), Color.saturate(b), Color.saturate(a));
    }

    public static Color valueOf(float r, float g, float b, float a, ColorSpace colorSpace) {
        if (colorSpace.getComponentCount() > 3) {
            throw new IllegalArgumentException("The specified color space must use a color model with at most 3 color components");
        }
        return new Color(r, g, b, a, colorSpace);
    }

    public static Color valueOf(float[] components, ColorSpace colorSpace) {
        if (components.length < colorSpace.getComponentCount() + 1) {
            throw new IllegalArgumentException("Received a component array of length " + components.length + " but the color model requires " + (colorSpace.getComponentCount() + 1) + " (including alpha)");
        }
        return new Color(Arrays.copyOf(components, colorSpace.getComponentCount() + 1), colorSpace);
    }

    public static long pack(int color2) {
        return ((long)color2 & 0xFFFFFFFFL) << 32;
    }

    public static long pack(float red, float green, float blue) {
        return Color.pack(red, green, blue, 1.0f, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public static long pack(float red, float green, float blue, float alpha) {
        return Color.pack(red, green, blue, alpha, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public static long pack(float red, float green, float blue, float alpha, ColorSpace colorSpace) {
        if (colorSpace.isSrgb()) {
            int argb = (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
            return ((long)argb & 0xFFFFFFFFL) << 32;
        }
        int id2 = colorSpace.getId();
        if (id2 == -1) {
            throw new IllegalArgumentException("Unknown color space, please use a color space returned by ColorSpace.get()");
        }
        if (colorSpace.getComponentCount() > 3) {
            throw new IllegalArgumentException("The color space must use a color model with at most 3 components");
        }
        short r = Half.toHalf(red);
        short g = Half.toHalf(green);
        short b = Half.toHalf(blue);
        int a = (int)(Math.max(0.0f, Math.min(alpha, 1.0f)) * 1023.0f + 0.5f);
        return ((long)r & 0xFFFFL) << 48 | ((long)g & 0xFFFFL) << 32 | ((long)b & 0xFFFFL) << 16 | ((long)a & 0x3FFL) << 6 | (long)id2 & 0x3FL;
    }

    public static long convert(int color2, ColorSpace colorSpace) {
        float r = (float)(color2 >> 16 & 0xFF) / 255.0f;
        float g = (float)(color2 >> 8 & 0xFF) / 255.0f;
        float b = (float)(color2 & 0xFF) / 255.0f;
        float a = (float)(color2 >> 24 & 0xFF) / 255.0f;
        ColorSpace source = ColorSpace.get(ColorSpace.Named.SRGB);
        return Color.convert(r, g, b, a, source, colorSpace);
    }

    public static long convert(long color2, ColorSpace colorSpace) {
        float r = Color.red(color2);
        float g = Color.green(color2);
        float b = Color.blue(color2);
        float a = Color.alpha(color2);
        ColorSpace source = Color.colorSpace(color2);
        return Color.convert(r, g, b, a, source, colorSpace);
    }

    public static long convert(float r, float g, float b, float a, ColorSpace source, ColorSpace destination) {
        float[] c = ColorSpace.connect(source, destination).transform(r, g, b);
        return Color.pack(c[0], c[1], c[2], a, destination);
    }

    public static long convert(long color2, ColorSpace.Connector connector) {
        float r = Color.red(color2);
        float g = Color.green(color2);
        float b = Color.blue(color2);
        float a = Color.alpha(color2);
        return Color.convert(r, g, b, a, connector);
    }

    public static long convert(float r, float g, float b, float a, ColorSpace.Connector connector) {
        float[] c = connector.transform(r, g, b);
        return Color.pack(c[0], c[1], c[2], a, connector.getDestination());
    }

    public static float luminance(long color2) {
        ColorSpace colorSpace = Color.colorSpace(color2);
        if (colorSpace.getModel() != ColorSpace.Model.RGB) {
            throw new IllegalArgumentException("The specified color must be encoded in an RGB color space. The supplied color space is " + (Object)((Object)colorSpace.getModel()));
        }
        DoubleUnaryOperator eotf = ((ColorSpace.Rgb)colorSpace).getEotf();
        double r = eotf.applyAsDouble(Color.red(color2));
        double g = eotf.applyAsDouble(Color.green(color2));
        double b = eotf.applyAsDouble(Color.blue(color2));
        return Color.saturate((float)(0.2126 * r + 0.7152 * g + 0.0722 * b));
    }

    private static float saturate(float v) {
        return v <= 0.0f ? 0.0f : (v >= 1.0f ? 1.0f : v);
    }

    public static int alpha(int color2) {
        return color2 >>> 24;
    }

    public static int red(int color2) {
        return color2 >> 16 & 0xFF;
    }

    public static int green(int color2) {
        return color2 >> 8 & 0xFF;
    }

    public static int blue(int color2) {
        return color2 & 0xFF;
    }

    public static int rgb(int red, int green, int blue) {
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    public static int rgb(float red, float green, float blue) {
        return 0xFF000000 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public static int argb(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int argb(float alpha, float red, float green, float blue) {
        return (int)(alpha * 255.0f + 0.5f) << 24 | (int)(red * 255.0f + 0.5f) << 16 | (int)(green * 255.0f + 0.5f) << 8 | (int)(blue * 255.0f + 0.5f);
    }

    public static float luminance(int color2) {
        ColorSpace.Rgb cs = (ColorSpace.Rgb)ColorSpace.get(ColorSpace.Named.SRGB);
        DoubleUnaryOperator eotf = cs.getEotf();
        double r = eotf.applyAsDouble((double)Color.red(color2) / 255.0);
        double g = eotf.applyAsDouble((double)Color.green(color2) / 255.0);
        double b = eotf.applyAsDouble((double)Color.blue(color2) / 255.0);
        return (float)(0.2126 * r + 0.7152 * g + 0.0722 * b);
    }

    public static int parseColor(String colorString) {
        if (colorString.charAt(0) == '#') {
            long color2 = Long.parseLong(colorString.substring(1), 16);
            if (colorString.length() == 7) {
                color2 |= 0xFFFFFFFFFF000000L;
            } else if (colorString.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)color2;
        }
        Integer color3 = sColorNameMap.get(colorString.toLowerCase(Locale.ROOT));
        if (color3 != null) {
            return color3;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static void RGBToHSV(int red, int green, int blue, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(red, green, blue, hsv);
    }

    public static void colorToHSV(int color2, float[] hsv) {
        Color.RGBToHSV(color2 >> 16 & 0xFF, color2 >> 8 & 0xFF, color2 & 0xFF, hsv);
    }

    public static int HSVToColor(float[] hsv) {
        return Color.HSVToColor(255, hsv);
    }

    public static int HSVToColor(int alpha, float[] hsv) {
        if (hsv.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(alpha, hsv);
    }

    @LayoutlibDelegate
    private static void nativeRGBToHSV(int n, int n2, int n3, float[] fArray) {
        Color_Delegate.nativeRGBToHSV(n, n2, n3, fArray);
    }

    @LayoutlibDelegate
    private static int nativeHSVToColor(int n, float[] fArray) {
        return Color_Delegate.nativeHSVToColor(n, fArray);
    }

    public static int getHtmlColor(String color2) {
        Integer i = sColorNameMap.get(color2.toLowerCase(Locale.ROOT));
        if (i != null) {
            return i;
        }
        try {
            return XmlUtils.convertValueToInt(color2, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
        sColorNameMap.put("aqua", -16711681);
        sColorNameMap.put("fuchsia", -65281);
        sColorNameMap.put("darkgrey", -12303292);
        sColorNameMap.put("grey", -7829368);
        sColorNameMap.put("lightgrey", -3355444);
        sColorNameMap.put("lime", -16711936);
        sColorNameMap.put("maroon", -8388608);
        sColorNameMap.put("navy", -16777088);
        sColorNameMap.put("olive", -8355840);
        sColorNameMap.put("purple", -8388480);
        sColorNameMap.put("silver", -4144960);
        sColorNameMap.put("teal", -16744320);
    }
}

