/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.Bitmap;
import android.graphics.BitmapShader_Delegate;
import android.graphics.Shader;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;

public class BitmapShader
extends Shader {
    @UnsupportedAppUsage
    public Bitmap mBitmap;
    @UnsupportedAppUsage
    private int mTileX;
    @UnsupportedAppUsage
    private int mTileY;

    public BitmapShader(Bitmap bitmap, Shader.TileMode tileX, Shader.TileMode tileY) {
        this(bitmap, tileX.nativeInt, tileY.nativeInt);
    }

    private BitmapShader(Bitmap bitmap, int tileX, int tileY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must be non-null");
        }
        if (bitmap == this.mBitmap && tileX == this.mTileX && tileY == this.mTileY) {
            return;
        }
        this.mBitmap = bitmap;
        this.mTileX = tileX;
        this.mTileY = tileY;
    }

    @Override
    long createNativeInstance(long nativeMatrix) {
        return BitmapShader.nativeCreate(nativeMatrix, this.mBitmap.getNativeInstance(), this.mTileX, this.mTileY);
    }

    @LayoutlibDelegate
    private static long nativeCreate(long l, long l2, int n, int n2) {
        return BitmapShader_Delegate.nativeCreate(l, l2, n, n2);
    }
}

