/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.compat.annotation.UnsupportedAppUsage;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;

public class DdmHandleAppName
extends ChunkHandler {
    public static final int CHUNK_APNM = DdmHandleAppName.type("APNM");
    private static volatile Names sNames = new Names("", "");
    private static DdmHandleAppName mInstance = new DdmHandleAppName();

    private DdmHandleAppName() {
    }

    public static void register() {
    }

    @Override
    public void connected() {
    }

    @Override
    public void disconnected() {
    }

    @Override
    public Chunk handleChunk(Chunk request) {
        return null;
    }

    @UnsupportedAppUsage
    public static void setAppName(String name, int userId) {
        DdmHandleAppName.setAppName(name, name, userId);
    }

    @UnsupportedAppUsage
    public static void setAppName(String appName, String pkgName, int userId) {
        if (appName == null || appName.isEmpty() || pkgName == null || pkgName.isEmpty()) {
            return;
        }
        sNames = new Names(appName, pkgName);
        DdmHandleAppName.sendAPNM(appName, pkgName, userId);
    }

    @UnsupportedAppUsage
    public static Names getNames() {
        return sNames;
    }

    private static void sendAPNM(String appName, String pkgName, int userId) {
        ByteBuffer out = ByteBuffer.allocate(4 + appName.length() * 2 + 4 + 4 + pkgName.length() * 2);
        out.order(ChunkHandler.CHUNK_ORDER);
        out.putInt(appName.length());
        DdmHandleAppName.putString(out, appName);
        out.putInt(userId);
        out.putInt(pkgName.length());
        DdmHandleAppName.putString(out, pkgName);
        Chunk chunk = new Chunk(CHUNK_APNM, out);
        DdmServer.sendChunk(chunk);
    }

    static class Names {
        private final String mAppName;
        private final String mPkgName;

        private Names(String appName, String pkgName) {
            this.mAppName = appName;
            this.mPkgName = pkgName;
        }

        public String getAppName() {
            return this.mAppName;
        }

        public String getPkgName() {
            return this.mPkgName;
        }
    }
}

