/*
 * Decompiled with CFR 0.152.
 */
package android.database;

import android.database.BulkCursorDescriptor;
import android.database.BulkCursorNative;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.IContentObserver;
import android.database.StaleDataException;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.Collection;

public class CursorToBulkCursorAdaptor
extends BulkCursorNative
implements IBinder.DeathRecipient {
    private static final String TAG = "Cursor";
    private final Object mLock = new Object();
    private final String mProviderName;
    private ContentObserverProxy mObserver;
    private CrossProcessCursor mCursor;
    private CursorWindow mFilledWindow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorToBulkCursorAdaptor(Cursor cursor, IContentObserver observer, String providerName) {
        this.mCursor = cursor instanceof CrossProcessCursor ? (CrossProcessCursor)cursor : new CrossProcessCursorWrapper(cursor);
        this.mProviderName = providerName;
        Object object = this.mLock;
        synchronized (object) {
            this.createAndRegisterObserverProxyLocked(observer);
        }
    }

    private void closeFilledWindowLocked() {
        if (this.mFilledWindow != null) {
            this.mFilledWindow.close();
            this.mFilledWindow = null;
        }
    }

    private void disposeLocked() {
        if (this.mCursor != null) {
            this.unregisterObserverProxyLocked();
            this.mCursor.close();
            this.mCursor = null;
        }
        this.closeFilledWindowLocked();
    }

    private void throwIfCursorIsClosed() {
        if (this.mCursor == null) {
            throw new StaleDataException("Attempted to access a cursor after it has been closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void binderDied() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkCursorDescriptor getBulkCursorDescriptor() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            BulkCursorDescriptor d = new BulkCursorDescriptor();
            d.cursor = this;
            d.columnNames = this.mCursor.getColumnNames();
            d.wantsAllOnMoveCalls = this.mCursor.getWantsAllOnMoveCalls();
            d.count = this.mCursor.getCount();
            d.window = this.mCursor.getWindow();
            if (d.window != null) {
                d.window.acquireReference();
            }
            return d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CursorWindow getWindow(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            if (!this.mCursor.moveToPosition(position)) {
                this.closeFilledWindowLocked();
                return null;
            }
            CursorWindow window = this.mCursor.getWindow();
            if (window != null) {
                this.closeFilledWindowLocked();
            } else {
                window = this.mFilledWindow;
                if (window == null) {
                    window = this.mFilledWindow = new CursorWindow(this.mProviderName);
                } else if (position < window.getStartPosition() || position >= window.getStartPosition() + window.getNumRows()) {
                    window.clear();
                }
                this.mCursor.fillWindow(position, window);
            }
            if (window != null) {
                window.acquireReference();
            }
            return window;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMove(int position) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.mCursor.onMove(this.mCursor.getPosition(), position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deactivate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCursor != null) {
                this.unregisterObserverProxyLocked();
                this.mCursor.deactivate();
            }
            this.closeFilledWindowLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.disposeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int requery(IContentObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            this.closeFilledWindowLocked();
            try {
                if (!this.mCursor.requery()) {
                    return -1;
                }
            }
            catch (IllegalStateException e) {
                IllegalStateException leakProgram = new IllegalStateException(this.mProviderName + " Requery misuse db, mCursor isClosed:" + this.mCursor.isClosed(), e);
                throw leakProgram;
            }
            this.unregisterObserverProxyLocked();
            this.createAndRegisterObserverProxyLocked(observer);
            return this.mCursor.getCount();
        }
    }

    private void createAndRegisterObserverProxyLocked(IContentObserver observer) {
        if (this.mObserver != null) {
            throw new IllegalStateException("an observer is already registered");
        }
        this.mObserver = new ContentObserverProxy(observer, this);
        this.mCursor.registerContentObserver(this.mObserver);
    }

    private void unregisterObserverProxyLocked() {
        if (this.mObserver != null) {
            this.mCursor.unregisterContentObserver(this.mObserver);
            this.mObserver.unlinkToDeath(this);
            this.mObserver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getExtras() {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.getExtras();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle respond(Bundle extras) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfCursorIsClosed();
            return this.mCursor.respond(extras);
        }
    }

    private static class ContentObserverProxy
    extends ContentObserver {
        protected IContentObserver mRemote;

        public ContentObserverProxy(IContentObserver remoteObserver, IBinder.DeathRecipient recipient) {
            super(null);
            this.mRemote = remoteObserver;
            try {
                remoteObserver.asBinder().linkToDeath(recipient, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        public boolean unlinkToDeath(IBinder.DeathRecipient recipient) {
            return this.mRemote.asBinder().unlinkToDeath(recipient, 0);
        }

        @Override
        public boolean deliverSelfNotifications() {
            return false;
        }

        @Override
        public void onChange(boolean selfChange, Collection<Uri> uris, int flags, int userId) {
            ArrayList asList = new ArrayList();
            uris.forEach(asList::add);
            Uri[] asArray = asList.toArray(new Uri[asList.size()]);
            try {
                this.mRemote.onChangeEtc(selfChange, asArray, flags, userId);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

