/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ColorStateList;
import android.content.res.ComplexColor;
import android.content.res.Resources;
import android.content.res.Resources_Delegate;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.graphics.Typeface_Accessor;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.util.TypedValue;
import android.view.LayoutInflater_Delegate;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.rendering.api.TextResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.UnresolvedResourceValue;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public final class BridgeTypedArray
extends TypedArray {
    private static final String MATCH_PARENT_INT_STRING = String.valueOf(-1);
    private static final String WRAP_CONTENT_INT_STRING = String.valueOf(-2);
    private final Resources mBridgeResources;
    private final BridgeContext mContext;
    private final int[] mResourceId;
    private final ResourceValue[] mResourceData;
    private final String[] mNames;
    private final ResourceNamespace[] mNamespaces;
    private int[] mEmptyIds;

    public BridgeTypedArray(Resources resources, BridgeContext context, int len) {
        super(resources);
        this.mBridgeResources = resources;
        this.mContext = context;
        this.mResourceId = new int[len];
        this.mResourceData = new ResourceValue[len];
        this.mNames = new String[len];
        this.mNamespaces = new ResourceNamespace[len];
    }

    public void bridgeSetValue(int index, String name, ResourceNamespace namespace, int resourceId, ResourceValue value) {
        this.mResourceId[index] = resourceId;
        this.mResourceData[index] = value;
        this.mNames[index] = name;
        this.mNamespaces[index] = namespace;
    }

    public void sealArray() {
        int i;
        int count = 0;
        ArrayList<Integer> emptyIds = null;
        for (i = 0; i < this.mResourceData.length; ++i) {
            ResourceValue data = this.mResourceData[i];
            if (data == null) continue;
            String dataValue = data.getValue();
            if ("@null".equals(dataValue) || "@undefined".equals(dataValue)) {
                this.mResourceData[i] = null;
                continue;
            }
            if ("@empty".equals(dataValue)) {
                this.mResourceData[i] = null;
                if (emptyIds == null) {
                    emptyIds = new ArrayList<Integer>(4);
                }
                emptyIds.add(i);
                continue;
            }
            ++count;
        }
        if (emptyIds != null) {
            this.mEmptyIds = new int[emptyIds.size()];
            for (i = 0; i < emptyIds.size(); ++i) {
                this.mEmptyIds[i] = (Integer)emptyIds.get(i);
            }
        }
        this.mIndices = new int[count + 1];
        this.mIndices[0] = count;
        int index = 1;
        for (int i2 = 0; i2 < this.mResourceData.length; ++i2) {
            if (this.mResourceData[i2] == null) continue;
            this.mIndices[index++] = i2;
        }
    }

    public void setTheme(Resources.Theme theme) {
        this.mTheme = theme;
    }

    @Override
    public int length() {
        return this.mResourceData.length;
    }

    @Override
    public Resources getResources() {
        return this.mBridgeResources;
    }

    @Override
    public CharSequence getText(int index) {
        String rawValue;
        if (!this.hasValue(index)) {
            return null;
        }
        Integer v = this.resolveEnumAttribute(index);
        if (v != null) {
            return String.valueOf(v);
        }
        ResourceValue resourceValue = this.mResourceData[index];
        String value = resourceValue.getValue();
        if (resourceValue instanceof TextResourceValue && (rawValue = resourceValue.getRawXmlValue()) != null && !rawValue.equals(value)) {
            return Html.fromHtml(rawValue, 63);
        }
        return value;
    }

    @Override
    public String getString(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        Integer v = this.resolveEnumAttribute(index);
        return v == null ? this.mResourceData[index].getValue() : String.valueOf(v);
    }

    @Override
    public boolean getBoolean(int index, boolean defValue) {
        String s = this.getString(index);
        return s == null ? defValue : XmlUtils.convertValueToBoolean(s, defValue);
    }

    @Override
    public int getInt(int index, int defValue) {
        String s = this.getString(index);
        try {
            return BridgeTypedArray.convertValueToInt(s, defValue);
        }
        catch (NumberFormatException e) {
            Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid integer", s, this.mNames[index]), null, null);
            return defValue;
        }
    }

    @Override
    public float getFloat(int index, float defValue) {
        String s = this.getString(index);
        try {
            if (s != null) {
                return Float.parseFloat(s);
            }
        }
        catch (NumberFormatException e) {
            Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to float.", s, this.mNames[index]), null, null);
        }
        return defValue;
    }

    @Override
    public int getColor(int index, int defValue) {
        if (index < 0 || index >= this.mResourceData.length) {
            return defValue;
        }
        if (this.mResourceData[index] == null) {
            return defValue;
        }
        ColorStateList colorStateList = ResourceHelper.getColorStateList(this.mResourceData[index], this.mContext, this.mTheme);
        if (colorStateList != null) {
            return colorStateList.getDefaultColor();
        }
        return defValue;
    }

    @Override
    public ColorStateList getColorStateList(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        return ResourceHelper.getColorStateList(this.mResourceData[index], this.mContext, this.mTheme);
    }

    @Override
    public ComplexColor getComplexColor(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        return ResourceHelper.getComplexColor(this.mResourceData[index], this.mContext, this.mTheme);
    }

    @Override
    public int getInteger(int index, int defValue) {
        return this.getInt(index, defValue);
    }

    @Override
    public float getDimension(int index, float defValue) {
        String s = this.getString(index);
        if (s == null) {
            return defValue;
        }
        if (MATCH_PARENT_INT_STRING.equals(s)) {
            return -1.0f;
        }
        if (WRAP_CONTENT_INT_STRING.equals(s)) {
            return -2.0f;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
            return this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
        }
        return defValue;
    }

    @Override
    public int getDimensionPixelOffset(int index, int defValue) {
        return (int)this.getDimension(index, defValue);
    }

    @Override
    public int getDimensionPixelSize(int index, int defValue) {
        String s = this.getString(index);
        if (s == null) {
            return defValue;
        }
        if (MATCH_PARENT_INT_STRING.equals(s)) {
            return -1;
        }
        if (WRAP_CONTENT_INT_STRING.equals(s)) {
            return -2;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
            float f = this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
            int res = (int)(f + 0.5f);
            if (res != 0) {
                return res;
            }
            if (f == 0.0f) {
                return 0;
            }
            if (f > 0.0f) {
                return 1;
            }
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" is not a valid format.", s, this.mNames[index]), null, null);
        return defValue;
    }

    @Override
    public int getLayoutDimension(int index, String name) {
        String s = this.getString(index);
        if (s != null) {
            if (MATCH_PARENT_INT_STRING.equals(s)) {
                return -1;
            }
            if (WRAP_CONTENT_INT_STRING.equals(s)) {
                return -2;
            }
            if (ResourceHelper.parseFloatAttribute(this.mNames[index], s, this.mValue, true)) {
                float f = this.mValue.getDimension(this.mBridgeResources.getDisplayMetrics());
                int res = (int)(f + 0.5f);
                if (res != 0) {
                    return res;
                }
                if (f == 0.0f) {
                    return 0;
                }
                if (f > 0.0f) {
                    return 1;
                }
            }
        }
        if (LayoutInflater_Delegate.sIsInInclude) {
            throw new RuntimeException("Layout Dimension '" + name + "' not found.");
        }
        Bridge.getLog().warning("resources.format", "You must supply a " + name + " attribute.", null, null);
        return 0;
    }

    @Override
    public int getLayoutDimension(int index, int defValue) {
        return this.getDimensionPixelSize(index, defValue);
    }

    @Override
    public float getFraction(int index, int base, int pbase, float defValue) {
        String value = this.getString(index);
        if (value == null) {
            return defValue;
        }
        if (ResourceHelper.parseFloatAttribute(this.mNames[index], value, this.mValue, false)) {
            return this.mValue.getFraction(base, pbase);
        }
        Bridge.getLog().warning("resources.format", String.format("\"%1$s\" in attribute \"%2$s\" cannot be converted to a fraction.", value, this.mNames[index]), null, null);
        return defValue;
    }

    @Override
    public int getResourceId(int index, int defValue) {
        Integer enumValue;
        if (index < 0 || index >= this.mResourceData.length) {
            return defValue;
        }
        ResourceValue resValue = this.mResourceData[index];
        if (resValue == null) {
            return defValue;
        }
        if (resValue instanceof StyleResourceValue) {
            return this.mContext.getDynamicIdByStyle((StyleResourceValue)resValue);
        }
        if (!(resValue instanceof UnresolvedResourceValue)) {
            return this.mContext.getResourceId(resValue.asReference(), defValue);
        }
        String value = resValue.getValue();
        if (value == null) {
            return defValue;
        }
        value = value.trim();
        ResourceNamespace contextNamespace = resValue.getNamespace();
        ResourceNamespace.Resolver namespaceResolver = resValue.getNamespaceResolver();
        if (value.startsWith("#")) {
            return defValue;
        }
        if (Typeface_Accessor.isSystemFont(value)) {
            return defValue;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)value);
        if (resourceUrl != null) {
            if (resourceUrl.type == ResourceType.ID) {
                ResourceReference referencedId = resourceUrl.resolve(contextNamespace, namespaceResolver);
                if (resourceUrl.isCreate()) {
                    int idValue = referencedId.getNamespace() == ResourceNamespace.ANDROID ? Bridge.getResourceId(ResourceType.ID, resourceUrl.name) : this.mContext.getLayoutlibCallback().getOrGenerateResourceId(referencedId);
                    return idValue;
                }
                return this.mContext.getResourceId(referencedId, defValue);
            }
            if (resourceUrl.type == ResourceType.AAPT) {
                ResourceReference referencedId = resourceUrl.resolve(contextNamespace, namespaceResolver);
                return this.mContext.getLayoutlibCallback().getOrGenerateResourceId(referencedId);
            }
        }
        if ((enumValue = this.resolveEnumAttribute(index)) != null) {
            return enumValue;
        }
        return defValue;
    }

    @Override
    public int getThemeAttributeId(int index, int defValue) {
        return defValue;
    }

    @Override
    public Drawable getDrawable(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue value = this.mResourceData[index];
        return ResourceHelper.getDrawable(value, this.mContext, this.mTheme);
    }

    @Override
    public Drawable getDrawableForDensity(int index, int density) {
        return this.getDrawable(index);
    }

    @Override
    public Typeface getFont(int index) {
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue value = this.mResourceData[index];
        return ResourceHelper.getFont(value, this.mContext, this.mTheme);
    }

    @Override
    public CharSequence[] getTextArray(int index) {
        String resIdMessage;
        if (!this.hasValue(index)) {
            return null;
        }
        ResourceValue resVal = this.mResourceData[index];
        if (resVal instanceof ArrayResourceValue) {
            ArrayResourceValue array2 = (ArrayResourceValue)resVal;
            int count = array2.getElementCount();
            return count >= 0 ? Resources_Delegate.resolveValues(this.mBridgeResources, array2) : null;
        }
        int id2 = this.getResourceId(index, 0);
        String string2 = resIdMessage = id2 > 0 ? " (resource id 0x" + Integer.toHexString(id2) + ')' : "";
        assert (false) : String.format("%1$s in %2$s%3$s is not a valid array resource.", resVal.getValue(), this.mNames[index], resIdMessage);
        return new CharSequence[0];
    }

    @Override
    public int[] extractThemeAttrs() {
        return null;
    }

    @Override
    public int getChangingConfigurations() {
        return 0;
    }

    @Override
    public boolean getValue(int index, TypedValue outValue) {
        outValue.type = this.getType(index);
        switch (outValue.type) {
            case 0: {
                return false;
            }
            case 3: {
                outValue.string = this.getString(index);
                return true;
            }
            case 1: {
                outValue.resourceId = this.mResourceId[index];
                return true;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                ColorStateList colorStateList = this.getColorStateList(index);
                if (colorStateList == null) {
                    return false;
                }
                outValue.data = colorStateList.getDefaultColor();
                return true;
            }
        }
        String s = this.getString(index);
        return s != null && ResourceHelper.parseFloatAttribute(this.mNames[index], s, outValue, false);
    }

    @Override
    public int getType(int index) {
        String value = this.getString(index);
        return BridgeTypedArray.getType(value);
    }

    @Override
    public boolean hasValue(int index) {
        return index >= 0 && index < this.mResourceData.length && this.mResourceData[index] != null;
    }

    @Override
    public boolean hasValueOrEmpty(int index) {
        return this.hasValue(index) || index >= 0 && index < this.mResourceData.length && this.mEmptyIds != null && Arrays.binarySearch(this.mEmptyIds, index) >= 0;
    }

    @Override
    public TypedValue peekValue(int index) {
        if (index < 0 || index >= this.mResourceData.length) {
            return null;
        }
        if (this.getValue(index, this.mValue)) {
            return this.mValue;
        }
        return null;
    }

    @Override
    public String getPositionDescription() {
        return "<internal -- stub if needed>";
    }

    @Override
    public void recycle() {
    }

    @Override
    public String toString() {
        return Arrays.toString(this.mResourceData);
    }

    private Integer resolveEnumAttribute(int index) {
        Map map = null;
        if (this.mNamespaces[index] == ResourceNamespace.ANDROID) {
            map = Bridge.getEnumValues(this.mNames[index]);
        } else {
            RenderResources res = this.mContext.getRenderResources();
            ResourceValue attr2 = res.getResolvedResource(ResourceReference.attr((ResourceNamespace)this.mNamespaces[index], (String)this.mNames[index]));
            if (attr2 instanceof AttrResourceValue) {
                map = ((AttrResourceValue)attr2).getAttributeValues();
            }
        }
        if (map != null && !map.isEmpty()) {
            int result = 0;
            boolean found = false;
            String value = this.mResourceData[index].getValue();
            if (!value.isEmpty()) {
                String[] keywords;
                char c = value.charAt(0);
                if (Character.isDigit(c) || c == '-' || c == '+') {
                    try {
                        return BridgeTypedArray.convertValueToInt(value, 0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                for (String keyword : keywords = value.split("\\|")) {
                    Integer i = (Integer)map.get(keyword.trim());
                    if (i == null) continue;
                    result |= i.intValue();
                    found = true;
                }
                if (found) {
                    return result;
                }
            }
        }
        return null;
    }

    private static int convertValueToInt(String charSeq, int defValue) {
        if (null == charSeq || charSeq.isEmpty()) {
            return defValue;
        }
        int sign = 1;
        int index = 0;
        int len = charSeq.length();
        int base = 10;
        if ('-' == charSeq.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == charSeq.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = charSeq.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
            }
        } else {
            if ('#' == charSeq.charAt(index)) {
                return ResourceHelper.getColor(charSeq) * sign;
            }
            if ("true".equals(charSeq) || "TRUE".equals(charSeq)) {
                return -1;
            }
            if ("false".equals(charSeq) || "FALSE".equals(charSeq)) {
                return 0;
            }
        }
        return (int)Long.parseLong(charSeq.substring(index), base) * sign;
    }

    protected static int getType(String value) {
        if (value == null) {
            return 0;
        }
        if (value.startsWith("@")) {
            return 1;
        }
        if (value.startsWith("?")) {
            return 2;
        }
        if (value.equals("true") || value.equals("false")) {
            return 18;
        }
        if (value.startsWith("0x") || value.startsWith("0X")) {
            try {
                Long.parseLong(value.substring(2), 16);
                return 17;
            }
            catch (NumberFormatException e) {
                return 3;
            }
        }
        if (value.startsWith("#")) {
            try {
                ResourceHelper.getColor(value);
                int length = value.length() - 1;
                if (length == 3) {
                    return 31;
                }
                if (length == 4) {
                    return 30;
                }
                if (length == 6) {
                    return 29;
                }
                if (length == 8) {
                    return 28;
                }
            }
            catch (NumberFormatException e) {
                return 3;
            }
        }
        if (!Character.isDigit(value.charAt(value.length() - 1))) {
            if (ResourceHelper.parseFloatAttribute(null, value, new TypedValue(), false)) {
                return 5;
            }
            return 3;
        }
        try {
            BridgeTypedArray.convertValueToInt(value, 0);
            return 16;
        }
        catch (NumberFormatException ignored) {
            try {
                Float.parseFloat(value);
                return 4;
            }
            catch (NumberFormatException numberFormatException) {
                return 3;
            }
        }
    }

    static TypedArray obtain(Resources res, int len) {
        return new BridgeTypedArray(res, null, len);
    }
}

