/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.IntentFilter;
import android.content.pm.PackageParser;
import android.content.pm.parsing.ParsingPackage;
import android.content.pm.parsing.ParsingUtils;
import android.content.pm.parsing.component.ParsedIntentInfo;
import android.content.pm.parsing.result.ParseInput;
import android.content.pm.parsing.result.ParseResult;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class ParsedIntentInfoUtils {
    private static final String TAG = "PackageParsing";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseResult<ParsedIntentInfo> parseIntentInfo(String className, ParsingPackage pkg, Resources res, XmlResourceParser parser, boolean allowGlobs, boolean allowAutoVerify, ParseInput input) throws XmlPullParserException, IOException {
        int type;
        ParsedIntentInfo intentInfo = new ParsedIntentInfo();
        TypedArray sa = res.obtainAttributes(parser, R.styleable.AndroidManifestIntentFilter);
        try {
            intentInfo.setPriority(sa.getInt(2, 0));
            intentInfo.setOrder(sa.getInt(3, 0));
            TypedValue v = sa.peekValue(0);
            if (v != null) {
                intentInfo.labelRes = v.resourceId;
                if (v.resourceId == 0) {
                    intentInfo.nonLocalizedLabel = v.coerceToString();
                }
            }
            if (PackageParser.sUseRoundIcon) {
                intentInfo.icon = sa.getResourceId(7, 0);
            }
            if (intentInfo.icon == 0) {
                intentInfo.icon = sa.getResourceId(1, 0);
            }
            if (allowAutoVerify) {
                intentInfo.setAutoVerify(sa.getBoolean(6, false));
            }
        }
        finally {
            sa.recycle();
        }
        int depth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > depth)) {
            ParseResult<ParsedIntentInfo> result;
            String nodeName;
            if (type != 2) continue;
            switch (nodeName = parser.getName()) {
                case "action": {
                    String value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                    if (value == null) {
                        result = input.error("No value supplied for <android:name>");
                        break;
                    }
                    if (value.isEmpty()) {
                        intentInfo.addAction(value);
                        result = input.deferError("No value supplied for <android:name>", 151163173L);
                        break;
                    }
                    intentInfo.addAction(value);
                    result = input.success(null);
                    break;
                }
                case "category": {
                    String value = parser.getAttributeValue("http://schemas.android.com/apk/res/android", "name");
                    if (value == null) {
                        result = input.error("No value supplied for <android:name>");
                        break;
                    }
                    if (value.isEmpty()) {
                        intentInfo.addCategory(value);
                        result = input.deferError("No value supplied for <android:name>", 151163173L);
                        break;
                    }
                    intentInfo.addCategory(value);
                    result = input.success(null);
                    break;
                }
                case "data": {
                    result = ParsedIntentInfoUtils.parseData(intentInfo, res, parser, allowGlobs, input);
                    break;
                }
                default: {
                    result = ParsingUtils.unknownTag("<intent-filter>", pkg, parser, input);
                }
            }
            if (!result.isError()) continue;
            return input.error(result);
        }
        intentInfo.hasDefault = intentInfo.hasCategory("android.intent.category.DEFAULT");
        return input.success(intentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult<ParsedIntentInfo> parseData(ParsedIntentInfo intentInfo, Resources resources, XmlResourceParser parser, boolean allowGlobs, ParseInput input) {
        TypedArray sa = resources.obtainAttributes(parser, R.styleable.AndroidManifestData);
        try {
            String str = sa.getNonConfigurationString(0, 0);
            if (str != null) {
                try {
                    intentInfo.addDataType(str);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error(e.toString());
                    sa.recycle();
                    return parseResult;
                }
            }
            if ((str = sa.getNonConfigurationString(10, 0)) != null) {
                intentInfo.addMimeGroup(str);
            }
            if ((str = sa.getNonConfigurationString(1, 0)) != null) {
                intentInfo.addDataScheme(str);
            }
            if ((str = sa.getNonConfigurationString(7, 0)) != null) {
                intentInfo.addDataSchemeSpecificPart(str, 0);
            }
            if ((str = sa.getNonConfigurationString(8, 0)) != null) {
                intentInfo.addDataSchemeSpecificPart(str, 1);
            }
            if ((str = sa.getNonConfigurationString(9, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> e = input.error("sspPattern not allowed here; ssp must be literal");
                    return e;
                }
                intentInfo.addDataSchemeSpecificPart(str, 2);
            }
            String host = sa.getNonConfigurationString(2, 0);
            String port = sa.getNonConfigurationString(3, 0);
            if (host != null) {
                intentInfo.addDataAuthority(host, port);
            }
            if ((str = sa.getNonConfigurationString(4, 0)) != null) {
                intentInfo.addDataPath(str, 0);
            }
            if ((str = sa.getNonConfigurationString(5, 0)) != null) {
                intentInfo.addDataPath(str, 1);
            }
            if ((str = sa.getNonConfigurationString(6, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("pathPattern not allowed here; path must be literal");
                    return parseResult;
                }
                intentInfo.addDataPath(str, 2);
            }
            if ((str = sa.getNonConfigurationString(11, 0)) != null) {
                if (!allowGlobs) {
                    ParseResult<ParsedIntentInfo> parseResult = input.error("pathAdvancedPattern not allowed here; path must be literal");
                    return parseResult;
                }
                intentInfo.addDataPath(str, 3);
            }
            ParseResult<Object> parseResult = input.success(null);
            return parseResult;
        }
        finally {
            sa.recycle();
        }
    }
}

