/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing.component;

import android.content.ComponentName;
import android.content.pm.parsing.ParsingPackageImpl;
import android.content.pm.parsing.component.ParsedComponent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;

public class ParsedInstrumentation
extends ParsedComponent {
    private String targetPackage;
    private String targetProcesses;
    boolean handleProfiling;
    boolean functionalTest;
    public static final Parcelable.Creator<ParsedInstrumentation> CREATOR = new Parcelable.Creator<ParsedInstrumentation>(){

        @Override
        public ParsedInstrumentation createFromParcel(Parcel source) {
            return new ParsedInstrumentation(source);
        }

        public ParsedInstrumentation[] newArray(int size) {
            return new ParsedInstrumentation[size];
        }
    };

    public ParsedInstrumentation() {
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = TextUtils.safeIntern(targetPackage);
    }

    public void setTargetProcesses(String targetProcesses) {
        this.targetProcesses = TextUtils.safeIntern(targetProcesses);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("Instrumentation{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        ComponentName.appendShortString(sb, this.getPackageName(), this.getName());
        sb.append('}');
        return sb.toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        ParsingPackageImpl.sForInternedString.parcel(this.targetPackage, dest, flags);
        ParsingPackageImpl.sForInternedString.parcel(this.targetProcesses, dest, flags);
        dest.writeBoolean(this.handleProfiling);
        dest.writeBoolean(this.functionalTest);
    }

    protected ParsedInstrumentation(Parcel in) {
        super(in);
        this.targetPackage = ParsingPackageImpl.sForInternedString.unparcel(in);
        this.targetProcesses = ParsingPackageImpl.sForInternedString.unparcel(in);
        this.handleProfiling = in.readByte() != 0;
        this.functionalTest = in.readByte() != 0;
    }

    public String getTargetPackage() {
        return this.targetPackage;
    }

    public String getTargetProcesses() {
        return this.targetProcesses;
    }

    public boolean isHandleProfiling() {
        return this.handleProfiling;
    }

    public boolean isFunctionalTest() {
        return this.functionalTest;
    }
}

